/********************************************************************

void wn_force_conj_direction_stop()

void wn_conj_direction_method(pcode,pval_min,vect,len,pfunction,max_iterations)

********************************************************************/
#include <stdio.h>
#include <math.h>

#include "wnlib.h"
#include "wnasrt.h"
#include "wnmem.h"
#include "wnswap.h"

#include "wnvect.h"
#include "wnmat.h"

#include "wnconj.h"



#define TOLERANCE             (1.0e-13)
#define ROOT_TOLERANCE        (1.0e-7)
/*
#define TOLERANCE             (1.0e-13)
#define ROOT_TOLERANCE        (1.0e-7)
#define TOLERANCE             (1.0e-16)
#define ROOT_TOLERANCE        (1.0e-8)
#define TOLERANCE             (1.0e-20)
#define ROOT_TOLERANCE        (1.0e-10)
#define TOLERANCE             (1.0e-15)
#define ROOT_TOLERANCE        (3.3e-8)
*/
#define GOLDEN_RATIO          1.618034
#define GOLDEN_SECTION        0.3819660
#define MAX_MAGNIFICATION     100.0
#define MAX_BRENT_ITERATIONS  200

#define SHIFT3(_x1,_x2,_x3)  {(_x1)=(_x2); (_x2)=(_x3);}
#define SHIFT4(_x1,_x2,_x3,_x4)  {SHIFT3(_x1,_x2,_x3); (_x3)=(_x4);}


local bool force_optimize_stop_flag=FALSE;



void wn_force_conj_direction_stop(void)
{
  force_optimize_stop_flag = TRUE;
}


local void initialize_powell_directions(double **xi,int len)
{
  int i;

  wn_zero_mat(xi,len,len);

  for(i=0;i<len;++i)
  {
    xi[i][i] = 1.0;
  }
}


local int save_len;
local double *buffer_vect,*save_vect,*save_direction;
local double (*save_pfunction)(double vect[]);


local double powell_line_function(double x)
{
  wn_copy_vect(save_vect,buffer_vect,save_len);
  wn_add_scaled_vect(save_vect,save_direction,x,save_len);

  return((*save_pfunction)(save_vect));
}


local void powell_line_minimize
(
  double vect[],
  double direction[],
  int len,
  double *pval_min,
  double (*pfunction)(double vect[])
)
{
  double ax,bx,cx,fa,fb,fc;
  bool code;

  wn_copy_vect(buffer_vect,vect,len);
  save_vect = vect;
  save_len = len;
  save_direction = direction;
  save_pfunction = pfunction;

  ax = -1.0;
  bx = 0.0;
  cx = 1.0;
  fa = powell_line_function(ax);
  fb = *pval_min;
  fc = powell_line_function(cx);

  /*
  printf("now.\n");
  */
  /*
  wn_minimize_1d_raw(&code,&fa,&fb,&fc,&ax,&bx,&cx,fb,&powell_line_function,5);
  */
  wn_minimize_1d_raw(&code,&fa,&fb,&fc,&ax,&bx,&cx,fb,&powell_line_function,500);
  /*
  printf("l = %lf\n",bx);
  */

  wn_copy_vect(vect,buffer_vect,len);

  if(*pval_min == fb)
  {
    return;  /* do not move if no improvement */
  }

  wn_add_scaled_vect(vect,direction,bx,len);

  *pval_min = fb;
}


local double square(double x)
{
  return(x*x);
}


void wn_conj_direction_method
(
  int *pcode,
  double *pval_min,
  double vect[],
  int len,
  double (*pfunction)(double vect[]),
  int max_iterations
)
{
  int i,ibig,j,iteration;
  double t,fptt,fp,del;
  double *pt,*ptt,*xit;
  double **xi;
  double last_val_min;
   
  force_optimize_stop_flag = FALSE;

  wn_gpmake("no_free");

  wn_make_vect(&buffer_vect,len);
  wn_make_mat(&xi,len,len);
  wn_make_vect(&pt,len);
  wn_make_vect(&ptt,len);
  wn_make_vect(&xit,len);

  initialize_powell_directions(xi,len);

  *pval_min = (*pfunction)(vect);

  wn_copy_vect(pt,vect,len);

  iteration = 0;

  for(iteration=0;;++iteration)
  {
    /*
    printf("iteration = %d\n",iteration);
    */

    last_val_min = *pval_min;

    fp = *pval_min;
    del = 0.0;

    for(i=0;i<len;++i)
    {
      /*
      printf("minimize vector = %d\n",i);
      */

      fptt = *pval_min;
      powell_line_minimize(vect,xi[i],len,pval_min,pfunction);
      if(fabs(fptt-(*pval_min)) > del)
      {
	del = fabs(fptt-(*pval_min));
	ibig = i;
      }
    }

    wn_assert(*pval_min <= last_val_min);
    if(*pval_min == last_val_min)
    {
      *pcode = WN_SUCCESS;
      force_optimize_stop_flag = FALSE;
      wn_gpfree();
      return;
    }
    /*
    if(2.0*fabs(fp-(*pval_min)) <= TOLERANCE*(fabs(fp)+fabs(*pval_min)))
    {
      *pcode = WN_SUCCESS;
      force_optimize_stop_flag = FALSE;
      wn_gpfree();
      return;
    }
    */
    if(
	force_optimize_stop_flag
	  ||
        ((iteration >= max_iterations)&&(max_iterations < WN_IHUGE))
      )
    {
      *pcode = WN_SUBOPTIMAL;
      force_optimize_stop_flag = FALSE;
      wn_gpfree();
      return;
    }
    for(j=0;j<len;++j)
    {
      ptt[j] = 2.0*vect[j]-pt[j];
      xit[j] = vect[j]-pt[j];
    }
    wn_copy_vect(pt,vect,len);
    fptt = (*pfunction)(ptt);
    if(fptt < fp)
    {
      t = 2.0*(fp-2.0*(*pval_min)+fptt)*square(fp-(*pval_min)-del) -
	  del*square(fp-fptt);
      if(t < 0.0)
      {
        powell_line_minimize(vect,xit,len,pval_min,pfunction);
        wn_copy_vect(xi[ibig],xit,len);
      }
    }
  }
}
