NAME
     wnasrt -- allows application to commit suicide

SYNOPSIS
     #include "wnasrt.h"

     wn_assert(bool condition)

     wn_assert_notreached()

     wn_assert_warn(bool condition)

     wn_assert_warn_notreached()

     wn_set_assert_print(passert_print)
     void (*passert_print)(/*string*/);   /* char string[]; */

DESCRIPTION
     "wn_assert" evaluates "condition".  If "condition" is TRUE, execution
     continues.  If "condition" is FALSE, it 
     prints a message giving the file name and line number
     where it was called from.  Then it crashes the application using
     abort(3).

     "wn_assert_notreached" prints a message giving the file name and 
     line number
     where it was called from.  Then it crashes the application using
     abort(3).

     "wn_assert_warn" evaluates "condition".  
     If "condition" is FALSE, it 
     prints a message giving the file name and line number
     where it was called from.  

     "wn_assert_warn_notreached" prints a message giving the file name and 
     line number
     where it was called from.  

     "wn_set_assert_print" allows the programmer to change the
     routine used for printing messages.  The default is to print
     to standard error.

DIAGNOSTICS
  
BUGS

SEE ALSO
     abort(3)

AUTHOR
     Will Naylor


