/*   cn3dpane.c
* ===========================================================================
*
*                            PUBLIC DOMAIN NOTICE
*            National Center for Biotechnology Information (NCBI)
*
*  This software/database is a "United States Government Work" under the
*  terms of the United States Copyright Act.  It was written as part of
*  the author's official duties as a United States Government employee and
*  thus cannot be copyrighted.  This software/database is freely available
*  to the public for use. The National Library of Medicine and the U.S.
*  Government do not place any restriction on its use or reproduction.
*  We would, however, appreciate having the NCBI and the author cited in
*  any work or product based on this material
*
*  Although all reasonable efforts have been taken to ensure the accuracy
*  and reliability of the software and data, the NLM and the U.S.
*  Government do not and cannot warrant the performance or results that
*  may be obtained by using this software or data. The NLM and the U.S.
*  Government disclaim all warranties, express or implied, including
*  warranties of performance, merchantability or fitness for any particular
*  purpose.
*
Description: side panel for aligned structures.  lyg.
*/

#include <viewer3d.h>
#include <cn3dmain.h>
#include <math.h>
#include <mmdbapi.h>
#include <cn3dpane.h>
#include <algorend.h>
#include <cn3dmsg.h>
#include <salutil.h>


static ButtoN Cn3D_bShowAlign; 
static ButtoN   Cn3D_bLRedraw;
static LisT Cn3D_lSlaves;
static ButtoN  Cn3D_bAlignOn, Cn3D_bUnalignOn; 

Boolean Cn3D_fAlignOn, Cn3D_fUnalignOn; /* globals  for above buttons */
 

static void fnAlignList(LisT l)
/* set the values of the alignment pane */
{
  Int4 iCount;
  PDNMS pdnmsMaster, pdnmsSlave;
  PMSD pmsdMaster, pmsdSlave;

  PDNMM pdnmmHead = NULL;
  PMMD  pmmdThis = NULL;
  Byte bVisible;
  SeqIdPtr sipThis;
  Uint2 entityID, itemID, itemtype;         /* yanli */

  Cn3D_SaveActiveCam();

  pdnmsMaster = GetSelectedModelstruc();
  if (pdnmsMaster != NULL)
  {
    pmsdMaster = (PMSD)pdnmsMaster->data.ptrvalue;
    pdnmsSlave = pmsdMaster->pdnmsSlaves;
    
    iCount = 1;
    while(pdnmsSlave)
    {
      pmsdSlave = (PMSD)pdnmsSlave->data.ptrvalue;

      bVisible = pmsdSlave->bVisible;   /* yanli */

      pmsdSlave->bVisible = GetItemStatus(Cn3D_lSlaves, iCount);

      if(bVisible != pmsdSlave->bVisible){
         pdnmmHead = pmsdSlave->pdnmmHead;
         while(pdnmmHead){
            pmmdThis = pdnmmHead->data.ptrvalue;
            if(pmmdThis){
               if(mediadata[iCount]->Gi == pmmdThis->iGi){
                  sipThis = mediadata[iCount]->sip;
                  entityID = BioseqFindEntity(sipThis, &itemID);
                  itemtype = OBJ_SEQALIGN;

                  Salsa_BioseqUpdate = FALSE;

                  if(pmsdSlave->bVisible) {
                     ObjMgrAlsoSelect(entityID, itemID, itemtype, 0, NULL);
                     Salsa_BioseqUpdate = TRUE;
                  }
                  else if(!pmsdSlave->bVisible) {
                     if(!is_selectedbyID (entityID, itemID, OBJ_BIOSEQ)){ 
                        ObjMgrAlsoSelect(entityID, itemID, itemtype, 0, NULL);
                        ObjMgrDeSelect(entityID, itemID, itemtype, 0, NULL);
                        Salsa_BioseqUpdate = TRUE;
                     }
                     else ObjMgrDeSelect(entityID, itemID, itemtype, 0, NULL);
                  }
                  break;
               }
            }

            pdnmmHead = pdnmmHead->next;

         }
      }                        /* yanli */

      iCount++;
      pdnmsSlave = pdnmsSlave->next;
    }
  }
  Cn3D_v3d->is_zoomed = TRUE;  /* keep the proteins from moving */
  Cn3D_Redraw(FALSE);
}



static void fnNeighborMode(ButtoN b)
{

if(GetStatus(Cn3D_bShowAlign)) SetNeighborOn();
else SetNeighborOff();
Cn3D_v3d->is_zoomed = TRUE;  /* keep the proteins from moving */
Cn3D_Redraw(FALSE);
}

static void fnAlignOn(ButtoN b)
{
Cn3D_fAlignOn = GetStatus(Cn3D_bAlignOn);
Cn3D_v3d->is_zoomed = TRUE;  /* keep the proteins from moving */
Cn3D_Redraw(FALSE);
}

static void fnUnalignOn(ButtoN b)
{
Cn3D_fUnalignOn = GetStatus(Cn3D_bUnalignOn);
Cn3D_v3d->is_zoomed = TRUE;  /* keep the proteins from moving */
Cn3D_Redraw(FALSE);
}


GrouP LIBCALL AlignControls ( Nlm_GrouP prnt)
{
  GrouP g;

  g = NormalGroup ( prnt, 1, 0, "Aligned Structures", systemFont, NULL );
  if (!g) return NULL;
#ifdef WIN_MOTIF
      SetGroupMargins ( g, 4, 1 );
      SetGroupSpacing ( g, 2, 1 );
#else
      SetGroupMargins ( g, 1, 1 );
      SetGroupSpacing ( g, 0, 0 );
#endif


 
  Cn3D_bShowAlign = CheckBox(g, "Alignment mode", fnNeighborMode );

  Cn3D_bAlignOn = CheckBox(g, "Show Aligned", fnAlignOn);

  Cn3D_bUnalignOn = CheckBox(g, "Show Unaligned", fnUnalignOn);
 

  Cn3D_lSlaves = MultiList(g, 10, 15,  fnAlignList);
  

/* set the values for the above */
  ResetAlignCtrls();

  return g;
}


void LIBCALL ResetAlignCtrls(void)
/* set the values of the alignment pane */
{
  Int4 iCount;
  PDNMS pdnmsMaster, pdnmsSlave;
  PMSD pmsdMaster, pmsdSlave;

  SetStatus(Cn3D_bShowAlign, AreNeighborsOn());
  SetStatus(Cn3D_bAlignOn, Cn3D_fAlignOn);
  SetStatus(Cn3D_bUnalignOn, Cn3D_fUnalignOn);
  
  Reset(Cn3D_lSlaves);
  pdnmsMaster = GetSelectedModelstruc();
  if (pdnmsMaster != NULL)
  {
    pmsdMaster = (PMSD)pdnmsMaster->data.ptrvalue;
    pdnmsSlave = pmsdMaster->pdnmsSlaves;
    
    iCount = 1;
    while(pdnmsSlave)
    {
      pmsdSlave = (PMSD)pdnmsSlave->data.ptrvalue;
      ListItem(Cn3D_lSlaves, (CharPtr) pmsdSlave->pcPDBName);  
      if(pmsdSlave->bVisible) SetItemStatus(Cn3D_lSlaves, iCount, TRUE);
      iCount++;
      pdnmsSlave = pdnmsSlave->next;
    }
  }
}

