/*   saldist.c
* ===========================================================================
*
*                            PUBLIC DOMAIN NOTICE
*            National Center for Biotechnology Information (NCBI)
*
*  This software/database is a "United States Government Work" under the
*  terms of the United States Copyright Act.  It was written as part of
*  the author's official duties as a United States Government employee and
*  thus cannot be copyrighted.  This software/database is freely available
*  to the public for use. The National Library of Medicine and the U.S.
*  Government do not place any restriction on its use or reproduction.
*  We would, however, appreciate having the NCBI and the author cited in
*  any work or product based on this material
*
*  Although all reasonable efforts have been taken to ensure the accuracy
*  and reliability of the software and data, the NLM and the U.S.
*  Government do not and cannot warrant the performance or results that
*  may be obtained by using this software or data. The NLM and the U.S.
*  Government disclaim all warranties, express or implied, including
*  warranties of performance, merchantability or fitness for any particular
*  purpose.
*
* ===========================================================================
*
* File Name:  salfiles.c
*
* Author:  Colombe Chappey
*
* Version Creation Date:   1/27/96
*
* $Revision: 6.8 $
*
* File Description: 
*
* Modifications:  
* --------------------------------------------------------------------------
* Date     Name        Description of modification
* -------  ----------  -----------------------------------------------------
*
*
* ==========================================================================
*/
#include <saldist.h>
#include <saledit.h>
#include <salutil.h>
#include <salsap.h>
#include <salstruc.h>
#include <salpanel.h>
#include <salfiles.h>

#include <simutil.h>
#include <biosrc.h> 
#include <dlogutil.h>
#include <sequtil.h>

#ifdef SALSA_DEBUG
#include <treeview.h>
#include <treemgr.h>
#endif
 
#define MISMATCHCOUNT_ALL 1
#define MISMATCHCOUNT_REF 2 
#define GAPCOUNT      7 
#define NSSPW         3 
#define NSSREF        4 
#define NSSGP         5 
#define QUORUM        6 

#define CARNUL  ' '
#define CARGAP  '-'
#define ChgSy     1
#define ChgNSy    2
#define ChgNSS    3
#define StP  "FFLLLLLLIIIMVVVVSSSSPPPPTTTTAAAAYY**HHQQNNKKDDEECC*WRRRRSSRRGGGG"
#define AAdecode  "-ABCDEFGHIKLMNPQRSTVWXYZU*"

static Char  path_out[] = "outfile"; 
static FILE  *fout;

char *amino_acid_order = "ABCDEFGHIKLMNPQRSTVWXYZ";

static Int2Ptr spaning_tree (Int4Ptr PNTR matcost, Int4 dim);


short blosum30mt[]={
  4,
  0,  5,
 -3, -2, 17,
  0,  5, -3,  9,
  0,  0,  1,  1,  6,
 -2, -3, -3, -5, -4, 10,
  0,  0, -4, -1, -2, -3,  8,
 -2, -2, -5, -2,  0, -3, -3, 14,
  0, -2, -2, -4, -3,  0, -1, -2,  6,
  0,  0, -3,  0,  2, -1, -1, -2, -2,  4,
 -1, -1,  0, -1, -1,  2, -2, -1,  2, -2,  4,
  1, -2, -2, -3, -1, -2, -2,  2,  1,  2,  2,  6,
  0,  4, -1,  1, -1, -1,  0, -1,  0,  0, -2,  0,  8,
 -1, -2, -3, -1,  1, -4, -1,  1, -3,  1, -3, -4, -3, 11,
  1, -1, -2, -1,  2, -3, -2,  0, -2,  0, -2, -1, -1,  0,  8,
 -1, -2, -2, -1, -1, -1, -2, -1, -3,  1, -2,  0, -2, -1,  3,  8,
  1,  0, -2,  0,  0, -1,  0, -1, -1,  0, -2, -2,  0, -1, -1, -1,  4,
  1,  0, -2, -1, -2, -2, -2, -2,  0, -1,  0,  0,  1,  0,  0, -3,  2,  5,
  1, -2, -2, -2, -3,  1, -3, -3,  4, -2,  1,  0, -2, -4, -3, -1, -1,  1,  5,
 -5, -5, -2, -4, -1,  1,  1, -5, -3, -2, -2, -3, -7, -3, -1,  0, -3, -5, -3, 20,
  0, -1, -2, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0, -1,  0, -1,  0,  0,  0, -2, -1,
 -4, -3, -6, -1, -2,  3, -3,  0, -1, -1,  3, -1, -4, -2, -1,  0, -2, -1,  1,  5, -1,  9,
  0,  0,  0,  0,  5, -4, -2,  0, -3,  1, -1, -1, -1,  0,  4,  0, -1, -1, -3, -1,  0, -2,  4};

/*
short blosum35mt[]={
  5,
 -1,  5,
 -2, -2, 15,
 -1,  5, -3,  8,
 -1,  0, -1,  2,  6,
 -2, -2, -4, -3, -3,  8,
  0,  0, -3, -2, -2, -3,  7,
 -2,  0, -4,  0, -1, -3, -2, 12,
 -1, -2, -4, -3, -3,  1, -3, -3,  5,
  0,  0, -2, -1,  1, -1, -1, -2, -2,  5,
 -2, -2, -2, -2, -1,  2, -3, -2,  2, -2,  5,
  0, -2, -4, -3, -2,  0, -1,  1,  1,  0,  3,  6,
 -1,  4, -1,  1, -1, -1,  1,  1, -1,  0, -2, -1,  7,
 -2, -1, -4, -1,  0, -4, -2, -1, -1,  0, -3, -3, -2, 10,
  0,  0, -3, -1,  2, -4, -2, -1, -2,  0, -2, -1,  1,  0,  7,
 -1, -1, -3, -1, -1, -1, -2, -1, -3,  2, -2,  0, -1, -2,  2,  8,
  1,  0, -3, -1,  0, -1,  1, -1, -2,  0, -2, -1,  0, -2,  0, -1,  4,
  0, -1, -1, -1, -1, -1, -2, -2, -1,  0,  0,  0,  0,  0,  0, -2,  2,  5,
  0, -2, -2, -2, -2,  1, -3, -4,  4, -2,  2,  1, -2, -3, -3, -1, -1,  1,  5,
 -2, -3, -5, -3, -1,  1, -1, -4, -1,  0,  0,  1, -2, -4, -1,  0, -2, -2, -2, 16,
  0, -1, -2, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0, -1, -1, -1,  0,  0,  0, -1, -1,
 -1, -2, -5, -2, -1,  3, -2,  0,  0, -1,  0,  0, -2, -3,  0,  0, -1, -2,  0,  3, -1,  8,
 -1,  0, -2,  1,  5, -3, -2, -1, -3,  1, -2, -2,  0,  0,  4,  0,  0, -1, -2, -1,  0, -1,  4};
*/
short blosum40mt[]={
  5,
 -1,  5,
 -2, -2, 16,
 -1,  6, -2,  9,
 -1,  1, -2,  2,  7,
 -3, -3, -2, -4, -3,  9,
  1, -1, -3, -2, -3, -3,  8,
 -2,  0, -4,  0,  0, -2, -2, 13,
 -1, -3, -4, -4, -4,  1, -4, -3,  6,
 -1,  0, -3,  0,  1, -3, -2, -1, -3,  6,
 -2, -3, -2, -3, -2,  2, -4, -2,  2, -2,  6,
 -1, -3, -3, -3, -2,  0, -2,  1,  1, -1,  3,  7,
 -1,  4, -2,  2, -1, -3,  0,  1, -2,  0, -3, -2,  8,
 -2, -2, -5, -2,  0, -4, -1, -2, -2, -1, -4, -2, -2, 11,
  0,  0, -4, -1,  2, -4, -2,  0, -3,  1, -2, -1,  1, -2,  8,
 -2, -1, -3, -1, -1, -2, -3,  0, -3,  3, -2, -1,  0, -3,  2,  9,
  1,  0, -1,  0,  0, -2,  0, -1, -2,  0, -3, -2,  1, -1,  1, -1,  5,
  0,  0, -1, -1, -1, -1, -2, -2, -1,  0, -1, -1,  0,  0, -1, -2,  2,  6,
  0, -3, -2, -3, -3,  0, -4, -4,  4, -2,  2,  1, -3, -3, -3, -2, -1,  1,  5,
 -3, -4, -6, -5, -2,  1, -2, -5, -3, -2, -1, -2, -4, -4, -1, -2, -5, -4, -3, 19,
  0, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1,  0, -1, -2, -1, -1,  0,  0, -1, -2, -1,
 -2, -3, -4, -3, -2,  4, -3,  2,  0, -1,  0,  1, -2, -3, -1, -1, -2, -1, -1,  3, -1,  9,
 -1,  2, -3,  1,  5, -4, -2,  0, -4,  1, -2, -2,  0, -1,  4,  0,  0, -1, -3, -2, -1, -2,  5};

short blosum45mt[]={
  5,
 -1,  4,
 -1, -2, 12,
 -2,  5, -3,  7,
 -1,  1, -3,  2,  6,
 -2, -3, -2, -4, -3,  8,
  0, -1, -3, -1, -2, -3,  7,
 -2,  0, -3,  0,  0, -2, -2, 10,
 -1, -3, -3, -4, -3,  0, -4, -3,  5,
 -1,  0, -3,  0,  1, -3, -2, -1, -3,  5,
 -1, -3, -2, -3, -2,  1, -3, -2,  2, -3,  5,
 -1, -2, -2, -3, -2,  0, -2,  0,  2, -1,  2,  6,
 -1,  4, -2,  2,  0, -2,  0,  1, -2,  0, -3, -2,  6,
 -1, -2, -4, -1,  0, -3, -2, -2, -2, -1, -3, -2, -2,  9,
 -1,  0, -3,  0,  2, -4, -2,  1, -2,  1, -2,  0,  0, -1,  6,
 -2, -1, -3, -1,  0, -2, -2,  0, -3,  3, -2, -1,  0, -2,  1,  7,
  1,  0, -1,  0,  0, -2,  0, -1, -2, -1, -3, -2,  1, -1,  0, -1,  4,
  0,  0, -1, -1, -1, -1, -2, -2, -1, -1, -1, -1,  0, -1, -1, -1,  2,  5,
  0, -3, -1, -3, -3,  0, -3, -3,  3, -2,  1,  1, -3, -3, -3, -2, -1,  0,  5,
 -2, -4, -5, -4, -3,  1, -2, -3, -2, -2, -2, -2, -4, -3, -2, -2, -4, -3, -3, 15,  
  0, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0, -1, -2, -1,
 -2, -2, -3, -2, -2,  3, -3,  2,  0, -1,  0,  0, -2, -3, -1, -1, -2, -1, -1,  3, -1,  8,
 -1,  2, -3,  1,  4, -3, -2,  0, -3,  1, -2, -1,  0, -1,  4,  0,  0, -1, -3, -2, -1, -2,  4};

/*
short blosum50mt[]={
  5,
 -2,  5,
 -1, -3, 13,
 -2,  5, -4,  8,
 -1,  1, -3,  2,  6,
 -3, -4, -2, -5, -3,  8,
  0, -1, -3, -1, -3, -4,  8,
 -2,  0, -3, -1,  0, -1, -2, 10,
 -1, -4, -2, -4, -4,  0, -4, -4,  5,
 -1,  0, -3, -1,  1, -4, -2,  0, -3,  6,
 -2, -4, -2, -4, -3,  1, -4, -3,  2, -3,  5,
 -1, -3, -2, -4, -2,  0, -3, -1,  2, -2,  3,  7,
 -1,  4, -2,  2,  0, -4,  0,  1, -3,  0, -4, -2,  7,
 -1, -2, -4, -1, -1, -4, -2, -2, -3, -1, -4, -3, -2, 10,
 -1,  0, -3,  0,  2, -4, -2,  1, -3,  2, -2,  0,  0, -1,  7,
 -2, -1, -4, -2,  0, -3, -3,  0, -4,  3, -3, -2, -1, -3,  1,  7,
  1,  0, -1,  0, -1, -3,  0, -1, -3,  0, -3, -2,  1, -1,  0, -1,  5,
  0,  0, -1, -1, -1, -2, -2, -2, -1, -1, -1, -1,  0, -1, -1, -1,  2,  5,
  0, -4, -1, -4, -3, -1, -4, -4,  4, -3,  1,  1, -3, -3, -3, -3, -2,  0,  5,
 -3, -5, -5, -5, -3,  1, -3, -3, -3, -3, -2, -1, -4, -4, -1, -3, -4, -3, -3, 15,
 -1, -1, -2, -1, -1, -2, -2, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1,  0, -1, -3, -1,
 -2, -3, -3, -3, -2,  4, -3,  2, -1, -2, -1,  0, -2, -3, -1, -1, -2, -2, -1,  2, -1,  8,
 -1,  2, -3,  1,  5, -4, -2,  0, -3,  1, -3, -1,  0, -1,  4,  0,  0, -1, -3, -2, -1, -2,  5};

short blosum55mt[]={
  5,
 -2,  5,
  0, -4, 13,
 -2,  5, -4,  8,
 -1,  1, -4,  2,  7,
 -3, -5, -3, -5, -4,  9,
  0, -1, -3, -2, -3, -4,  8,
 -2,  0, -4, -1, -1, -1, -2, 11,
 -2, -4, -2, -4, -4,  0, -5, -4,  6,
 -1,  0, -4, -1,  1, -4, -2,  0, -4,  6,
 -2, -4, -2, -5, -4,  1, -5, -3,  2, -3,  6,
 -1, -3, -2, -4, -3,  0, -3, -2,  2, -2,  3,  8,
 -2,  4, -3,  2,  0, -4,  0,  1, -4,  0, -4, -3,  8,
 -1, -2, -3, -2, -1, -5, -3, -3, -3, -1, -4, -3, -2, 10,
 -1,  0, -4,  0,  2, -4, -2,  1, -4,  2, -3,  0,  0, -1,  7,
 -2, -1, -4, -2,  0, -3, -3,  0, -4,  3, -3, -2, -1, -3,  1,  8,
  2,  0, -1,  0,  0, -3,  0, -1, -3,  0, -3, -2,  1, -1,  0, -1,  5,
  0, -1, -1, -1, -1, -3, -2, -2, -1, -1, -2, -1,  0, -1, -1, -1,  2,  6,
  0, -4, -1, -4, -3, -1, -4, -4,  4, -3,  1,  1, -4, -3, -3, -3, -2,  0,  5,
 -4, -5, -4, -5, -3,  2, -3, -3, -3, -4, -3, -2, -5, -5, -2, -3, -4, -3, -4, 15,
 -1, -1, -2, -2, -1, -2, -2, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -3, -1,
 -2, -3, -3, -3, -2,  4, -4,  2, -1, -2, -1, -1, -2, -4, -1, -2, -2, -2, -2,  3, -1,  9,
 -1,  2, -4,  1,  5, -4, -3,  0, -4,  1, -3, -2,  0, -1,  4,  0,  0, -1, -3, -3, -1, -2,  5};
*/

short blosum62mt[]={
  4,
 -2,  4,
  0, -3,  9,
 -2,  4, -3,  6,
 -1,  1, -4,  2,  5,
 -2, -3, -2, -3, -3,  6,
  0, -1, -3, -1, -2, -3,  6,
 -2,  0, -3, -1,  0, -1, -2,  8,
 -1, -3, -1, -3, -3,  0, -4, -3,  4,
 -1,  0, -3, -1,  1, -3, -2, -1, -3,  5,
 -1, -4, -1, -4, -3,  0, -4, -3,  2, -2,  4,
 -1, -3, -1, -3, -2,  0, -3, -2,  1, -1,  2,  5,
 -2,  3, -3,  1,  0, -3,  0,  1, -3,  0, -3, -2,  6,
 -1, -2, -3, -1, -1, -4, -2, -2, -3, -1, -3, -2, -2,  7,
 -1,  0, -3,  0,  2, -3, -2,  0, -3,  1, -2,  0,  0, -1,  5,
 -1, -1, -3, -2,  0, -3, -2,  0, -3,  2, -2, -1,  0, -2,  1,  5,
  1,  0, -1,  0,  0, -2,  0, -1, -2,  0, -2, -1,  1, -1,  0, -1,  4,
  0, -1, -1, -1, -1, -2, -2, -2, -1, -1, -1, -1,  0, -1, -1, -1,  1,  5,
  0, -3, -1, -3, -2, -1, -3, -3,  3, -2,  1,  1, -3, -2, -2, -3, -2,  0,  4,
 -3, -4, -2, -4, -3,  1, -2, -2, -3, -3, -2, -1, -4, -4, -2, -3, -3, -2, -3, 11,
  0, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -1,  0,  0, -1, -2, -1,
 -2, -3, -2, -3, -2,  3, -3,  2, -1, -2, -1, -1, -2, -3, -1, -2, -2, -2, -1,  2, -1,  7,
 -1,  1, -3,  1,  4, -3, -2,  0, -3,  1, -3, -1,  0, -1,  3,  0,  0, -1, -2, -3, -1, -2,  4};


short blosum62mt2[]={
  8,
 -4,  8,
  0, -6, 18,
 -4,  8, -6, 12,
 -2,  2, -8,  4, 10,
 -4, -6, -4, -6, -6, 12,
  0, -2, -6, -2, -4, -6, 12,
 -4,  0, -6, -2,  0, -2, -4, 16,
 -2, -6, -2, -6, -6,  0, -8, -6,  8,
 -2,  0, -6, -2,  2, -6, -4, -2, -6, 10,
 -2, -8, -2, -8, -6,  0, -8, -6,  4, -4,  8,
 -2, -6, -2, -6, -4,  0, -6, -4,  2, -2,  4, 10,
 -4,  6, -6,  2,  0, -6,  0,  2, -6,  0, -6, -4, 12,
 -2, -4, -6, -2, -2, -8, -4, -4, -6, -2, -6, -4, -4, 14,
 -2,  0, -6,  0,  4, -6, -4,  0, -6,  2, -4,  0,  0, -2, 10,
 -2, -2, -6, -4,  0, -6, -4,  0, -6,  4, -4, -2,  0, -4,  2, 10,
  2,  0, -2,  0,  0, -4,  0, -2, -4,  0, -4, -2,  2, -2,  0, -2,  8,
  0, -2, -2, -2, -2, -4, -4, -4, -2, -2, -2, -2,  0, -2, -2, -2,  2, 10,
  0, -6, -2, -6, -4, -2, -6, -6,  6, -4,  2,  2, -6, -4, -4, -6, -4,  0,  8,
 -6, -8, -4, -8, -6,  2, -4, -4, -6, -6, -4, -2, -8, -8, -4, -6, -6, -4, -6, 22,
  0, -2, -4, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -4, -2, -2,  0,  0, -2, -4, -2,
 -4, -6, -4, -6, -4,  6, -6,  4, -2, -4, -2, -2, -4, -6, -2, -4, -4, -4, -2,  4, -2, 14,
 -2,  2, -6,  2,  8, -6, -4,  0, -6,  2, -6, -2,  0, -2,  6,  0,  0, -2, -4, -6, -2, -4,  8};

/*
short blosum65mt[]={
  4,
 -2,  4,
  0, -3,  9,
 -2,  4, -4,  6,
 -1,  1, -4,  2,  5,
 -2, -3, -2, -4, -3,  6,
  0, -1, -3, -1, -2, -3,  6,
 -2,  0, -3, -1,  0, -1, -2,  8,
 -1, -3, -1, -3, -3,  0, -4, -3,  4,
 -1,  0, -3, -1,  1, -3, -2, -1, -3,  5,
 -2, -4, -1, -4, -3,  0, -4, -3,  2, -3,  4,
 -1, -3, -2, -3, -2,  0, -3, -2,  1, -2,  2,  6,
 -2,  3, -3,  1,  0, -3, -1,  1, -3,  0, -4, -2,  6,
 -1, -2, -3, -2, -1, -4, -2, -2, -3, -1, -3, -3, -2,  8,
 -1,  0, -3,  0,  2, -3, -2,  1, -3,  1, -2,  0,  0, -1,  6,
 -1, -1, -4, -2,  0, -3, -2,  0, -3,  2, -2, -2,  0, -2,  1,  6,
  1,  0, -1,  0,  0, -2,  0, -1, -2,  0, -3, -2,  1, -1,  0, -1,  4,
  0, -1, -1, -1, -1, -2, -2, -2, -1, -1, -1, -1,  0, -1, -1, -1,  1,  5,
  0, -3, -1, -3, -3, -1, -3, -3,  3, -2,  1,  1, -3, -2, -2, -3, -2,  0,  4,
 -3, -4, -2, -5, -3,  1, -3, -2, -2, -3, -2, -2, -4, -4, -2, -3, -3, -3, -3, 10,
 -1, -1, -2, -1, -1, -2, -2, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -2, -1,
 -2, -3, -2, -3, -2,  3, -3,  2, -1, -2, -1, -1, -2, -3, -2, -2, -2, -2, -1,  2, -1,  7,
 -1,  1, -4,  1,  4, -3, -2,  0, -3,  1, -3, -2,  0, -1,  3,  0,  0, -1, -2, -3, -1, -2,  4};

short blosum70mt[]={
  4,
 -2,  4,
 -1, -4,  9,
 -2,  4, -4,  6,
 -1,  1, -4,  1,  5,
 -2, -4, -2, -4, -4,  6,
  0, -1, -3, -2, -2, -4,  6,
 -2, -1, -4, -1,  0, -1, -2,  8,
 -2, -4, -1, -4, -4,  0, -4, -4,  4,
 -1, -1, -4, -1,  1, -3, -2, -1, -3,  5,
 -2, -4, -2, -4, -3,  0, -4, -3,  2, -3,  4,
 -1, -3, -2, -3, -2,  0, -3, -2,  1, -2,  2,  6,
 -2,  3, -3,  1,  0, -3, -1,  0, -4,  0, -4, -2,  6,
 -1, -2, -3, -2, -1, -4, -3, -2, -3, -1, -3, -3, -2,  8,
 -1,  0, -3, -1,  2, -3, -2,  1, -3,  1, -2,  0,  0, -2,  6,
 -2, -1, -4, -2,  0, -3, -3,  0, -3,  2, -3, -2, -1, -2,  1,  6,
  1,  0, -1,  0,  0, -3, -1, -1, -3,  0, -3, -2,  0, -1,  0, -1,  4,
  0, -1, -1, -1, -1, -2, -2, -2, -1, -1, -2, -1,  0, -1, -1, -1,  1,  5,
  0, -3, -1, -4, -3, -1, -4, -3,  3, -3,  1,  1, -3, -3, -2, -3, -2,  0,  4,
 -3, -4, -3, -5, -4,  1, -3, -2, -3, -3, -2, -2, -4, -4, -2, -3, -3, -3, -3, 11,
 -1, -1, -2, -2, -1, -2, -2, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -3, -1,
 -2, -3, -3, -4, -3,  3, -4,  2, -1, -2, -1, -1, -2, -3, -2, -2, -2, -2, -2,  2, -2,  7,
 -1,  0, -4,  1,  4, -4, -2,  0, -3,  1, -3, -2,  0, -1,  3,  0,  0, -1, -3, -3, -1, -2,  4};

short blosum75mt[]={
  4,
 -2,  4,
 -1, -4,  9,
 -2,  4, -4,  6,
 -1,  1, -5,  1,  5,
 -3, -4, -2, -4, -4,  6,
  0, -1, -3, -2, -3, -4,  6,
 -2, -1, -4, -1,  0, -2, -2,  8,
 -2, -4, -1, -4, -4,  0, -5, -4,  4,
 -1, -1, -4, -1,  1, -4, -2, -1, -3,  5,
 -2, -4, -2, -4, -4,  0, -4, -3,  1, -3,  4,
 -1, -3, -2, -4, -2,  0, -3, -2,  1, -2,  2,  6,
 -2,  3, -3,  1, -1, -4, -1,  0, -4,  0, -4, -3,  6,
 -1, -2, -4, -2, -1, -4, -3, -2, -3, -1, -3, -3, -3,  8,
 -1,  0, -3, -1,  2, -4, -2,  1, -3,  1, -3,  0,  0, -2,  6,
 -2, -1, -4, -2,  0, -3, -3,  0, -3,  2, -3, -2, -1, -2,  1,  6,
  1,  0, -1, -1,  0, -3, -1, -1, -3,  0, -3, -2,  0, -1,  0, -1,  5,
  0, -1, -1, -1, -1, -2, -2, -2, -1, -1, -2, -1,  0, -1, -1, -1,  1,  5,
  0, -4, -1, -4, -3, -1, -4, -4,  3, -3,  1,  1, -3, -3, -2, -3, -2,  0,  4,
 -3, -5, -3, -5, -4,  1, -3, -2, -3, -4, -2, -2, -4, -5, -2, -3, -3, -3, -3, 11,
 -1, -2, -2, -2, -1, -2, -2, -1, -2, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -3, -1,
 -2, -3, -3, -4, -3,  3, -4,  2, -2, -2, -1, -2, -3, -4, -2, -2, -2, -2, -2,  2, -2,  7,
 -1,  0, -4,  1,  4, -4, -2,  0, -4,  1, -3, -2,  0, -2,  3,  0,  0, -1, -3, -3, -1, -3,  4};
*/

short blosum80mt[]={
  7,
 -3,  6,
 -1, -6, 13,
 -3,  6, -7, 10,
 -2,  1, -7,  2,  8,
 -4, -6, -4, -6, -6, 10,
  0, -2, -6, -3, -4, -6,  9,
 -3, -1, -7, -2,  0, -2, -4, 12,
 -3, -6, -2, -7, -6, -1, -7, -6,  7,
 -1, -1, -6, -2,  1, -5, -3, -1, -5,  8,
 -3, -7, -3, -7, -6,  0, -7, -5,  2, -4,  6,
 -2, -5, -3, -6, -4,  0, -5, -4,  2, -3,  3,  9,
 -3,  5, -5,  2, -1, -6, -1,  1, -6,  0, -6, -4,  9,
 -1, -4, -6, -3, -2, -6, -5, -4, -5, -2, -5, -4, -4, 12,
 -2, -1, -5, -1,  3, -5, -4,  1, -5,  2, -4, -1,  0, -3,  9,
 -3, -2, -6, -3, -1, -5, -4,  0, -5,  3, -4, -3, -1, -3,  1,  9,
  2,  0, -2, -1, -1, -4, -1, -2, -4, -1, -4, -3,  1, -2, -1, -2,  7,
  0, -1, -2, -2, -2, -4, -3, -3, -2, -1, -3, -1,  0, -3, -1, -2,  2,  8,
 -1, -6, -2, -6, -4, -2, -6, -5,  4, -4,  1,  1, -5, -4, -4, -4, -3,  0,  7,
 -5, -8, -5, -8, -6,  0, -6, -4, -5, -6, -4, -3, -7, -7, -4, -5, -6, -5, -5, 16,
 -1, -3, -4, -3, -2, -3, -3, -2, -2, -2, -2, -2, -2, -3, -2, -2, -1, -1, -2, -5, -2,
 -4, -5, -5, -6, -5,  4, -6,  3, -3, -4, -2, -3, -4, -6, -3, -4, -3, -3, -3,  3, -3, 11,
 -2,  0, -7,  1,  6, -6, -4,  0, -6,  1, -5, -3, -1, -2,  5,  0, -1, -2, -4, -5, -1, -4,  6};

/*
short blosum85mt[]={
  5,
 -2,  4,
 -1, -4,  9,
 -2,  4, -5,  7,
 -1,  0, -5,  1,  6,
 -3, -4, -3, -4, -4,  7,
  0, -1, -4, -2, -3, -4,  6,
 -2, -1, -5, -2, -1, -2, -3,  8,
 -2, -5, -2, -5, -4, -1, -5, -4,  5,
 -1, -1, -4, -1,  0, -4, -2, -1, -3,  6,
 -2, -5, -2, -5, -4,  0, -5, -3,  1, -3,  4,
 -2, -4, -2, -4, -3, -1, -4, -3,  1, -2,  2,  7,
 -2,  4, -4,  1, -1, -4, -1,  0, -4,  0, -4, -3,  7,
 -1, -3, -4, -2, -2, -4, -3, -3, -4, -2, -4, -3, -3,  8,
 -1, -1, -4, -1,  2, -4, -3,  1, -4,  1, -3,  0,  0, -2,  6,
 -2, -2, -4, -2, -1, -4, -3,  0, -4,  2, -3, -2, -1, -2,  1,  6,
  1,  0, -2, -1, -1, -3, -1, -1, -3, -1, -3, -2,  0, -1, -1, -1,  5,
  0, -1, -2, -2, -1, -3, -2, -2, -1, -1, -2, -1,  0, -2, -1, -2,  1,  5,
 -1, -4, -1, -4, -3, -1, -4, -4,  3, -3,  0,  0, -4, -3, -3, -3, -2,  0,  5,
 -3, -5, -4, -6, -4,  0, -4, -3, -3, -5, -3, -2, -5, -5, -3, -4, -4, -4, -3, 11,
 -1, -2, -3, -2, -1, -2, -2, -2, -2, -1, -2, -1, -2, -2, -1, -2, -1, -1, -1, -3, -2,
 -3, -4, -3, -4, -4,  3, -5,  2, -2, -3, -2, -2, -3, -4, -2, -3, -2, -2, -2,  2, -2,  7,
 -1,  0, -5,  1,  4, -4, -3,  0, -4,  1, -4, -2, -1, -2,  4,  0, -1, -1, -3, -4, -1, -3,  4};

short blosum90mt[]={
  5,
 -2,  4,
 -1, -4,  9,
 -3,  4, -5,  7,
 -1,  0, -6,  1,  6,
 -3, -4, -3, -5, -5,  7,
  0, -2, -4, -2, -3, -5,  6,
 -2, -1, -5, -2, -1, -2, -3,  8,
 -2, -5, -2, -5, -4, -1, -5, -4,  5,
 -1, -1, -4, -1,  0, -4, -2, -1, -4,  6,
 -2, -5, -2, -5, -4,  0, -5, -4,  1, -3,  5,
 -2, -4, -2, -4, -3, -1, -4, -3,  1, -2,  2,  7,
 -2,  4, -4,  1, -1, -4, -1,  0, -4,  0, -4, -3,  7,
 -1, -3, -4, -3, -2, -4, -3, -3, -4, -2, -4, -3, -3,  8,
 -1, -1, -4, -1,  2, -4, -3,  1, -4,  1, -3,  0,  0, -2,  7,
 -2, -2, -5, -3, -1, -4, -3,  0, -4,  2, -3, -2, -1, -3,  1,  6,
  1,  0, -2, -1, -1, -3, -1, -2, -3, -1, -3, -2,  0, -2, -1, -1,  5,
  0, -1, -2, -2, -1, -3, -3, -2, -1, -1, -2, -1,  0, -2, -1, -2,  1,  6,
 -1, -4, -2, -5, -3, -2, -5, -4,  3, -3,  0,  0, -4, -3, -3, -3, -2, -1,  5,
 -4, -6, -4, -6, -5,  0, -4, -3, -4, -5, -3, -2, -5, -5, -3, -4, -4, -4, -3, 11,
 -1, -2, -3, -2, -2, -2, -2, -2, -2, -1, -2, -1, -2, -2, -1, -2, -1, -1, -2, -3, -2,
 -3, -4, -4, -4, -4,  3, -5,  1, -2, -3, -2, -2, -3, -4, -3, -3, -3, -2, -3,  2, -2,  8,
 -1,  0, -5,  0,  4, -4, -3,  0, -4,  1, -4, -2, -1, -2,  4,  0, -1, -1, -3, -4, -1, -3,  4};
*/

short pam20mt[]={
  6,
 -5,  6,
 -8,-14, 10,
 -4,  6,-16,  8,
 -3,  0,-16,  2,  8,
 -9,-12,-15,-17,-16,  9,
 -3, -4,-11, -4, -5,-10,  7,
 -8, -2, -8, -5, -6, -7,-10,  9,
 -6, -7, -7, -9, -6, -3,-13,-11,  9,
 -8, -3,-16, -6, -5,-16, -8, -8, -7,  7,
 -7,-10,-17,-15,-10, -4,-12, -7, -2, -9,  7,
 -6,-12,-16,-13, -8, -5,-10,-13, -2, -3,  0, 11,
 -5,  6,-13,  1, -3,-10, -4, -1, -6, -2, -8,-11,  8,
 -2, -8, -9, -9, -7,-11, -7, -5,-10, -8, -8, -9, -7,  8,
 -5, -4,-16, -4,  0,-15, -8,  0, -9, -4, -6, -5, -5, -4,  9,
 -8, -9, -9,-12,-11,-10,-11, -3, -6, -1,-10, -5, -7, -5, -2,  9,
 -1, -2, -4, -5, -5, -7, -3, -7, -8, -5, -9, -6, -1, -3, -6, -4,  7,
 -1, -4, -9, -6, -7,-10, -7, -8, -3, -4, -8, -5, -3, -5, -7, -8,  0,  7,
 -3, -9, -7, -9, -8, -9, -7, -7,  1,-10, -3, -2, -9, -7, -8, -9, -8, -4,  7,
-16,-11,-18,-17,-19, -6,-17, -8,-16,-14, -7,-15, -9,-16,-15, -3, -6,-15,-18, 13,
 -4, -6,-11, -7, -6, -9, -6, -6, -6, -6, -7, -6, -4, -6, -6, -7, -4, -5, -6,-13, -6,
 -9, -7, -5,-13, -9,  1,-16, -4, -7,-10, -8,-13, -5,-16,-14,-11, -8, -7, -8, -6, -9, 10,
 -4, -1,-16,  0,  6,-16, -6, -2, -7, -5, -8, -6, -4, -5,  7, -5, -6, -7, -8,-17, -6,-11,  6};

short pam60mt[]={
  5,
 -2,  5,
 -5, -9,  9,
 -2,  5,-10,  7,
 -1,  2,-10,  3,  7,
 -6, -8, -9,-11,-10,  8,
  0, -2, -7, -2, -2, -7,  6,
 -5,  0, -6, -2, -3, -4, -6,  8,
 -3, -4, -4, -5, -4, -1, -7, -6,  7,
 -5, -1,-10, -2, -3,-10, -5, -4, -4,  6,
 -4, -7,-11, -9, -7, -1, -8, -4,  0, -6,  6,
 -3, -6,-10, -7, -5, -2, -6, -7,  1,  0,  2, 10,
 -2,  5, -7,  2,  0, -6, -1,  1, -4,  0, -5, -6,  6,
  0, -4, -6, -5, -3, -7, -4, -2, -6, -4, -5, -6, -4,  7,
 -3, -1,-10, -1,  2, -9, -5,  2, -5, -1, -3, -2, -2, -1,  7,
 -5, -5, -6, -6, -6, -7, -7,  0, -4,  2, -6, -2, -3, -2,  0,  8,
  1,  0, -1, -2, -2, -5,  0, -4, -4, -2, -6, -4,  1,  0, -3, -2,  5,
  1, -2, -5, -3, -4, -6, -3, -5, -1, -2, -5, -2, -1, -2, -4, -4,  1,  6,
 -1, -5, -4, -6, -4, -5, -4, -5,  3, -6, -1,  0, -5, -4, -5, -5, -4, -1,  6,
-10, -8,-12,-11,-12, -3,-11, -5,-10, -8, -4, -9, -6,-10, -9,  0, -4, -9,-11, 13,
 -2, -3, -6, -3, -3, -5, -3, -3, -3, -3, -4, -3, -2, -3, -3, -4, -2, -2, -3, -8, -3,
 -6, -5, -2, -8, -7,  3,-10, -2, -4, -7, -5, -7, -3,-10, -8, -8, -5, -5, -5, -3, -5,  9,
 -2,  1,-10,  2,  5,-10, -3,  0, -4, -2, -5, -4, -1, -2,  6, -2, -3, -4, -5,-11, -3, -7,  5};

short pam120mt[]={
  3,
  0,  4,
 -3, -6,  9,
  0,  4, -7,  5,
  0,  3, -7,  3,  5,
 -4, -5, -6, -7, -7,  8,
  1,  0, -4,  0, -1, -5,  5,
 -3,  1, -4,  0, -1, -3, -4,  7,
 -1, -3, -3, -3, -3,  0, -4, -4,  6,
 -2,  0, -7, -1, -1, -7, -3, -2, -3,  5,
 -3, -4, -7, -5, -4,  0, -5, -3,  1, -4,  5,
 -2, -4, -6, -4, -3, -1, -4, -4,  1,  0,  3,  8,
 -1,  3, -5,  2,  1, -4,  0,  2, -2,  1, -4, -3,  4,
  1, -2, -4, -3, -2, -5, -2, -1, -3, -2, -3, -3, -2,  6,
 -1,  0, -7,  1,  2, -6, -3,  3, -3,  0, -2, -1,  0,  0,  6,
 -3, -2, -4, -3, -3, -5, -4,  1, -2,  2, -4, -1, -1, -1,  1,  6,
  1,  0,  0,  0, -1, -3,  1, -2, -2, -1, -4, -2,  1,  1, -2, -1,  3,
  1,  0, -3, -1, -2, -4, -1, -3,  0, -1, -3, -1,  0, -1, -2, -2,  2,  4,
  0, -3, -3, -3, -3, -3, -2, -3,  3, -4,  1,  1, -3, -2, -3, -3, -2,  0,  5,
 -7, -6, -8, -8, -8, -1, -8, -3, -6, -5, -3, -6, -4, -7, -6,  1, -2, -6, -8, 12,
 -1, -1, -4, -2, -1, -3, -2, -2, -1, -2, -2, -2, -1, -2, -1, -2, -1, -1, -1, -5, -2,
 -4, -3, -1, -5, -5,  4, -6, -1, -2, -5, -2, -4, -2, -6, -5, -5, -3, -3, -3, -2, -3,  8,
 -1,  2, -7,  3,  4, -6, -2,  1, -3, -1, -3, -2,  0, -1,  4, -1, -1, -2, -3, -7, -1, -5,  4};

/*
short pam160mt[]={
  2,
  0,  3,
 -2, -4,  9,
  0,  3, -5,  4,
  0,  2, -5,  3,  4,
 -3, -4, -5, -6, -5,  7,
  1,  0, -3,  0,  0, -4,  4,
 -2,  1, -3,  0,  0, -2, -3,  6,
 -1, -2, -2, -3, -2,  0, -3, -3,  5,
 -2,  0, -5,  0, -1, -5, -2, -1, -2,  4,
 -2, -4, -6, -4, -3,  1, -4, -2,  2, -3,  5,
 -1, -3, -5, -3, -2,  0, -3, -3,  2,  0,  3,  7,
  0,  2, -4,  2,  1, -3,  0,  2, -2,  1, -3, -2,  3,
  1, -1, -3, -2, -1, -4, -1, -1, -2, -2, -3, -2, -1,  5,
 -1,  1, -5,  1,  2, -5, -2,  2, -2,  0, -2, -1,  0,  0,  5,
 -2, -1, -3, -2, -2, -4, -3,  1, -2,  3, -3, -1, -1, -1,  1,  6,
  1,  0,  0,  0,  0, -3,  1, -1, -2, -1, -3, -2,  1,  1, -1, -1,  2,
  1,  0, -2, -1, -1, -3, -1, -2,  0,  0, -2, -1,  0,  0, -1, -1,  1,  3,
  0, -2, -2, -3, -2, -2, -2, -2,  3, -3,  1,  1, -2, -2, -2, -3, -1,  0,  4,
 -5, -5, -7, -6, -7, -1, -7, -3, -5, -4, -2, -4, -4, -5, -5,  1, -2, -5, -6, 12,
  0, -1, -3, -1, -1, -3, -1, -1, -1, -1, -2, -1,  0, -1, -1, -1,  0,  0, -1, -4, -1,
 -3, -3,  0, -4, -4,  5, -5,  0, -2, -4, -2, -3, -2, -5, -4, -4, -3, -3, -3, -1, -3,  8,
  0,  2, -5,  2,  3, -5, -1,  1, -2,  0, -3, -2,  1, -1,  3,  0, -1, -1, -2, -6, -1, -4,  3};
*/
short pam250mt[]={
  2,
  0,  3,
 -2, -4, 12,
  0,  3, -5,  4,
  0,  3, -5,  3,  4,
 -3, -4, -4, -6, -5,  9,
  1,  0, -3,  1,  0, -5,  5,
 -1,  1, -3,  1,  1, -2, -2,  6,
 -1, -2, -2, -2, -2,  1, -3, -2,  5,
 -1,  1, -5,  0,  0, -5, -2,  0, -2,  5,
 -2, -3, -6, -4, -3,  2, -4, -2,  2, -3,  6,
 -1, -2, -5, -3, -2,  0, -3, -2,  2,  0,  4,  6,
  0,  2, -4,  2,  1, -3,  0,  2, -2,  1, -3, -2,  2,
  1, -1, -3, -1, -1, -5,  0,  0, -2, -1, -3, -2,  0,  6,
  0,  1, -5,  2,  2, -5, -1,  3, -2,  1, -2, -1,  1,  0,  4,
 -2, -1, -4, -1, -1, -4, -3,  2, -2,  3, -3,  0,  0,  0,  1,  6,
  1,  0,  0,  0,  0, -3,  1, -1, -1,  0, -3, -2,  1,  1, -1,  0,  2,
  1,  0, -2,  0,  0, -3,  0, -1,  0,  0, -2, -1,  0,  0, -1, -1,  1,  3,
  0, -2, -2, -2, -2, -1, -1, -2,  4, -2,  2,  2, -2, -1, -2, -2, -1,  0,  4,
 -6, -5, -8, -7, -7,  0, -7, -3, -5, -3, -2, -4, -4, -6, -5,  2, -2, -5, -6, 17,
  0, -1, -3, -1, -1, -2, -1, -1, -1, -1, -1, -1,  0, -1, -1, -1,  0,  0, -1, -4, -1,
 -3, -3,  0, -4, -4,  7, -5,  0, -1, -4, -1, -2, -2, -5, -4, -4, -3, -3, -2,  0, -2, 10,
  0,  2, -5,  3,  3, -5,  0,  2, -2,  0, -3, -2,  1,  0,  3,  0,  0, -1, -2, -6, -1, -4,  3};
/**/

short pam350mt[]={
  2,
  1,  3,
 -2, -5, 18,
  1,  3, -6,  4,
  1,  3, -6,  4,  4,
 -4, -5, -5, -6, -6, 13,
  2,  1, -4,  1,  1, -6,  5,
 -1,  1, -4,  1,  1, -2, -2,  7,
  0, -2, -3, -2, -2,  2, -2, -2,  5,
 -1,  1, -6,  1,  0, -6, -1,  1, -2,  5,
 -2, -4, -7, -4, -4,  3, -4, -2,  4, -3,  8,
 -1, -2, -6, -3, -2,  1, -3, -2,  3,  0,  5,  6,
  0,  2, -4,  2,  2, -4,  1,  2, -2,  1, -3, -2,  2,
  1,  0, -3,  0,  0, -5,  0,  0, -2, -1, -3, -2,  0,  6,
  0,  2, -6,  2,  3, -5, -1,  3, -2,  1, -2, -1,  1,  1,  4,
 -1,  0, -4, -1,  0, -5, -2,  2, -2,  4, -3,  0,  1,  0,  2,  7,
  1,  1,  0,  1,  0, -4,  1, -1, -1,  0, -3, -2,  1,  1,  0,  0,  1,
  1,  0, -2,  0,  0, -3,  1, -1,  0,  0, -2, -1,  1,  1,  0, -1,  1,  2,
  0, -2, -2, -2, -2, -1, -1, -2,  4, -2,  3,  2, -2, -1, -2, -3, -1,  0,  5,
 -7, -6,-10, -8, -8,  1, -8, -3, -6, -4, -2, -5, -5, -7, -5,  4, -3, -6, -7, 27,
  0,  0, -3, -1,  0, -2, -1,  0,  0, -1, -1,  0,  0,  0,  0, -1,  0,  0,  0, -5, -1,
 -4, -4,  1, -5, -5, 11, -6,  0,  0, -5,  0, -2, -3, -6, -5, -5, -3, -3, -2,  1, -2, 14,
  0,  2, -6,  3,  3, -6,  0,  2, -2,  1, -3, -2,  2,  0,  3,  1,  0,  0, -2, -7,  0, -5,  3};

/*
short md_40mt[]={
  9,
  0,  0,
 -7,  0, 16,
 -6,  0,-13, 11,
 -5,  0,-15,  3, 11,
-11,  0, -5,-15,-16, 13,
 -3,  0, -7, -4, -4,-15, 10,
 -9,  0, -6, -4, -8, -7,-10, 14,
 -6,  0,-11,-12,-12, -5,-13,-11, 11,
 -8,  0,-12, -8, -3,-16, -9, -6,-11, 11,
 -9,  0,-10,-14,-13, -1,-14, -7, -1,-12,  9,
 -6,  0, -9,-12,-11, -7,-12, -9,  1, -7,  1, 14,
 -6,  0, -8,  1, -5,-12, -5,  0, -8, -1,-12, -9, 12,
 -2,  0,-11,-11,-11,-11, -9, -4,-11,-10, -5,-10, -9, 12,
 -7,  0,-12, -6,  0,-14, -9,  2,-12, -1, -6, -8, -5, -3, 12,
 -7,  0, -5,-10, -8,-15, -4,  0,-10,  3, -9, -8, -6, -6,  0, 11,
  0,  0, -2, -6, -8, -6, -2, -6, -8, -7, -7, -8,  1, -1, -7, -5,  9,
  1,  0, -7, -8, -8,-11, -7, -7, -2, -5, -9, -2, -2, -4, -7, -6,  1, 10,
 -1,  0, -7, -9, -8, -6, -8,-12,  4,-12, -2,  0,-10, -9,-11,-11, -7, -4, 10,
-14,  0, -4,-15,-15, -7, -7,-13,-13,-13, -8,-11,-14,-14,-11, -4, -9,-12,-10, 18,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
-13,  0, -2, -8,-14,  2,-13,  2, -9,-13, -9,-11, -6,-13, -9,-10, -7,-10,-11, -6,  0, 14,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};

short md_120mt[]={
  6,
  0,  0,
 -3,  0, 14,
 -2,  0, -7,  8,
 -2,  0, -8,  5,  8,
 -6,  0, -2, -9,-10, 11,
  0,  0, -3,  0, -1, -9,  8,
 -4,  0, -2, -1, -3, -2, -4, 11,
 -1,  0, -5, -7, -7, -1, -6, -6,  7,
 -4,  0, -6, -2,  0, -9, -4, -1, -6,  8,
 -4,  0, -5, -8, -8,  2, -8, -4,  2, -6,  7,
 -2,  0, -5, -7, -6, -2, -6, -5,  3, -4,  3, 10,
 -1,  0, -3,  3, -1, -6, -1,  2, -4,  1, -6, -5,  8,
  0,  0, -5, -5, -5, -5, -4, -1, -5, -4, -2, -5, -3,  9,
 -3,  0, -6, -1,  2, -7, -4,  4, -6,  2, -3, -4, -1,  0,  9,
 -3,  0, -2, -4, -3, -8, -1,  2, -6,  4, -5, -4, -2, -2,  2,  8,
  2,  0,  0, -2, -3, -3,  0, -2, -3, -3, -3, -3,  2,  1, -3, -2,  5,
  2,  0, -3, -3, -4, -6, -2, -3,  0, -2, -4,  0,  1,  0, -3, -3,  2,  6,
  1,  0, -3, -5, -5, -2, -4, -6,  5, -6,  1,  2, -5, -4, -6, -6, -3,  0,  7,
 -8,  0,  0, -9, -9, -3, -3, -6, -7, -6, -4, -6, -8, -8, -6, -1, -5, -7, -6, 17,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 -7,  0,  2, -4, -7,  5, -8,  4, -5, -7, -4, -6, -2, -7, -4, -5, -3, -6, -6, -2,  0, 12,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};

short md_250mt[]={
  2,
  0,  0,
 -1,  0, 11,
 -1,  0, -3,  5,
 -1,  0, -4,  4,  5,
 -3,  0,  0, -5, -5,  8,
  1,  0, -1,  1,  1, -5,  5,
 -2,  0,  0,  0,  0,  0, -2,  6,
  0,  0, -2, -3, -3,  0, -3, -3,  4,
 -1,  0, -3,  0,  1, -5, -1,  1, -3,  5,
 -1,  0, -2, -4, -4,  2, -4, -2,  2, -3,  5,
  0,  0, -2, -3, -3,  0, -3, -2,  3, -2,  3,  6,
  0,  0, -1,  2,  1, -3,  0,  1, -2,  1, -3, -2,  3,
  1,  0, -2, -2, -2, -2, -1,  0, -2, -1,  0, -2, -1,  6,
 -1,  0, -3,  0,  2, -4, -1,  3, -3,  2, -2, -2,  0,  0,  5,
 -1,  0, -1, -1,  0, -4,  0,  2, -3,  4, -3, -2,  0, -1,  2,  5,
  1,  0,  1,  0, -1, -2,  1, -1, -1, -1, -2, -1,  1,  1, -1, -1,  2,
  2,  0, -1, -1, -1, -2,  0, -1,  1, -1, -1,  0,  1,  1, -1, -1,  1,  2,
  1,  0, -2, -3, -2,  0, -2, -3,  4, -3,  2,  2, -2, -1, -3, -3, -1,  0,  4,
 -4,  0,  1, -5, -5, -1, -1, -3, -4, -3, -2, -3, -4, -4, -3,  0, -3, -4, -3, 15,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 -3,  0,  2, -2, -4,  5, -4,  4, -2, -3, -1, -3, -1, -3, -2, -2, -1, -3, -3,  0,  0,  9,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};

short md_350mt[]={
  1,
  0,  0,
  0,  0,  9,
  0,  0, -2,  3,
  0,  0, -2,  3,  3,
 -2,  0,  1, -3, -4,  6,
  1,  0,  0,  1,  1, -3,  4,
 -1,  0,  0,  0,  0,  0, -1,  3,
  0,  0, -1, -2, -2,  1, -2, -2,  3,
 -1,  0, -1,  0,  1, -3,  0,  1, -2,  3,
 -1,  0, -1, -3, -3,  2, -2, -1,  2, -2,  3,
  0,  0, -1, -2, -2,  1, -2, -1,  2, -2,  2,  3,
  0,  0, -1,  1,  1, -2,  0,  1, -1,  1, -2, -1,  2,
  1,  0, -1, -1, -1, -2, -1,  0, -1, -1,  0, -1,  0,  4,
 -1,  0, -2,  1,  1, -2,  0,  2, -2,  2, -1, -1,  0,  0,  3,
 -1,  0,  0,  0,  0, -3,  0,  1, -2,  3, -2, -1,  0,  0,  2,  3,
  1,  0,  0,  0,  0, -1,  1,  0, -1,  0, -1, -1,  1,  1,  0,  0,  1,
  1,  0,  0,  0, -1, -1,  0, -1,  0,  0, -1,  0,  0,  1, -1,  0,  1,  1,
  0,  0, -1, -2, -2,  0, -1, -2,  2, -2,  1,  2, -1, -1, -2, -2,  0,  0,  2,
 -3,  0,  1, -4, -3,  0, -1, -2, -3, -2, -1, -2, -3, -3, -2,  0, -2, -3, -2, 14,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 -2,  0,  2, -2, -2,  5, -3,  3, -1, -2,  0, -1, -1, -2, -1, -1, -1, -2, -2,  0,  0,  7,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};
*/

short idmat[]={
10,
 0, 10,
 0, 0, 10,
 0, 0, 0, 10,
 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10};

short gon40mt[]={
  92,
   0,   0,
 -31,   0, 163,
 -56,   0,-135, 111,
 -37,   0,-140,  16, 105,
 -92,   0, -64,-152,-143, 126,
 -32,   0, -91, -51, -76,-152, 105,
 -65,   0, -67, -41, -40, -50, -81, 145,
 -76,   0, -87,-150,-106, -39,-158, -94, 104,
 -54,   0,-132, -47, -13,-127, -79, -34, -86, 103,
 -68,   0, -85,-155,-108, -13,-141, -85,   5, -85,  89,
 -45,   0, -63,-130, -80, -16,-114, -60,  10, -57,  16, 140,
 -62,   0, -83,   6, -38,-104, -40,  -7, -99, -20,-112, -91, 115,
 -37,   0,-137, -69, -60,-128, -87, -71,-108, -62, -83,-119, -78, 124,
 -43,   0,-113, -32,  10,-100, -71,   0, -91,   2, -60, -35, -25, -46, 118,
 -61,   0, -86, -77, -50,-130, -69, -31,-103,  19, -84, -81, -47, -73,  -6, 112,
   0,   0, -35, -36, -41,-111, -37, -48, -95, -43, -95, -64, -11, -35, -35, -51,  99,
 -25,   0, -59, -47, -52, -90, -85, -46, -51, -34, -78, -44, -27, -42, -39, -52,  13, 100,
 -22,   0, -43,-133, -74, -58,-122, -98,  28, -82, -18, -22,-103, -86, -79, -88, -74, -25,  97,
-120,   0, -68,-171,-131,  -6,-108, -70, -93,-127, -71, -72,-119,-149, -87, -63, -98,-120,-115, 181,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 -95,   0, -56, -98,-107,  31,-129,   5, -76, -88, -64, -66, -62,-106, -81, -75, -69, -87, -73,   1,   0, 135,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0};

short gon80mt[]={
  75,
   0,   0,
 -10,   0, 154,
 -31,   0, -93,  96,
 -17,   0, -94,  31,  88,
 -64,   0, -39,-111,-102, 114,
 -11,   0, -61, -26, -47,-115,  97,
 -39,   0, -43, -17, -17, -26, -53, 127,
 -43,   0, -54,-106, -73, -15,-114, -64,  86,
 -30,   0, -88, -21,   4, -89, -50, -12, -59,  85,
 -43,   0, -55,-109, -75,   7,-104, -57,  22, -58,  77,
 -26,   0, -39, -88, -53,   3, -83, -38,  25, -37,  31, 117,
 -34,   0, -55,  21, -13, -75, -18,   9, -71,  -2, -79, -62,  97,
 -16,   0, -93, -42, -35, -93, -58, -45, -75, -37, -58, -78, -48, 114,
 -22,   0, -76,  -9,  23, -70, -44,  14, -60,  17, -39, -19,  -6, -24,  95,
 -36,   0, -60, -44, -23, -90, -43, -10, -71,  33, -58, -53, -22, -45,  11,  97,
  14,   0, -15, -14, -19, -77, -16, -25, -62, -20, -64, -41,   5, -14, -15, -27,  78,
  -5,   0, -34, -24, -27, -62, -52, -24, -28, -15, -49, -25,  -7, -20, -18, -27,  25,  81,
  -6,   0, -21, -89, -51, -31, -86, -65,  41, -54,   3,   1, -69, -57, -51, -60, -43,  -9,  80,
 -87,   0, -43,-124, -98,  16, -81, -43, -63, -89, -44, -45, -86,-112, -62, -41, -72, -87, -80, 173,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 -65,   0, -32, -69, -74,  49, -94,  21, -47, -60, -35, -37, -39, -76, -53, -50, -46, -58, -47,  23,   0, 123,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0};

short gon120mt[]={
  59,
   0,   0,
  -1,   0, 144,
 -18,   0, -69,  82,
  -9,   0, -68,  35,  72,
 -48,   0, -26, -87, -78, 102,
  -3,   0, -45, -14, -31, -92,  90,
 -26,   0, -31,  -7,  -6, -14, -37, 110,
 -27,   0, -36, -80, -55,  -3, -87, -48,  72,
 -19,   0, -64,  -8,  11, -67, -34,  -2, -44,  69,
 -30,   0, -39, -82, -57,  15, -82, -42,  28, -44,  66,
 -17,   0, -26, -64, -40,  11, -65, -28,  29, -27,  34,  95,
 -20,   0, -41,  26,  -1, -58,  -7,  14, -55,   5, -61, -46,  80,
  -6,   0, -68, -28, -22, -72, -41, -31, -56, -24, -44, -56, -32, 105,
 -12,   0, -56,   1,  25, -53, -30,  17, -43,  20, -30, -14,   1, -14,  74,
 -23,   0, -45, -27, -10, -68, -30,  -1, -53,  36, -44, -38, -10, -30,  16,  83,
  16,   0,  -7,  -5,  -9, -58,  -6, -14, -44, -10, -47, -29,  10,  -5,  -7, -15,  60,
   2,   0, -21, -13, -15, -47, -35, -14, -17,  -6, -34, -16,   0, -10,  -9, -16,  26,  64,
   0,   0, -11, -65, -38, -17, -65, -47,  42, -39,  13,  10, -50, -42, -36, -44, -28,  -3,  65,
 -68,   0, -29, -96, -78,  27, -66, -28, -46, -68, -29, -31, -68, -89, -49, -30, -57, -67, -59, 166,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 -48,   0, -20, -53, -56,  55, -74,  26, -31, -44, -20, -22, -28, -59, -38, -37, -35, -42, -33,  33,   0, 111,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0};

short gon160mt[]={
  46,
   0,   0,
   3,   0, 135,
 -11,   0, -53,  70,
  -4,   0, -52,  34,  59,
 -38,   0, -18, -70, -62,  91,
   2,   0, -34,  -7, -21, -76,  82,
 -18,   0, -23,  -1,  -1,  -7, -27,  93,
 -18,   0, -25, -62, -43,   3, -70, -37,  59,
 -12,   0, -48,  -1,  13, -53, -24,   2, -35,  55,
 -22,   0, -29, -65, -45,  19, -67, -32,  30, -34,  57,
 -12,   0, -19, -50, -31,  14, -52, -21,  29, -21,  34,  76,
 -12,   0, -31,  26,   5, -47,  -2,  15, -44,   8, -48, -36,  65,
  -1,   0, -52, -19, -14, -58, -30, -22, -43, -16, -35, -42, -22,  96,
  -7,   0, -42,   6,  23, -41, -21,  17, -32,  20, -24, -12,   5,  -8,  56,
 -16,   0, -35, -16,  -3, -53, -21,   3, -41,  35, -35, -29,  -4, -21,  17,  71,
  16,   0,  -2,   0,  -3, -45,  -1,  -8, -33,  -4, -36, -23,  11,   0,  -2,  -9,  44,
   5,   0, -14,  -6,  -8, -36, -24,  -8, -12,  -2, -24, -11,   3,  -4,  -4,  -9,  23,  50,
   1,   0,  -6, -49, -30,  -8, -52, -35,  40, -30,  17,  14, -38, -32, -27, -34, -20,   0,  53,
 -55,   0, -21, -78, -64,  32, -55, -19, -34, -54, -20, -22, -55, -74, -40, -24, -47, -54, -45, 158,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 -37,   0, -13, -42, -44,  56, -60,  27, -20, -35, -11, -13, -22, -48, -29, -29, -28, -32, -24,  38,   0, 100,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0};

short gon250mt[]={
  24,
   0,   0,
   5,   0, 115,
  -3,   0, -32,  47,
   0,   0, -30,  27,  36,
 -23,   0,  -8, -45, -39,  70,
   5,   0, -20,   1,  -8, -52,  66,
  -8,   0, -13,   4,   4,  -1, -14,  60,
  -8,   0, -11, -38, -27,  10, -45, -22,  40,
  -4,   0, -28,   5,  12, -33, -11,   6, -21,  32,
 -12,   0, -15, -40, -28,  20, -44, -19,  28, -21,  40,
  -7,   0,  -9, -30, -20,  16, -35, -13,  25, -14,  28,  43,
  -3,   0, -18,  22,   9, -31,   4,  12, -28,   8, -30, -22,  38,
   3,   0, -31,  -7,  -5, -38, -16, -11, -26,  -6, -23, -24,  -9,  76,
  -2,   0, -24,   9,  17, -26, -10,  12, -19,  15, -16, -10,   7,  -2,  27,
  -6,   0, -22,  -3,   4, -32, -10,   6, -24,  27, -22, -17,   3,  -9,  15,  47,
  11,   0,   1,   5,   2, -28,   4,  -2, -18,   1, -21, -14,   9,   4,   2,  -2,  22,
   6,   0,  -5,   0,  -1, -22, -11,  -3,  -6,   1, -13,  -6,   5,   1,   0,  -2,  15,  25,
   1,   0,   0, -29, -19,   1, -33, -20,  31, -17,  18,  16, -22, -18, -15, -20, -10,   0,  34,
 -36,   0, -10, -52, -43,  36, -40,  -8, -18, -35,  -7, -10, -36, -50, -27, -16, -33, -35, -26, 142,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 -22,   0,  -5, -28, -27,  51, -40,  22,  -7, -21,   0,  -2, -14, -31, -17, -18, -19, -19, -11,  41,   0,  78,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0};

short gon300mt[]={
  16,
   0,   0,
   5,   0, 104,
  -1,   0, -24,  37,
   1,   0, -23,  23,  27,
 -18,   0,  -5, -37, -31,  60,
   5,   0, -15,   3,  -4, -42,  58,
  -6,   0, -10,   5,   4,   0, -10,  45,
  -6,   0,  -7, -30, -21,  11, -36, -16,  33,
  -2,   0, -21,   6,  11, -26,  -7,   5, -17,  24,
  -9,   0, -10, -32, -22,  19, -36, -14,  25, -17,  33,
  -5,   0,  -6, -24, -16,  15, -28, -10,  22, -11,  24,  31,
  -1,   0, -14,  18,   9, -25,   5,  10, -22,   8, -24, -17,  27,
   3,   0, -23,  -4,  -2, -30, -11,  -8, -20,  -3, -18, -19,  -6,  66,
  -1,   0, -18,   9,  14, -20,  -6,   9, -15,  13, -13,  -8,   7,  -1,  18,
  -4,   0, -17,   0,   5, -25,  -6,   6, -19,  22, -18, -13,   4,  -6,  13,  37,
   8,   0,   1,   5,   3, -22,   4,  -1, -14,   2, -17, -11,   7,   4,   2,   0,  15,
   5,   0,  -3,   1,   1, -17,  -7,  -1,  -4,   2,  -9,  -5,   4,   2,   1,  -1,  11,  17,
   0,   0,   1, -23, -15,   4, -26, -15,  26, -13,  17,  15, -17, -14, -12, -15,  -8,   0,  26,
 -29,   0,  -7, -42, -36,  36, -34,  -5, -13, -28,  -4,  -6, -30, -41, -23, -14, -27, -28, -19, 132,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 -17,   0,  -3, -22, -22,  46, -33,  18,  -3, -17,   3,   1, -12, -25, -14, -14, -15, -15,  -7,  40,   0,  67,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0};

short gon350mt[]={
  10,
   0,   0,
   4,   0,  93,
   0,   0, -19,  29,
   1,   0, -17,  19,  20,
 -14,   0,  -3, -30, -25,  51,
   5,   0, -12,   4,  -2, -35,  51,
  -4,   0,  -8,   5,   4,   1,  -7,  33,
  -4,   0,  -5, -24, -17,  11, -29, -13,  27,
  -1,   0, -16,   6,   9, -21,  -4,   5, -13,  18,
  -7,   0,  -7, -25, -18,  18, -30, -11,  22, -14,  28,
  -4,   0,  -4, -19, -13,  14, -23,  -8,  19,  -9,  21,  23,
   0,   0, -11,  15,   9, -20,   5,   8, -18,   7, -19, -14,  20,
   3,   0, -18,  -2,   0, -25,  -7,  -5, -16,  -2, -15, -14,  -3,  56,
   0,   0, -14,   8,  11, -16,  -4,   7, -11,  10, -11,  -7,   6,   0,  12,
  -2,   0, -13,   2,   6, -20,  -4,   6, -15,  18, -14, -11,   4,  -4,  10,  28,
   6,   0,   1,   5,   3, -18,   5,   0, -11,   2, -13,  -9,   6,   4,   2,   1,  10,
   4,   0,  -2,   2,   1, -13,  -5,  -1,  -3,   2,  -7,  -4,   4,   2,   1,   0,   8,  11,
   0,   0,   2, -18, -12,   5, -21, -11,  22, -10,  16,  14, -13, -11,  -9, -12,  -6,   0,  21,
 -24,   0,  -4, -35, -29,  35, -30,  -3,  -9, -23,  -1,  -3, -24, -34, -19, -12, -22, -23, -14, 124,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 -14,   0,  -1, -18, -17,  42, -27,  15,  -1, -14,   5,   2, -10, -20, -11, -12, -12, -12,  -4,  39,   0,  57,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0};

/***************************************************************
***
***  ALIGNMENT
***
#define DEFAULT_M       ((FloatHi)1.0)
#define DEFAULT_I       ((FloatHi)-1.0)
#define DEFAULT_V       ((FloatHi)-1.0)
#define DEFAULT_O       ((FloatHi)6.0)
#define DEFAULT_E       ((FloatHi)0.2)
#define DEFAULT_PAM_O   ((FloatHi) 12.0)
#define DEFAULT_PAM_E   ((FloatHi)4.0)
**************************************************************/
static Char *matrixlst [] = {"", "idmat",
"blosum30mt", "blosum40mt", "blosum62mt", "blosum80mt",
"pam60mt", "pam120mt", "pam250mt", "pam350mt",
"gon80mt", "gon250mt", "gon350mt"
};

/***********************************************************
***
*/

static Int2 arank (Char aa, CharPtr aalst)
{
  Int2 j;
  for (j=0; j<23; j++)
     if (aalst[j] == aa) return j;
  return 0;
}

static Boolean new_matrice (Int2 simmatrix, CharPtr path)
{
  CharPtr aalst = "ABCDEFGHIKLMNPQRSTVWXYZ";
  CharPtr zjlst = "ARNDCQEGHILKMFPSTWYVBZX";

  Int2   mattmp[23][23];
  Int2   matzj[23][23];
  Int2   j, k, j1;
  FILE   *fout;
  short *mat;

  if (simmatrix == 2)  mat = blosum30mt;
  else if (simmatrix == 3)  mat = blosum40mt;
  else if (simmatrix == 4)  mat = blosum62mt;
  else if (simmatrix == 5)  mat = blosum80mt;
  else if (simmatrix == 6)  mat = pam60mt;
  else if (simmatrix == 7)  mat = pam120mt;
  else if (simmatrix == 8)  mat = pam250mt;
  else if (simmatrix == 9)  mat = pam350mt;
  else if (simmatrix == 10) mat = gon80mt;
  else if (simmatrix == 11) mat = gon250mt;
  else if (simmatrix == 12) mat = gon350mt;
  else mat = idmat;

  j1 = 0;
  for (j=0; j<23; j++) {
     for(k=0; k<=j; k++) {
        mattmp [j][k] = mat [j1];
        mattmp [k][j] = mattmp [j][k];
        j1++;
     }
  }
  for (j=0; j<23; j++)
     for(k=0; k<=j; k++) {
        matzj [j][k] = mattmp [arank((Char)zjlst[j], aalst)] [arank((Char)zjlst[k], aalst)];
        matzj [k][j] = matzj [j][k];
     }

  if ( (fout = FileOpen (path, "w")) != NULL) {
     fprintf (fout, "%s\n", zjlst);
     for (j=0; j<23; j++) {
        for(k=0; k<23; k++) {
           fprintf (fout, "%3d,",  matzj [j][k]);
        }
        fprintf (fout, "\n");
     }
     FileClose (fout);
     return TRUE;
  }
  return FALSE;
}

/*----------------------------------------------------------------------*/
/*----------------------------------------------------------------------*/
static Int4 ANcode(Char car)
{
  if (car == 'T' || car=='t') return(1);
  if (car == 'C' || car=='c') return(2);
  if (car == 'A' || car=='a') return(3);
  if (car == 'G' || car=='g') return(4);
  return(0);
}
static Char ANdecode(Int4 c)
{
  if (c == 1) return('T');
  if (c == 2) return('C');
  if (c == 3) return('A');
  if (c == 4) return('G');
  return('-');
}
 
static Int2 AAcode(Char car)
/* ------------associate numbers 1-20 to AA in alphabetic order, otw 0 */
{
  if (car=='.' || car=='-') return(0);
  if (car=='A') return(1);  if (car=='B') return(2);
  if (car=='C') return(3);  if (car=='D') return(4);
  if (car=='E') return(5);  if (car=='F') return(6);
  if (car=='G') return(7);  if (car=='H') return(8);
  if (car=='I') return(9);  if (car=='K') return(10);
  if (car=='L') return(11); if (car=='M') return(12);
  if (car=='N') return(13); if (car=='P') return(14);
  if (car=='Q') return(15); if (car=='R') return(16);
  if (car=='S') return(17); if (car=='T') return(18);
  if (car=='V') return(19); if (car=='W') return(20);
  if (car=='X') return(21); if (car=='Y') return(22);
  if (car=='Z') return(23); if (car=='U') return(24);
  if (car=='*') return(25);
  return(0);
}
 
/*----------------------------------------------------------------------*/
static char Transl(char *s)
{
  int cod;
 
  if (s==NULL) return(CARNUL);
  if (ANcode(s[0])==0 || ANcode(s[1])==0 || ANcode(s[2])==0)
     return(CARGAP);
  cod=4*(ANcode(s[0])-1) + (16*(ANcode(s[1])-1))
                + (ANcode(s[2])-1);
  return(StP[cod]);
}

/*----------------------------------------------------------------------*/
static Int2Ptr PNTR Int2matrix (Int4 nrows, Int4 ncol)
{
  Int2Ptr PNTR tabp = NULL;
  Int4         j, k;

  if (nrows < 2 || ncol < 2) 
     return NULL;
  tabp = (Int2Ptr PNTR) MemNew ((size_t)((nrows+1)*sizeof(Int2Ptr)));
  if (tabp == NULL) 
     return NULL; 
  tabp +=1;
  tabp[0]=(Int2Ptr) MemNew((size_t)((nrows*ncol+1)*sizeof(Int2)));
  if (tabp[0] == NULL) 
     return NULL; 
  tabp[0] +=1;
  for ( j = 1;j < nrows; j++ ) 
     tabp[j] = tabp[j-1] + ncol;
  for (k = 0; k < nrows; k++) 
     for (j = 0; j < ncol; j++) 
        tabp[k][j] = 0; 
  return tabp;
} 

static Int4Ptr PNTR Int4matrix (Int2 nrows, Int2 ncol)
{
  Int4Ptr PNTR tabp = NULL;
  Int2         j, k;

  if (nrows < 2 || ncol < 2) 
     return NULL;
  tabp = (Int4Ptr PNTR) MemNew ((size_t)((nrows+1)*sizeof(Int4Ptr)));
  if (tabp == NULL) 
     return NULL; 
  tabp +=1;
  tabp[0] = (Int4Ptr) MemNew ((size_t)((nrows*ncol+1)*sizeof(Int4)));
  if (tabp[0] == NULL) 
     return NULL; 
  tabp[0] +=1;
  for (j = 1; j < nrows; j++) {
     tabp[j] = tabp[j-1] + ncol;
  }
  for (k = 0; k < nrows; k++) 
     for (j = 0; j < ncol; j++) 
        tabp[k][j] = 0; 
  return tabp;
} 

static FloatLoPtr PNTR FloatLomatrix (Int2 nrows, Int2 ncol)
{
  FloatLoPtr PNTR  tabp = NULL;
  Int2           j, k;

  tabp = (FloatLoPtr PNTR) MemNew ((size_t)((nrows+1)*sizeof(FloatLoPtr)));
  if (tabp == NULL) { return NULL; }  
  tabp +=1;
  tabp[0]=(FloatLoPtr) MemNew((size_t)((nrows*ncol+1)*sizeof(FloatLo)));
  if (tabp[0] == NULL)  
     return NULL; 
  tabp[0] +=1;
  for ( j = 1;j < nrows; j++ ) {
     tabp[j] = tabp[j-1] + ncol;
  }
  for (k = 0; k < nrows; k++) 
     for (j = 0; j < ncol; j++) 
        tabp[k][j] = (float)0; 
  return tabp;
} 

static void writematrix (FILE *f_out, Int4Ptr PNTR dist, ValNodePtr sqlocs, Int4 from1, Int4 to1, Int4 from2, Int4 to2, CharPtr str)
{
  Int4            j, k;
  ValNodePtr      vnp,
                  vnp2;
  SeqLocPtr       slp;
  Char  strLog[128];

  if (f_out != NULL) {
     if (to1-from1 < 4 && sqlocs != NULL) {
        vnp = sqlocs;
        for (j = from1; j < to1; j++) {
           if (dist[j] != NULL) {
              vnp2 = sqlocs;
              for (k = from2; k <= j; k++) 
                 vnp2=vnp2->next;
              for (; k < to2; k++) {
                 slp = (SeqLocPtr) vnp->data.ptrvalue;
                 SeqIdWrite(SeqLocId(slp),strLog,PRINTID_REPORT,sizeof(strLog));
                 fprintf (f_out, "%5s ", strLog);
                 slp = (SeqLocPtr) vnp2->data.ptrvalue;
                 SeqIdWrite(SeqLocId(slp),strLog,PRINTID_REPORT,sizeof(strLog));
                 fprintf (f_out, "/ %5s ", strLog);
                 fprintf (f_out, "%5ld ", (long)dist[j][k]);
                 vnp2=vnp2->next;
              }
           }
           vnp=vnp->next;
           fprintf(f_out, "\n");
        }
        return;
     }
     fprintf (f_out, "%s\n\n", str);
     if (sqlocs!=NULL) {
           for (vnp=sqlocs; vnp!=NULL; vnp=vnp->next) {
           slp = (SeqLocPtr) vnp->data.ptrvalue;
           SeqIdWrite(SeqLocId(slp), strLog, PRINTID_REPORT, 5); 
           fprintf (f_out, "%5s ", strLog);
        }
        fprintf(f_out, "\n");
        vnp = sqlocs;
     }
     for (j = from1; j < to1; j++) {
        if (dist[j] != NULL) {
           for (k = from2; k < to2; k++)
              fprintf (f_out, "%5ld ", (long)dist[j][k]);
           if (sqlocs!=NULL) {
              slp = (SeqLocPtr) vnp->data.ptrvalue;
              SeqIdWrite(SeqLocId(slp),strLog,PRINTID_REPORT, sizeof (strLog)); 
              fprintf (f_out, "%5s ", strLog);
              vnp=vnp->next;
           }
           fprintf(f_out, "\n");
        }
     }
     fprintf(f_out, "\n");
     return;
  }
  WriteLog ("%s\n\n", str);
  for (j = from1; j < to1; j++) {
     if (dist[j] != NULL) {
        for (k = from2; k < to2; k++)
           WriteLog ("%5ld ", (long)dist[j][k]);
        WriteLog ("\n");
     }
  }
  WriteLog ("\n");
  return; 
}

static void writematrixhalf (FILE *f_out, Int4Ptr PNTR dist, ValNodePtr sqlocs, Int4 from1, Int4 to1, Int4 from2, Int4 to2, CharPtr str)
{
  Int4            j, k;
  ValNodePtr      vnp,
                  vnp2;
  SeqLocPtr       slp;
  Char  strLog[128];

  if (f_out != NULL) {
     if (to1-from1 < 4 && sqlocs != NULL) {
        fprintf (f_out, "%s\n\n", str);
        vnp = sqlocs;
        for (j = from1; j < to1; j++) {
           if (dist[j] != NULL) {
              vnp2 = sqlocs;
              for (k = from2; k <= j; k++)
                 vnp2=vnp2->next;
              for (; k < to2; k++) {
                 slp = (SeqLocPtr) vnp->data.ptrvalue;
                 SeqIdWrite(SeqLocId(slp),strLog,PRINTID_REPORT,sizeof(strLog));
                 fprintf (f_out, "%5s ", strLog);
                 slp = (SeqLocPtr) vnp2->data.ptrvalue;
                 SeqIdWrite(SeqLocId(slp),strLog,PRINTID_REPORT,sizeof(strLog));
                 fprintf (f_out, "/ %5s ", strLog);
                 fprintf (f_out, "%5ld \n", (long)dist[j][k]);
                 vnp2=vnp2->next;
              }
           }
           vnp=vnp->next;
           fprintf(f_out, "\n");
        }
        return;
     }
     fprintf (f_out, "%s\n\n", str);
     if (sqlocs!=NULL) {
        vnp=sqlocs->next;
        for (; vnp!=NULL; vnp=vnp->next) {
           slp = (SeqLocPtr) vnp->data.ptrvalue;
           SeqIdWrite(SeqLocId(slp), strLog, PRINTID_REPORT, 6); 
           fprintf (f_out, "%5s ", strLog);
        }
        fprintf(f_out, "\n");
        vnp = sqlocs;
     }
     for (j = from1; j < to1; j++) {
        if (dist[j] != NULL) {
           for (k = from2+1; k <= j; k++) 
              fprintf (f_out, "      "); 
           for (; k < to2; k++)
              fprintf (f_out, "%5ld ", (long)dist[j][k]);
           if (sqlocs!=NULL) {
              slp = (SeqLocPtr) vnp->data.ptrvalue;
              SeqIdWrite(SeqLocId(slp),strLog,PRINTID_REPORT, sizeof (strLog)); 
              fprintf (f_out, " %s", strLog);
              vnp=vnp->next;
           }
           fprintf(f_out, "\n");
        }
     }
     fprintf(f_out, "\n");
     return;
  }
  WriteLog ("%s\n\n", str);
  for (j = from1; j < to1; j++) {
     if (dist[j] != NULL) {
        for (k = from2; k <= j; k++)
           WriteLog ("      ");
        for (; k < to2; k++)
           WriteLog ("%5ld ", (long)dist[j][k]);
        WriteLog ("\n");
     }
  }
  WriteLog ("\n");
  return; 
}

static void write_vector2 (Int2Ptr tab, Int4 lens)
{
  FILE            *fout;
  Int4            j;
 
  if (tab == NULL)
     return;
  fout = FileOpen (path_out, "w");
  if (fout != NULL) 
  {
     for (j=0; j<lens; j++) {
        fprintf(fout, "%ld %ld \n", (long)j, (long)tab[j]);
     }
     FileClose(fout);
  }
  return;
}

/*---------------------- copy_string ------------------*/
static Int4 copy_string (CharPtr to, CharPtr from, Int4 i1, Int4 i2, Uint1 mol_type, Boolean caps)
{
  Int4 i = i1;
 
  if (i1== i2)  {
    Message (MSG_ERROR, "error in copy_string : length null");
    return(0);
  }
  if (i1 > 0)   from += i1;
  if (!*from) {
    Message (MSG_ERROR, "error in copy_string: prematured initial index %d", i1);
    return (0);
  } 
  switch ( mol_type )
  {
     case Seq_mol_other:
        while (i < i2 && *from && *from != '\0' && *from != '\n')
        {
 
          if (*from != ' ') {
             *to++ = *from;
             ++i;
           }
           *from++;
        }
        break;
     case Seq_mol_aa:
        while (i < i2 && *from && *from != '\0' && *from != '\n') {
          if (caps == TRUE && (*from >= 'a' && *from <= 'z'))
            *from = *from - ('a' - 'A');
          if ( (*from >= 'a' && *from <= 'z') || (*from >= 'A' && *from <= 'Z')
             || *from == '-' || *from == '.' || *from == '*') {
            *to = *from;
            to++;
            ++i;
          }
          *from++;
        }
        break;
     case Seq_mol_na:
        while (i < i2 && *from && *from != '\0' && *from != '\n') {
          if ( *from == 'a') *from = 'A';
          if ( *from == 'c') *from = 'C';
          if ( *from == 'g') *from = 'G';
          if ( *from == 't') *from = 'T';
          if ( *from == 'n') *from = 'N';
 
          if(((( *from == 'a' || *from == 'c' || *from == 't' || *from == 'g')
             || (*from == 'A' || *from == 'C' || *from == 'T' || *from == 'G'))
             || (*from == 'n' || *from == 'N'))
             || (*from == '-' || *from == '.')) {
             *to = *from;
             to++;
           }
           ++i;
           from++;
        }
        break;
     default:
        while (i++ < i2 && *from && *from != '\0' && *from != '\n')
           *to++ = *from++;
        break;
  }
  *to = '\0';
  if (i > i1) return(i - i1);
  return(0);
}
 

/***************************************************************************/
/*------------------------   SELECTION PRESURE     -----------------------*/
/***************************************************************************/

static FloatLo ChangeTh (Char s[], Int2 iChoix)
{
  Char    codon[4]; 
  Char    codon2[4]; 
  FloatLo stemp = (FloatLo)0;
  Char    cod, 
          codt;
  Int4    j, k;

  if (!(k=copy_string(codon, s, 0, 3, Seq_mol_other, FALSE))) {
    return (FloatLo)0;
  }
  codon2[0] = codon[0]; codon2[1] = codon[1];
  codon2[2] = codon[2]; codon2[3] = '\0';
  cod = Transl(codon);
  if (cod == '*') {
    return (FloatLo)0;
  }
  for (k=0; k < 3; ++k) {
    for (j=1; j < 5; ++j) 
      if (j != ANcode(codon[k]) ) {
        codon2[k] = ANdecode(j);
        codt = Transl(codon2);
        if (cod == codt ) stemp += (float)(1.00/3.00);
      }
    codon2[k] = codon[k];
  }
  if ( iChoix == ChgNSy ) {
     return (FloatLo)(3.0 - stemp);
  }
  return(stemp);
}


static FloatLo ChangeObs (Char s1[], Char s2[], Int2 iChoix)
{
  Char    codt[4];
  Char    codtp[4];
  FloatLo stemp = (FloatLo)0, ntemp = (FloatLo)0;
  Int4    diff[4], j, k, 
          nbdiff = 0;
  Char    c1, c2, c3, c4;

  if ((c1=Transl(s1)) == '*' || (c2=Transl(s2)) == '*') {
    return (FloatLo)0;
  }
  if (!(k=copy_string(codt, s1, 0, 3, Seq_mol_other, FALSE))) {
    return (FloatLo)0;
  }
  for (k=0; k<3; ++k) if (s1[k] != s2[k]) {
    diff[nbdiff] = k;
    ++nbdiff;
  }
  if (nbdiff==1) 
  {
    if (((c1==c2) && (iChoix==ChgSy)) || ((c1 !=c2) && (iChoix !=ChgSy))) {
      return (FloatLo)1; 
   }
   return (FloatLo)0;
  }
  if (nbdiff==2) {
    for (k=0; k<2; ++k) {
      codt[diff[k]] = s2[diff[k]];
      c3 = Transl (codt);  
      if (c1==c3) stemp+=(FloatLo)1; else ntemp+=(FloatLo)1;
      if (c2==c3) stemp+=(FloatLo)1; else ntemp+=(FloatLo)1;
      codt[diff[k]] = s1[diff[k]]; 
    }
    if (iChoix == ChgSy) {   
       return(stemp/2);
    }
    return(ntemp/2);
  }
  if (nbdiff==3) {
    if (!(k=copy_string(codtp, s1, 0, 3, Seq_mol_other, FALSE))) {
       return (FloatLo)-1;
    }
    for (k =0; k <3; ++k) {
      codt[diff[k]] = s2[diff[k]];
      codtp[diff[k]] = s2[diff[k]];
      c3 = Transl(codt);
      j = (k + 1) % 3;
      while (j != k) 
      {
        codtp[diff[j]] = s2[diff[j]];
        c4 = Transl(codtp);
        if (c1==c3) stemp+=(FloatLo)1; else ntemp+=(FloatLo)1;
        if (c3==c4) stemp+=(FloatLo)1; else ntemp+=(FloatLo)1;
        if (c4==c2) stemp+=(FloatLo)1; else ntemp+=(FloatLo)1;
        codtp[diff[k]] = s1[diff[k]];
        k = (k+1) % 3;
      }
      codt[diff[k]] = s1[diff[k]];
      codtp[diff[k]] = s1[diff[k]]; 
    }
    if (iChoix == ChgSy) {  
       return(stemp/6);
    }
    return(ntemp/6);
  }
  return (FloatLo)0;
}


static void nss_ref_complength (CharPtr PNTR seqp, Int2 ref, Int2 fromseq2, Int2 toseq2, Int4 kfrom, Int4 kto)
{
  Char     s1 [4],
           s2 [4];
  Int2     m;
  Int4     k, k1;
  Int4     l1, l2;
  Int2     sum;
  FloatLo  syth, nsth,  syob, nsob;
  FloatLo  ssyth, snsth,  ssyob, snsob;
  Int2     window = 0;
  Char     c0, c02,
           c1, c2; 
  Boolean  first;

  ssyth = snsth = ssyob = snsob = (FloatLo)0;
  window = 0;
  k = k1 = kfrom;  
  first = TRUE;
  while ( k < kto ) 
  {
    syth = nsth = syob = nsob = (FloatLo)0;
    sum = 0;
    if (first) {
       l2 = copy_string (s2, seqp[ref], k, (k+3), Seq_mol_na, FALSE);
       c0 = Transl(s2);
       l2 = copy_string (s2, seqp[ref], k+3, (k+6), Seq_mol_na, FALSE);
       c02 = Transl(s2);
    }
    l2 = copy_string (s2, seqp[ref], k, (k+3), Seq_mol_na, FALSE);
    for (m = fromseq2; m < toseq2; ++m) 
    {
	  l1 = copy_string (s1, seqp[m], k, (k+3), Seq_mol_na, FALSE);
	  
	  if ( l1 != 0 && l2 != 0 ) 
          {
             if (s1[0] != '-' && s1[1] != '-' && s1[2] != '-' && s2[0] != '-' && s2[1] != '-' && s2[2] != '-') 
             if (s1[0] != 'N' && s1[1] != 'N' && s1[2] != 'N' && s2[0] != 'N' && s2[1] != 'N' && s2[2] != 'N') 
             {      
                    if (first) { c1=Transl(s1); c2=Transl(s2); first=FALSE; }
                    sum++;
		    syth += (ChangeTh(s1, ChgSy) + ChangeTh(s2,ChgSy)) / 2;
		    nsth += (ChangeTh(s1, ChgNSy)+ ChangeTh(s2,ChgNSy))/ 2;
		    syob += ChangeObs(s1, s2, ChgSy);
		    nsob += ChangeObs(s1, s2, ChgNSy);
/**
WriteLog("%d %c%c %s %s %d %f %f %f %f %f\n", k, Transl(s1), Transl(s2), s1, s2, sum, syth, nsth, syob, nsob, snsob);
WriteLog("%s %s %f %f %f %f\n",s1,s2,syth, nsth, syob, nsob);
**/
	     }
             else { 
                /*Message (MSG_ERROR, "1 gap");*/ }
          }
     } 
     if (sum>0) {
        window++;
        ssyth += syth / (float)sum; 
        snsth += nsth / (float)sum; 
        ssyob += syob / (float)sum; 
        snsob += nsob / (float)sum;
     }
     k += 3;
  }
  if (window > 0) 
  {
        fprintf(fout, "%c%c, %c%c, %5d, %5d, %5d,  ", (char)c0, (char)c02, (char)Transl(s1), (char)Transl(s2), (int)k, (int)k1, (int)sum);
         
        if (ssyth > 0.000001 && snsth >0.000001 )  { 
           fprintf(fout, "  %5.3f, %5.3f, ", (float)ssyob/ssyth, (float)snsob/snsth);
        } 
        else fprintf(fout, "  ,  , "); 
        if (ssyth > 0.000001 && snsth >0.000001 && ssyob >0.000001 ) { 
           fprintf(fout, " %5.3f, ", (float)snsob/snsth/ssyob/ssyth); 
        }
        else fprintf(fout, "  , "); 
        fprintf(fout, "\n");
  }
}

static void nss_ref_window (CharPtr PNTR seqp, Int2 ref, Int2 fromseq2, Int2 toseq2, Int4 kfrom, Int4 kto, Int4 win_width)
{
  Int4            k;

  k = kfrom;  
  while ( k < kto - (3 * 10)) 
  {
     nss_ref_complength (seqp, ref, fromseq2, toseq2, k, k+win_width);
     k += (3 * 10);
  }
  return;
}

static void nss_pw_complength (CharPtr PNTR seqp, Int2 fromseq, Int2 toseq, Int4 kfrom, Int4 kto)
{
  Char     s1 [4],
           s2 [4];
  Int2     n, m;
  Int4     k, k1;
  Int4     l1, l2;
  Int2     sum;
  FloatLo  syth, nsth,  syob, nsob;
  FloatLo  ssyth, snsth,  ssyob, snsob;
  Int2     window = 0;
  Char     c0, c02,
           c1, c2; 
  Boolean  first;

  ssyth = snsth = ssyob = snsob = (FloatLo)0;
  window = 0;
  k = kfrom; k1 = kfrom;  
  first = TRUE;
  while ( k < kto ) 
  {
     syth = nsth = syob = nsob = (FloatLo)0;
     sum = 0;
     if (first) {
        l2 = copy_string (s2, seqp[0], k, (k+3), Seq_mol_na, FALSE);
        c0 = Transl(s2);
        l2 = copy_string (s2, seqp[0], k+3, (k+6), Seq_mol_na, FALSE);
        c02 = Transl(s2);
     }
     for (n = fromseq; n < toseq; ++n) 
     {
        l1 = copy_string (s1, seqp[n], k, (k+3), Seq_mol_na, FALSE);
        for (m = fromseq; m < toseq; ++m) 
        {
           l2 = copy_string (s2, seqp[m], k, (k+3), Seq_mol_na, FALSE);
	   if ( l1 != 0 && l2 != 0 ) 
           {
              if (s1[0] != '-' && s1[1] != '-' && s1[2] != '-' && s2[0] != '-' && s2[1] != '-' && s2[2] != '-') 
              if (s1[0] != 'N' && s1[1] != 'N' && s1[2] != 'N' && s2[0] != 'N' && s2[1] != 'N' && s2[2] != 'N') 
              {      
                    if (first) { c1=Transl(s1); c2=Transl(s2); first=FALSE; }
                    sum++;
		    syth += (ChangeTh(s1, ChgSy) + ChangeTh(s2,ChgSy)) / 2;
		    nsth += (ChangeTh(s1, ChgNSy)+ ChangeTh(s2,ChgNSy))/ 2;
		    nsob += ChangeObs(s1, s2, ChgNSy);
		    syob += ChangeObs(s1, s2, ChgSy);
/**
WriteLog ("%d %d %s %s %f %f %f %f   %d  %f %f %f %f\n", k, kto, s1, s2, syth, nsth, syob, nsob, window, ssyth, snsth, ssyob, snsob);
**/
	      }
              else { 
                 /*Message (MSG_ERROR, "1 gap");*/ }
           }
        }
     }
     if (sum>0) {
        window++;
        ssyth +=(syth/(float)sum); 
        snsth +=(nsth/(float)sum); 
        ssyob+=(syob/(float)sum);  
        snsob +=(nsob/(float)sum);
     }
     k += 3;
  }
  if (window > 0) {
        fprintf(fout, "%c%c, %c%c, %5d, %5d, %5d,  ", (char)c0, (char)c02, (char)Transl(s1), (char)Transl(s2), (int)k, (int)k1, (int)sum);
         
        if (ssyth > 0.000001 && snsth >0.000001 )  { 
           fprintf(fout, "  %5.3f, %5.3f, ", (float)ssyob/ssyth, (float)snsob/snsth);
        } 
        else fprintf(fout, "  ,  , "); 
        if (ssyth > 0.000001 && snsth >0.000001 && ssyob >0.000001 ) { 
           fprintf(fout, " %5.3f, ", (float)snsob/snsth/ssyob/ssyth); 
        }
        else fprintf(fout, "  , "); 
        fprintf(fout, "\n");
  }
}

static void nss_pw_window (CharPtr PNTR seqp, Int2 ref, Int2 fromseq, Int2 toseq, Int4 kfrom, Int4 kto, Int4 win_width)
{
  Int4            k;

  k = kfrom;  
  while ( k < kto - (3 * 10)) 
  {
     nss_pw_complength (seqp, fromseq, toseq, k, k+win_width);
     k += (3 * 10);
  }
  return;
}


static void nss_gp_complength (CharPtr PNTR seqp, ValNodePtr params, Int2 group1, Int2 group2, Int2 fromseq, Int2 toseq, Int4 kfrom, Int4 kto)
{
  Char     s1 [4],
           s2 [4];
  Int2     n, m;
  Int4     k, k1;
  Int4     l1, l2;
  Int2     sum;
  FloatLo  syth, nsth,  syob, nsob;
  FloatLo  ssyth, snsth,  ssyob, snsob;
  Int2     window = 0;
  Char     c0, c02,
           c1, c2; 
  Boolean  first;
  ValNodePtr      vnp1, vnp2 = NULL;
  SeqParamPtr     spp1, spp2;

  ssyth = snsth = ssyob = snsob = (FloatLo)0;
  window = 0;
  k = kfrom; k1 = kfrom;  
  first = TRUE;
  while ( k < kto ) 
  {
     syth = nsth = syob = nsob = (FloatLo)0;
     sum = 0;
     if (first) {
        l2 = copy_string (s2, seqp[0], k, (k+3), Seq_mol_na, FALSE);
        c0 = Transl(s2);
        l2 = copy_string (s2, seqp[0], k+3, (k+6), Seq_mol_na, FALSE);
        c02 = Transl(s2);
     }
     for (n=0, vnp1=params; n < fromseq && vnp1!=NULL; n++) 
        vnp1=vnp1->next;
     for (n = fromseq; n < toseq && vnp1!=NULL; ++n, vnp1=vnp1->next) 
     {
        l1 = copy_string (s1, seqp[n], k, (k+3), Seq_mol_na, FALSE);
        for (m=0, vnp2=params; m < k+1 && vnp2!=NULL; m++) 
           vnp2=vnp2->next;
        for (m = fromseq; m < toseq && vnp2!=NULL; ++m, vnp2=vnp2->next) 
        {
           spp1 = (SeqParamPtr) vnp1->data.ptrvalue;
           spp2 = (SeqParamPtr) vnp2->data.ptrvalue;
           if (spp1->group == group1 && spp2->group == group1)
           {
              l2 = copy_string (s2, seqp[m], k, (k+3), Seq_mol_na, FALSE);
	      if ( l1 != 0 && l2 != 0 ) 
              {
                 if (s1[0] != '-' && s1[1] != '-' && s1[2] != '-' && s2[0] != '-' && s2[1] != '-' && s2[2] != '-') 
                 if (s1[0] != 'N' && s1[1] != 'N' && s1[2] != 'N' && s2[0] != 'N' && s2[1] != 'N' && s2[2] != 'N') 
                 {      
                    if (first) { c1=Transl(s1); c2=Transl(s2); first=FALSE; }
                    sum++;
		    syth += (ChangeTh(s1, ChgSy) + ChangeTh(s2,ChgSy)) / 2;
		    nsth += (ChangeTh(s1, ChgNSy)+ ChangeTh(s2,ChgNSy))/ 2;
		    nsob += ChangeObs(s1, s2, ChgNSy);
		    syob += ChangeObs(s1, s2, ChgSy);
/**
WriteLog ("%d %d %s %s %f %f %f %f   %d  %f %f %f %f\n", k, kto, s1, s2, syth, nsth, syob, nsob, window, ssyth, snsth, ssyob, snsob);
**/
	         }
                 else { 
                    /*Message (MSG_ERROR, "1 gap");*/ }
              }
           }
        }
     }
     if (sum>0) {
        window++;
        ssyth +=(syth/(float)sum); 
        snsth +=(nsth/(float)sum); 
        ssyob+=(syob/(float)sum);  
        snsob +=(nsob/(float)sum);
     }
     k += 3;
  }
  if (window > 0) {
        fprintf(fout, "%c%c, %c%c, %5d, %5d, %5d,  ", (char)c0, (char)c02, (char)Transl(s1), (char)Transl(s2), (int)k, (int)k1, (int)sum);
         
        if (ssyth > 0.000001 && snsth >0.000001 )  { 
           fprintf(fout, "  %5.3f, %5.3f, ", (float)ssyob/ssyth, (float)snsob/snsth);
        } 
        else fprintf(fout, "  ,  , "); 
        if (ssyth > 0.000001 && snsth >0.000001 && ssyob >0.000001 ) { 
           fprintf(fout, " %5.3f, ", (float)snsob/snsth/ssyob/ssyth); 
        }
        else fprintf(fout, "  , "); 
        fprintf(fout, "\n");
  }
}


static void nss_gp_window (CharPtr PNTR seqp, ValNodePtr params, Int2 group1, Int2 group2, Int2 fromseq, Int2 toseq, Int4 kfrom, Int4 kto, Int4 win_width)
{
  Int4            k;

  k = kfrom;  
  while ( k < kto - (3 * 10)) 
  {
     nss_gp_complength (seqp, params, group1, group2, fromseq, toseq, k, k+win_width);
     k += (3 * 10);
  }
  return;
}

static Int4Ptr PNTR count_mismatch (Int4Ptr PNTR dist, CharPtr PNTR seqp, Int2 nseq, int from, int to)
{
  Char         c1, c2;
  Int2         m, j, k;

  for (m = 0; m < nseq-1; m++) {  
     if (seqp [m] != NULL) {
        for (j = m+1; j < nseq; j++) {
           if (seqp [j] != NULL) {
              for (k = from; k <= to; k++) {
                 c1 = seqp[m][k]; 
                 c2 = seqp[j][k];
                 if (c1!=CARNUL && c2!=CARNUL && c1!=CARGAP &&  c2!=CARGAP) 
                 {
                    dist [j][m] += 1;
                    if (c1 != c2) { 
                       dist [m][j] += 1; 
                    } 
                 }
              }
           }
        }
     }
  }
  return dist;
}

static Int4Ptr PNTR count_gap (Int4Ptr PNTR dist, CharPtr PNTR seqp, Int2 nseq, int from, int to)
{
  Char         c1, c2;
  Int2         m, j, k;

  for (m = 0; m < nseq-1; m++) {  
     if (seqp [m] != NULL) {
        for (j = m+1; j < nseq; j++) {
           if (seqp [j] != NULL) {
              for (k = from; k <= to; k++) {
                 c1 = seqp[m][k]; 
                 c2 = seqp[j][k];
                 if (c1!=CARNUL && c2!=CARNUL && !(c1==CARGAP && c2==CARGAP)) {
                    dist [j][m] += 1;
                    if (c1==CARGAP || c2==CARGAP) 
                       dist [m][j] += 1; 
                 }
              }
           }
        }
     }
  }
  return dist;
}

static void FreeBufArray (CharPtr PNTR bufp, Int2 nrows)
{
  Int2  j;
  if (bufp != NULL) {
     for (j=0; j<nrows+1; j++)
        bufp[j] = NULL;
     MemFree (bufp);
  }
}

/****************************************************
*** DON't FORGET TO DELETE bufstr
***
*****************************************************/

static Int4Ptr PNTR  scanall_calcul (EditAlignDataPtr adp, Int2 seq1, Int2 seq2, Int4 from, Int4 to, Int2 group, Int2 choice, Int2 win_width)
{
  Int4Ptr PNTR    dist = NULL;
  ValNodePtr      vnp = NULL;
  SeqParamPtr     spp;
  CharPtr PNTR    bufstr;
  Int2            nseq = 0;
  Int2            width;
  Int2            numberalignline = 0;
  Int2            j;
  Boolean         goOn = FALSE;

  if (group == 0) nseq = seq2 - seq1 + 1;
  else {
     for (j = 0, vnp = adp->params; vnp!=NULL; vnp=vnp->next, j++) {
        if (j >= seq1 && j <= seq2) {
           spp = (SeqParamPtr) vnp->data.ptrvalue;
           if (spp->group == group) nseq++;
        }
     }
  }
  dist = Int4matrix (nseq, nseq);
  if (dist == NULL)
     return NULL;
  if (to-from > 32000)
     return NULL;
  width = (Int2)(to - from + 1);
  goOn = read_buffer_fromalignnode (adp, &vnp, from, width, &numberalignline);
  while ( goOn )
  {
     bufstr = buf2array (vnp, seq1, seq2);
     if (bufstr != NULL) {
        if (choice == MISMATCHCOUNT_ALL)
           dist = count_mismatch (dist, bufstr, nseq, from, to);
        else if (choice ==GAPCOUNT)
           dist = count_gap (dist, bufstr, nseq, from, to);
        else if (choice ==NSSPW && win_width == 0)
           nss_pw_complength (bufstr, 0, nseq, from, to);
        else if (choice ==NSSPW && win_width > 0)
           nss_pw_window (bufstr, 0, 0, nseq, from, to, win_width);
        else if (choice ==NSSREF && win_width == 0)
           nss_ref_complength (bufstr, 0, 0, nseq, from, to);
        else if (choice ==NSSREF && win_width > 0)
           nss_ref_window (bufstr, 0, 0, nseq, from, to, win_width);
        else 
           return NULL;
        FreeBufArray (bufstr, nseq);
     }
     FreeTextAlignList (vnp);
     goOn = FALSE;
  }
  return dist;
}
 
static Int4Ptr PNTR  scangp_calcul (EditAlignDataPtr adp, Int2 seq1, Int2 seq2, Int4 from, Int4 to, Int2 group, Int2 choice, Int2 win_width)
{
  Int4Ptr PNTR    dist = NULL;
  ValNodePtr      vnp = NULL;
  SeqParamPtr     spp;
  CharPtr PNTR    bufstr;
  Int2            nseq = 0;
  Int2            width;
  Int2            numberalignline = 0;
  Int2            j, j1, j2;
  Boolean         goOn;

  if (adp->ngroup < 2)
     return NULL;
  if (group == 0) nseq = seq2 - seq1 + 1;
  else {
     for (j = 0, vnp = adp->params; vnp!=NULL; vnp=vnp->next, j++) {
        if (j >= seq1 && j <= seq2) {
           spp = (SeqParamPtr) vnp->data.ptrvalue;
           if (spp->group == group) nseq++;
        }
     }
  }
  dist = Int4matrix (nseq, nseq);
  if (dist == NULL)
     return NULL;
  if (to-from > 32000) 
     return NULL; 
  width = (Int2)(to - from + 1);
  for (j1 = 1; j1 <= (Int2) adp->ngroup; j1++) 
  {
     for (j2 = j1+1; j2 <= (Int2) adp->ngroup; j2++)
     {
        goOn=read_buffer_fromalignnode(adp,&vnp, from, width, &numberalignline);
        while ( goOn )
        {
           bufstr = buf2array (vnp, seq1, seq2);
           if (bufstr != NULL) {
              if (choice == NSSGP && win_width == 0) {
                 nss_gp_complength (bufstr, adp->params, j1, j2, seq1, seq2, from, to);
              }
              else if (choice == NSSGP && win_width > 0) {
                 nss_gp_window(bufstr, adp->params, j1, j2, seq1, seq2, from, to, win_width);
              }
              else 
                 return NULL;
              FreeBufArray (bufstr, nseq);
           }
           FreeTextAlignList (vnp);
           goOn = FALSE;
        }
     }
  }
  return dist;
}

static Int2Ptr scan_position (EditAlignDataPtr adp, Int2 seq1, Int2 seq2, Int4 from, Int4 to, Uint2 choice)
{
  Int2Ptr         tab = NULL;
  ValNodePtr      vnp = NULL;
  CharPtr PNTR    bufstr;
  Int2            nseq = 0;
  Int2            width;
  Int2            numberalignline = 0;
  Int2            val;
  Int2            j, k; 
  Boolean         goOn = FALSE;

  nseq = seq2 - seq1 + 1;
  if (to-from > 32000) 
     return NULL; 
  width = (Int2)(to - from + 1);
  tab = (Int2Ptr) MemNew ((size_t)((width + 10))* sizeof(Int2));
  goOn = read_buffer_fromalignnode (adp, &vnp, from, width, &numberalignline);
  while ( goOn )
  {
     bufstr = buf2array (vnp, seq1, seq2);
     if (bufstr != NULL) {
        if (choice == QUORUM) {
           for (j=0; j<width; j++) {
              val = 0;
              for (k=0; k<nseq; k++) {
                 if (bufstr[k][j]!='-') val ++;
              }
              tab[j] = val;
           }
        } 
        else if (choice == MISMATCHCOUNT_REF) {
           for (j=0; j<width; j++) {
              val = 0;
              if (bufstr[0][j] != '-') {
                 for (k=1; k<nseq; k++) {
                    if (bufstr[k][j] != '-') 
                       if (bufstr[k][j] != bufstr[0][j]) 
                          val ++;
                 }
              }
              tab[j] = val;
           }
        }
     }
     goOn = FALSE;
  }
  return tab;
}

/*********************************************************************
***  DON't FORGET TO MEMFREE dist
***
**********************************************************************/
static void AlignReportProc (EditAlignDataPtr adp)
{
  Int4            from,
                  to;
  Int2            seq1,
                  seq2;
  Int4Ptr PNTR    dist;
  FILE            *f_out;
 
  from = 0;
  to = adp->length - 1;
 
  seq1 = 0;
  seq2 = adp->seqnumber - 1;
  dist = scanall_calcul (adp, seq1, seq2, from, to, 0, MISMATCHCOUNT_ALL, 0);
  if (dist != NULL)
  {
     f_out = FileOpen (path_out, "w");
     if (f_out != NULL) 
     {
        writematrixhalf (f_out, dist, adp->sqloc_list, 0, (seq2 -seq1 +1), 0, (seq2 -seq1 +1), "Number of mismatches");
        dist = scanall_calcul (adp, seq1, seq2, from, to, 0, GAPCOUNT, 0);
        if (dist != NULL)
           writematrixhalf (f_out, dist, adp->sqloc_list, 0, (seq2 -seq1 +1), 0, (seq2 -seq1 +1), "Number of gaps");
        FileClose (f_out);
        LaunchGeneralTextViewer (path_out, "Pairwise distance");
        FileRemove (path_out);
     }
  }  
}

/*********************************************************************
***  DON't FORGET TO MEMFREE dist
***
**********************************************************************/
static void PwDistProc (EditAlignDataPtr adp)
{
  Int4            from,
                  to; 
  Int2            seq1,
                  seq2;
  Int4Ptr PNTR    dist;
  Int2            j, k;
  FILE            *f_out;

  from = 0;
  to = adp->length - 1;

  seq1 = 0;
  seq2 = adp->seqnumber - 1;
  dist = scanall_calcul (adp, seq1, seq2, from, to, 0, MISMATCHCOUNT_ALL, 0);
  if (dist != NULL) 
  {
     f_out = FileOpen (path_out, "w");
     if (f_out != NULL) 
     {
        writematrix (f_out, dist, adp->sqloc_list, 0, (seq2 -seq1 +1), 0, (seq2 -seq1 +1), "Number of mismatches vs pairwise alignment lenth");
        for (j = 0; j < (seq2 - seq1 + 1); j++) {
           if (dist[j] != NULL) {
              for (k=j+1; k < (seq2 - seq1 + 1); k++) {
                 if (dist[k][j] > 0)
                    dist[j][k] = (Int4) ( (float)(1000.00*((float)dist[j][k]/(float)dist[k][j])) ); 
                 else dist[j][k] = (Int4) 0;
              }
           }
        }
        writematrixhalf (f_out, dist, adp->sqloc_list, 0, (seq2 -seq1 +1), 0, (seq2 -seq1 +1), "Percentages of mismatches (x1000)");
        FileClose (f_out);
        LaunchGeneralTextViewer (path_out, "Pairwise distance");
        FileRemove (path_out);
     }
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
     MemFree (dist); 
*/
  }
}

/*********************************************************************
***  DON't FORGET TO MEMFREE dist
***
**********************************************************************/
static void GpDistProc (EditAlignDataPtr adp)
{
  Int4            from,
                  to; 
  Int2            seq1,
                  seq2;
  Int4Ptr PNTR    dist;
  FloatLo         val, minval, maxval, moy;
  Int2            j1, j2, k, m, n;
  ValNodePtr      vnp1, vnp2 = NULL;
  SeqParamPtr     spp1, spp2;

  if (adp->ngroup < 1) 
     return;
  from = 0;
  to = adp->length - 1;

  seq1 = 0;
  seq2 = adp->seqnumber - 1;

  dist = scanall_calcul (adp, seq1, seq2, from, to, 0, MISMATCHCOUNT_ALL, 0);
  if (dist == NULL) 
     return;
  fout = FileOpen (path_out, "w");
  if (fout != NULL) 
  {
     for (j1 = 1; j1 <= (Int2) adp->ngroup; j1++) {
        minval = (FloatLo)99999.99;
        maxval = (FloatLo)0;
        moy = (FloatLo)0;
        n=0;
        for (k=0, vnp1=adp->params; k < seq1 && vnp1!=NULL; k++) 
           vnp1=vnp1->next;
        for (k=seq1; k <= seq2 && vnp1!=NULL; k++, vnp1=vnp1->next) {
           for (m=0, vnp2=adp->params; m < k+1 && vnp2!=NULL; m++) 
              vnp2=vnp2->next;
           for (m = k+1; m <= seq2 && vnp2!=NULL; m++, vnp2=vnp2->next) {
              spp1 = (SeqParamPtr) vnp1->data.ptrvalue;
              spp2 = (SeqParamPtr) vnp2->data.ptrvalue;
              if (spp1->group == j1 && spp2->group == j1)
              {
                 val =(FloatLo)dist [k][m] / (FloatLo)dist[m][k];
                 if (val < minval) minval = val;
                 if (val > maxval) maxval = val;
                 moy += val;
                 n++;
              }
           }
        }
        fprintf (fout, "WITHIN GROUP %d : %f  %f  %f  \n", j1, (float)(moy / (FloatLo)n), (float)minval, (float)maxval);
     }
     for (j1 = 1; j1 <= (Int2) adp->ngroup; j1++) {
        for (j2 = j1+1; j2 <= (Int2) adp->ngroup; j2++) {
           minval = (FloatLo)99999.99;
           maxval = (FloatLo)0;
           moy = (FloatLo)0;
           n=0;
           for (k=0, vnp1=adp->params; k < seq1 && vnp1!=NULL; k++) 
              vnp1=vnp1->next;
           for (k=seq1; k <= seq2 && vnp1!=NULL; k++, vnp1=vnp1->next) {
              for (m=0, vnp2=adp->params; m < k+1 && vnp2!=NULL; m++) 
                 vnp2=vnp2->next;
              for (m = k+1; m <= seq2 && vnp2!=NULL; m++, vnp2=vnp2->next) {
                 spp1 = (SeqParamPtr) vnp1->data.ptrvalue;
                 spp2 = (SeqParamPtr) vnp2->data.ptrvalue;
                 if (spp1->group == j1 && spp2->group == j2)
                 {
                    val =(FloatLo)dist [k][m] / (FloatLo)dist[m][k];
                    if (val < minval) minval = val;
                    if (val > maxval) maxval = val;
                    moy += val;
                    n++;
                 }
              }
           }
           fprintf (fout, "BETWEEN GROUPS %d - %d : %f  %f  %f  \n", j1, j2, (float)(moy / (FloatLo)n), (float)minval, (float)maxval);
        }
     }
     FileClose (fout);
     LaunchGeneralTextViewer (path_out, "Group distance");
     FileRemove (path_out);
  }
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  MemFree (dist); 
*/
}

static void SortbySimProc (EditAlignDataPtr adp)
{
  Int2               seq1,
                     seq2;
  Int4               from,
                     to; 
  Int4Ptr PNTR       dist;
  Int2Ptr            sortlst;
  SeqAlignPtr        newsalp, newsalpd;

  from = 0;
  to = adp->length - 1;

  seq1 = 0;
  seq2 = adp->seqnumber - 1;

  dist = scanall_calcul (adp, seq1, seq2, from, to, 0, MISMATCHCOUNT_ALL, 0);
  if (dist != NULL)
  {
     sortlst = spaning_tree (dist, (seq2 - seq1 +1));
     if (sortlst != NULL)
     {
        newsalp = SortSeqAlignFromList ((SeqAlignPtr)adp->sap_align->data, sortlst);
        newsalpd = SeqAlignBoolSegToDenseSeg (newsalp);
        CompSeqAlignFree (newsalp);
        MemFree (sortlst);   
        LaunchAlignEditor (newsalp);
     }
     MemFree (dist); /** FREE DIST */   
  }
}

static void SortbyLenProc (EditAlignDataPtr adp)
{
  SeqAlignPtr        newsalp, newsalpd;
  ValNodePtr         vnp;
  AlignNodePtr       anp;
  SeqLocPtr          slp;
  Int4Ptr            lens;
  Int2Ptr            sortlst;
  Int4               minlens, maxlens = 0;
  Int2               j, k, mink;

  lens = (Int4Ptr) MemNew ((size_t)(adp->seqnumber * sizeof(Int4)));
  sortlst = (Int2Ptr) MemNew ((size_t)(adp->seqnumber * sizeof(Int2)));
  vnp=adp->anp_list;
  for (j=0; j < adp->seqnumber && vnp!=NULL; j++, vnp=vnp->next) {
     anp = (AlignNodePtr) vnp->data.ptrvalue;
     slp = CollectSeqLocFromAlignNode (anp);
     lens [j] = SeqLocLen (slp);
     if (lens [j] > maxlens) maxlens = lens [j];
     SeqLocFree (slp);
  }
  for (j=0; j < adp->seqnumber; j++) {
     minlens = maxlens + 10;
     for (k=0; k < adp->seqnumber; k++)
        if (lens [k] < minlens) {
           mink = k;
           minlens = lens [k];
        }
     sortlst [mink] = j + 1;
     lens [mink] = maxlens + 10;
  }
  MemFree (lens);
  if (sortlst != NULL) {
     newsalp = SortSeqAlignFromList ((SeqAlignPtr)adp->sap_align->data, sortlst);
     newsalpd = SeqAlignBoolSegToDenseSeg (newsalp);
     CompSeqAlignFree (newsalp);
     MemFree (sortlst);
     LaunchAlignEditor (newsalpd);
  }
}

static void QuorumProc (EditAlignDataPtr adp)
{
  Int2               seq1,
                     seq2;
  Int4               from,
                     to; 
  Int2Ptr            tab;

  from = 0;
  to = adp->length - 1;
  seq1 = 0;
  seq2 = adp->seqnumber - 1;
  tab = scan_position (adp, seq1, seq2, from, to, QUORUM);
  write_vector2 (tab, (to-from+1));
  MemFree (tab);
}

static void DistPosProc (EditAlignDataPtr adp)
{
  Int2               seq1,
                     seq2;
  Int4               from,
                     to; 
  Int2Ptr            tab;

  from = 0;
  to = adp->length - 1;
  seq1 = 0;
  seq2 = adp->seqnumber - 1;
  tab = scan_position (adp, seq1, seq2, from, to, MISMATCHCOUNT_REF);
  write_vector2 (tab, (to-from+1));
  MemFree (tab);
}

static void NonsyToSynProc (EditAlignDataPtr adp, Int2 choice, Int2 choice2)
{
  Int4            from,
                  to; 
  Int2            seq1,
                  seq2;
  Int4Ptr PNTR    dist = NULL;

  from = 0;
  to = adp->length - 1;

  seq1 = 0;
  seq2 = adp->seqnumber - 1;

  fout = FileOpen (path_out, "w");
  if (fout != NULL) 
  {
     if (choice2 == 0)
        dist = scanall_calcul (adp, seq1, seq2, from, to, 0, choice, 0);
     else
        dist = scanall_calcul (adp, seq1, seq2, from, to, 0, choice, 30);
     FileClose (fout);
     if (dist != NULL)
        LaunchGeneralTextViewer (path_out, "Non-synonymous vs synonymous mutations");
     FileRemove (path_out);
  }
  return;
}
 
extern void AlignReportItem (IteM i)
{
  EditAlignDataPtr   adp;
  adp = GetAlignEditData ((WindoW) ParentWindow (i));
  if ( adp == NULL ) return;
  WatchCursor ();
  AlignReportProc (adp);
  ArrowCursor ();
}

extern void PwDistanceItem (IteM i)
{
  EditAlignDataPtr   adp;
  adp = GetAlignEditData ((WindoW) ParentWindow (i));
  if ( adp == NULL ) return;
  WatchCursor ();
  PwDistProc (adp);
  ArrowCursor ();
}

extern void PwDistanceLongItem (IteM i)
{
  EditAlignDataPtr   adp;
  adp = GetAlignEditData ((WindoW) ParentWindow (i));
  if ( adp == NULL ) return;
  WatchCursor ();
  PwDistProc (adp);
  ArrowCursor ();
}

extern void GpDistanceItem (IteM i)
{
  EditAlignDataPtr   adp;
  adp = GetAlignEditData ((WindoW) ParentWindow (i));
  if ( adp == NULL ) return;
  WatchCursor ();
  GpDistProc (adp);
  ArrowCursor ();
}

extern void SortbySimItem (IteM i)
{
  EditAlignDataPtr   adp;
  adp = GetAlignEditData ((WindoW) ParentWindow (i));
  if ( adp == NULL ) return;
  WatchCursor ();
  SortbySimProc (adp);
  ArrowCursor ();
}

extern void SortbyLenItem (IteM i)
{
  EditAlignDataPtr   adp;
  adp = GetAlignEditData ((WindoW) ParentWindow (i));
  if ( adp == NULL ) return;
  WatchCursor ();
  SortbyLenProc (adp);
  ArrowCursor ();
}

extern void QuorumItem (IteM i)
{
  EditAlignDataPtr   adp;
  adp = GetAlignEditData ((WindoW) ParentWindow (i));
  if ( adp == NULL ) return;
  WatchCursor ();
  QuorumProc (adp);
  ArrowCursor ();
}

extern void DistPosItem (IteM i)
{
  EditAlignDataPtr   adp;
  adp = GetAlignEditData ((WindoW) ParentWindow (i));
  if ( adp == NULL ) return;
  WatchCursor ();
  DistPosProc (adp); 
  ArrowCursor ();
}

extern void NonsyToSynItem1 (IteM i)
{
  EditAlignDataPtr   adp;
  adp = GetAlignEditData ((WindoW) ParentWindow (i));
  if ( adp == NULL ) return;
  WatchCursor ();
  NonsyToSynProc (adp, NSSPW, 0);
  ArrowCursor ();
}

extern void NonsyToSynItem2 (IteM i)
{
  EditAlignDataPtr   adp;
  adp = GetAlignEditData ((WindoW) ParentWindow (i));
  if ( adp == NULL ) return;
  WatchCursor ();
  NonsyToSynProc (adp, NSSPW, 1);
  ArrowCursor ();
}

extern void NonsyToSynItem3 (IteM i)
{
  EditAlignDataPtr   adp;
  adp = GetAlignEditData ((WindoW) ParentWindow (i));
  if ( adp == NULL ) return;
  WatchCursor ();
  NonsyToSynProc (adp, NSSREF, 0);
  ArrowCursor ();
}

extern void NonsyToSynItem4 (IteM i)
{
  EditAlignDataPtr   adp;
  adp = GetAlignEditData ((WindoW) ParentWindow (i));
  if ( adp == NULL ) return;
  WatchCursor ();
  NonsyToSynProc (adp, NSSREF, 1);
  ArrowCursor ();
}

extern void NonsyToSynItem5 (IteM i)
{
  EditAlignDataPtr   adp;
  adp = GetAlignEditData ((WindoW) ParentWindow (i));
  if ( adp == NULL ) return;
  WatchCursor ();
  NonsyToSynProc (adp, NSSGP, 0);
  ArrowCursor ();
}

extern void NonsyToSynItem6 (IteM i)
{
  EditAlignDataPtr   adp;
  adp = GetAlignEditData ((WindoW) ParentWindow (i));
  if ( adp == NULL ) return;
  WatchCursor ();
  NonsyToSynProc (adp, NSSGP, 1);
  ArrowCursor ();
}

static Int2Ptr spaning_tree (Int4Ptr PNTR matcost, Int4 dim)
{
  Int2Ptr    sortlst;
  Int2Ptr    done;
  FloatLoPtr cost;
  FloatLo    c, ccost;
  Int4       npair,
             xmin, ymin,
             inc_n, dec_n, j, k;
  Boolean    ok;
  Int2Ptr    *matvu ;

  npair = 0;
  inc_n = 1;
  dec_n = dim; 
  
  sortlst = (Int2Ptr) MemNew ((size_t)((dim+1)*sizeof(Int2)));
  for (j=0; j<dim; j++)  sortlst [j] = 0;

  done = (Int2Ptr) MemNew ((size_t)((dim+1)*sizeof(Int2)));
  for (j=0; j<dim; j++)  done [j] = FALSE;

  cost = (FloatLoPtr) MemNew ((size_t)((dim+1)*sizeof(FloatLo)));
  for (j=0; j<dim; j++)  cost [j] = (FloatLo)0;

  matvu = Int2matrix (dim, dim);

  xmin = -1; 
  ymin = -1;
  ccost = (FloatLo)99999.99;
  for (j = 0; j < dim; j++)   
     for (k = j+1; k < dim; k++) 
     {
        c = (FloatLo) matcost [j][k];
        if (c >= 0.00 && c < ccost ){
           xmin = j; 
           ymin = k; 
           ccost = c;
        }
     }
  if (xmin < 0 || ymin < 0)
     return NULL;
  done [xmin] = TRUE;
  done [ymin] = TRUE;
  matvu [xmin][ymin] = TRUE;
  matvu [ymin][xmin] = TRUE;
  sortlst [xmin] = (Int2)inc_n;
  sortlst [ymin] = (Int2)(inc_n+1);
  inc_n += 2;
  dec_n --;
  npair ++;
  cost [npair] = ccost;
  ok = TRUE;
  while (dec_n > 1 && ok)
  {
     xmin = -1; ymin = -1;
     ccost = (FloatLo)99999.99;
     for (j = 0; j < dim; j++) {
        if (done [j]) {  
           for (k = 0; k < dim; k++) 
              if (matvu [j][k] == FALSE)
              {
                 c = (FloatLo) matcost [j][k];
                 if (c >= 0.00 && c < ccost ){
                    xmin = j; 
                    ymin = k; 
                    ccost = c;
                 }
              }
        }
     }
     ok = (Boolean) (xmin >= 0 && ymin >= 0);
     if (ok) {
        if (!done [ymin]) {
           done [ymin] = TRUE;
           sortlst [ymin] = (Int2)inc_n;
           inc_n ++;
           dec_n --;
           npair += 1;
           cost [npair] = ccost;
        }
        for (j=0; j < dim; j++) {
           if (done[j] && matvu [j][ymin] == FALSE) {
              matvu [j][ymin] = TRUE;
              matvu [ymin][j] = TRUE;
           }
        }
     }
  }
  return sortlst;
}

#ifdef SALSA_DEBUG
/*******************************************************
***
***          TREE
***
********************************************************/
 
typedef struct nodedata  {
  Int2    index;
  Int2    distance;
  CharPtr label;
} NodeData, PNTR NodeDataPtr;

  Int2       IDcrs;
  Int2Ptr    asc;
  FloatLoPtr coutb;
  Int2Ptr    IDs;
  CharPtr PNTR name;

  Int2   OMAX = 1000;

  Int2   NbSq =33;

  Int2 incr=1;

/*******************************************************
***  TreeEntryFileRead
***     Read a tree in format treefile from PHYLIP --
***     write in the struct ...
***     the root is no of seq. +1 = [NbSq]
*******************************************************/

Int2 TreeEntryTreefileRead (CharPtr path, Int2 NbSq)
{
   FILE    *f;
   Char    c, cp;
   Int2    i, ng, cur_node;
   Int2    ns_cur = 0;

  asc =(Int2Ptr) MemNew ((size_t)((OMAX)*sizeof(Int2)));
  IDs =(Int2Ptr) MemNew ((size_t)((OMAX)*sizeof(Int2)));
  coutb =(FloatLoPtr) MemNew ((size_t)((OMAX)*sizeof(FloatLo)));
  name =(CharPtr PNTR) MemNew ((size_t)((OMAX)*sizeof(CharPtr)));
  for (i = 0; i < OMAX; ++i) {
     name[i]= (CharPtr)MemNew((size_t)(66*sizeof(Char)));
     name[i][64] = '\0';
     asc[i] = IDs[i] = 0;
     coutb[i] = 0.00;
  }
  cur_node = 0;
  cp = c = ' ';
  ng = NbSq-1;

  if ( ( f = fopen(path, "r")) == (FILE *) NULL) {
    Message(MSG_ERROR,"fail in TreeEntryTreefileRead: can't open %s\n", path);
    return(0);
  }
  while ( (c = getc(f) ) != EOF && c != ';') {
      if (c == ' ' || c =='\n' || c =='\0') ;
      else if ( c ==')' || c ==',') {
       /* case: end of group, waiting for the branch-cost */
        cp = c;
      }
      else if (c == ':' && cp == ')') {
        /* case:  read branch cost of an intermediary node */
        if ((fscanf(f, "%f", &coutb[IDs[cur_node]])) == 0) {
           Message(MSG_ERROR, "NO LENGTH FOR THE BRANCH %d\n", (int) IDs[cur_node]);
           return (0);
         }
        --cur_node;
      }  
      else if (c == '(') {
        /* case: new group, incr no of groups */
        /* pre_ng_cur = ng_cur;  ng_cur = ++ng; */
        IDs[++cur_node] = ++ng;
        sprintf(name[IDs[cur_node]], "%d", IDs[cur_node]);
        asc[IDs[cur_node]] = IDs[cur_node - 1];
        cp = c;
      }
      else if ( cp == '(' || cp ==',' ) {
        /* reading the sequence name if exist && branch cost*/
         if (c != ':') {
           name[ns_cur][0] = c;
           i = 0;
           while ( (c = getc(f) ) != EOF && c != ':' && i < 64) {
             name[ns_cur][++i] = c;
           }
         }
         else sprintf(name[ns_cur], "Seq.%d", ns_cur);
         if ( fscanf(f, "%f", &coutb[ns_cur]) == 0) {
           Message(MSG_ERROR, "NO LENGTH FOR THE BRANCH %d\n", ns_cur);
           return (0);
         }
         asc[ns_cur] = IDs[cur_node] ;
         ++ns_cur;
      }
      else {
        Message(MSG_ERROR, "PROBLEM WITH THE FILE %s\n", path);
        return (0);
      }
      /*WriteLog ("%c %c %d %d %d %f\n",cp, c, ng, IDs[cur_node], ns_cur, coutb[ns_cur-1]);*/
  }  
  fclose(f);
  ++ng;
  return (ng);
}

static void treefile_print (Int2 NbGp)
{
  Int2 ns_cur;
  for (ns_cur = 0; ns_cur < NbGp; ++ns_cur) {
     WriteLog ("%d %4d %10s %4d %10f \n", NbGp, ns_cur, name[ns_cur], asc[ns_cur], coutb[ns_cur]);
  }
}

/***********************************************************
***
***   loadtree + getChild 
***
***      DELETE NodeData ??
***
************************************************************/
static NodeDataPtr getChild (Int2 NbGp, Int2Ptr xp, Int2 x)
{
  NodeDataPtr ndp;
  Int2        j;
 
  if (xp == NULL) 
     return NULL;
  for (j=0; j<NbGp; j++) {
     if (asc[j] == x) {
        ndp = (NodeDataPtr) MemNew (sizeof(NodeData)); 
        ndp->distance = (Int2) (1000 * coutb[j]);
        ndp->label = MemFree (ndp->label);
        ndp->label = StringSave (name[j]);
        ndp->index = j;
        asc[j] = -1;
        return ndp;
     }
  }
  return NULL;
}

static void loadtree(TreeCursorPtr cursor, Int2 NbGp, Int2Ptr xp, Int2 x)
{
  NodeDataPtr ndp;
  TreeNodeId  node_id;

  ndp = getChild (NbGp, xp, x);
  while (ndp != NULL) {
     node_id = tree_addChild (cursor, ndp, sizeof(NodeData));
     tree_toNode (cursor, node_id);
     loadtree (cursor, NbGp, xp, (Int2) ndp->index);
     tree_parent (cursor);
     incr++;
     ndp = getChild (NbGp, xp, x);
  }
}

/********************************************************
***
*** my_get_node: Call back function to use tree_getNode ()
***
***     ndp = (NodeDataPtr) tree_getNode(cursor, TREE_NODE_FMT_DEFAULT, &ds);
***     index = tree_getNode (cursor, TREE_NODE_FMT_INDEX, &ds);
***     distp = (FloatLoPtr) tree_getNode (cursor, TREE_NODE_FMT_DIST, &ds);
***     label = (CharPtr) tree_getNode (cursor, TREE_NODE_FMT_LABEL, &ds);
***
*********************************************************/
static VoidPtr my_get_node (TreeCursorPtr c, Uint4 format, Uint2Ptr data_size)
{
  NodeDataPtr ndp;
  Uint2       s;
  Int2        x;

  ndp = tree_getNodeData (c, &s);
  switch (format) {
     case TREE_NODE_FMT_DEFAULT: 
             *data_size = (Uint2)sizeof(NodeData);
             return (VoidPtr) ndp;
     case TREE_NODE_FMT_ICON:
             *data_size = (Uint2)sizeof(Int2);
             return (VoidPtr) (ndp->index);
     case TREE_NODE_FMT_DISTANCE: 
             *data_size = (Uint2)sizeof(Int2);
             x = (Int2) (ndp->distance);
             return (VoidPtr) (x);
     case TREE_NODE_FMT_LABEL: 
             if (ndp->label!=NULL) {
                *data_size = (Uint2)sizeof(StringLen(ndp->label)); 
                return (VoidPtr) ndp->label;
             }
             return NULL;
  }
}

static void do_root (TreeCursorPtr cursor)
{
  NodeDataPtr   root;
  Uint2         data_size;

  root = (NodeDataPtr) tree_getNodeData (cursor, &data_size);
  WriteLog ("NODE %d %s %d\n", (int) root->index, root->label, (int)root->distance);
}

static void traverse_tree_internal (TreeCursorPtr cursor)
{
  NodeDataPtr ndp;
  Uint2       data_size;

  data_size = sizeof(NodeData);
  if (tree_child(cursor)) { 
     do { 
        ndp = (NodeDataPtr) tree_getNodeData (cursor, &data_size);
        WriteLog ("NODE %d %s %d\n", (int) ndp->index, ndp->label, (int) ndp->distance);
        traverse_tree_internal (cursor); 
     } while (tree_sibling (cursor)); 
     tree_parent (cursor);
  } 
}

static void print_tree (IteM i)
{
  TreeCursorPtr cursor;
  TreeViewPtr tv;

  tv = GetWindowExtra((WindoW)ParentWindow (i));
  cursor = tree_openCursor (tv->tree, NULL, NULL);
  tree_root (cursor);
  do_root (cursor);
  traverse_tree_internal (cursor);
  tree_closeCursor (cursor);
}

static void ss_proc (IteM i)
{
  TreeViewPtr tv = GetWindowExtra((WindoW)ParentWindow (i));
  tview_showSelected (tv);
}

static void wh_proc(TreeViewPtr tv)
{
  TreeCursorPtr cursor;
 
  cursor= tree_openCursor(tv->tree, NULL, NULL);
  tview_moveRoot(tv, tree_getId(cursor));
  tree_closeCursor(cursor);
}
 
static void dbl_func(TreeViewPtr tv, TreeNodeId id, Boolean isNode)
{
    if(isNode) tview_moveRoot(tv, id);
    else wh_proc(tv);
}

static void dismisswindow_proc (IteM i)
{
  TreeViewPtr tv = GetWindowExtra((WindoW)ParentWindow (i));
  tview_delete (tv, 0);
  Remove ((WindoW) ParentWindow(i));
}

static void crtMenu(WindoW m_window)
{
    MenU m;
 
    m= PulldownMenu(m_window, "File");
    CommandItem(m, "Save", print_tree);
    SeparatorItem (m);
    CommandItem(m, "Show Selected", ss_proc);
    CommandItem(m, "Show whole tree", NULL);
    SeparatorItem (m);
    CommandItem(m, "Dismiss", dismisswindow_proc);
}

static void show_tree (TreePtr tree)
{
  TreeViewPtr tv;
 
  tv = tview_createCustom(-50, -33, 600, 600, "Tree", crtMenu, tree, NULL, 5, NULL);
  tview_setDblClickFunc (tv, dbl_func);

  Green ();
  tview_setTextColor(tv, GetColor());
  Red ();
  tview_setLineColor(tv, GetColor());
  tview_redraw(tv);

  ProcessEvents();
}
 
extern void TreeViewItem (IteM i)
{
  Char          path [PATH_MAX];
  TreePtr       tree;
  TreeCursorPtr cursor;
  NodeDataPtr   ndp;
  Int2          NbGp;

  if ( !GetInputFileName (path, PATH_MAX, "", "TEXT") ) {
    Message(MSG_ERROR, "fail in TreeViewItem [1]");
    return;
  }
  NbGp = TreeEntryTreefileRead (path, NbSq);
  if ( !( NbGp == 0 || NbGp > NbSq ) ) {
    Message (MSG_ERROR, "fail in TreeViewItem [2]");
    return;
  }
  tree = tree_new ();
  cursor = tree_openCursor (tree, NULL, NULL);

  ndp = (NodeDataPtr) MemNew (sizeof(NodeData)); 
  ndp->distance = (Int2)0;
  ndp->label = MemFree (ndp->label);
  ndp->label = StringSave ("ROOT");
  ndp->index = 0;
  tree_updateNodeData(cursor, ndp, sizeof(NodeData));

  loadtree (cursor, NbGp, asc, NbSq);
  tree_root (cursor);

  tree_setGetNodeFunc (tree, my_get_node);
  show_tree (tree);
}

#endif
