#include <objseq.h>
#include <seqport.h>
#include <gather.h>
#include <picture.h>
#include <viewer.h>
#include <seqptrnx.h>
#include <seqgraph.h>
#include <seqptrn.h>

/* functions - internal */

extern void ProcessPatternProc (ButtoN b)
{
  SeqPtrnPtr         sptp;
  GraphViewFormPtr   gvp;
  WindoW             w;
  Uint1              graphtype;

  WatchCursor ();
  if (b != NULL)
  {
    sptp = (SeqPtrnPtr) GetObjectExtra (b);
    if (sptp != NULL && sptp->bsp != NULL)
    {
      if (ISA_aa (sptp->bsp->mol))
        graphtype = GRAPH_PATTERN_AA;
      else
        graphtype = GRAPH_PATTERN_NA;
      w = (WindoW) CreateGraphViewForm (-50, -33, "Pattern Matching",
                                        sptp->bsp, graphtype);
    }
    else
    {
      ArrowCursor ();
      return;
    }
  }
  if (w == NULL)
  {
    ArrowCursor ();
    return;
  }
  if ((gvp = (GraphViewFormPtr) GetObjectExtra (w)) == NULL)
  {
/*    w = Remove (w); */
    ArrowCursor ();
    return;
  }
  else
  {
    sptp->pattern = MemFree (sptp->pattern);
    sptp->pattern = SaveStringFromText (sptp->pbox);
    gvp->window = 0;
    if (ISA_aa (gvp->bsp->mol))
      gvp->graphtype = GRAPH_PATTERN_AA;
    else
      gvp->graphtype = GRAPH_PATTERN_NA;
    gvp->entityID = sptp->entityID;
    gvp->itemID = sptp->itemID;
    gvp->sgp = NULL;
    if (ISA_na (gvp->bsp->mol))
    {
      if ((gvp->sgp = PatternSeq (gvp->bsp, &(gvp->window), NA_PATTERN,
                                  gvp->sgp, sptp->pattern, 0)) == NULL)
      {
/*        w = Remove (w); */
        ArrowCursor ();
        return;
      }
      else
      {
        BioseqPtrToGraphViewForm (gvp->form, gvp->sgp);
        WatchCursor ();
        PatternSeq (gvp->bsp, &(gvp->window), NA_PATTERN,
                    gvp->sgp, sptp->pattern, 0);
        if (gvp->sgp->next == NULL)
        {
          ArrowCursor ();
          return;
        }
        else
        {
          BioseqPtrToGraphViewForm (gvp->form, gvp->sgp->next);
        }
      }
    }
    else
    {
      if ((gvp->sgp = PatternSeq (gvp->bsp, &(gvp->window), AA_PATTERN,
                                  gvp->sgp, sptp->pattern, 1)) == NULL)
      {
/*        w = Remove (w); */
        ArrowCursor ();
        return;
      }
      else
      {
        BioseqPtrToGraphViewForm (gvp->form, gvp->sgp);
      }
    }
  }
  ArrowCursor ();
  Show (w);
  Select (w);
  return;
}

/* functions - cleanup */

static void CleanupSelectPatForm (GraphiC g, VoidPtr data)
{
  SeqPtrnPtr sptp;

  if ((sptp = (SeqPtrnPtr) data) != NULL)
  {
    WatchCursor ();
    sptp->pattern = MemFree (sptp->pattern);
    ArrowCursor ();
  }
  StdCleanupFormProc (g, data);
  return;
}

static void CloseSelectPatFormProc (WindoW w)
{
  Remove (w);
  return;
}

extern ForM CreateSelectPatForm (Int2 left, Int2 top, CharPtr title,
                                 BioseqPtr bsp)
{
  SeqPtrnPtr            sptp;
  WindoW                w;

  w = NULL;
  if (bsp == NULL)
    return (ForM) w;

  sptp = (SeqPtrnPtr) MemNew (sizeof (SeqPtrn));
  if (sptp != NULL)
  {
    w = DocumentWindow (left, top, -10, -10, title,
                        CloseSelectPatFormProc, NULL);
    SetObjectExtra (w, sptp, CleanupSelectPatForm);
    sptp->form = (ForM) w;
    sptp->actproc = NULL;
    sptp->toform = NULL;
    sptp->bsp = bsp;
  }
  return (ForM) w;
}

/* function  -  hooks */

Int2 LIBCALLBACK PatternFunc (Pointer data)
{
  OMProcControlPtr      ompcp;
  BioseqPtr             bsp;
  SeqPtrnPtr            sptp;
  WindoW                w;
  TexT                  pbox;
  GrouP                 h1, c;
  ButtoN                b;

  ompcp = (OMProcControlPtr) data;
  if (ompcp == NULL || ompcp->input_itemtype == 0)
    return OM_MSG_RET_ERROR;

  switch (ompcp->input_itemtype)
  {
    case OBJ_BIOSEQ:
      bsp = (BioseqPtr) ompcp->input_data;
      break;
    default:
      return OM_MSG_RET_ERROR;
  }

  if (bsp != NULL)
  {
/*
    if (!ISA_na (bsp->mol))
      return OM_MSG_RET_ERROR;
*/
    if ((w = (WindoW) CreateSelectPatForm (-50, -33, "Enter pattern",
                                           bsp)) == NULL)
      return OM_MSG_RET_ERROR;
  }
  else
  {
    return OM_MSG_RET_ERROR;
  }

  if ((sptp = (SeqPtrnPtr) GetObjectExtra (w)) == NULL)
  {
/*    w = Remove (w); */
    return OM_MSG_RET_ERROR;
  }

  h1 = HiddenGroup (w, -1, 0, NULL);
  SetGroupSpacing (h1, 5, 10);

  pbox = ScrollText (h1, 32, 8, programFont, TRUE, NULL);
  sptp->pbox = pbox;
  sptp->entityID = ompcp->input_entityID;
  sptp->itemID = ompcp->input_itemID;

  c = HiddenGroup (h1, 3, 0, NULL);
  b = PushButton (c, "Proceed", ProcessPatternProc);
  SetObjectExtra (b, sptp, NULL);
  PushButton (c, "Cancel", StdCancelButtonProc);

  AlignObjects (ALIGN_CENTER, (HANDLE) pbox, (HANDLE) c, NULL);

  Show (w);
  Select (w);
  return OM_MSG_RET_DONE;
}
