#ifndef _URKBIAS__
#define _URKBIAS__

#include <ncbi.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct Gather_Cds
{
  Int4Ptr     tableGlobal, tableRefine;
  SeqLocPtr   slpGlobal, slpRefine, slpAll, slpHit, slpFound;
  Int4        stdcount, globalcount, refinecount, findcount;
  FloatHi     stdev, HIscore, LOscore, mean;
  FloatHi     scorecut;
} Gather_CDS, PNTR Gather_CDSPtr;

extern Gather_CDSPtr GatherCDSNew (void);
extern Gather_CDSPtr GatherCDSFree (Gather_CDSPtr gcdsp);

extern SeqLocPtr SeqLocDup (SeqLocPtr slp);
extern SeqLocPtr SeqLocLink (SeqLocPtr PNTR slph, SeqLocPtr slp);
extern Boolean SeqLocMatch (SeqLocPtr slplist, SeqLocPtr slpnew);

extern void UniqueOrfs (SeqLocPtr PNTR pslpFound);
extern void SortByLocOrfs (SeqLocPtr PNTR pslpFound);
extern void RemoveInternalOrfs (SeqLocPtr PNTR slpFound);

extern SeqLocPtr FindSimilarBiasOrfs (SeqEntryPtr sep, FloatHi probcut,
                                      Int4 clustmin, Int4 findmin,
                                      SeqLocPtr slpKnown,
                                      SeqLocPtr slpPotential);

extern FloatHiPtr BiasScoreBioseq (BioseqPtr bsp, Int4Ptr globaltable,
                                   Int4 tripletwindow, Int4 xframe,
                                   Uint1 xstrand);

#ifdef __cplusplus
}
#endif

#endif
