#include <urkcnsrt.h>
#include <gather.h>
#include <seqport.h>

/* CONDONE */

static FloatHi findtot (Int4Ptr fq, Int4 index)
{
  Int4 score;

  switch (index)
  {
   default:
   case 0:         /* lys K */
   case 1:
    score = fq[0] + fq[1];
    break;
   case 2:         /* asn N */
   case 3:
    score = fq[2] + fq[3];
    break;
   case 4:         /* arg R */
   case 5:
   case 36:
   case 37:
   case 38:
   case 39:
    score = fq[4] + fq[5] + fq[36] + fq[37] + fq[38] + fq[39];
    break;
   case 6:         /* ser S */
   case 7:
   case 56:
   case 57:
   case 58:
   case 59:
    score = fq[6] + fq[7] + fq[56] + fq[57] + fq[58] + fq[59];
    break;
   case 8:         /* thr T */
   case 9:
   case 10:
   case 11:
    score = fq[8] + fq[9] + fq[10] + fq[11];
    break;
   case 12:        /* ile I */
   case 14:
   case 15:
    score = fq[12] + fq[14] + fq[15];
    break;
   case 13:        /* met M */
    score = fq[13];
    break;
   case 16:        /* glu E */
   case 17:
    score = fq[16] + fq[17];
    break;
   case 18:        /* asp D */
   case 19:
    score = fq[18] + fq[19];
    break;
   case 20:        /* gly G */
   case 21:
   case 22:
   case 23:
    score = fq[20] + fq[21] + fq[22] + fq[23];
    break;
   case 24:        /* ala A */
   case 25:
   case 26:
   case 27:
    score = fq[24] + fq[25] + fq[26] + fq[27];
    break;
   case 28:        /* val V */
   case 29:
   case 30:
   case 31:
    score = fq[28] + fq[29] + fq[30] + fq[31];
    break;
   case 32:        /* gln N */
   case 33:
    score = fq[32] + fq[33];
    break;
   case 34:        /* his H */
   case 35:
    score = fq[34] + fq[35];
    break;
   case 40:        /* pro P */
   case 41:
   case 42:
   case 43:
    score = fq[40] + fq[41] + fq[42] + fq[43];
    break;
   case 44:        /* leu L */
   case 45:
   case 46:
   case 47:
   case 60:
   case 61:
    score = fq[44] + fq[45] + fq[46] + fq[47] + fq[60] + fq[61];
    break;
   case 48:        /* ochre UAA */
   case 49:        /* amber UAG */
   case 52:        /* umber UGA */
    score = fq[48] + fq[49] + fq[52];
    break;
   case 50:        /* tyr Y */
   case 51:
    score = fq[50] + fq[51];
    break;
   case 53:        /* trp W */
    score = fq[53];
    break;
   case 54:        /* cys C */
   case 55:
    score = fq[54] + fq[55];
    break;
   case 62:        /* phe F */
   case 63:
    score = fq[62] + fq[63];
    break;
  }
  if (score == 0)
    score = 1;
  return (FloatHi) score;
}

static Int4Ptr Condone (SeqPortPtr spp, Int4Ptr codontable, Uint1 strand,
                        Boolean flagAdd)
{
  Boolean flagNextCodon = TRUE;
  Uint1   na;
  Int4    nn, nx;

/*
 note:
 use A G C T in switch statement rather than A C G T (alphabetical)
     because the order comes out nicer in findtot switch statement
     it's biological
*/
  SeqPortSeek (spp, 0, SEEK_SET);
  while (flagNextCodon)
  {
    nn = 0;
    na = '\0';
    while (na < 'A' || na > 'Z')
    {
      if ((na = SeqPortGetResidue (spp)) == SEQPORT_EOF)
        flagNextCodon = FALSE;
      if (na < 'A' || na > 'Z')
        flagNextCodon = FALSE;
      if (!flagNextCodon)
        break;
    }
    if (!flagNextCodon)
      continue;
    switch (na)
    {
     default:
     case 'A':
      nx = 0;
      break;
     case 'G':
      nx = 1;
      break;
     case 'C':
      nx = 2;
      break;
     case 'T':
      nx = 3;
      break;
    }
    if (strand == Seq_strand_minus)
      nn += (3 - nx);
    else
      nn += (nx * 16);
    na = '\0';
    while (na < 'A' || na > 'Z')
    {
      if ((na = SeqPortGetResidue (spp)) == SEQPORT_EOF)
        flagNextCodon = FALSE;
      if (na < 'A' || na > 'Z')
        flagNextCodon = FALSE;
      if (!flagNextCodon)
        break;
    }
    if (!flagNextCodon)
      continue;
    switch (na)
    {
     default:
     case 'A':
      nx = 0;
      break;
     case 'G':
      nx = 1;
      break;
     case 'C':
      nx = 2;
      break;
     case 'T':
      nx = 3;
      break;
    }
    if (strand == Seq_strand_minus)
      nn += ((3 - nx) * 4);
    else
      nn += (nx * 4);
    na = '\0';
    while (na < 'A' || na > 'Z')
    {
      if ((na = SeqPortGetResidue (spp)) == SEQPORT_EOF)
        flagNextCodon = FALSE;
      if (na < 'A' || na > 'Z')
        flagNextCodon = FALSE;
      if (!flagNextCodon)
        break;
    }
    if (!flagNextCodon)
      continue;
    switch (na)
    {
     default:
     case 'A':
      nx = 0;
      break;
     case 'G':
      nx = 1;
      break;
     case 'C':
      nx = 2;
      break;
     case 'T':
      nx = 3;
      break;
    }
    if (strand == Seq_strand_minus)
      nn += ((3 - nx) * 16);
    else
      nn += nx;
    if (flagAdd)
      codontable[nn] += 1;
    else
      codontable[nn] -= 1;
  }
  return codontable;
}

/* CONCUR */

static FloatHi Concur (Int4Ptr freq1, Int4Ptr freq2, Int4Ptr freqgbl)
{
  Int4    i;
  Int4    freqlcl[64];
  FloatHi st1, st2, fr1, fr2, frq, score;

  if (freq1 == NULL || freq2 == NULL)
    return 0.0;

  if (freqgbl == NULL)
  {
    for (i = 0; i < 64; i++)
    {
      freqlcl[i] = (freq1[i] + freq2[i]) / 2;
      if (freqlcl[i] == 0)
        freqlcl[i] = 1;
    }
    freqgbl = freqlcl;
  }
  score = 0.0;
  for (i = 0; i < 64; i++)
  {
    st1 = findtot (freq1, i);
    if (st1 == 0)
      st1 = 1;
    st2 = findtot (freq2, i);
    if (st2 == 0)
      st2 = 1;
    fr1 = freq1[i]/st1;
    fr2 = freq2[i]/st2;
    frq = fr1 - fr2;
    score += (((FloatHi) frq * (FloatHi) frq) / (FloatHi) freqgbl[i]);
  }
  return score;
}

/* CONSORT */

static TreeNodePtr Consort (FloatHiPtr PNTR conmat, Int4 matsize,
                           CharPtr PNTR coname)
{
  ValNodePtr vnphead = NULL, vnp = NULL;
  TreeNodePtr ptrNode;
  Int4       i, n, min1, min2;
  FloatHi    ftemp, minscore;
  TreeNodePtr ptrFirst, ptrLast;

  for (i = 0; i < matsize; i++)
  {
    vnp = ValNodeNew (vnp);
    if (vnphead == NULL)
      vnphead = vnp;
    ptrNode = TreeNodeNew ();
    vnp->data.ptrvalue = ptrNode;
    ptrNode->name = StringSave (coname[i]);
  }

  while (matsize > 2)
  {
/* find lowest non-trivial score */
    min1 = 0;
    min2 = 1;
    minscore = conmat[min1][min2];
    for (n = 0; n < matsize-1; n++)
    {
      for (i = n+1; i < matsize; i++)
      {
        if (minscore > conmat[n][i])
        {
          minscore = conmat[n][i];
          min1 = n;
          min2 = i;
        }
      }
    }
    if (min2 < min1)
    {
      i = min2;
      min2 = min1;
      min1 = i;
    }

/* average the low scoring columns */
    for (i = 0; i < matsize; i++)
    {
      ftemp = (conmat[i][min1] + conmat[i][min2]) / 2;
      conmat[i][min1] = ftemp;
      conmat[i][min2] = ftemp;
    }
/* average the low scoring rows */
    for (i = 0; i < matsize; i++)
    {
      ftemp = (conmat[min1][i] + conmat[min2][i]) / 2;
      conmat[min1][i] = ftemp;
      conmat[min2][i] = ftemp;
    }
/* exchange 2nd low column with last column */
    for (i = 0; i < matsize; i++)
    {
      ftemp = conmat[i][min2];
      conmat[i][min2] = conmat[i][matsize-1];
      conmat[i][matsize-1] = ftemp;
    }
/* exchange 1st low column with 2nd last column */
    for (i = 0; i < matsize; i++)
    {
      ftemp = conmat[i][min1];
      conmat[i][min1] = conmat[i][matsize-2];
      conmat[i][matsize-2] = ftemp;
    }
/* exchange 2nd low row with last row */
    for (i = 0; i < matsize; i++)
    {
      ftemp = conmat[min2][i];
      conmat[min2][i] = conmat[matsize-1][i];
      conmat[matsize-1][i] = ftemp;
    }
/* exchange 1st low row with 2nd last row */
    for (i = 0; i < matsize; i++)
    {
      ftemp = conmat[min1][i];
      conmat[min1][i] = conmat[matsize-2][i];
      conmat[matsize-2][i] = ftemp;
    }

/* exchange 2nd low node with last node */
    vnp = vnphead;
    for (i = 0; i < min2; i++)
      vnp = vnp->next;
    ptrFirst = (TreeNodePtr) vnp->data.ptrvalue;
    for (i = min2+1; i < matsize; i++)
      vnp = vnp->next;
    ptrLast = (TreeNodePtr) vnp->data.ptrvalue;
    vnp = vnphead;
    for (i = 0; i < min2; i++)
      vnp = vnp->next;
    vnp->data.ptrvalue = ptrLast;
    for (i = min2+1; i < matsize; i++)
      vnp = vnp->next;
    vnp->data.ptrvalue = ptrFirst;

/* exchange 1st low node with 2nd last node */
    vnp = vnphead;
    for (i = 0; i < min1; i++)
      vnp = vnp->next;
    ptrFirst = (TreeNodePtr) vnp->data.ptrvalue;
    for (i = min1+1; i < matsize-1; i++)
      vnp = vnp->next;
    ptrLast = (TreeNodePtr) vnp->data.ptrvalue;
    vnp = vnphead;
    for (i = 0; i < min1; i++)
      vnp = vnp->next;
    vnp->data.ptrvalue = ptrLast;
    for (i = min1+1; i < matsize-1; i++)
      vnp = vnp->next;
    vnp->data.ptrvalue = ptrFirst;

/*
 fuse 2nd last and last nodes
 new node will be last node after matrix shrinks
*/
    ptrNode = TreeNodeNew ();
    ptrNode->name = StringSave ("Internal Node");
    ptrNode->score = minscore;
    ptrNode->ptrLeft = (TreeNodePtr) vnp->data.ptrvalue;
    ptrNode->ptrRight = (TreeNodePtr) vnp->next->data.ptrvalue;
    ptrNode->ptrLeft->ptrUp = ptrNode;
    ptrNode->ptrRight->ptrUp = ptrNode;
    vnp->data.ptrvalue = ptrNode;

/* shrink matrix */
    matsize--;
  }

/* fuse the remaining two nodes at the root node */
  vnp = vnphead;
  ptrNode = TreeNodeNew ();
  ptrNode->name = StringSave ("Root Node");
  ptrNode->score = conmat[0][1];
  ptrNode->ptrLeft = (TreeNodePtr) vnp->data.ptrvalue;
  ptrNode->ptrRight = (TreeNodePtr) vnp->next->data.ptrvalue;
  ptrNode->ptrLeft->ptrUp = ptrNode;
  ptrNode->ptrRight->ptrUp = ptrNode;

/* just free the vnp store */
  ValNodeFree (vnphead);

  return ptrNode;
}

/* CONFORM */

static Int4 whattotal (FloatHiPtr freq)
{
  Int4  i, codons = 0;

  for (i = 0; i < 64; i++)
  {
    codons += (Int4) *freq;
    freq++;
  }
  return codons;
}

static FloatHi whatthou (FloatHiPtr freq, Int4 count, Int4 codons)
{
  Int4  i = 0;

  while (i < count)
    freq++;

  return (*freq / (FloatHi) codons * 1000.0);
}

static void Conform (FloatHiPtr freq, TreeNodePtr ptrNode, FILE *fn)
{
  Int4    i, codons, nodecount = 0;
  Char    triplets;
  Char    aa;
  CharPtr treebuff, tempbuff;
  FloatHi perthou, percent;
  Char    trips, amino;

/* this is not used yet */
    triplets = 'A';
    trips = triplets;
    aa = 'A';
    amino = aa;
    codons  = whattotal (freq);
    fprintf (stdout, "Total nodenumber amino acids %3d\n", codons);
    fprintf (stdout, "AA    Codon Number /1000  Fraction ..\n");
    for (i = 0; i < 64; i++)
    {
      perthou = whatthou (freq, i, codons);
      percent = perthou / 10;
      fprintf (stdout,
               "%3.3s    %3.3s    %3d  %4.0f  %6.2f\n",
               amino, trips, freq[i], perthou, percent);
      amino += 3;
      trips += 3;
    }
    fprintf (stdout, "\n");

/* buffers to play with */
  treebuff = (CharPtr) MemNew ((size_t) (nodecount*8));
  tempbuff = (CharPtr) MemNew ((size_t) (nodecount*8));

/* fill the buffer */
  for (i = 0; i < 2; i++)
  {
  }

/* output */
  i = 2;
  while (treebuff[i])
  {
    if ((treebuff[i-2] == ')') &&
        (treebuff[i-1] == ',') &&
        (treebuff[i] == '('))
    {
      StrCpy (tempbuff, &treebuff[i]);
      treebuff[i] = 0;
      StrCat (treebuff, "\n");
      StrCat (treebuff, tempbuff);
      i++;
    }
    i++;
  }
  StrCat (treebuff, ";");
  fprintf (fn, "%s", treebuff);
  MemFree (tempbuff);
  MemFree (treebuff);

  return;
}

/* main outside connections */

typedef struct gather_Cds
{
  SeqEntryPtr     sep;
  BioseqPtr       bsp;
  Int4            globaltable[64];
  Int4            gene1table[64];
  Int4            gene2table[64];
  Int4            genecount, genecurrent, genelocal;
  CharPtr PNTR    genename;
  FloatHiPtr PNTR conmat;
  TreeNodePtr     ptrNode;
} GatherCDS, PNTR GatherCDSPtr;

static Boolean getgene1cdn (GatherContextPtr gcp)
{
  GatherCDSPtr gcdsp;
  SeqAnnotPtr  sap;
  SeqFeatPtr   sfp;
  Int4         start, stop;
  SeqPortPtr   spp;
  Uint1        strand;

  GBQualPtr    gbqp;
  ValNodePtr   vnp;
  DbtagPtr     dtp;
  ObjectIdPtr  oip;
  Char         buf[16];

  if (gcp == NULL)
    return FALSE;
  if ((gcdsp = (GatherCDSPtr) gcp->userdata) == NULL)
    return FALSE;
  if (gcp->thistype != OBJ_SEQANNOT)
    return TRUE;
  if ((sap = (SeqAnnotPtr) (gcp->thisitem)) == NULL)
    return TRUE;

  while (sap != NULL)
  {
    sfp = (SeqFeatPtr) sap->data;
    while (sfp != NULL && gcdsp->genelocal < CONMATSIZE)
    {
      if (sfp->data.choice == SEQFEAT_CDREGION)
      {
        if (sfp->location->choice == SEQLOC_INT)
        {
          start = SeqLocStart (sfp->location);
          stop = SeqLocStop (sfp->location);
          strand = SeqLocStrand (sfp->location);
          if ((spp = SeqPortNew (gcdsp->bsp, start, stop, 0,
                                 Seq_code_iupacna)) != NULL)
          {
            if (gcdsp->genelocal == gcdsp->genecurrent)
            {
              MemSet ((Pointer) gcdsp->gene1table, 0,
                (size_t) (64 * sizeof (Int4)));
              Condone (spp, gcdsp->gene1table, strand, TRUE);
              buf[0] = '\0';
              if (sfp->qual != NULL)
              {
                gbqp = sfp->qual;
                if (gbqp->val != NULL)
                {
                  StrNCpy (buf, gbqp->val, 15);
                  buf[15] = '\0';
                }
              }
              else if (sfp->comment != NULL)
              {
                StrNCpy (buf, sfp->comment, 15);
                buf[15] = '\0';
              }
              else if (sfp->dbxref != NULL)
              {
                vnp = sfp->dbxref;
                if (vnp != NULL)
                {
                  dtp = vnp->data.ptrvalue;
                  if (dtp != NULL)
                  {
                    oip = dtp->tag;
                    if (oip != NULL)
                    {
                      StrNCpy (buf, oip->str, 15);
                      buf[15] = '\0';
                    }
                  }
                }
              }
              else
              {
                sprintf (buf, "ORF_%ld", gcdsp->genecurrent+1);
              }
              if (buf[0] == '\0')
              {
                sprintf (gcdsp->genename[gcdsp->genecurrent],
                         "ORF_%ld", gcdsp->genecurrent+1);
              }
              else
              {
                StrCpy (gcdsp->genename[gcdsp->genecurrent], buf);
              }
              gcdsp->genelocal += 1;
              SeqPortFree (spp);
              return TRUE;
            }
            gcdsp->genelocal += 1;
            SeqPortFree (spp);
          }
        }
      }
      sfp = sfp->next;
    }
    sap = sap->next;
  }
  return TRUE;
}

static Boolean getgene2cdn (GatherContextPtr gcp)
{
  GatherCDSPtr gcdsp;
  SeqAnnotPtr  sap;
  SeqFeatPtr   sfp;
  Int4         start, stop;
  SeqPortPtr   spp;
  Uint1        strand;

  if (gcp == NULL)
    return FALSE;
  if ((gcdsp = (GatherCDSPtr) gcp->userdata) == NULL)
    return FALSE;
  if (gcp->thistype != OBJ_SEQANNOT)
    return TRUE;
  if ((sap = (SeqAnnotPtr) (gcp->thisitem)) == NULL)
    return TRUE;

  while (sap != NULL)
  {
    sfp = (SeqFeatPtr) sap->data;
    while (sfp != NULL && gcdsp->genelocal < CONMATSIZE)
    {
      if (sfp->data.choice == SEQFEAT_CDREGION)
      {
        if (sfp->location->choice == SEQLOC_INT)
        {
          start = SeqLocStart (sfp->location);
          stop = SeqLocStop (sfp->location);
          strand = SeqLocStrand (sfp->location);
          if ((spp = SeqPortNew (gcdsp->bsp, start, stop, 0,
                                 Seq_code_iupacna)) != NULL)
          {
            MemSet ((Pointer) gcdsp->gene2table, 0,
              (size_t) (64 * sizeof (Int4)));
            Condone (spp, gcdsp->gene2table, strand, TRUE);
            SeqPortFree (spp);
            gcdsp->conmat[gcdsp->genecurrent][gcdsp->genelocal] =
              Concur (gcdsp->gene1table, gcdsp->gene2table,
                      gcdsp->globaltable);
            gcdsp->genelocal += 1;
          }
        }
      }
      sfp = sfp->next;
    }
    sap = sap->next;
  }
  return TRUE;
}

static Boolean getgblcdn (GatherContextPtr gcp)
{
  GatherCDSPtr gcdsp;
  SeqAnnotPtr  sap;
  SeqFeatPtr   sfp;
  Int4         start, stop;
  SeqPortPtr   spp;
  Uint1        strand;

  if (gcp == NULL)
    return FALSE;
  if ((gcdsp = (GatherCDSPtr) gcp->userdata) == NULL)
    return FALSE;
  if (gcp->thistype != OBJ_SEQANNOT)
    return TRUE;
  if ((sap = (SeqAnnotPtr) (gcp->thisitem)) == NULL)
    return TRUE;

  while (sap != NULL)
  {
    sfp = (SeqFeatPtr) sap->data;
    while (sfp != NULL && gcdsp->genecount < CONMATSIZE)
    {
      if (sfp->data.choice == SEQFEAT_CDREGION)
      {
        if (sfp->location->choice == SEQLOC_INT)
        {
          start = SeqLocStart (sfp->location);
          stop = SeqLocStop (sfp->location);
          strand = SeqLocStrand (sfp->location);
          if ((spp = SeqPortNew (gcdsp->bsp, start, stop, 0,
                                 Seq_code_iupacna)) != NULL)
          {
            Condone (spp, gcdsp->globaltable, strand, TRUE);
            gcdsp->genecount += 1;
            SeqPortFree (spp);
          }
        }
      }
      sfp = sfp->next;
    }
    sap = sap->next;
  }
  return TRUE;
}

static void FindNuc (SeqEntryPtr sep, Pointer data, Int4 index,
                     Int2 indent)
{
  BioseqPtr PNTR bspp;
  BioseqPtr bsp;

  bspp = (BioseqPtr PNTR) data;

  if (*bspp != NULL)
    return;

  if (IS_Bioseq (sep))
  {
    bsp = (BioseqPtr) sep->data.ptrvalue;
    if (ISA_na (bsp->mol))
      *bspp = bsp;
  }
  return;
}

extern TreeNodePtr ConsortSeqEntry (SeqEntryPtr sep)
{
  BioseqPtr           bsp = NULL;
  Int4                i, genecount;

  static GatherScope  gs;
  GatherScopePtr      gsp;

  static GatherCDS    gcds;
  GatherCDSPtr        gcdsp;

  SeqEntryExplore (sep, &bsp, FindNuc);
  if (bsp == NULL)
    return NULL;

  gsp = &gs;
  gcdsp = &gcds;

  MemSet ((Pointer) gsp, 0, sizeof (GatherScope));
  MemSet ((Pointer) gsp->ignore, (int) (TRUE),
          (size_t) (OBJ_MAX * sizeof (Boolean)));
  gsp->ignore[OBJ_SEQANNOT] = FALSE;

  gcdsp->genename = MemNew ((size_t) (CONMATSIZE * sizeof (Pointer)));
  for (i = 0; i < CONMATSIZE; i++)
    gcdsp->genename[i] = MemNew (64 * sizeof (Char));
  gcdsp->conmat = MemNew (CONMATSIZE * sizeof (Pointer));
  for (i = 0; i < CONMATSIZE; i++)
    gcdsp->conmat[i] = MemNew ((size_t) (CONMATSIZE * sizeof (FloatHi)));

  MemSet ((Pointer) gcdsp->globaltable, 0,
          (size_t) (64 * sizeof (Int4)));

  gcdsp->sep       = sep;
  gcdsp->bsp       = bsp;
  gcdsp->ptrNode   = NULL;
  gcdsp->genecount = 0;

  GatherSeqEntry (sep, (Pointer) gcdsp, getgblcdn, (Pointer) gsp);
  for (i = 0; i < 64; i++)
  {
    if (gcdsp->globaltable[i] == 0)
      gcdsp->globaltable[i] = 1;
  }

  for (genecount = 0; genecount < gcdsp->genecount; genecount++)
  {
    gcdsp->genecurrent = genecount;
    gcdsp->genelocal = 0;

    MemSet ((Pointer) gsp, 0, sizeof (GatherScope));
    MemSet ((Pointer) gsp->ignore, (int) (TRUE),
            (size_t) (OBJ_MAX * sizeof (Boolean)));
    gsp->ignore[OBJ_SEQANNOT] = FALSE;

    GatherSeqEntry (sep, (Pointer) gcdsp, getgene1cdn, (Pointer) gsp);

    gcdsp->genelocal = 0;

    MemSet ((Pointer) gsp, 0, sizeof (GatherScope));
    MemSet ((Pointer) gsp->ignore, (int) (TRUE),
            (size_t) (OBJ_MAX * sizeof (Boolean)));
    gsp->ignore[OBJ_SEQANNOT] = FALSE;

    GatherSeqEntry (sep, (Pointer) gcdsp, getgene2cdn, (Pointer) gsp);
  }

  gcdsp->ptrNode = Consort (gcdsp->conmat, gcdsp->genecount,
                            gcdsp->genename);

  for (i = 0; i < CONMATSIZE; i++)
    MemFree (gcdsp->genename[i]);
  MemFree (gcdsp->genename);
  for (i = 0; i < CONMATSIZE; i++)
    MemFree (gcdsp->conmat[i]);
  MemFree (gcdsp->conmat);

  SetLevelNode (gcdsp->ptrNode, 0);
  UnSetPivotNode (gcdsp->ptrNode);
  SetAllPivotNodes (gcdsp->ptrNode);

  return gcdsp->ptrNode;
}

/* exploration */

extern Int4Ptr NewCodonTable (void)
{
  return (Int4Ptr) MemNew ((size_t) (64 * sizeof (Int4)));
}

extern Int4Ptr FreeCodonTable (Int4Ptr cutp)
{
  return (Int4Ptr) MemFree (cutp);
}

extern Int4Ptr CodonTableFromSeqLoc (BioseqPtr bsp, SeqLocPtr slp)
{
  Int4Ptr    cutp;
  Int4       start, stop;
  SeqPortPtr spp;
  Uint1      strand;
  Boolean    flagHaveCDS = FALSE;

  if (bsp == NULL || slp == NULL)
    return NULL;

  if (!ISA_na (bsp->mol))
    return NULL;

  if ((cutp = NewCodonTable ()) == NULL)
    return NULL;

  while (slp != NULL)
  {
    start = SeqLocStart (slp);
    stop = SeqLocStop (slp);
    strand = SeqLocStrand (slp);
    if ((spp = SeqPortNew (bsp, start, stop, 0, Seq_code_iupacna)) != NULL)
    {
      Condone (spp, cutp, strand, TRUE);
      SeqPortFree (spp);
      flagHaveCDS = TRUE;
    }
    slp = slp->next;
  }
  if (!flagHaveCDS)
    cutp = FreeCodonTable (cutp);
  return cutp;
}

extern void AddSeqLocToCodonTable (Int4Ptr cutp, BioseqPtr bsp,
                                   SeqLocPtr slp, Boolean flagAdd)
{
  Int4       start, stop;
  SeqPortPtr spp;
  Uint1      strand;

  if (cutp == NULL || bsp == NULL || slp == NULL)
    return;

  if (!ISA_na (bsp->mol))
    return;

  while (slp != NULL)
  {
    start = SeqLocStart (slp);
    stop = SeqLocStop (slp);
    strand = SeqLocStrand (slp);
    if ((spp = SeqPortNew (bsp, start, stop, 0, Seq_code_iupacna)) != NULL)
    {
      Condone (spp, cutp, strand, flagAdd);
      SeqPortFree (spp);
    }
    slp = slp->next;
  }
  return;
}

extern Int4Ptr MergeCodonTables (Int4Ptr cutp1, Int4Ptr cutp2)
{
  Int4Ptr    cutp;
  Int4       i;

  if (cutp1 == NULL || cutp2 == NULL)
    return NULL;

  if ((cutp = NewCodonTable ()) == NULL)
    return NULL;

  for (i = 0; i < 64; i++)
    cutp[i] = cutp1[i] + cutp2[i];

  return cutp;
}

extern FloatHi Confide (Int4Ptr cutgene, Int4Ptr cutgbl)
{
  Int4    i;
  FloatHi st1, st2, fr1, fr2, frq, score;

  if (cutgene == NULL || cutgbl == NULL)
    return 0.0;

  score = 0.0;
  for (i = 0; i < 64; i++)
  {
    st1 = findtot (cutgene, i);
    if (st1 == 0)
      st1 = 1;
    st2 = findtot (cutgbl, i);
    if (st2 == 0)
      st2 = 1;
    fr1 = cutgene[i]/st1;
    fr2 = cutgbl[i]/st2;
    frq = fr1 - fr2;
    score += ((FloatHi) frq * (FloatHi) frq);
  }

  return score;
}
