#ifndef _URKPCC__
#define _URKPCC__

#include <ncbi.h>
#include <seqport.h>

#ifdef __cplusplus
extern "C" {
#endif

#define  PI  3.141592654

typedef struct predictCCdata
{
  FloatHi  meang, stdg, meanc, stdc;
  Int4     window, linker;
  CharPtr  pccdatafile;
  CharPtr  res;
  FloatHiPtr PNTR scr;
} PccDat, PNTR PccDatPtr;

/*
 caller responsibiliity
  pccp = PccDatNew ();
  ReadPccData (pccp);
  probability_scores = PredictCC...
  MemFree (probability_scores);
  PccDatFree (pccp);
*/

extern Int4 ReadPccData (PccDatPtr pccp);

extern PccDatPtr PccDatNew (void);
extern PccDatPtr PccDatFree (PccDatPtr pccp);

extern FloatHiPtr PredictCC (CharPtr seq, Int4 start, Int4 end,
                             PccDatPtr pccp);

extern FloatHiPtr PredictCCSeqPort (SeqPortPtr spp,
                                    Int4 start, Int4 end,
                                    PccDatPtr pccp);

extern FloatHiPtr PredictCCBioseq (BioseqPtr bsp,
                                   Int4 start, Int4 end,
                                   PccDatPtr pccp);

extern FloatHiPtr PredictCCSeqLoc (SeqLocPtr slp,
                                   PccDatPtr pccp);

extern SeqLocPtr FilterCC (FloatHiPtr score, FloatHi percentcut,
                           Int4 length, Int4 linker, SeqIdPtr sip);

extern SeqLocPtr FilterCCVS (FloatHiPtr score, FloatHi percentcut,
                             Int4 length, Int4 linker, SeqIdPtr sip);

#ifdef __cplusplus
}
#endif

#endif
