/*								-*- C++ -*-
 * $Id: MSC_timer.cpp,v 1.2 1997-02-28 16:04:08+01 mho Exp $
 *
 * Purpose: class to process time outs
 *
 * Authors: Markus Holzem and Julian Smart
 *          Matthew added wxTimerList
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "MSC_timer.h"
#endif

#define  Uses_XtIntrinsic
#define  Uses_wxTimer
#define  Uses_wxList
#include "wx.h"

//-----------------------------------------------------------------------------
// wxTimer implementation
//-----------------------------------------------------------------------------

static wxList wxTimerList(wxKEY_INTEGER);

wxTimer::wxTimer(void)
{
    __type = wxTYPE_TIMER;

    id       = 0;
    interval = 0;
    one_shot = FALSE;
}

wxTimer::~wxTimer(void)
{
    Stop();
}

// start timer using XtAppAddTimeOut
Bool wxTimer::Start(int milliseconds, Bool mode)
{
    one_shot = mode;
    if (milliseconds > 0)
	interval = milliseconds;
    if (interval == 0)
	return FALSE;

    // timer currently running? -> stop
    if (id > 0) {
	XtRemoveTimeOut(id);
	id = 0;
    }

    if (!wxTimerList.Find((long)this))
	wxTimerList.Append((long)this, this);

    // start new timer
    id = XtAppAddTimeOut(wxAPP_CONTEXT,
			 (unsigned long)interval,
			 (XtTimerCallbackProc)wxTimer::EventCallback,
			 (XtPointer)this);
    return TRUE;
}

// stop timer using XtRemoveTimeOut
void wxTimer::Stop(void)
{
    if (id > 0) {
	XtRemoveTimeOut(id);
	id = 0;
    }
    interval = 0;

    wxNode *node = wxTimerList.Find((long)this);
    if (node)
	wxTimerList.DeleteNode(node);
}

// callback for XtAppAddTimeOut
void wxTimer::EventCallback(wxTimer *timer, XtIntervalId *WXUNUSED(id))
{
    if (!wxTimerList.Find((long)timer))
	return;

    if (timer->id == 0)
	return;	// Avoid to process spurious timer events

    if (!timer->one_shot)
	timer->id = XtAppAddTimeOut(wxAPP_CONTEXT,
				    (unsigned long)timer->interval,
				    (XtTimerCallbackProc)wxTimer::EventCallback,
				    (XtPointer)timer);
    else {
      timer->id = 0;
      timer->Stop(); /* To remove from the active list */
    }

    timer->Notify();
}
