/*								-*- C++ -*-
 * $Id: WIN_radiobox.cpp,v 1.2 1997-01-15 14:59:18+01 mho Exp $
 *
 * Purpose: radio box panel item
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "WIN_radiobox.h"
#endif

#define  Uses_XtIntrinsic
#define  Uses_wxRadioBox
#include "wx.h"
#define  Uses_EnforcerWidget
#define  Uses_GroupWidget
#define  Uses_ToggleWidget
#include <widgets.h>

#define TOGGLES ((Widget*)toggles)

//-----------------------------------------------------------------------------
// create and destroy button
//-----------------------------------------------------------------------------

IMPLEMENT_DYNAMIC_CLASS(wxRadioBox, wxItem)

wxRadioBox::wxRadioBox(void) : wxItem()
{
    __type = wxTYPE_RADIO_BOX;

    toggles     = NULL;
    num_toggles = 0;
}

wxRadioBox::wxRadioBox(wxPanel *panel, wxFunction func, Const char *label,
		       int x, int y, int width, int height, int n, char **choices,
		       int num_rows, long style, Constdata char *name) : wxItem()
{
    __type = wxTYPE_RADIO_BOX;

    toggles     = NULL;
    num_toggles = 0;

    Create(panel, func, label, x, y, width, height, n, choices,
	   num_rows, style, name);
}

wxRadioBox::wxRadioBox(wxPanel *panel, wxFunction func, Const char *label,
		       int x, int y, int width, int height, int n, wxBitmap **choices,
		       int num_rows, long style, Constdata char *name) : wxItem()
{
    __type = wxTYPE_RADIO_BOX;

    toggles     = NULL;
    num_toggles = 0;

    Create(panel, func, label, x, y, width, height, n, choices,
	   num_rows, style, name);
}

Bool wxRadioBox::Create(wxPanel *panel, wxFunction func, Const char *label,
		   int x, int y, int width, int height, int n, char **choices,
		   int num_rows, long style, Constdata char *name)
{
    num_Rows = num_rows;
    if ( (num_toggles = n) <= 0 ) {
	wxError("created without items (n=0)!\n", name);
	return TRUE;
    }

    ChainToPanel(panel, style, name);

    // create frame
    FWidget() = XtVaCreateManagedWidget
	(name, xfwfEnforcerWidgetClass, GetParentWidget(parent),
	 XtNlabel,              label,
	 XtNalignment,          ((label_position == wxVERTICAL) ?
				 XfwfTop : XfwfTopLeft),
	 XtNbackground,         bg.GetPixel(&cmap),
	 XtNforeground,         label_fg.GetPixel(&cmap),
	 XtNfont,               label_font.GetInternalFont(),
	 XtNframeType,          (style & wxFLAT) ? XfwfChiseled : XfwfSunken,
	 XtNframeWidth,         (style & wxNO_BORDER ? 0 : 2),
	 XtNhighlightThickness, (style & wxNO_BORDER ? 0 : 2),
	 XtNshrinkToFit,        (width < 0 || height < 0),
	 NULL);
    // create group widget, which holds the the toggles
    HWidget() = XtVaCreateManagedWidget
	(name, xfwfGroupWidgetClass, FWidget(),
	 XtNbackground,          bg.GetPixel(&cmap),
	 XtNselectionStyle,      (style & wxAT_MOST_ONE) ? XfwfSingleSelection : XfwfOneSelection,
	 XtNlabel,               NULL,
	 XtNframeWidth,          0,
	 XtNhighlightThickness,  0,
	 XtNhSpacing,		 ((style & wxNO_BORDER) && !(style & wxVERTICAL)) ?
				  panel->GetHorizontalSpacing() : 0,
	 XtNinnerVOffset,        ((style & wxNO_BORDER) ? 2 : 0),
	 XtNshrinkToFit,         TRUE,
	 XtNstoreByRow,          (!(style & wxVERTICAL)),
	 (style & wxVERTICAL ?
	  XtNrows : XtNcolumns), (num_rows <= 0) ? num_toggles : num_rows,
	 NULL);
    // create the toggles
    toggles = (void*)     wxNEW Widget[num_toggles];
    bmps    = (wxBitmap*) wxNEW wxBitmap[num_toggles];
    for (int i=0; i < num_toggles; ++i) {
	char num_name[10]; sprintf(num_name, "%d", i);
	((Widget*)toggles)[i] = XtVaCreateManagedWidget
	    (num_name, xfwfToggleWidgetClass, HWidget(),
	     XtNlabel,                choices[i],
	     XtNbackground,           bg.GetPixel(&cmap),
	     XtNforeground,           fg.GetPixel(&cmap),
	     XtNfont,                 font.GetInternalFont(),
	     XtNrightMargin,          ((style & wxNO_BORDER) ? 0 : 2),
	     XtNshrinkToFit,          TRUE,
	     XtNpropagateKeyToParent, TRUE,
	     XtNalignment,	      XfwfLeft,
	     NULL);
    }
    // resize enforcer widget
    Dimension ww, hh; float lw=0, lh=0;
    XtVaGetValues(HWidget(), XtNwidth, &ww, XtNheight, &hh, NULL);
    if (label) GetTextExtent(label, &lw, &lh, NULL, NULL, &label_font);
    if (label_position == wxVERTICAL)
	hh += int(lh);
    else
	ww += int(lw);
    XtVaSetValues(FWidget(), XtNwidth, ww + (label ? 8 : 0), XtNheight, hh + (label ? 8 : 0), NULL);
    // set data declared in wxItem
    callback = func;
    XtAddCallback(HWidget(), XtNactivate, wxRadioBox::EventCallback,
		  (XtPointer)this);
    // position item
    if (width > -1 || height > -1) {
	XtVaSetValues(FWidget(), XtNshrinkToFit, FALSE, NULL);
	XtVaSetValues(HWidget(), XtNshrinkToFit, FALSE, NULL);
    }
    panel->PositionItem(this, x, y, width, height);
    // add event handlers
    AddEventHandlers();

    return TRUE;
}

Bool wxRadioBox::Create(wxPanel *panel, wxFunction func, Const char *label,
		   int x, int y, int width, int height, int n, wxBitmap **choices,
		   int num_rows, long style, Constdata char *name)
{
    num_Rows = num_rows;
    if ( (num_toggles = n) <= 0 ) {
	wxError("created without items (n=0)!\n", name);
	return TRUE;
    }

    ChainToPanel(panel, style, name);

    // create frame
    FWidget() = XtVaCreateManagedWidget
	(name, xfwfEnforcerWidgetClass, GetParentWidget(parent),
	 XtNlabel,              label,
	 XtNalignment,          ((label_position == wxVERTICAL) ?
				 XfwfTop : XfwfTopLeft),
	 XtNbackground,         bg.GetPixel(&cmap),
	 XtNforeground,         label_fg.GetPixel(&cmap),
	 XtNfont,               label_font.GetInternalFont(),
	 XtNframeType,          (style & wxFLAT) ? XfwfChiseled : XfwfSunken,
	 XtNframeWidth,         (style & wxNO_BORDER ? 0 : 2),
	 XtNhighlightThickness, (style & wxNO_BORDER ? 0 : 2),
	 XtNshrinkToFit,        (width < 0 || height < 0),
	 NULL);
    // create group widget, which holds the the toggles
    HWidget() = XtVaCreateManagedWidget
	(name, xfwfGroupWidgetClass, FWidget(),
	 XtNbackground,          bg.GetPixel(&cmap),
	 XtNselectionStyle,      (style & wxAT_MOST_ONE) ? XfwfSingleSelection : XfwfOneSelection,
	 XtNlabel,               NULL,
	 XtNframeWidth,          0,
	 XtNhighlightThickness,  0,
	 XtNhSpacing,		 ((style & wxNO_BORDER) && !(style & wxVERTICAL)) ?
				  panel->GetHorizontalSpacing() : 0,
	 XtNinnerVOffset,        ((style & wxNO_BORDER) ? 2 : 0),
	 XtNshrinkToFit,         TRUE,
	 XtNstoreByRow,          (!(style & wxVERTICAL)),
	 (style & wxVERTICAL ?
	  XtNrows : XtNcolumns), (num_rows <= 0) ? num_toggles : num_rows,
	 NULL);
    // create the toggles
    toggles = (void*)     wxNEW Widget[num_toggles];
    bmps    = (wxBitmap*) wxNEW wxBitmap[num_toggles];
    for (int i=0; i < num_toggles; ++i) {
	char num_name[10]; sprintf(num_name, "%d", i);
	((Widget*)toggles)[i] = XtVaCreateManagedWidget
	    (num_name, xfwfToggleWidgetClass, HWidget(),
	     XtNpixmap,               choices[i]->GetPixmap(),
	     XtNmask,                 choices[i]->GetMask(),
	     XtNbackground,           bg.GetPixel(&cmap),
	     XtNforeground,           fg.GetPixel(&cmap),
	     XtNfont,                 font.GetInternalFont(),
	     XtNrightMargin,          ((style & wxNO_BORDER) ? 0 : 2),
	     XtNshrinkToFit,          TRUE,
	     XtNpropagateKeyToParent, TRUE,
	     XtNalignment,	      XfwfLeft,
	     NULL);
	bmps[i] = choices[i];
    }
    // resize enforcer widget
    Dimension ww, hh; float lw=0, lh=0;
    XtVaGetValues(HWidget(), XtNwidth, &ww, XtNheight, &hh, NULL);
    if (label) GetTextExtent(label, &lw, &lh, NULL, NULL, &label_font);
    if (label_position == wxVERTICAL)
	hh += int(lh);
    else
	ww += int(lw);
    XtVaSetValues(FWidget(), XtNwidth, ww + (label ? 8 : 0), XtNheight, hh + (label ? 8 : 0), NULL);
    // set data declared in wxItem
    callback = func;
    XtAddCallback(HWidget(), XtNactivate, wxRadioBox::EventCallback,
		  (XtPointer)this);
    // position item
    if (width > -1 || height > -1) {
	XtVaSetValues(FWidget(), XtNshrinkToFit, FALSE, NULL);
	XtVaSetValues(HWidget(), XtNshrinkToFit, FALSE, NULL);
    }
    panel->PositionItem(this, x, y, width, height);
    // add event handlers
    AddEventHandlers();

    return TRUE;
}

wxRadioBox::~wxRadioBox(void)
{
    if (num_toggles) {
	delete[] toggles;
	delete[] bmps;
	num_toggles = 0;
    }
}

//-----------------------------------------------------------------------------
// methods to access internal data
//-----------------------------------------------------------------------------

void wxRadioBox::Enable(int item, Bool enable)
{
    if (0 <= item && item < num_toggles)
	XtSetSensitive(TOGGLES[item], enable);
}

int wxRadioBox::FindString(char *s)
{
    for (int i=0; i < num_toggles; ++i) {
	if (! strcmp(GetLabel(i), s))
	    return i;
    }
    return -1;
}

char *wxRadioBox::GetLabel(int item)
{
    char *label = NULL;

    if (0 <= item && item < num_toggles)
	XtVaGetValues(TOGGLES[item], XtNlabel, &label, NULL);

    return label;
}

int wxRadioBox::GetSelection(void)
{
    long selection;

    XtVaGetValues(HWidget(), XtNselection, &selection, NULL);

    return int(selection);
}

char *wxRadioBox::GetStringSelection(void)
{
    char *label = NULL;
    int  item = GetSelection();

    if (0 <= item && item < num_toggles)
	XtVaGetValues(TOGGLES[item], XtNlabel, &label, NULL);
    return label;
}

void wxRadioBox::SetLabel(int item, char *label)
{
    if (0 <= item && item < num_toggles)
	XtVaSetValues(TOGGLES[item], XtNlabel, label, NULL);
}

void wxRadioBox::SetLabel(int item, wxBitmap *bitmap)
{
    if (0 <= item && item < num_toggles) {
	bmps[item] = bitmap;
	XtVaSetValues(TOGGLES[item], XtNlabel, NULL,
		      XtNpixmap, bitmap->GetPixmap(),
		      XtNmask,   bitmap->GetMask(), NULL);
    }
}

void wxRadioBox::SetSelection(int item)
{
    if (0 <= item && item < num_toggles)
	XtVaSetValues(HWidget(), XtNselection, long(item), NULL);
}

void wxRadioBox::SetStringSelection(char *s)
{
    SetSelection(FindString(s));
}

Bool wxRadioBox::Show(int item, Bool show)
{
    if (0 <= item && item < num_toggles) {
	if (show) XtMapWidget(TOGGLES[item]);
	else      XtUnmapWidget(TOGGLES[item]);
    }
    return FALSE;
}

//-----------------------------------------------------------------------------
// override parent methods
//-----------------------------------------------------------------------------

void wxRadioBox::ChangeColours(void)
{
    wxItem::ChangeColours();
    for (int i=0; i < num_toggles; ++i)
	XtVaSetValues(TOGGLES[i],
		      XtNbackground, bg.GetPixel(&cmap),
		      XtNforeground, fg.GetPixel(&cmap),
		      NULL);
}

void wxRadioBox::SetFont(wxFont *font)
{
    wxItem::SetFont(font);
    for (int i=0; i < num_toggles; ++i) {
	XtVaSetValues(TOGGLES[i], XtNfont, font->GetInternalFont(), NULL);
    }
}

//-----------------------------------------------------------------------------
// callbacks for xfwfGroupWidgetClass
//-----------------------------------------------------------------------------

void wxRadioBox::EventCallback(Widget WXUNUSED(w),
			       XtPointer dclient, XtPointer dcall)
{
    wxRadioBox     *radioBox = (wxRadioBox*)dclient;
    wxCommandEvent event(wxEVENT_TYPE_RADIOBOX_COMMAND);

    event.eventObject = radioBox;
    event.commandInt  = long(dcall); // dcall == selection

    radioBox->ProcessCommand(event);
}
