/*								-*- C++ -*-
 * $Id: DLG_colour.h,v 1.1 1996-09-25 11:06:08+02 mho Exp $
 *
 * Purpose: colour dialog box
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1996, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1996, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef wxColourDialog_h
#define wxColourDialog_h

#ifdef __GNUG__
#pragma interface
#endif

#define wxColourDialog wxGenericColourDialog

class wxColourData: public wxObject
{
 DECLARE_DYNAMIC_CLASS(wxColourData)
 public:
  wxColour dataColour;
  wxColour custColours[16];
  Bool chooseFull;

  wxColourData(void);
  ~wxColourData(void);

  inline void SetChooseFull(Bool flag) { chooseFull = flag; }
  inline Bool GetChooseFull(void) { return chooseFull; }
  inline void SetColour(wxColour& colour) { dataColour = colour; }
  inline wxColour &GetColour(void) { return dataColour; } 

  // Array of 16 custom colours
  void SetCustomColour(int i, wxColour& colour);
  wxColour GetCustomColour(int i);

  void operator=(const wxColourData& data);
};

class wxSlider;
class wxGenericColourDialog: public wxDialogBox
{
 DECLARE_DYNAMIC_CLASS(wxGenericColourDialog)
 protected:
  wxColourData colourData;
  wxWindow *dialogParent;

  // Area reserved for grids of colours
  wxRectangle standardColoursRect;
  wxRectangle customColoursRect;
  wxRectangle singleCustomColourRect;

  // Size of each colour rectangle
  wxIntPoint smallRectangleSize;

  // For single customizable colour
  wxIntPoint customRectangleSize;

  // Grid spacing (between rectangles)
  int gridSpacing;

  // Section spacing (between left and right halves of dialog box)
  int sectionSpacing;

  // 48 'standard' colours
  wxColour standardColours[48];

  // 16 'custom' colours
  wxColour customColours[16];

  // One single custom colour (use sliders)
  wxColour singleCustomColour;

  // Which colour is selected? An index into one of the two areas.
  int colourSelection;
  int whichKind; // 1 for standard colours, 2 for custom colours,

  wxSlider *redSlider;
  wxSlider *greenSlider;
  wxSlider *blueSlider;

  int buttonY;

  int okButtonX;
  int customButtonX;

  static Bool colourDialogCancelled;
 public:
  wxGenericColourDialog(void);
  wxGenericColourDialog(wxWindow *parent, wxColourData *data = NULL);
  ~wxGenericColourDialog(void);

  Bool Create(wxWindow *parent, wxColourData *data = NULL);

  Bool Show(Bool show);
  wxColourData& GetColourData(void) { return colourData; }

  // Internal functions
  void OnEvent(wxMouseEvent& event);
  void OnPaint(void);
  Bool OnClose(void);
  Bool OnCharHook(wxKeyEvent& event);

  virtual void CalculateMeasurements(void);
  virtual void CreateWidgets(void);
  virtual void InitializeColours(void);
  
  virtual void PaintBasicColours(void);
  virtual void PaintCustomColours(void);
  virtual void PaintCustomColour(void);
  virtual void PaintHighlight(Bool draw);

  virtual void OnBasicColourClick(int which);
  virtual void OnCustomColourClick(int which);

  virtual void OnOk(void);
  virtual void OnCancel(void);
  virtual void OnAddCustom(void);

  virtual void OnRedSlider(wxCommandEvent& event);
  virtual void OnGreenSlider(wxCommandEvent& event);
  virtual void OnBlueSlider(wxCommandEvent& event);
};

#endif // wxColourDialog_h
