/*								-*- C++ -*-
 * $Id: DLG_dialogs.h,v 1.2 1997-01-30 09:55:25+01 mho Exp $
 *
 * Purpose: common dialogs
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef wxDialogs_h
#define wxDialogs_h

#ifdef __GNUG__
#pragma interface
#endif

class wxWindow;
class wxBitmap;

int wxMessageBox(
    const char *message, const char *caption = wxMessageBoxCaptionStr,
    long style = wxOK|wxCENTRE, wxWindow *parent = NULL, int x = -1, int y = -1);
int wxMessageBox(
    const char *message, const wxBitmap* bitmap, 
    const char *caption = wxMessageBoxCaptionStr,
    long style = wxOK|wxCENTRE, wxWindow *parent = NULL, int x = -1, int y = -1);
char *wxGetTextFromUser(
    const char *message, const char *caption = wxGetTextFromUserPromptStr,
    const char *default_value = wxEmptyString, wxWindow *parent = NULL,
    int x = -1, int y = -1, Bool centre = TRUE);
char *wxGetSingleChoice(
    const char *message, const char *caption,
    int n, char *choices[],
    wxWindow *parent = NULL, int x = -1, int y = -1, Bool centre = TRUE,
    int width = wxCHOICE_WIDTH, int height = wxCHOICE_HEIGHT);
int wxGetSingleChoiceIndex(
    const char *message, const char *caption,
    int n, char *choices[],
    wxWindow *parent = NULL, int x = -1, int y = -1, Bool centre = TRUE,
    int width = wxCHOICE_WIDTH, int height = wxCHOICE_HEIGHT);
char *wxGetSingleChoiceData(
    const char *message, const char *caption,
    int n, char *choices[], char *client_data[],
    wxWindow *parent = NULL, int x = -1, int y = -1, Bool centre = TRUE,
    int width = wxCHOICE_WIDTH, int height = wxCHOICE_HEIGHT);
int wxGetMultipleChoice(
    const char *message, const char *caption,
    int n, char *choices[],
    int nsel, int * selection, wxWindow *parent = NULL,
    int x = -1 , int y = -1, Bool centre = TRUE,
    int width = wxCHOICE_WIDTH, int height = wxCHOICE_HEIGHT);
char *wxLoadFileSelector(
    const char *what, const char *extension, const char *default_name = NULL,
    wxWindow *parent=NULL);
char *wxSaveFileSelector(
    const char *what, const char *extension, const char *default_name = NULL,
    wxWindow *parent=NULL);
char *wxFileSelector(
    const char *message = wxFileSelectorPromptStr, const char *default_path = NULL,
    const char *default_filename = NULL, const char *default_extension = NULL,
    const char *wildcard = wxFileSelectorDefaultWildcardStr, int flags = 0,
    wxWindow *parent = NULL, int x = -1, int y = -1);

#endif // wxDialogs_h
