static char rcsid[] = "@(#)$Id: strmcpy.c,v 1.3 1999/05/22 13:49:48 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.3 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *
 *  Initially written by: Michael Elkins <elkins@aero.org>, 1995
 *****************************************************************************/

#include "headers.h"

char * strmcpy (dest, src)
     char *dest;
     CONST char *src;
{
	int len = strlen (src) + 1;

	if (dest)
		dest = (char *) safe_realloc (dest, len);
	else
		dest = (char *) safe_malloc (len);
	strfcpy (dest, src, len);
	return dest;
}


char * strmcat (dest, src)
     char *dest;
     CONST char *src;
{
	int len;

	if (!dest)
	  return strmcpy(dest,src);

	len = strlen (src) + 1 + strlen(dest);

	dest = (char *) safe_realloc (dest, len);
	strfcat (dest, src, len);
	return dest;
}
