/*
** 
** Copyright (C) 1993 Swedish University Network (SUNET)
** 
** 
** This program is developed by UDAC, Uppsala University by commission
** of the Swedish University Network (SUNET). 
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITTNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
** 
** 
**                                           Martin.Wendel@its.uu.se
** 				             Torbjorn.Wictorin@its.uu.se
** 
**                                           ITS	
**                                           P.O. Box 887
**                                           S-751 08 Uppsala
**                                           Sweden
** 
*/
#include "emil.h"

char *
makelong(unsigned long i, int length)
{
  unsigned char *s, *t;
  s = (char *)Yalloc(length + 1);
  t = s;
  for (;length != 0; length--)
    {
      *s = 0xFF & (i >> (length - 1)*8);
      s++;
    }
  return(t);
}


int
getlong(unsigned long *l, struct data *d)
{
  unsigned char *s;
  int i;
  if (get_length(d) < 4)
    return(NOK);
  s = d->contents + d->offset;
  *l = 0;
  for (i = 0; i < 4; i++)
      *l = (unsigned long) *s++ | *l<<8;
  d->offset += 4;
  return(OK);
}

unsigned long
getblong(unsigned char *s)
{
  unsigned long l;
  int i;
  l = 0;
  for (i = 0; i < 4; i++)
      l = (unsigned long) *s++ | l<<8;
  return(l);
}

int
getshort(unsigned short *l, struct data *d)
{
  unsigned char *s;
  int i;
  if (get_length(d) < 2)
    return(NOK);
  s = d->contents + d->offset;
  *l = 0;
  for (i = 0; i < 2; i++)
      *l = (unsigned short) *s++ | *l<<8;
  d->offset += 2;
  return(OK);
}

