/* DSTART                                                                    */
/*                                                                           */
/*           maildrop - mail delivery agent with filtering abilities         */
/*                                                                           */
/*  Copyright 1998, Double Precision Inc.                                    */
/*                                                                           */
/*  This program is distributed under the terms of the GNU General Public    */
/*  License. See COPYING for additional information.                         */
/* DEND                                                                      */
#include	"funcs.h"
#include	"buffer.h"
#include	"config.h"
#include	"varlist.h"
#include	"maildrop.h"
#include	"autoconf.h"
#include	<string.h>
#include	<grp.h>
#if	HAVE_MEMORY_H
#include	<memory.h>
#endif
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif

#if	HAS_GETHOSTNAME
#else
extern "C" int gethostname(const char *, size_t);
#endif

static const char rcsid[]="$Id: funcs.C 1.2 1998/06/21 17:49:09 mrsam Exp $";

void	memorycopy(void *dst, void *src, int cnt)
{
	if (cnt <= 0)	return;
	memmove(dst, src, cnt);
}

void	outofmem()
{
	throw "Out of memory.\n";
}

void	seekerr()
{
	throw "Seek error.\n";
}

const char *TempName(const char *dir, unsigned l)
{
static Buffer buf;
static unsigned counter=0;
char	hostname[256];

	hostname[0]=0;
	gethostname(hostname, 256);
	hostname[sizeof(hostname)-1]=0;

	buf=dir;
	if (l > 0)	buf.Length(l);
	buf.append( (unsigned long)getpid() );
	buf += '.';
	buf.append( (unsigned long)counter++ );
	buf += '.';
	buf += hostname;
	buf += '\0';

	return (buf);
}

int backslash_char(int c)
{
	switch (c)	{
	case 'r':
		return '\r';
	case 'n':
		return '\n';
	case 't':
		return '\t';
	case 'f':
		return '\f';
	case 'v':
		return '\v';
	}
	return (c);
}
