/*
	sysdep.h	System dependant macros and the like.
	Copyright (c) 1998 by Christopher S L Heng. All rights reserved.

	$Id: sysdep.h,v 1.1 1998/03/30 13:31:58 chris Released $
*/

#if !defined(SYSDEP_H_INCLUDED)
#define	SYSDEP_H_INCLUDED

/* macros for the operating system */
/* Note that the tests have to proceed in this order because */
/* Borland defines MSDOS and _Windows for all windows systems, I think. */
#if defined(__NT__) || defined(__WIN32__) || defined(_WIN32)
#if defined(__BORLANDC__) && (__BORLANDC__ <= 0x460)
#ifndef WIN32
#define	WIN32		/* Borland's WINDOWS.H defines WIN32 as a null macro */
#endif
#else
#ifndef WIN32
#define	WIN32	1
#endif
#endif
#endif

#if defined(__WINDOWS__) || (defined(_Windows) && !defined(WIN32))
#ifndef WIN16
#define	WIN16
#endif
#endif

#if defined(WIN16) || defined(WIN32)
#ifndef	WINDOWS
#define	WINDOWS		/* defined for both WIN16 and WIN32 */
#endif
#endif

/* Beware of potential bug in the following: I actually undefine */
/* MSDOS and __MSDOS__ in Borland. I think this is okay for BC 3.1 and */
/* 4.52 because no header in include\*.h or include\sys\*.h seems to rely */
/* on the existence of this macro, but I don't know about later */
/* versions! */
#if defined(__BORLANDC__) && defined(WINDOWS)
#undef	MSDOS		/* Borland C/C++ always defines these! */
#undef	__MSDOS__
#endif

#if defined(__DOS__) || defined(__MSDOS__)
#ifndef	MSDOS
#define	MSDOS
#endif
#endif

#if defined(__linux__)
#ifndef LINUX
#define	LINUX
#endif
#ifndef UNIX
#define	UNIX
#endif
#ifndef __GNUC__	/* make sure __GNUC__ is defined */
#define	__GNUC__
#endif
#endif	/* if defined(__linux__) */

/* define UNIX as the default if no system is defined so far since */
/* this was the default behaviour for the versions of splitdigest */
/* older than 2.4 */
#if !defined(MSDOS) && !defined(WINDOWS) && !defined(UNIX)
#define	UNIX
#endif


/* integer sizes */

#if defined(WIN16)
#define	INTEGER16
#endif

#if defined(MSDOS)
#if defined(__386__) || defined(__DJGPP__) || defined(__GO32__)
#define	INTEGER32
#else
#define	INTEGER16
#endif
#endif

#if defined(LINUX) || defined(WIN32)
#define	INTEGER32
#endif

/* macros for stuff specific to compilers */
#if defined(_MSC_VER) || defined(__BORLANDC__)
#if defined(_MSC_VER) || \
	(defined(__BORLANDC__) && ((__BORLANDC__ < 0x460) || !defined(__FLAT__)))
#define	S_IRUSR		S_IREAD
#define	S_IWUSR		S_IWRITE
#define	S_IXUSR		S_IEXEC
#define	S_IRWXU		(S_IRUSR|S_IWUSR|S_IXUSR)
#endif
#define	S_IRGRP		0		/* assume we're in MSDOS or Windows 3.1/95 */
#define	S_IWGRP		0		/* where this is not relevant */
#define	S_IXGRP		0
#define	S_IROTH		0
#define	S_IWOTH		0
#define	S_IXOTH		0
#endif

#if defined(__BORLANDC__) || defined(_MSC_VER)
#if !defined(F_OK)
#define	F_OK		0		/* for access() to test file's existance */
#endif
#endif

#if defined(_MSC_VER)
#if !defined(S_ISDIR)
#define	S_ISDIR(m)	((m) & S_IFDIR)
#endif
#endif

/* some system dependent stuff */
#if defined(LINUX)
#define	HAVE_GETOPT_H
#elif !defined(UNIX)
	/* we assume that Unix systems either have getopt.h which */
	/* declares getopt() or their own <unistd.h> has getopt() */
#define	NEED_GETOPT_DECLARATION
#endif



#endif	/* SYSDEP_H_INCLUDED */
