/*

Copyright 1990 by Cray Research, Inc.

Permission to use, copy, modify, distribute, and sell this software and its
documentation for any purpose is hereby granted without fee, provided that
the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation, and that the name of Cray Research, Inc. not be used in
advertising or publicity pertaining to distribution of the software without
specific, written prior permission.  Cray Research, Inc. makes no
representations about the suitability of this software for any purpose.  It
is provided "as is" without express or implied warranty.

*/

static char mail_test_rcsid[]="$Id: mailhandler.c,v 1.12 1995/05/12 21:03:10 bobo Exp $";

#include <stdio.h>
#include <stdlib.h>
#if defined(SYSV) || defined(SVR4) || defined(__hpux) || defined (_SEQUENT_)
#include <string.h>
#else
#include <strings.h>
#endif
#include <pwd.h>
#include <errno.h>
#include <time.h>
#ifndef X_NOT_POSIX
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <netinet/in.h>
/* #include <arpa/nameser.h> */
/* #include <resolv.h> */
#include <utime.h>
#include <fcntl.h>
#include <netdb.h>
#include "mailhandler.h"
#include "defs.h"

#ifdef __hpux
#define setegid(gid) setresgid(-1,gid,-1)
#endif

extern char *username,*TMPDIR;

static struct lockent locktab[50];
	
#define	 MAXLINE	 1024

char		TmpFileName[MAXPATHLEN+1];
char		*MailBoxPath,
		*ReplyPrefix = "Re: ",
		MBFileName[MAXPATHLEN+1] = "*TEMPTHING*",
		LinePtrBuffer[MAXLINE+1],
		*LinePtr = LinePtrBuffer,
		*NoToLine = "* Unknown Recipiant *",
		*NoHFromLine = "* Unknown Sender *",
		*NoCcLine = "* No Cc *",
		*NoContentType = "* No Content Type *",
		*NoSubjectLine = "* No Subject *",
		*NoReturnPathLine = "* No Return Path *",
		*NoReplyToLine = "* No Reply To *",
		*NoInReplyToLine = "* No In Reply To *",
		*NoReferencesLine = "* No References *",
		*NoKeywordsLine = "* No Keywords *",
		*NoCommentsLine = "* No Comments *",
		*NoEncryptedLine = "* No Encrypted *",
		*NoDateLine = "* No Date *",
		*NoMessageIdLine = "* No Message Id *",
		*NoSenderLine = "* No Sender *",
		*NoContentTransferEncodingLine = "* No ContentTransferEncoding *",
		*NoXMailerLine = "* No X-Mailer *",
		*NoXFaceLine = "* No X-Face *",
		*NoAttachment = "* No Attachment-1 *";
struct stat     OriginalSysMBStat,	/*  The file stats of the system mbox file since
					    the last time it was loaded.  This may be
					    the same as OriginalMBStat. */
		CurrentSysMBStat,	/*  The file stats of the system mbox file.  This
					    is used to determine if the mbox is newer. */
		OriginalMBStat,		/*  The file stats of the current mbox file since
					    last time it was loaded or updated */
		CurrentMBStat;		/*  The file stats of what ever.  This is a
					    temporary variable that can be used whenever */
extern struct stat		saved_stat;
char *cur_mbox_fname=(char *)0;
extern char *system_mbox_fname,*MBOX;

extern int *sortTypes,mygroup,mailgroup,cur_msg_num,hold,keep,showold,
		shownew,saveCurrent,bodyOnly,fromAddress;

char *ignoreList[IR_LISTSIZE];
int useIgnore=0;
char *retainList[IR_LISTSIZE];
int useRetain=0;
/*char *mprefix=":-} "; */
extern char *mprefix;
extern int debug,detectiv,caught_fatal_signal,safe_to_exit;

int LetterCount=0;
int OldMessageCount=0;	/* I can't count the new messages as they
				may not contain a status. */
int UnreadMessageCount;

int ReadWriteMBOX=0;	/* flag indicating RW or R-only */

struct HEADLIST *Letters_Top = (struct HEADLIST *)0;
struct HEADLIST *Letters_Bot = (struct HEADLIST *)0;
struct HEADLIST *previous_msg = (struct HEADLIST *)0;
struct HEADLIST *current_msg = (struct HEADLIST *)0;
struct HEADLIST **sortedList = (struct HEADLIST **)0;
FILE	    *MBFP,
		*SysMBFP;
void SortMessages();
void BaseAddr();



/*
 *      Just free dynamic memory used for message addressing.
 *
 */

void FreeMB()
{
struct HEADLIST *this_msg,*tmp_msg;
int letter_index;

for (letter_index=0,this_msg = Letters_Top ; this_msg != (struct HEADLIST *)0 ;
			letter_index++)
{
	if(this_msg->To != NoToLine)
		free(this_msg->To);
	if(this_msg->From_username!=(char *)0)
		free(this_msg->From_username);
	if(this_msg->From!=(char *)0)
		free(this_msg->From);
	if(this_msg->From_UID!=(char *)0)
	{
		free(this_msg->From_UID);
		this_msg->From_UID=(char *)0;
	}
	if(this_msg->From_DAY!=(char *)0)
		free(this_msg->From_DAY);
	if(this_msg->From_MONTH!=(char *)0)
		free(this_msg->From_MONTH);
	if(this_msg->From_DATE!=(char *)0)
		free(this_msg->From_DATE);
	if(this_msg->From_TIME!=(char *)0)
		free(this_msg->From_TIME);
	if(this_msg->HFrom != NoHFromLine)
		free(this_msg->HFrom);
	if(this_msg->Cc != NoCcLine)
		free(this_msg->Cc);
	if(this_msg->ContentType != NoContentType)
		free(this_msg->ContentType);
	if(this_msg->Subject != NoSubjectLine)
		free(this_msg->Subject);
	if(this_msg->ReturnPath != NoReturnPathLine)
		free(this_msg->ReturnPath);
	if(this_msg->ReplyTo != NoReplyToLine)
		free(this_msg->ReplyTo);
	if(this_msg->InReplyTo != NoInReplyToLine)
		free(this_msg->InReplyTo);
	if(this_msg->References != NoReferencesLine)
		free(this_msg->References);
	if(this_msg->Keywords != NoKeywordsLine)
		free(this_msg->Keywords);
	if(this_msg->Comments != NoCommentsLine)
		free(this_msg->Comments);
	if(this_msg->Encrypted != NoEncryptedLine)
		free(this_msg->Encrypted);
	if(this_msg->Date != NoDateLine)
		free(this_msg->Date);
	if(this_msg->MessageId != NoMessageIdLine)
		free(this_msg->MessageId);
	if(this_msg->Sender != NoSenderLine)
		free(this_msg->Sender);
	if(this_msg->ContentTransferEncoding != NoContentTransferEncodingLine)
		free(this_msg->ContentTransferEncoding);
	if(this_msg->XMailer != NoXMailerLine)
		free(this_msg->XMailer);
	if(this_msg->Attach != NoAttachment)
		free(this_msg->Attach);
	if(this_msg->XFace != NoXFaceLine)
		free(this_msg->XFace);

	tmp_msg=this_msg->next;
	free(this_msg);
	this_msg=tmp_msg;

}
	if(letter_index!=LetterCount)
		fprintf(stderr,"letter index = %d, should be %d\n",
				letter_index,LetterCount);
	LetterCount=0;
	OldMessageCount=0;
	UnreadMessageCount=0;
	Letters_Top=(struct HEADLIST *)0;
	Letters_Bot=(struct HEADLIST *)0;
	previous_msg=(struct HEADLIST *)0;
	current_msg=(struct HEADLIST *)0;
}

int LoadMB(mbFileName)
char    *mbFileName;
{
FILE    *mbFP;
int     aChar,tmp_fd,nread,total_read=0;
char message[4096];
struct stat tmp_stat;

if (debug)
    fprintf(stderr,"LoadMB(): mbFileName [%s]\n", mbFileName);

if(LetterCount!=0 || Letters_Top!=(struct HEADLIST *)0)
{
	FreeMB();
}

/*
 * For this next section, a global flag should be set to indicate
 * that this mailbox file is readonly.
 */
if (LockMB(mbFileName)) {
	sprintf(message,"Opening %s as read only\n",mbFileName);
	warn(message);
	ReadWriteMBOX=0;
}
else
{
	if(debug)
	{
		sprintf(message,"Locked %s\n",mbFileName);
		fputs(message,stderr);
		warn(message);
	}
	ReadWriteMBOX=1;
}

if ((mbFP = fopen(mbFileName, "r")) == NULL)
{
	sprintf(message,"Couldn't open mailbox file %s:\n%s\n", 
					mbFileName,strerror(errno));
	warn(message);
	if(debug)
		fputs(message,stderr);

	if(ReadWriteMBOX)
		UnLockMB(mbFileName);

	return(-1);
}

	sprintf(TmpFileName,"%s/XMTbXXXXXX",TMPDIR);

if( ((tmp_fd=my_mkstemp(TmpFileName,""))==-1) || 
	((MBFP = fdopen(tmp_fd, "w+")) == NULL))
{
	sprintf(message,"Couldn't open temp file %s:\n%s\n",
				TmpFileName,strerror(errno));
	warn(message);

	
	fclose(mbFP);
	mbFP=NULL;

	if(ReadWriteMBOX)
		UnLockMB(mbFileName);

	if(tmp_fd!=0)
		close(tmp_fd);

	return(-1);
}

if(debug)
	fprintf(stderr,"TmpFileName = %s\n",TmpFileName);

if (fchmod(fileno(MBFP), S_IRUSR|S_IWUSR) != 0 )
{
	sprintf(message,"Can't fchmod() temporary mailbox file %s : %s\n",
			TmpFileName,strerror(errno));

	warn(message);

}

if(!debug)
	unlink(TmpFileName);

if(debug)
	fprintf(stderr,"starting copy\n");
/*
 * I wonder if doing 1K block reads and writes would be
 * more efficient?
 */
/* while ((aChar = getc(mbFP)) != EOF)
    putc(aChar, MBFP); */

/*
 * this is just a percausion.  Since the file is already
 * locked, it shouldn't be necessary.  However, the
 * locking mechanism may not be effective.
 *
 * fstat(fileno(mbFP),&tmp_stat);
 * fchmod(fileno(mbFP),0);
 */

while ((nread=read(fileno(mbFP),message,4096)) >0)
{
	if(write(fileno(MBFP),message,nread)==-1)
	{
		perror(TmpFileName);
		sprintf(message,
		"WARNING: write of %s failed: %s\nQuitting now is recommended!!\n",
			TmpFileName,strerror(errno));
		fputs(message,stderr);
		/* fchmod(fileno(mbFP),tmp_stat.st_mode); */
		exit(1);
		break;
	}
	total_read+=nread;
}

if(debug)
	fprintf(stderr,"done with copy.  %d bytes copied\n",total_read);

fflush(MBFP);

/* fchmod(fileno(mbFP),tmp_stat.st_mode); */
fclose(mbFP);
mbFP=NULL;

/*
 * this stat is used to determine if this mailbox file
 * has been updated when we do a SaveMB().
 */
stat(mbFileName, &OriginalMBStat);

/*
 * if mbFileName is system_mbox_fname, then we
 * need to remember the stat information so we
 * can update the icon and such.
 */
if (strcmp(mbFileName, system_mbox_fname) == 0)
{
#ifdef SYSV
	memcpy(&OriginalSysMBStat, &OriginalMBStat, sizeof(struct stat));
	memcpy(&CurrentSysMBStat, &OriginalMBStat, sizeof(struct stat));
#else
    bcopy(&OriginalMBStat, &OriginalSysMBStat, sizeof(struct stat));
    bcopy(&OriginalMBStat, &CurrentSysMBStat, sizeof(struct stat));
#endif
}

if (ReadWriteMBOX)
{
	UnLockMB(mbFileName);
}

/*
 * BuildPointers can return a -1 value only if byteIndex !=0.  If
 * BuildPointers(0) encounters an error it will terminate.
 */
if (!(LetterCount = BuildPointers(0)))
    if (debug)
	fprintf(stderr, "No mail.\n");

SortMessages();

if(cur_mbox_fname != (char *)0)
	free(cur_mbox_fname);

if(mbFileName[0]!='/')
{
	char cwd[1024];
#if defined(SYSV) || defined(__alpha)
	getcwd(cwd,1024);
#else
	getwd(cwd);
#endif
	cur_mbox_fname=(char *)malloc(strlen(cwd)+
				strlen(mbFileName)+3);
	sprintf(cur_mbox_fname,"%s/%s",cwd,mbFileName);
}
else
{
	cur_mbox_fname=(char *)malloc(strlen(mbFileName)+1);
	strcpy(cur_mbox_fname,mbFileName);
}

return(LetterCount);


}




/*
 *  Update system mailbox file, if messages have been deleted.
 *  Assume InitMailbox() has been called already.
 *
 */

int SaveMB(mbFileName)
char    *mbFileName;
{
int	     i, 
		j,
		aChar,
		isExtra = FALSE;
unsigned int    S;
char message[1024];
char tmp_mbFileName[1024];
struct HEADLIST *this_msg;
struct stat tmp_stat1,tmp_stat2;
struct utimbuf utime_ptr;
FILE	    *extraFP = NULL,
		*mbFP = NULL,
		*MBOX_FP=NULL,
		*this_FP;

if(debug)
	fprintf(stderr,"SaveMB(): %x\n",mbFileName);

if (debug && (mbFileName != (char *)0))
	fprintf(stderr,"SaveMB(): mbFileName [%s]\n", mbFileName);

if(!ReadWriteMBOX)
{
	FreeMB();
	if(MBFP!=NULL)
	{
		fclose(MBFP);
		MBFP=NULL;
	}

	if(debug)
	{
		sprintf(message,"Shouldn't be trying to save a Read only Mbox\n");
		warn(message);
		return(-1);
	}
	return(0);
}

if(saveCurrent)
	current_msg=sortedList[cur_msg_num];

/*
 * We need to mark all of the messages as being OLD if it isn't
 * already.
 */
for (this_msg = Letters_Top; this_msg != (struct HEADLIST *)0 ;
			this_msg = this_msg->next)
{
	if(!ISMMOLD(this_msg))
	{
		MMSETOLD(this_msg);
		if(this_msg->modified != 0)
		{
			this_msg->modified=MMOLD;
		}
	}
}

/*
 * If the System Mailbox has grown, the following line will
 * copy the new stuff into the tmp file and load the header information.
 * This is done to insure that we don't get rid of the stuff at the
 * end of the file.
 */
if(UpdateSysMB(mbFileName)==-1)
{
	fclose(MBFP);
	MBFP=NULL;
	FreeMB();
	return(0);
}

/*
 * if none of the message have been modified, we don't need to
 * do anything.
 */
for (this_msg = Letters_Top ; this_msg != (struct HEADLIST *)0 ;
			this_msg = this_msg->next)
{
	if(this_msg->modified!=0)
	{
		if(debug)
			fprintf(stderr,"%d %s\n",this_msg->modified,this_msg->From);
		break;
	}
}

if((this_msg==(struct HEADLIST *)0) && (!saveCurrent))
{
	fclose(MBFP);
	MBFP=NULL;
	FreeMB();
	return(0);
}

LinePtr = LinePtrBuffer;

safe_to_exit=0;

if (LockMB(mbFileName))
{
/*	sprintf(message,"SaveMB():  Couldn't lock mailbox file [%s]\n",
				mbFileName);
	warn(message);
*/
	safe_to_exit=1;
	return(-1);
}

/*
 *  Copy NON-deleted mail entries from user temp file to system file.
 */
/*
 * instead of writing to the actual mbox file, we will write to a temporary
 * file in the same file system and then rename the file latter.
 */
setegid(mailgroup);

sprintf(tmp_mbFileName,"%s.XMTtmp",mbFileName);
if(stat(tmp_mbFileName,&tmp_stat1)!=-1)
{
	sprintf(message,"SaveMB:  The file [%s] already exists.  This\n",
					tmp_mbFileName);
	strcat(message,"indicates that another session of XMailTool had a problem while\n");
	strcat(message,"trying to save this mailbox file.  You need to resolve this problem\n");
	strcat(message,"before XMailTool will save messages to this mailbox file.");
	warn(message);
	fputs(message,stderr);
	setegid(mygroup);
	UnLockMB(mbFileName);
	safe_to_exit=1;
	return(-1);
}

if(stat(mbFileName,&tmp_stat1)==-1)
{
	sprintf(message,"SaveMB:  can't stat(2) mbox file (%s): %s",strerror(errno));
	warn(message);
	setegid(mygroup);
	UnLockMB(mbFileName);
	safe_to_exit=1;
	return(-1);
}

if(access(mbFileName,W_OK)==-1)
{
	sprintf(message,"SaveMB: Can't open mailbox file [%s]: %s\n",
			 mbFileName,strerror(errno));
	warn(message);
	fputs(message,stderr);
	setegid(mygroup);
	UnLockMB(mbFileName);
	safe_to_exit=1;
	return(-1);
}

if ((mbFP = fopen(tmp_mbFileName, "w+")) == NULL)
{
	sprintf(message,"SaveMB: Can't open mailbox file [%s]: %s\n",
			 tmp_mbFileName,strerror(errno));
	warn(message);
	setegid(mygroup);
	UnLockMB(mbFileName);
	safe_to_exit=1;
	return(-1);
}
chmod(tmp_mbFileName,tmp_stat1.st_mode);

setegid(mygroup);

/*
 * fstat(fileno(mbFP),&tmp_stat1);
 * fchmod(fileno(mbFP),0);
 */

/*
 * If the hold variable isn't set, we need to save the OLD messages
 * from the system mailbox to the MBOX file.
 */
if((strcmp(mbFileName,system_mbox_fname)==0) && ((hold==0) && (MBOX!=NULL)))
{
	if(LockMB(MBOX))
	{
		sprintf(message,"Can't lock MBOX file (%s): %s\n",
				MBOX,strerror(errno));
		warn(message);
	}
	else
	{
		if((MBOX_FP=fopen(MBOX,"a+")) == NULL)
		{
			sprintf(message,"Can't open MBOX file (%s): %s\n", 
				MBOX,strerror(errno));
		}
		else
		{
			/* 
			 * fstat(fileno(MBOX_FP),&tmp_stat2);
			 * fchmod(fileno(MBOX_FP),0);
			 */
		}
	}
}

if (fseek(MBFP, 0L, 0) == -1)
{
	fprintf(stderr, "SaveMB: Error fseeking Mailbox.\n");
	fflush(stderr);
	UnLockMB(mbFileName);
	setegid(mailgroup);
	unlink(tmp_mbFileName);
	setegid(mygroup);
	/* fchmod(fileno(mbFP),tmp_stat1.st_mode);*/
	if(MBOX_FP!=(FILE *)0)
	{
		UnLockMB(MBOX);
		/* fchmod(fileno(MBOX_FP),tmp_stat2.st_mode); */
	}
	exit(1);
}



for (this_msg = Letters_Top ; this_msg != (struct HEADLIST *)0 ;
			this_msg = this_msg->next)
{
	if (ISMMDEL(this_msg))
	{
		if (debug)
			fprintf(stderr,"Deleting (0x%x)\n", this_msg);
		continue;
	}

	if (debug)
		fprintf(stderr,"Saving (0x%x) %d bytes from location %d \n", this_msg,
			this_msg->byteSize, this_msg->hdrIndex);

	if (fseek(MBFP, this_msg->hdrIndex, 0) == -1)
	{
		fprintf(stderr, "SaveMB: Error fseeking Mailbox.\n");
		fflush(stderr);
		UnLockMB(mbFileName);
		setegid(mailgroup);
		unlink(tmp_mbFileName);
		setegid(mygroup);
		/* fchmod(fileno(mbFP),tmp_stat1.st_mode); */
		if(MBOX_FP!=(FILE *)0)
		{
			UnLockMB(MBOX);
			/* fchmod(fileno(MBOX_FP),tmp_stat2.st_mode); */
		}
		exit(1);
	}

	if((MBOX_FP!=NULL) && (ISMMREAD(this_msg)) && (this_msg->modified!=0))
	{
		this_FP=MBOX_FP;
	}
	else
	{
		this_FP=mbFP;
	}


	for (j = 0; j < this_msg->hdrCount; j++)
	{
		if ((LinePtr = fgets(LinePtr, MAXLINE, MBFP)) == NULL)
		{
			perror("SaveMB:");
			sprintf(message, 
"SaveMB: Error reading header from temp file. Report [%d],[%d],[0x%x]\n",
				j,this_msg->hdrCount,MBFP);
			
			fputs(message,stderr);
			warn(message);
			setegid(mygroup);
			{
				int junk_fd,nread;
				char buff[2048];

				junk_fd=open("/tmp/XMTjunk",O_WRONLY|O_CREAT|O_TRUNC,0600);
				fseek(MBFP,0,SEEK_SET);
				for(;;)
				{
					nread=read(fileno(MBFP),buff,2048);
					if(nread<1)
						break;
					write(junk_fd,buff,nread);
				}
				close(junk_fd);
			}
			setegid(mailgroup);
			unlink(tmp_mbFileName);
			setegid(mygroup);
			UnLockMB(mbFileName);
			safe_to_exit=1;
			exit(1);
		}
		else
		{
			if ((strncmp(LinePtr, "Status: ", 7) != 0) &&
				(strncmp(LinePtr, "Content-Length: ",15) !=0) &&
				(strncmp(LinePtr, "X-Display-Position: ",19) !=0) &&
				(strncmp(LinePtr, "X-Current-Message: ",18) !=0) &&
				(strncmp(LinePtr, "X-Lines: ",8) !=0))
			{
				fputs(LinePtr, this_FP);
			}
		}
	}
    
	fprintf(this_FP, "Status: ");
	if (ISMMREAD(this_msg))
		putc('R', this_FP);
	if (ISMMOLD(this_msg))
		putc('O', this_FP);
	if (!ISMMOLD(this_msg) && !ISMMREAD(this_msg))
		putc('N', this_FP);
	putc('\n', this_FP);

	if(this_msg->ContentLength==-1)
	{
		this_msg->ContentLength = this_msg->byteSize -
					(this_msg->bodyIndex -
					 this_msg->hdrIndex) - 2;
	}

	if(this_msg->ContentLength<0)
		this_msg->ContentLength=0;

	fprintf(this_FP, "Content-Length: %d\n", this_msg->ContentLength);

	if(this_msg->ContentLength==0)
		fprintf(this_FP, "X-Lines: 0\n");
	else
		fprintf(this_FP, "X-Lines: %d\n",this_msg->bodyCount-2);

	if(saveCurrent && (this_msg == current_msg))
	{
		fprintf(this_FP, "X-Current-Message: 0\n");
		current_msg=(struct HEADLIST *)0;
	}

	if((this_msg->display_position!=0) && (this_msg->bodyCount > 1))
		fprintf(this_FP,"X-Display-Position: %d\n",this_msg->display_position);

	for (j = 0; j < this_msg->bodyCount; j++)
	{
		if ((LinePtr = fgets(LinePtr, MAXLINE, MBFP)) == NULL)
		{
			perror("SaveMB:");
			sprintf(message, 
"SaveMB: Error reading body from temp file. Report [%d],[%d],[0x%x]\n",
				j,this_msg->bodyCount,MBFP);
			fputs(message,stderr);
			warn(message);
			setegid(mailgroup);
			unlink(tmp_mbFileName);
			setegid(mygroup);
			UnLockMB(mbFileName);
			safe_to_exit=1;
			exit(1);
		}
		else
		{
			fputs(LinePtr, this_FP);
		}
	}

	MMUNDEL(this_msg);
}


if(MBOX_FP!=NULL)
{
	fclose(MBOX_FP);
	/* fchmod(fileno(MBOX_FP),tmp_stat2.st_mode); */
	MBOX_FP=NULL;
	if (UnLockMB(MBOX))
	{
		sprintf(message,"Can't unlock MBOX file (%s): %s\n",
				MBOX,strerror(errno));
		fputs(message,stderr);
		warn(message);
		setegid(mailgroup);
		unlink(tmp_mbFileName);
		setegid(mygroup);
		UnLockMB(mbFileName);
		safe_to_exit=1;
		return(-1);
	}
}

if((ftell(mbFP)==0) && keep==0)
{
	sprintf(message,"removing empty file [%s]\n",mbFileName);
	warn(message);
	setegid(mailgroup);
	unlink(mbFileName);
	unlink(tmp_mbFileName);
	setegid(mygroup);
}
else
{
char tmpName[1024];
	sprintf(tmpName,"%s.XMTback",mbFileName);
	if(stat(tmpName,&tmp_stat1)!=-1)
	{
		sprintf(message,"SaveMB:  The file [%s] already exists.  This\n",
					tmpName);
		strcat(message,"indicates that another session of XMailTool had a problem while\n");
		strcat(message,"trying to save this mailbox file.  You need to resolve this problem\n");
		strcat(message,"before XMailTool will save messages to this mailbox file.");
		fputs(message,stderr);
		warn(message);
		setegid(mailgroup);
		unlink(tmp_mbFileName);
		setegid(mygroup);
		UnLockMB(mbFileName);
		safe_to_exit=1;
		return(-1);
	}

	setegid(mailgroup);
	link(mbFileName,tmpName);
	unlink(mbFileName);
	link(tmp_mbFileName,mbFileName);

	unlink(tmp_mbFileName);
	unlink(tmpName);
	setegid(mygroup);
}


/* fchmod(fileno(mbFP),tmp_stat1.st_mode); */
fclose(mbFP);
mbFP=NULL;

utime_ptr.actime=time(0L);
utime_ptr.modtime=utime_ptr.actime;
utime(mbFileName,&utime_ptr);

if (UnLockMB(mbFileName)) {
    fflush(stderr);
    fprintf(stderr, "Can't unlock system mailbox file [%s]\n", mbFileName);
}

	if(debug)
		fprintf(stderr,"closing %s\n",TmpFileName);

if(fclose(MBFP)==-1)
{
	perror(TmpFileName);
	exit(1);
}
MBFP=NULL;

if(!debug)
	unlink(TmpFileName);

FreeMB();

if(strcmp(system_mbox_fname,mbFileName)==0)
{
	stat(system_mbox_fname,&OriginalSysMBStat);
#ifdef SYSV
	memcpy(&CurrentSysMBStat,&OriginalSysMBStat,
#else
	bcopy(&OriginalSysMBStat,&CurrentSysMBStat,
#endif
			sizeof(struct stat));
}

safe_to_exit=1;
if(caught_fatal_signal)
{
	fprintf(stderr,"SaveMB():  Caught_fatal_signal.  Exiting...\n");
	clean_up();
	exit(0);
}

return(0);

}

/*
 *
 */

int UpdateSysMB(mbFileName)
char    *mbFileName;
{
int	     aChar,tmp_lc;
FILE	    *mbFP = NULL;
int		oldEnd;

if (debug)
    fprintf(stderr,"UpdateSysMB():\n");

if(MBFP==NULL)
{
	fprintf(stderr,"temp mail file not open yet\n");
	return(1);
}
/*
 * See if system mailbox has new mail. If so, then get it into the temp
 * mailbox
 */

stat(mbFileName, &CurrentMBStat);

if (CurrentMBStat.st_mtime != OriginalMBStat.st_mtime)
{
	if (CurrentMBStat.st_size > OriginalMBStat.st_size)
	{

		if (LockMB(mbFileName))
		{
			fprintf(stderr,
				"UpdateSysMB: Can't lock system mailbox file [%s]\n",
				 mbFileName);
			fflush(stderr);
			return(1);
		}

		if ((mbFP = fopen(mbFileName, "r")) == NULL)
		{
			fprintf(stderr, 
				"UpdateSysMB: Can't open system mailbox file [%s]\n",
				mbFileName);
			fflush(stderr);
			exit(1);
		}

		if (fseek(mbFP, OriginalMBStat.st_size, SEEK_SET) == -1)
		{
			fprintf(stderr, "UpdateSysMB: Error fseeking system mailbox.\n");
			fflush(stderr);
			exit(1);
		}

	
		if(fflush(MBFP)!=0)
		{
			perror("fflush(MBFP)");
		}

		if (fseek(MBFP, 0L, SEEK_END) == -1)
		{
			perror("fseek(tmp mailbox file)");
			fprintf(stderr, "UpdateSysMB: Error fseeking temp mailbox file.\n");
			fflush(stderr);
			 exit(1);
		}

		oldEnd = ftell(MBFP);
		while ((aChar = getc(mbFP)) != EOF)
			putc(aChar, MBFP);

		fclose(mbFP);
		mbFP=NULL;

		if (UnLockMB(mbFileName))
		{
			fflush(stderr);
			fprintf(stderr, "Can't unlock system mailbox file [%s]\n", mbFileName);
		}


		tmp_lc = BuildPointers(oldEnd);


		/*
		 * if BuildPointers() has returned -1 then we need to
		 * call LoadMB().
		 */

		if(tmp_lc==-1)
		{
			LoadMB(cur_mbox_fname);
			return(LetterCount);
		}
		else
			LetterCount=tmp_lc;

		SortMessages();

		stat(mbFileName, &OriginalMBStat);


		/*
		 * if this is the system mailbox we need to remember this
		 * information so we know when to update the icon ans such.
		 */
		if (strcmp(mbFileName, system_mbox_fname) == 0)
		{
#ifdef SYSV
			memcpy(&CurrentSysMBStat, &OriginalMBStat,
					sizeof(struct stat));
			memcpy(&OriginalSysMBStat, &OriginalMBStat,
					sizeof(struct stat));
#else
			bcopy(&OriginalMBStat, &CurrentSysMBStat,
					sizeof(struct stat));
			bcopy(&OriginalMBStat, &OriginalSysMBStat,
					sizeof(struct stat));
#endif
		}

		return(LetterCount);
	}
	return(-1);
}
	return(LetterCount);


}






char *StepOverWhiteSpace(str)
char    *str;
{

	if(str==NULL)
		return(NULL);

	while (*str)
	{
  		if (ISWHITE(*str))
      	 		str++;
  		else
      			break;
	}

	return(str);
}

char *StepUnderWhiteSpace(str)
char    *str;
{
int x;

	if(str==NULL)
		return(NULL);

	for(x=strlen(str)-1;x>=0;x--)
	{
  		if (ISWHITE(str[x]))
      	 		str[x]=(char)0;
  		else
      			break;
	}

	return(str);
}

char *GetAttachmentLine(my_index)
int     my_index;
{

	if (sortedList[my_index]->attachment)
		return(sortedList[my_index]->Attach);
	else
		return(NULL);
}

/*
 *	Return Attachment type.
 */

int GetAttachmentType(my_index)
int     my_index;
{
	return(sortedList[my_index]->attachmentType);
}

/*
 *	Mark attachment as "seen" or "unseen"
 */

void AttachmentSeen(my_index, state)
int     my_index;
int     state;
{
	sortedList[my_index]->attachmentSeen = state;
}

/*
 *	Mark attachment as "seen" or "unseen"
 */

int IsAttachmentSeen(my_index)
int     my_index;
{
	return(sortedList[my_index]->attachmentSeen);
}


/*
 * set up the ignore and retain lists.
 */
setupIgnoreRetain(lst,ln)
char *lst[];
char *ln;
{
char *mytok;
int ir_index;

	for(ir_index=0;ir_index<IR_LISTSIZE;ir_index++)
	{
		if(lst[ir_index]!=(char *)0)
		{
			free(lst[ir_index]);
			lst[ir_index]=(char *)0;
		}
	}

	mytok=strtok(ln," \t\"\'");
	for(ir_index=0;(mytok!=(char *)0) && (ir_index <IR_LISTSIZE);
			mytok=strtok((char *)0," \t\"\'"),ir_index++)
	{
		lst[ir_index]=(char *)malloc(strlen(mytok)+2);
		strcpy(lst[ir_index],mytok);
	}

	if(ir_index >= IR_LISTSIZE)
	{
		fprintf(stderr,"ir_index too big %d\n",ir_index);
	}
}	
		

/*
 * check ignore and retain lists to determine
 * if this header is to be printed.
 */
int checkHeaderPrint(ln)
char *ln;
{
int ir_index;

	if(strncasecmp(ln,"From ",5)==0)
		return(1);

	if(useIgnore)
	{
		for(ir_index=0;ignoreList[ir_index]!=(char *)0;ir_index++)
		{
			if(strncasecmp(ignoreList[ir_index],
					ln,strlen(ignoreList[ir_index]))==0)
			{
				return(0);
			}
		}
		return(1);
	}

	if(useRetain)
	{
		for(ir_index=0;retainList[ir_index]!=(char *)0;ir_index++)
		{
			if(strncasecmp(retainList[ir_index],
					ln,strlen(retainList[ir_index]))==0)
			{
				return(1);
			}
		}
		return(0);
	}

	return(1);
}


int CopyMessage(this_msg,mbFileName,ifHeader,ifPrefix,ifIgnore)
struct HEADLIST *this_msg;
int	ifHeader,
	ifPrefix,
	ifIgnore;
char *mbFileName;
{
int	i,
	j,
	aChar,
	prevCheckPrint=0;
unsigned int	S,new_file=0;
FILE	*mbFP = NULL;
char tmp_buff[1024];
struct utimbuf utime_ptr;
struct stat tmp_stat;

	LinePtr = LinePtrBuffer;


	if (debug)
	{
		fprintf(stderr,
			"CopyMessage(): mbFileName [%s] index [0x%x] ifHeader [%d]",
			mbFileName,this_msg,ifHeader);
		fprintf(stderr,
			" ifPrefix [%d] ifIgnore[%d]\n",ifPrefix,ifIgnore);
	}

	if((stat(mbFileName,&tmp_stat)==-1) && (errno==ENOENT))
	{
		new_file=1;
	}
	
	safe_to_exit=0;
	if (LockMB(mbFileName))
	{
		safe_to_exit=1;
		return(-1);
	}

	if ((mbFP = fopen(mbFileName, "a")) == NULL)
	{
		sprintf(tmp_buff,"CopyMessage: Error opening %s: %s\n",
				mbFileName,strerror(errno));
		warn(tmp_buff);
		UnLockMB(mbFileName);
		safe_to_exit=1;
		return(-1);
	}

	/* fchmod(fileno(mbFP),0); */

	if (debug)
		fprintf(stderr,"Copying (0x%x) %d bytes from location %d \n",
			this_msg, this_msg->byteSize, this_msg->hdrIndex);

	if(ifHeader)
	{
		if (fseek(MBFP, this_msg->hdrIndex, 0) == -1)
		{
			sprintf(tmp_buff, "CopyMessage: Error fseeking Mailbox.\n%s",
					strerror(errno));
			warn(tmp_buff);
			UnLockMB(mbFileName);
			/* fchmod(fileno(mbFP),tmp_stat.st_mode); */
			fclose(mbFP);
			mbFP=NULL;
			safe_to_exit=1;
			return(-1);
		}

		for (j = 0; j < this_msg->hdrCount; j++)
		{
			if ((LinePtr = fgets(LinePtr, MAXLINE, MBFP)) == NULL)
			{
				sprintf(tmp_buff, 
		"CopyMessage: Error reading header from mailbox file.\n%s",
						strerror(errno));
				warn(tmp_buff);
				UnLockMB(mbFileName);
				/* fchmod(fileno(mbFP),tmp_stat.st_mode); */
				fclose(mbFP);
				mbFP=NULL;
				safe_to_exit=1;
				return(-1);
			}
			else
			{
				if ((strncmp(LinePtr, "Status:", 7) != 0) &&
					(strncmp(LinePtr, "Content-Length: ",15) !=0) &&
					(strncmp(LinePtr, "X-Display-Position: ",19) !=0) &&
					(strncmp(LinePtr, "X-Current-Message: ",18) !=0) &&
					(strncmp(LinePtr, "X-Lines: ",8) !=0))
				{
					if( !ifIgnore || checkHeaderPrint(LinePtr))
					{
						if(ifPrefix)
							fputs(mprefix,mbFP);

						if(!ISWHITE(LinePtr[0]) ||
								prevCheckPrint)
						{
							fputs(LinePtr, mbFP);
							prevCheckPrint=1;
						}
					}
					else
						prevCheckPrint=0;
				}
			}
		}

		if(!ifIgnore || checkHeaderPrint("Status: "))
		{
			if(ifPrefix)
				fputs(mprefix,mbFP);

			fprintf(mbFP, "Status: ");
			if (ISMMOLD(this_msg))
				putc('O', mbFP);
			if (ISMMREAD(this_msg))
				putc('R', mbFP);
			if (!ISMMOLD(this_msg) && !ISMMREAD(this_msg))
				putc('N', mbFP);
			putc('\n', mbFP);
		}

		if(!ifIgnore || checkHeaderPrint("Content-Length: "))
		{
			if(ifPrefix)
				fputs(mprefix,mbFP);

			if(this_msg->ContentLength==-1)
			{
				this_msg->ContentLength = this_msg->byteSize -
					(this_msg->bodyIndex -
					 this_msg->hdrIndex) - 2;
			}

			if(this_msg->ContentLength<0)
				this_msg->ContentLength=0;

			fprintf(mbFP, "Content-Length: %d\n",this_msg->ContentLength);
		}

		if(!ifIgnore || checkHeaderPrint("X-Lines: "))
		{
			if(ifPrefix)
				fputs(mprefix,mbFP);

			fprintf(mbFP, "X-Lines: %d\n",
				(this_msg->ContentLength==0?0:
					this_msg->bodyCount-2));
		}

		if(!ifIgnore || checkHeaderPrint("X-Display-Position: "))
		{
			fprintf(mbFP, "X-Display-Position: %d\n",this_msg->display_position);
		}
	}
	else
	{
		if (fseek(MBFP, this_msg->bodyIndex, 0))
		{
			sprintf(tmp_buff, "Error fseeking mailbox file\n");
			warn(tmp_buff);
			UnLockMB(mbFileName);
			/* fchmod(fileno(mbFP),tmp_stat.st_mode); */
			fclose(mbFP);
			mbFP=NULL;
			safe_to_exit=1;
			return(-1);
		}
	}

	for (j = 0; j < this_msg->bodyCount; j++)
	{
		if ((LinePtr = fgets(LinePtr, MAXLINE, MBFP)) == NULL)
		{
			sprintf(tmp_buff, 
		"CopyMessage: Error reading body from mailbox file.\n%s",
					strerror(errno));
			warn(tmp_buff);
			UnLockMB(mbFileName);
			/* fchmod(fileno(mbFP),tmp_stat.st_mode); */
			fclose(mbFP);
			mbFP=NULL;
			safe_to_exit=1;
			return(-1);
		}
		else
		{
			if(ifPrefix)
				fputs(mprefix,mbFP);
			fputs(LinePtr, mbFP);
		}
	}

	/* fchmod(fileno(mbFP),tmp_stat.st_mode); */
	fclose(mbFP);
	mbFP=NULL;

	if (UnLockMB(mbFileName))
	{
		sprintf(tmp_buff,
			"Can't unlock system mailbox file [%s]\n", mbFileName);
		warn(tmp_buff);
		safe_to_exit=1;
		return(-1);
	}

	if(!new_file)
	{
		utime_ptr.actime=tmp_stat.st_atime;
		utime_ptr.modtime=time(0L);
		utime(mbFileName,&utime_ptr);
	}

	safe_to_exit=1;
	if(caught_fatal_signal)
	{
		fprintf(stderr,"CopyMessage():  Caught_fatal_signal.  Exiting...\n");
		clean_up();
		exit(0);
	}

	return(0);

}






/*
 *
 */

int SetStatus(statusStr)
char    *statusStr;
{
int     statusVal = 0;

while (*statusStr) {
    switch (*statusStr) {
	case 'O':
		statusVal |= MMOLD;
		break;
	case 'R':
		statusVal |= MMREAD;
		break;
    }
    statusStr++;
}
return(statusVal);

}



static int
do_CMP(s1,s2,sortType)
struct HEADLIST *s1,*s2;
int sortType;
{
struct HEADLIST *s1_tmp,*s2_tmp;
int return_val,switch_val;


	if(sortType>0)
	{
		s1_tmp=(s2);
		s2_tmp=(s1);
		switch_val=sortType;
	}
	else
	{
		s1_tmp=(s1);
		s2_tmp=(s2);
		switch_val = ( - sortType);
	}

	switch(switch_val)
	{
		case SortFrom:
			return_val=strcasecmp(s1_tmp->HFrom,s2_tmp->HFrom);
			break;
		case SortCc:
			return_val=strcasecmp(s1_tmp->Cc,s2_tmp->Cc);
			break;
		case SortSubject:
			return_val=strcasecmp(s1_tmp->Subject,s2_tmp->Subject);
			break;
		case SortReturnPath:
			return_val=strcasecmp(s1_tmp->ReturnPath,s2_tmp->ReturnPath);
			break;
		case SortReplyTo:
			return_val=strcasecmp(s1_tmp->ReplyTo,s2_tmp->ReplyTo);
			break;
		case SortInReplyTo:
			return_val=strcasecmp(s1_tmp->InReplyTo,s2_tmp->InReplyTo);
			break;
		case SortReferences:
			return_val=strcasecmp(s1_tmp->References,s2_tmp->References);
			break;
		case SortKeywords:
			return_val=strcasecmp(s1_tmp->Keywords,s2_tmp->Keywords);
			break;
		case SortComments:
			return_val=strcasecmp(s1_tmp->Comments,s2_tmp->Comments);
			break;
		case SortDate:
			return_val=strcasecmp(s1_tmp->Date,s2_tmp->Date);
			break;
		case SortMessageId:
			return_val=strcasecmp(s1_tmp->MessageId,s2_tmp->MessageId);
			break;
		case SortSender:
			return_val=strcasecmp(s1_tmp->Sender,s2_tmp->Sender);
			break;
		case SortPosition:
			return_val=s1_tmp->hdrIndex-s2_tmp->hdrIndex;
			break;
		case SortSize:
			return_val=s1_tmp->byteSize-s2_tmp->byteSize;
			break;
		case SortStatus:
			return_val= (s2_tmp->status & 0x3) - (s1_tmp->status & 0x3);
			break;
		case SortFace:
			return_val=strcasecmp(s1_tmp->XFace,s2_tmp->XFace);
			break;
	}

	return(return_val);
}


static int
messageCMP(s1,s2)
struct HEADLIST **s1,**s2;
{
int return_val=0,sortType_index;

for(sortType_index=0 ; sortTypes[sortType_index]!=0 ;
			sortType_index++)
{
	return_val=do_CMP(*s1,*s2,sortTypes[sortType_index]);
	if(return_val!=0)
		break;
}
return(return_val);

}


void SortMessages()
{
int x;

/*
 * set up array of message pointers.
 */
struct HEADLIST *this_msg,*sorted_this_msg,tmp_msg;


	if(sortedList != (struct HEADLIST **)0)
	{
		if(debug)
			fprintf(stderr,"freeing sorted list\n");

		free(sortedList);
		sortedList = (struct HEADLIST **)0;
	}
	else
	{
		if(debug)
			fprintf(stderr,"diddn't need to free sorted list\n");
	}
	if((sortedList=(struct HEADLIST **)malloc(
					sizeof(struct HEADLIST *)*(LetterCount+1))) ==
					(struct HEADLIST **)0)
	{
		perror("SortMessages:malloc()");
	}

	for(x=0,this_msg=Letters_Top;this_msg!=(struct HEADLIST *) 0;
					this_msg=this_msg->next,x++)
	{
		sortedList[x]= this_msg;
	}

	qsort(sortedList,LetterCount,sizeof(struct HEADLIST *),
#ifdef __STDC__
		(int(*)(const void*, const void*))messageCMP);
#else
		messageCMP);
#endif



}



int
ReadHeaderLine(hp,lp,tp,np,lc)
char **hp;	/* pointer to hader char pointer */
char *lp;	/* pointer to line of text	*/
char *tp;	/* string that tells up what type of header */
char *np;	/* pointer to No{}Line string	*/
int *lc;
{
char *cPtr;
int oldPos;

	if (*hp != np)
	{
		fprintf(stderr, "Duplicate %s Line: %s\n",
			tp,lp);
		fflush(stderr);
	}
	else
	{
		cPtr = (char *)strchr(lp, ':');
		cPtr++;
		cPtr = StepOverWhiteSpace(cPtr);

		if ((*hp = (char *)
				malloc((int)strlen(cPtr)+1)) == NULL)
		{
			fprintf(stderr,"%s: malloc failure.\n",tp);
			return(-1);
		}

		strcpy(*hp, cPtr);

		oldPos=ftell(MBFP);

		while ((lp = fgets(lp, MAXLINE, MBFP)) !=
							NULL)
		{
			if(!ISWHITE(lp[0]))
			{
				if (fseek(MBFP, (long)oldPos, 0) == -1)
				{
					fprintf(stderr,
		"BuildPointers: Error fseeking Mailbox.\n");
					exit(1);
				}
				break;
			}
			else
			{
				*lc++;
				*hp=(char *)realloc(*hp,
							strlen(*hp)+
							strlen(lp)+3);
				strcat(*hp,lp);
				oldPos=ftell(MBFP);

			}
		}
		if(strlen(*hp)==0)
			fprintf(stderr,"Zero length %s\n",tp);
		else
			*hp[strlen(*hp)-1]=(char)0;
	}
}
	
int BuildPointers(byteIndex)
int	byteIndex;
{
int     start = TRUE,
	inHeader = TRUE,
	startByte = byteIndex,
	letterCount = LetterCount,
	lineCount = 0;
int tmpPos,oldPos,valid_from=0;
char    *cPtr,*mytok,*tmp_string;
struct HEADLIST *this_msg;
	
	if (debug)
	{
	    fprintf(stderr,"BuildPointers(%d), LetterCount [%d]\n", byteIndex, LetterCount);
	}
	
	tmpPos=byteIndex;
	
	if (fseek(MBFP, (long)byteIndex, SEEK_SET) == -1)
	{
	    fprintf(stderr, "Error fseeking Mailbox.\n");
	    fflush(stderr);
	    exit(1);
	}
	
	LinePtr = LinePtrBuffer;
	
/*	oldPos=byteIndex; */

	while ((LinePtr = fgets(LinePtr, MAXLINE, MBFP)) != NULL)
	{
		if((byteIndex!=0) && (start && LinePtr[0]=='\n'))
			continue;

		if(start && !FIRSTWORD("From ",LinePtr))
		{

			if(byteIndex==0)
			{
				fprintf(stderr,
		"FATAL Error:  another session of MAIL has written information to the\n");
				fprintf(stderr,
	"\tmailbox file  where I'm expecting to see the begining of a message.\n");
				fprintf(stderr,
	"\tRather than loose information, XMailTool will terminate.\n");
				fprintf(stderr,
	"\tYou should restart your XMailTool session.\n");
				exit(1);
			}
			else
			{
				return(-1);
			}
		}
		

		valid_from=0;

		if (FIRSTWORD("From ", LinePtr))
		{
			char *tmp_string;

			tmp_string=(char *)malloc(strlen(LinePtr)+1);
			strcpy(tmp_string,LinePtr);
			
			mytok=strtok(&tmp_string[5]," \t\r\n");

			for(;;)
			{
				if((mytok==(char *)0) ||
					(strpbrk("\"",mytok)==(char *)0))
					break;

				mytok=strtok((char *)0,"\"");
				if(mytok!=(char *)0)
					mytok=strtok((char *)0," \t\r\n");
			}
	
			if(mytok!=(char *)0)
			{
				mytok=strtok((char *)0," \t\r\n");
			}
			valid_from=((mytok!=(char *)0) &&
				(strstr("SunMonTueWedThuFriSat",mytok)!=(char *)0));

			free(tmp_string);

		}
		if(valid_from)
		{
			if (!start)
			{
				if(detectiv && (this_msg->To==NoToLine) &&
					(this_msg->HFrom == NoHFromLine) &&
					(this_msg->Subject == NoSubjectLine))
				{
	fprintf(stderr,"XMailTool has found a message with no To: line\n");
	fprintf(stderr,"This could mean that you mailbox file is corrupted\n");
	fprintf(stderr,"The message begins with the following header line:\n\n");
	fprintf(stderr,"%s\n\n",this_msg->From);
	fprintf(stderr,"The current message begins with the following header line:\n\n");
	fprintf(stderr,"%s\n\n",LinePtr);
	fprintf(stderr,"You'll need to fix this before you try reading that file.\n");
					exit(1);
				}


				if(detectiv && (this_msg->bodyCount!=0) && (this_msg->bodyCount !=
							lineCount))
				{
	fprintf(stderr,"XMailTool has found an X-Lines: mismatch. Expected %d got %d\n",
				this_msg->bodyCount, lineCount);
	fprintf(stderr,"This could mean that you mailbox file is corrupted\n");
	fprintf(stderr,"The message begins with the following header line:\n\n");
	fprintf(stderr,"%s\n\n",this_msg->From);
	fprintf(stderr,"The current message begins with the following header line:\n\n");
	fprintf(stderr,"%s\n\n",LinePtr);
	fprintf(stderr,"You'll need to fix this before you try reading that file.\n");
					exit(1);
				}


				if(this_msg->bodyCount==0)
					this_msg->bodyCount = lineCount;
	 
				this_msg->byteSize = byteIndex - startByte;


				if((this_msg->ContentLength != -1) &&
					(this_msg->ContentLength !=
							(this_msg->byteSize -
							(this_msg->bodyIndex -
							 this_msg->hdrIndex)) -
					(this_msg->bodyCount==1?1:2)))
				{
					if(!detectiv)
					{
					  this_msg->ContentLength =
							(this_msg->byteSize -
							(this_msg->bodyIndex -
							 this_msg->hdrIndex))-
					  (this_msg->bodyCount==1?1:2);
					}
					else
					{
	fprintf(stderr,"XMailTool has found an Content-Length: mismatch. Expected %d got %d\n",
				this_msg->ContentLength, (this_msg->byteSize -
                                                        (this_msg->bodyIndex -
                                                         this_msg->hdrIndex)) -
					(this_msg->bodyCount==1?1:2));
	fprintf(stderr,"This could mean that you mailbox file is corrupted\n");
	fprintf(stderr,"The message begins with the following header line:\n\n");
	fprintf(stderr,"%s\n\n",this_msg->From);
	fprintf(stderr,"The current message begins with the following header line:\n\n");
	fprintf(stderr,"%s\n\n",LinePtr);
	fprintf(stderr,"You'll need to fix this before you try reading that file.\n");
						exit(1);
					}
				}

				startByte = byteIndex;
				letterCount++;
				if (letterCount == MAXMAIL)
				{
					fprintf(stderr,
						"Reached maximum message capacity[%d].\n", MAXMAIL);
					fflush(stderr);
					break;
				}
			}

			start = FALSE;

			if((this_msg=(struct HEADLIST *)malloc(
					sizeof(struct HEADLIST)))==
					(struct HEADLIST *)0)
			{
				fprintf(stderr,"HEADLIST malloc failure.\n");
				break;
			}


			if(Letters_Top==(struct HEADLIST *)0)
			{
				Letters_Top=this_msg;
			}

			if(Letters_Bot!=(struct HEADLIST *)0)
			{
				Letters_Bot->next=this_msg;
			}

			this_msg->prev=Letters_Bot;
			this_msg->next=(struct HEADLIST *)0;
			Letters_Bot=this_msg;

			this_msg->status = 0;
			this_msg->bodyCount = 0;
			this_msg->byteSize = 0;
			this_msg->modified = 0;
			this_msg->display_position=0;
	
			if ((this_msg->From = (char *) malloc(strlen(LinePtr)+1)) == NULL)
			{
				fprintf(stderr,"From malloc failure.\n");
				break;
			}
	
			strcpy(this_msg->From, &LinePtr[5]);
			this_msg->From[strlen(&LinePtr[5])-1] = '\0';
			mytok=strtok(&LinePtr[5]," \t\r\n");
			if(mytok!=NULL)
			{
				this_msg->From_UID=(char *)malloc(
							strlen(mytok)+1);
				strcpy(this_msg->From_UID,mytok);
				mytok=strtok(NULL," \t\r\n");
			}
			else
			{
				this_msg->From_UID=(char *)0;
			}

			if(mytok!=NULL)
			{
				this_msg->From_DAY=(char *)malloc(
							strlen(mytok)+1);
				strcpy(this_msg->From_DAY,mytok);
				mytok=strtok(NULL," \t\r\n");
			}
			else
			{
				this_msg->From_DAY=(char *)0;
			}

			if(mytok!=NULL)
			{
				this_msg->From_MONTH=(char *)malloc(
							strlen(mytok)+1);
				strcpy(this_msg->From_MONTH,mytok);
				mytok=strtok(NULL," \t\r\n");
			}
			else
			{
				this_msg->From_MONTH=(char *)0;
			}

			if(mytok!=NULL)
			{
				this_msg->From_DATE=(char *)malloc(
							strlen(mytok)+1);
				strcpy(this_msg->From_DATE,mytok);
				mytok=strtok(NULL," \t\r\n");
			}
			else
			{
				this_msg->From_DATE=(char *)0;
			}

			if(mytok!=NULL)
			{
				this_msg->From_TIME=(char *)malloc(
							strlen(mytok)+1);
				strcpy(this_msg->From_TIME,mytok);
			}
			else
				this_msg->From_TIME=(char *)0;	

			this_msg->From_me=0;
			if(this_msg->From_UID!=(char *)0)
			{
				char *addr1,*addr2,*addr3,*addr4;

				addr1=(char *)malloc(strlen(this_msg->From_UID)+1);
				strcpy(addr1,this_msg->From_UID);
				addr2=strtok(addr1,"@");
				addr3=strrchr(addr2,'!');
				if(addr3==(char *)0)
				{
					/* no bangs */
					addr4=addr2;
				}
				else
					addr4=addr3;

				this_msg->From_username=(char *)malloc(
						strlen(addr4)+1);
				strcpy(this_msg->From_username,addr4);
				this_msg->From_me= (!strcmp(addr4,username));
				free(addr1);
			}
			else
				this_msg->From_username=(char *)0;

			this_msg->To = NoToLine;	
			this_msg->Subject = NoSubjectLine;
			this_msg->HFrom = NoHFromLine;
			this_msg->Cc = NoCcLine;
			this_msg->ContentType=NoContentType;
			this_msg->ReturnPath = NoReturnPathLine;
			this_msg->Attach = NoAttachment;
			this_msg->XFace = NoXFaceLine;

			this_msg->ReplyTo = NoReplyToLine;
			this_msg->InReplyTo = NoInReplyToLine;
			this_msg->References = NoReferencesLine;
			this_msg->Keywords = NoKeywordsLine;
			this_msg->Comments = NoCommentsLine;
			this_msg->Encrypted = NoEncryptedLine;

			this_msg->Date = NoDateLine;
			this_msg->MessageId = NoMessageIdLine;
			this_msg->Sender = NoSenderLine;
			this_msg->ContentTransferEncoding = NoContentTransferEncodingLine;
			this_msg->XMailer = NoXMailerLine;

			this_msg->ContentLength=-1;
			this_msg->attachment = FALSE;
			this_msg->attachmentType = 0;
			this_msg->attachmentSeen = TRUE;
		
			inHeader = TRUE;
			this_msg->hdrIndex = byteIndex;
			byteIndex = ftell(MBFP);
	
			lineCount = 1;
			continue;
		}

	/*
 	 * If inHeader, *LinePtr!=space or newline, and no colon we're not in
	 * a header.
	 */
	
		if (inHeader && *LinePtr == '\n')
		{
			inHeader = FALSE;
	
			if((this_msg->status==0) && 
		(( showold && (current_msg==(struct HEADLIST *)0)) || shownew))
			{
				if(!saveCurrent)
				{
					current_msg=this_msg;
				}
			}
	
			this_msg->bodyIndex = byteIndex;
			this_msg->hdrCount = lineCount;
	
			lineCount = 1;
			if(!detectiv && (this_msg->ContentLength!=-1) &&
				(this_msg->bodyCount !=0))
			{
				if(this_msg->ContentLength>0)
				{
					fseek(MBFP,
						byteIndex+this_msg->ContentLength+2,0);
	/*
	 * If the world were an ideal place, at this
	 * point the next line would contain a "From " line or
	 * be the end of the file.  However, I have found
	 * that the world isn't ideal and sometimes the
	 * Content-Length: value is off.  It would be simple
	 * if this value were always under by one, which is
	 * the case most of the time.  However, I have found
	 * some rare ocasions where the value is over by one
	 * and other cases where the value is just plain off
	 * If the value is under by 1 or 2, it may be just that
	 * there are a couple of empty lines at the end of the
	 * message.  This doesn't cause a problem.
	 * If the value is over by 1 or more, that means that
	 * the begining of the next message won't be seen. This
	 * is a problem.
	 * If the value is under by 2 or more and the stuff at
	 * the end of the message that we would miss isn't
	 * new line characters, this is a problem.
	 */

					while((LinePtr = fgets(LinePtr, MAXLINE, MBFP)) !=
							NULL)
					{
						if(LinePtr[0]!='\n')
							break;


					}

					if(LinePtr==NULL)
					{
						LinePtr=LinePtrBuffer;
					}
					else if(!FIRSTWORD("From ",LinePtr))
					{
						byteIndex++;
						fseek(MBFP,byteIndex,0);
/* these values are incorrect so we need to set them such that they will be set
 * correctly latter
 */
						this_msg->ContentLength=-1;
						this_msg->bodyCount=0;
						continue;
					}

					byteIndex +=this_msg->ContentLength+2;
					lineCount=this_msg->bodyCount;
					fseek(MBFP,byteIndex,0);
						
				}
			}
			else
				byteIndex++;

			continue;
		}
		else if (inHeader && FIRSTWORD("Subject:", LinePtr))
		{
			if (this_msg->Subject != NoSubjectLine)
			{
				if(detectiv)
					fprintf(stderr,
			"Duplicate subject line in message [%d]\n",
					letterCount);
			}
			else
			{
				this_msg->subjectIndex = byteIndex;
	
				cPtr = (char *)strchr(LinePtr, ':');
				cPtr++;
				cPtr = StepOverWhiteSpace(cPtr);
	    
				if ((this_msg->Subject = (char *)
					malloc(strlen(cPtr)+1)) == NULL)
				{
					fprintf(stderr,"Subject: malloc failure.\n");
					break;
				}
	
				strcpy(this_msg->Subject, cPtr);

				oldPos=ftell(MBFP);

				while ((LinePtr = fgets(LinePtr, MAXLINE, MBFP)) !=
									NULL)
				{
					if(!ISWHITE(LinePtr[0]))
					{
						if (fseek(MBFP, (long)oldPos, 0) == -1)
						{
							fprintf(stderr,
				"BuildPointers: Error fseeking Mailbox.\n");
							exit(1);
						}
						break;
					}
					else
					{
						lineCount++;
						this_msg->Subject=(char *)realloc(this_msg->Subject,
									strlen(this_msg->Subject)+
									strlen(LinePtr)+3);
						strcat(this_msg->Subject,LinePtr);
						oldPos=ftell(MBFP);

					}
				}
if(strlen(this_msg->Subject)==0)
	fprintf(stderr,"zero length subject\n");
else
				this_msg->Subject[strlen(this_msg->Subject)-1] = '\0';

			}
		}
		else if (inHeader && FIRSTWORD("X-Lines: ", LinePtr))
		{
			if (this_msg->bodyCount!= 0)
			{
				if(detectiv)
					fprintf(stderr,"Duplicate X-Lines line in message [%d]\n",
					letterCount);
			}
			else
			{
	
				cPtr = (char *)strchr(LinePtr, ':');
				cPtr++;
				cPtr = StepOverWhiteSpace(cPtr);
				if(this_msg->ContentLength>0)
		   			this_msg->bodyCount=atoi(cPtr)+2;
				else
					this_msg->bodyCount=0;

				if(this_msg->bodyCount==2)
					this_msg->bodyCount=0;
			}
		}
		else if (inHeader && FIRSTWORD("X-Display-Position: ", LinePtr))
		{
			if (this_msg->display_position!= 0)
			{
				if(detectiv)
					fprintf(stderr, "Duplicate X-Display-Position line in message [%d]\n",
					letterCount);
			}
			else
			{
	
				cPtr = (char *)strchr(LinePtr, ':');
				cPtr++;
				cPtr = StepOverWhiteSpace(cPtr);
	   			this_msg->display_position=atoi(cPtr);
			}
		}
		else if (inHeader && FIRSTWORD("Content-Length: ", LinePtr))
		{
			if (this_msg->ContentLength!= -1)
			{
				if(detectiv)
					fprintf(stderr, "Duplicate ContentLength line in message [%d]\n",
					letterCount);
			}
			else
			{
	
				cPtr = (char *)strchr(LinePtr, ':');
				cPtr++;
				cPtr = StepOverWhiteSpace(cPtr);
	   			this_msg->ContentLength=atoi(cPtr); 
				if(this_msg->ContentLength<0)
				{
					/*
					 * This isn't a valid value...
					 */
	fprintf(stderr,"Your mailbox file is probably corupted!!!  I've detected a\n");
	fprintf(stderr,"Content-Length: line with a negative value (%d)\n\n",
				this_msg->ContentLength);
	fprintf(stderr,"\t!!!You should fix this before continuing!!!\n\n");
	fprintf(stderr,"It may be possible to fix this problem by running the following:\n");
	fprintf(stderr,"awk '{ if ($1!=\"X-Lines:\" && $1!=\"Content-Length:\") print $0}'\n");
	fprintf(stderr,"\nIf you have any doubts about what you are doing, you should\n");
	fprintf(stderr,"contact your system administrator!!!\n");
					exit(1);
				}
			}
		}
		else if (inHeader && (FIRSTWORD("Content-Type: ", LinePtr) ||
					FIRSTWORD("Content-type: ", LinePtr)))
		{
					this_msg->attachment = TRUE;
					this_msg->attachmentType = MIME_ATTACH;
					this_msg->attachmentSeen = FALSE;

			if (this_msg->ContentType != NoContentType)
			{
				if(detectiv)
					fprintf(stderr, "Duplicate ContentType line in message [%d]\n",
					letterCount);
			}
			else
			{
	
				cPtr = (char *)strchr(LinePtr, ':');
				cPtr++;
				cPtr = StepOverWhiteSpace(cPtr);
	    
				if ((this_msg->ContentType = (char *)
					malloc(strlen(cPtr)+1)) == NULL)
				{
					fprintf(stderr,"Subject: malloc failure.\n");
					break;
				}
	
				strcpy(this_msg->ContentType, cPtr);

				oldPos=ftell(MBFP);

				while ((LinePtr = fgets(LinePtr, MAXLINE, MBFP)) !=
									NULL)
				{
					if(!ISWHITE(LinePtr[0]))
					{
						if (fseek(MBFP, (long)oldPos, 0) == -1)
						{
							fprintf(stderr,
				"BuildPointers: Error fseeking Mailbox.\n");
							exit(1);
						}
						break;
					}
					else
					{
						lineCount++;
						this_msg->ContentType=(char *)realloc(this_msg->ContentType,
									strlen(this_msg->ContentType)+
									strlen(LinePtr)+3);
					
strcat(this_msg->ContentType,LinePtr);
						oldPos=ftell(MBFP);

					}
				}
if(strlen(this_msg->ContentType)==0)
	fprintf(stderr,"zero length subject\n");
else
				this_msg->ContentType[strlen(this_msg->ContentType)-1] = '\0';

			}
		}
		else if (inHeader && FIRSTWORD("From:", LinePtr))
		{

			if (this_msg->HFrom != NoHFromLine)
			{
				if(detectiv)
					fprintf(stderr, "Duplicate header from line in message [%d]\n",
							letterCount);
			}
			else
			{
				cPtr = (char *)strchr(LinePtr, ':');
				cPtr++;
				cPtr = StepOverWhiteSpace(cPtr);
	    
				if ((this_msg->HFrom = (char *)
					malloc(strlen(cPtr)+1)) == NULL)
				{
					fprintf(stderr,"From: malloc failure.\n");
					break;
				}
	
				strcpy(this_msg->HFrom, cPtr);

				oldPos=ftell(MBFP);

				while ((LinePtr = fgets(LinePtr, MAXLINE, MBFP)) !=
									NULL)
				{
					if(!ISWHITE(LinePtr[0]))
					{
						if (fseek(MBFP, (long)oldPos, 0) == -1)
						{
							fprintf(stderr,
				"BuildPointers: Error fseeking Mailbox.\n");
							exit(1);
						}
						break;
					}
					else
					{
						lineCount++;
						this_msg->HFrom=(char *)realloc(this_msg->HFrom,
									strlen(this_msg->HFrom)+
									strlen(LinePtr)+3);
						strcat(this_msg->HFrom,LinePtr);
						oldPos=ftell(MBFP);

					}
				}



if(strlen(this_msg->HFrom)==0)
	fprintf(stderr,"Zero length HFrom\n");
else
				this_msg->HFrom[strlen(this_msg->HFrom)-1]= '\0';
				if(this_msg->From_UID!=(char *)0)
				{
					free(this_msg->From_UID);
					this_msg->From_UID=0;
				}
				if((cPtr=strchr(this_msg->HFrom,'<'))!=
								(char *)0)
				{
					char *mytok,tmp_from[100];

					if(!fromAddress)
					{
						strcpy(tmp_from,this_msg->HFrom);
						if((cPtr=strchr(this_msg->HFrom,'('))!=
							(char *)0)
						{
							mytok=strtok(cPtr+1,
									")");
						}
						else
						{
							mytok=strtok(tmp_from,
								"<");
						}
					}
					else
					{
						strcpy(tmp_from,cPtr+1);
						mytok=strtok(tmp_from,">");
					}

					if (mytok!=(char *)0)
					{
						this_msg->From_UID=(char *)
							malloc(strlen(mytok) +
									2);
						strcpy(this_msg->From_UID,
								mytok);
					}
				}
				else if((cPtr=strchr(this_msg->HFrom,'('))!=
							(char *)0)
				{	
					char tmp_from[100];
					char *mytok;


					if(fromAddress)
					{
						strcpy(tmp_from,this_msg->HFrom);
						mytok=strtok(tmp_from," (");
					}
					else
					{
						
						strcpy(tmp_from,cPtr+1);
						mytok=strtok(tmp_from,")");
					}

					if (mytok!=(char *)0)
					{
						this_msg->From_UID=(char *)
							malloc(strlen(mytok) +
									2);
						strcpy(this_msg->From_UID,
								mytok);
					}
				
				}
				else
				{
					this_msg->From_UID=(char *)
						malloc(strlen(
							this_msg->HFrom)+2);
					strcpy(this_msg->From_UID,
							this_msg->HFrom);
				}

			}
		}
		else if (inHeader && (FIRSTWORD("To:", LinePtr) ||
					FIRSTWORD("Apparently-To:",LinePtr)))
		{
	
			if (this_msg->To != NoToLine)
			{
				if(detectiv)
					fprintf(stderr, "Duplicate To line in message [%d]\n",
					letterCount);
			}
			else
			{
			

				cPtr = (char *)strchr(LinePtr, ':');
				cPtr++;
				cPtr = StepOverWhiteSpace(cPtr);
	
				if ((this_msg->To = (char *)
						malloc((int)strlen(cPtr)+1)) == NULL)
				{
					fprintf(stderr,"To: malloc failure.\n");
					break;
				}
	
				strcpy(this_msg->To, cPtr);

				oldPos=ftell(MBFP);

				while ((LinePtr = fgets(LinePtr, MAXLINE, MBFP)) !=
									NULL)
				{
					if(!ISWHITE(LinePtr[0]))
					{
						if (fseek(MBFP, (long)oldPos, 0) == -1)
						{
							fprintf(stderr,
				"BuildPointers: Error fseeking Mailbox.\n");
							exit(1);
						}
						break;
					}
					else
					{
						lineCount++;
						this_msg->To=(char *)realloc(this_msg->To,
									strlen(this_msg->To)+
									strlen(LinePtr)+3);
						strcat(this_msg->To,LinePtr);
						oldPos=ftell(MBFP);

					}
				}
if(strlen(this_msg->To)==0)
	fprintf(stderr,"Zero length To:\n");
else
				this_msg->To[strlen(this_msg->To)-1]=(char)0;
			if(this_msg->From_me)
			{
				char *addr1,*addr2,*addr3,*addr4;

				addr1=(char *)malloc(strlen(this_msg->To)+1);
				strcpy(addr1,this_msg->To);
				addr2=strtok(addr1," @");
				addr3=strrchr(addr2,'!');
				if(addr3==(char *)0)
				{
					/* no bangs */
					addr4=addr2;
				}
				else
					addr4=addr3;

				this_msg->From_me= (strcmp(addr4,username));
				free(addr1);
			}
			}
		}
		else if (inHeader && FIRSTWORD("Cc:", LinePtr))
		{
	
			if (this_msg->Cc != NoCcLine)
			{
				if(detectiv)
					fprintf(stderr, "Duplicate cc line in message [%d]\n",
					letterCount);
			}
			else
			{
				cPtr = (char *)strchr(LinePtr, ':');
				cPtr++;
				cPtr = StepOverWhiteSpace(cPtr);
	
				if ((this_msg->Cc = (char *)
						malloc((int)strlen(cPtr)+1)) == NULL)
				{
					fprintf(stderr,"Cc: malloc failure.\n");
					break;
				}
	
				strcpy(this_msg->Cc, cPtr);

				oldPos=ftell(MBFP);

				while ((LinePtr = fgets(LinePtr, MAXLINE, MBFP)) !=
									NULL)
				{
					if(!ISWHITE(LinePtr[0]))
					{
						if (fseek(MBFP, (long)oldPos, 0) == -1)
						{
							fprintf(stderr,
				"BuildPointers: Error fseeking Mailbox.\n");
							exit(1);
						}
						break;
					}
					else
					{
						lineCount++;
						this_msg->Cc=(char *)realloc(this_msg->Cc,
									strlen(this_msg->Cc)+
									strlen(LinePtr)+3);
					/*	strcat(this_msg->Cc,"\n");*/
						strcat(this_msg->Cc,LinePtr);
						oldPos=ftell(MBFP);

					}
				}
if(strlen(this_msg->Cc)==0)
	fprintf(stderr,"Zero length CC\n");
else
				this_msg->Cc[strlen(this_msg->Cc)-1]=(char)0;
			}
		}
		else if (inHeader && FIRSTWORD("Return-Path:", LinePtr))
		{
	
			if (this_msg->ReturnPath != NoReturnPathLine)
			{
				if(detectiv)
					fprintf(stderr, "Duplicate return-path line in message [%d]\n",
						letterCount);
			}
			else
			{
				cPtr = (char *)strchr(LinePtr, ':');
				cPtr++;
				cPtr = StepOverWhiteSpace(cPtr);
	
				if ((this_msg->ReturnPath = (char *)
						malloc((int)strlen(cPtr)+1)) == NULL)
				{
					fprintf(stderr,"Return-Path: malloc failure.\n");
					break;
				}
	
				strcpy(this_msg->ReturnPath, cPtr);
if(strlen(this_msg->ReturnPath)==0)
	fprintf(stderr,"Zero length ReturnPath\n");
else
				this_msg->ReturnPath[strlen(this_msg->ReturnPath)-1]=(char)0;
			}
		}
		else if (inHeader && FIRSTWORD("Reply-To:", LinePtr))
		{
	
			if (this_msg->ReplyTo != NoReplyToLine)
			{
				if(detectiv)
					fprintf(stderr, "Duplicate Reply-To line in message [%d]\n",
						letterCount);
			}
			else
			{
				cPtr = (char *)strchr(LinePtr, ':');
				cPtr++;
				cPtr = StepOverWhiteSpace(cPtr);
	
				if ((this_msg->ReplyTo = (char *)
						malloc((int)strlen(cPtr)+1)) == NULL)
				{
					fprintf(stderr,"Return-Path: malloc failure.\n");
					break;
				}
	
				strcpy(this_msg->ReplyTo, cPtr);
if(strlen(this_msg->ReplyTo)==0)
	fprintf(stderr,"Zero lenght this_msg->ReplyTo\n");
else
				this_msg->ReplyTo[strlen(this_msg->ReplyTo)-1]=(char)0;
			}
		}
		else if (inHeader && FIRSTWORD("In-Reply-To:", LinePtr))
		{
	
			if (this_msg->InReplyTo != NoInReplyToLine)
			{
				if(detectiv)
					fprintf(stderr, "Duplicate In-Reply-To line in message [%d]\n",
						letterCount);
			}
			else
			{
				cPtr = (char *)strchr(LinePtr, ':');
				cPtr++;
				cPtr = StepOverWhiteSpace(cPtr);
	
				if ((this_msg->InReplyTo = (char *)
						malloc((int)strlen(cPtr)+1)) == NULL)
				{
					fprintf(stderr,"Return-Path: malloc failure.\n");
					break;
				}
	
				strcpy(this_msg->InReplyTo, cPtr);
if(strlen(this_msg->InReplyTo)==0)
	fprintf(stderr,"zero length this_msg->InReplyTo\n");
else
				this_msg->InReplyTo[strlen(this_msg->InReplyTo)-1]=(char)0;
			}
		}
		else if (inHeader && FIRSTWORD("References:", LinePtr))
		{
	
			if (this_msg->References != NoReferencesLine)
			{
				if(detectiv)
					fprintf(stderr, "Duplicate References line in message [%d]\n",
						letterCount);
			}
			else
			{
				cPtr = (char *)strchr(LinePtr, ':');
				cPtr++;
				cPtr = StepOverWhiteSpace(cPtr);
	
				if ((this_msg->References = (char *)
						malloc((int)strlen(cPtr)+1)) == NULL)
				{
					fprintf(stderr,"Return-Path: malloc failure.\n");
					break;
				}
	
				strcpy(this_msg->References, cPtr);

				oldPos=ftell(MBFP);

				while ((LinePtr = fgets(LinePtr, MAXLINE, MBFP)) !=
									NULL)
				{
					if(!ISWHITE(LinePtr[0]))
					{
						if (fseek(MBFP, (long)oldPos, 0) == -1)
						{
							fprintf(stderr,
				"BuildPointers: Error fseeking Mailbox.\n");
							exit(1);
						}
						break;
					}
					else
					{
						lineCount++;
						this_msg->References=(char *)realloc(this_msg->References,
									strlen(this_msg->References)+
									strlen(LinePtr)+3);
/*						strcat(this_msg->References,"\n");*/
						strcat(this_msg->References,LinePtr);
						oldPos=ftell(MBFP);

					}
				}
if(strlen(this_msg->References)==0)
	fprintf(stderr,"zero length this_msg->References\n");
else
				this_msg->References[strlen(this_msg->References)-1]=(char)0;
			}
		}
		else if (inHeader && FIRSTWORD("Keywords:", LinePtr))
		{
	
			if (this_msg->Keywords != NoKeywordsLine)
			{
				if(detectiv)
					fprintf(stderr, "Duplicate Keywords line in message [%d]\n",
						letterCount);
			}
			else
			{
				cPtr = (char *)strchr(LinePtr, ':');
				cPtr++;
				cPtr = StepOverWhiteSpace(cPtr);
	
				if ((this_msg->Keywords = (char *)
						malloc((int)strlen(cPtr)+1)) == NULL)
				{
					fprintf(stderr,"Return-Path: malloc failure.\n");
					break;
				}
	
				strcpy(this_msg->Keywords, cPtr);

				oldPos=ftell(MBFP);

				while ((LinePtr = fgets(LinePtr, MAXLINE, MBFP)) !=
									NULL)
				{
					if(!ISWHITE(LinePtr[0]))
					{
						if (fseek(MBFP, (long)oldPos, 0) == -1)
						{
							fprintf(stderr,
				"BuildPointers: Error fseeking Mailbox.\n");
							exit(1);
						}
						break;
					}
					else
					{
						lineCount++;
						this_msg->Keywords=(char *)realloc(this_msg->Keywords,
									strlen(this_msg->Keywords)+
									strlen(LinePtr)+3);
/*						strcat(this_msg->Keywords,"\n");*/
						strcat(this_msg->Keywords,LinePtr);
						oldPos=ftell(MBFP);

					}
				}
if(strlen(this_msg->Keywords)==0)
	fprintf(stderr,"Zero length this_msg->Keywords\n");
else
				this_msg->Keywords[strlen(this_msg->Keywords)-1]=(char)0;
			}
		}
		else if (inHeader && FIRSTWORD("Comments:", LinePtr))
		{
	
			if (this_msg->Comments != NoCommentsLine)
			{
				if(detectiv)
					fprintf(stderr, "Duplicate Comments line in message [%d]\n",
						letterCount);
			}
			else
			{
				cPtr = (char *)strchr(LinePtr, ':');
				cPtr++;
				cPtr = StepOverWhiteSpace(cPtr);
	
				if ((this_msg->Comments = (char *)
						malloc((int)strlen(cPtr)+1)) == NULL)
				{
					fprintf(stderr,"Return-Path: malloc failure.\n");
					break;
				}
	
				strcpy(this_msg->Comments, cPtr);

				oldPos=ftell(MBFP);

				while ((LinePtr = fgets(LinePtr, MAXLINE, MBFP)) !=
									NULL)
				{
					if(!ISWHITE(LinePtr[0]))
					{
						if (fseek(MBFP, (long)oldPos, 0) == -1)
						{
							fprintf(stderr,
				"BuildPointers: Error fseeking Mailbox.\n");
							exit(1);
						}
						break;
					}
					else
					{
						lineCount++;
						this_msg->Comments=(char *)realloc(this_msg->Comments,
									strlen(this_msg->Comments)+
									strlen(LinePtr)+3);
						strcat(this_msg->Comments,"\n");
						strcat(this_msg->Comments,LinePtr);
						oldPos=ftell(MBFP);

					}
				}
if(strlen(this_msg->Comments)==0)
	fprintf(stderr,"zerolenght this_msg->Comments\n");
else
				this_msg->Comments[strlen(this_msg->Comments)-1]=(char)0;
			}
		}
		else if (inHeader && FIRSTWORD("Encrypted:", LinePtr))
		{
	
			if (this_msg->Encrypted != NoEncryptedLine)
			{
				if(detectiv)
					fprintf(stderr, "Duplicate Encrypted line in message [%d]\n",
						letterCount);
			}
			else
			{
				cPtr = (char *)strchr(LinePtr, ':');
				cPtr++;
				cPtr = StepOverWhiteSpace(cPtr);

	
				if ((this_msg->Encrypted = (char *)
						malloc((int)strlen(cPtr)+1)) == NULL)
				{
					fprintf(stderr,"Return-Path: malloc failure.\n");
					break;
				}
	
				strcpy(this_msg->Encrypted, cPtr);
if(strlen(this_msg->Encrypted)==0)
	fprintf(stderr,"zero length this_msg->Encrypted\n");
else
				this_msg->Encrypted[strlen(this_msg->Encrypted)-1]=(char)0;
			}
		}
		else if (inHeader && FIRSTWORD("Date:", LinePtr))
		{
	
			if (this_msg->Date != NoDateLine)
			{
				if(detectiv)
					fprintf(stderr, "Duplicate Date line in message [%d]\n",
						letterCount);
			}
			else
			{
				cPtr = (char *)strchr(LinePtr, ':');
				cPtr++;
				cPtr = StepOverWhiteSpace(cPtr);
	
				if ((this_msg->Date = (char *)
						malloc((int)strlen(cPtr)+1)) == NULL)
				{
					fprintf(stderr,"Return-Path: malloc failure.\n");
					break;
				}
	
				strcpy(this_msg->Date, cPtr);
if(strlen(this_msg->Date)==0)
	fprintf(stderr,"zero length this_msg->Date\n");
else
				this_msg->Date[strlen(this_msg->Date)-1]=(char)0;
			}
		}
		else if (inHeader && FIRSTWORD("Message-Id:", LinePtr))
		{
	
			if (this_msg->MessageId != NoMessageIdLine)
			{
				if(detectiv)
					fprintf(stderr, "Duplicate Message-Id line in message [%d]\n",
						letterCount);
			}
			else
			{
				cPtr = (char *)strchr(LinePtr, ':');
				cPtr++;
				cPtr = StepOverWhiteSpace(cPtr);
	
				if ((this_msg->MessageId = (char *)
						malloc((int)strlen(cPtr)+1)) == NULL)
				{
					fprintf(stderr,"MessageId: malloc failure.\n");
					break;
				}
	
				strcpy(this_msg->MessageId, cPtr);
if(strlen(this_msg->MessageId)==0)
	fprintf(stderr,"zero length this_msg->MessageId\n");
else
				this_msg->MessageId[strlen(this_msg->MessageId)-1]=(char)0;
			}
		}
		else if (inHeader && FIRSTWORD("Sender:", LinePtr))
		{
	
			if (this_msg->Sender != NoSenderLine)
			{
				if(detectiv)
					fprintf(stderr, "Duplicate Sender line in message [%d]\n",
						letterCount);
			}
			else
			{
				cPtr = (char *)strchr(LinePtr, ':');
				cPtr++;
				cPtr = StepOverWhiteSpace(cPtr);
	
				if ((this_msg->Sender = (char *)
						malloc((int)strlen(cPtr)+1)) == NULL)
				{
					fprintf(stderr,"Sender: malloc failure.\n");
					break;
				}
	
				strcpy(this_msg->Sender, cPtr);
if(strlen(this_msg->Sender)==0)
	fprintf(stderr,"zero lenght this_msg->Sender\n");
else
				this_msg->Sender[strlen(this_msg->Sender)-1]=(char)0;
			}
		}
		else if (inHeader && FIRSTWORD("ContentTransferEncoding:", LinePtr))
		{
	
			if (this_msg->ContentTransferEncoding != NoContentTransferEncodingLine)
			{
				if(detectiv)
					fprintf(stderr, "Duplicate Content-Transfer-Encoding line in message [%d]\n",
						letterCount);
			}
			else
			{
				cPtr = (char *)strchr(LinePtr, ':');
				cPtr++;
				cPtr = StepOverWhiteSpace(cPtr);
	
				if ((this_msg->ContentTransferEncoding = (char *)
						malloc((int)strlen(cPtr)+1)) == NULL)
				{
					fprintf(stderr,"ContentTransferEncoding: malloc failure.\n");
					break;
				}
	
				strcpy(this_msg->ContentTransferEncoding, cPtr);
if(strlen(this_msg->ContentTransferEncoding)==0)
	fprintf(stderr,"zero length this_msg->ContentTransferEncoding\n");
else
				this_msg->ContentTransferEncoding[strlen(this_msg->ContentTransferEncoding)-1]=(char)0;
			}
		}
		else if (inHeader && FIRSTWORD("X-Mailer:", LinePtr))
		{
	
			if (this_msg->XMailer != NoXMailerLine)
			{
				if(detectiv)
					fprintf(stderr, "Duplicate X-Mailer line in message [%d]\n",
						letterCount);
			}
			else
			{
				cPtr = (char *)strchr(LinePtr, ':');
				cPtr++;
				cPtr = StepOverWhiteSpace(cPtr);
	
				if ((this_msg->XMailer = (char *)
						malloc((int)strlen(cPtr)+1)) == NULL)
				{
					fprintf(stderr,"XMailer: malloc failure.\n");
					break;
				}
	
				strcpy(this_msg->XMailer, cPtr);
if(strlen(this_msg->XMailer)==0)
	fprintf(stderr,"zerolenght this_msg->XMailer\n");
else
				this_msg->XMailer[strlen(this_msg->XMailer)-1]=(char)0;
			}
		}
		else if (inHeader && FIRSTWORD("X-Face:", LinePtr))
		{
	
			if (this_msg->XFace != NoXFaceLine)
			{
				if(detectiv)
					fprintf(stderr, "Duplicate X-Face line in message [%d]\n",
						letterCount);
			}
			else
			{
				cPtr = (char *)strchr(LinePtr, ':');
				cPtr++;
				cPtr = StepOverWhiteSpace(cPtr);
	
				if ((this_msg->XFace = (char *)
						malloc((int)strlen(cPtr)+1)) == NULL)
				{
					fprintf(stderr,"XFace: malloc failure.\n");
					break;
				}
	
				strcpy(this_msg->XFace, cPtr);

				oldPos=ftell(MBFP);

				while ((LinePtr = fgets(LinePtr, MAXLINE, MBFP)) !=
							NULL)
				{
					if(!ISWHITE(LinePtr[0]))
					{
						if (fseek(MBFP, (long)oldPos, 0) == -1)
						{
							fprintf(stderr,
					"BuildPointers: Error fseeking Mailbox.\n");
							exit(1);
						}
						break;
					}
					else
					{
						lineCount++;
						this_msg->XFace=(char *)realloc(this_msg->XFace,
							strlen(this_msg->XFace)+
							strlen(LinePtr)+3);
						strcat(this_msg->XFace,
							StepOverWhiteSpace(LinePtr));
						oldPos=ftell(MBFP);
					}
				}

if(strlen(this_msg->XFace)==0)
	fprintf(stderr,"zero length this_msg->XFace\n");
else
				this_msg->XFace[strlen(this_msg->XFace)-1] = '\0';


			}
		}
		else if (inHeader && FIRSTWORD("X-Current-Message:", LinePtr))
		{
			if(saveCurrent)
			{
				current_msg=this_msg;
			}
		}
		else if (inHeader && FIRSTWORD("Status:", LinePtr))
		{
	
			cPtr = (char *)strchr(LinePtr, ':');
			cPtr++;
			cPtr[strlen(cPtr)-1] = '\0';
			this_msg->status = SetStatus(cPtr);
			if(this_msg->status!=0)
			{
				OldMessageCount++;
			}
			else
			{
				if(((current_msg==(struct HEADLIST *)0) && showold) || shownew)
				{
					if(!saveCurrent)
					{
						current_msg=this_msg;
					}
				}
			}

			if(!ISMMREAD(this_msg))
			{
				if(((current_msg==(struct HEADLIST *)0) && showold) || shownew)
				{
					if(!saveCurrent)
					{
						current_msg=this_msg;
					}
				}
				UnreadMessageCount++;
			}
	
		}
		else if (inHeader && FIRSTWORD("X-Attach-1", LinePtr))
		{
	
			if (this_msg->Attach != NoAttachment)
			{
				if(detectiv)
					fprintf(stderr, "Duplicate attachment line in message [%d]\n",
						letterCount);
			}
			else
			{
				cPtr = (char *)strchr(LinePtr, ':');
				cPtr++;
				cPtr[strlen(cPtr)-1] = '\0';
	
				if ((this_msg->Attach = (char *)
						malloc((int)strlen(cPtr)+1)) == NULL)
				{
					fprintf(stderr,"X-Attach-1: malloc failure.\n");
					break;
				}
				strcpy(this_msg->Attach, cPtr);
				this_msg->attachment = TRUE;
				this_msg->attachmentType = CEM_ATTACH;
				this_msg->attachmentSeen = FALSE;
			}
		}
		else if (inHeader && FIRSTWORD("X-Pmuue", LinePtr))
		{
	
			if (this_msg->Attach != NoAttachment)
			{
				if(detectiv)
					fprintf(stderr, "Duplicate attachment line in message [%d]\n",
									letterCount);
			}
			else
			{
				cPtr = (char *)strchr(LinePtr, ':');
				cPtr++;
				cPtr[strlen(cPtr)-1] = '\0';
	
				if ((this_msg->Attach = (char *)
						malloc((int)strlen(cPtr)+1)) == NULL)
				{
					fprintf(stderr,"X-Attach-1: malloc failure.\n");
					break;
				}
				strcpy(this_msg->Attach, cPtr);
				this_msg->attachment = TRUE;
				this_msg->attachmentType = PMAIL_ATTACH;
				this_msg->attachmentSeen = FALSE;
			}
		}
		else if (inHeader && FIRSTWORD("Content-Type", LinePtr))
		{
	
			if (this_msg->Attach != NoAttachment)
			{
				if(detectiv)
					fprintf(stderr, "Duplicate attachment line in message [%d]\n",
					letterCount);
			}
			else
			{
				cPtr = (char *)strchr(LinePtr, ':');
				cPtr++;
				cPtr[strlen(cPtr)-1] = '\0';
	
				while (ISWHITE(*cPtr) && *cPtr != '\0')
					cPtr++;
	
				if (strncasecmp(cPtr, "text", 4) != 0)
				{
					if ((this_msg->Attach = (char *)
						malloc((int)strlen(cPtr)+1)) == NULL)
					{
						fprintf(stderr,"X-Attach-1: malloc failure.\n");
						break;
					}
					strcpy(this_msg->Attach, cPtr);
					this_msg->attachment = TRUE;
					this_msg->attachmentType = MIME_ATTACH;
					this_msg->attachmentSeen = FALSE;
				}
			}
		}
	    
	    byteIndex = ftell(MBFP);
	    lineCount++;
	}

	if (!start && letterCount != MAXMAIL)
	{

		if(detectiv && (this_msg->To==NoToLine) &&
			(this_msg->HFrom == NoHFromLine) &&
			(this_msg->Subject == NoSubjectLine))
		{
	fprintf(stderr,"XMailTool has found a message with no To: line\n");
	fprintf(stderr,"This could mean that you mailbox file is corrupted\n");
	fprintf(stderr,"The message begins with the following header line:\n\n");
	fprintf(stderr,"%s\n\n",this_msg->From);
	fprintf(stderr,"You'll need to fix this before you try reading that file.\n");
			exit(1);
		}


		if(detectiv && (this_msg->bodyCount!=0) &&
				(this_msg->bodyCount != lineCount))
		{
	fprintf(stderr,"XMailTool has found an X-Lines: mismatch. Expected %d got %d\n",
				this_msg->bodyCount, lineCount);
	fprintf(stderr,"This could mean that you mailbox file is corrupted\n");
	fprintf(stderr,"The message begins with the following header line:\n\n");
	fprintf(stderr,"%s\n\n",this_msg->From);
	fprintf(stderr,"You'll need to fix this before you try reading that file.\n");
			exit(1);
		}

		if(this_msg->bodyCount==0)
			this_msg->bodyCount = lineCount;
	 
		this_msg->byteSize = byteIndex - startByte;

		if((this_msg->ContentLength != -1) &&
			(this_msg->ContentLength != (this_msg->byteSize -
					(this_msg->bodyIndex -
					 this_msg->hdrIndex)) -
					(this_msg->bodyCount==1?1:2)))
		{
			if(!detectiv)
				this_msg->ContentLength =
					(this_msg->byteSize -
					(this_msg->bodyIndex -
					 this_msg->hdrIndex))-
					(this_msg->bodyCount==1?1:2);
			else
			{
	fprintf(stderr,"XMailTool has found an Content-Length: mismatch. Expected %d got %d\n",
				this_msg->ContentLength, (this_msg->byteSize -
						(this_msg->bodyIndex -
						 this_msg->hdrIndex)) -
					(this_msg->bodyCount==1?1:2));
	fprintf(stderr,"This could mean that you mailbox file is corrupted\n");
	fprintf(stderr,"The message begins with the following header line:\n\n");
	fprintf(stderr,"%s\n\n",this_msg->From);
	fprintf(stderr,"You'll need to fix this before you try reading that file.\n");
				exit(1);
			}
		}

	
	    letterCount++;


	}
	
	return(letterCount);
}


init_lockf()
{
#ifdef SYSV
	memset(locktab,0,sizeof(locktab));
#else
	bzero(locktab,sizeof(locktab));
#endif
}

int
my_lockf(fname,l)
char *fname;
int l;
{
int x,tmp_fd;
char *tmp_fname;

return(0);
#ifdef NDEF
	if(l)
	{
		/*
		 * set lock.
		 */
		for(x=0;x<50;x++)
		{
			if((locktab[x].fname==(char *)0) ||
				(strcmp(locktab[x].fname,fname)==0))
				break;
		}

		if(x>=50)
			/*
			 * out of space.
			 */
			return(-1);

		if(locktab[x].fname!=(char *)0)
			/*
			 * already locked.
			 */
			return(0);

		tmp_fname=(char *)malloc(strlen(fname)+1);
		strcpy(tmp_fname,fname);

		tmp_fd=open(tmp_fname,O_RDWR);
		if(tmp_fd==-1)
		{
			if(debug)
				perror(tmp_fname);
			free(tmp_fname);
			return(-1);
		}
		

		if(lockf(tmp_fd,F_LOCK,0)==-1)
		{
			if(debug)
				perror("lockf()");
			free(tmp_fname);
			return(-1);
		}
	
		locktab[x].fname=tmp_fname;
		locktab[x].fd=tmp_fd;
	}
	else
	{
		/*
		 * clear lock.
		 */
		for(x=0;x<50;x++)
		{
			if((locktab[x].fname != (char *)0) &&
					(strcmp(locktab[x].fname,fname)==0))
				break;
		}

		if(x>=50)
		{
			if(debug)
				fprintf(stderr,"no lock %s\n",fname);
			return(-1);
		}

		lockf(locktab[x].fd,F_ULOCK,0);
		close(locktab[x].fd);
		free(locktab[x].fname);
		locktab[x].fname=(char *)0;
	}

	return(0);
#endif /* NDEF */
}

int 
LockMB(mbFileName)
char    *mbFileName;
{
char	lockFile[MAXPATHLEN+1];
int	 fd;
struct stat lockFileStat;
time_t      theTime;
char message[1024];

strcpy(lockFile, mbFileName);
strcat(lockFile, ".lock");

if (debug)
    fprintf(stderr,"lock file [%s]\n", lockFile);

setegid(mailgroup);

while (1)
{
	if (stat(lockFile, &lockFileStat) == -1)
	{
		if (errno == ENOENT)
		{
			if ((fd = creat(lockFile, 0600)) == -1)
			{
				sprintf(message,
		"LockMB: Can't create lock file [%s]:\n%s\n", lockFile,strerror(errno));
				warn(message);
				setegid(mygroup);
				return(1);
			}
			else
			{
				my_lockf(lockFile,1);
				fchmod(fd,0);
				my_lockf(mbFileName,1);
				close(fd);
				if (debug)
					fprintf(stderr,"Good lock\n");
				setegid(mygroup);
				return(0);
			}
		}
		else
		{
			sprintf(message, 
		"LockMB: Can't stat() lock file [%s]:\n%s\n", lockFile,strerror(errno));
			warn(message);
			setegid(mygroup);
			return(1);
		}
	}
	time(&theTime); 
	if (theTime > lockFileStat.st_ctime + 300)
	{  /* 5 min. old? */ 
		fprintf(stderr, "LockMB: Removing 5 minute old lock file [%s]\n", lockFile);
		fflush(stderr);
		unlink(lockFile);
	}
	else
	{
		sleep(1);
	}
}
}

int RoLockMB(mbFileName)
char    *mbFileName;
{
char	lockFile[MAXPATHLEN+1];
int	 fd;
struct stat lockFileStat;
time_t      theTime;

strcpy(lockFile, mbFileName);
strcat(lockFile, ".rolock");

if (debug)
    fprintf(stderr,"rolock file [%s]\n", lockFile);

	if (stat(lockFile, &lockFileStat) == -1)
	{
		if (errno == ENOENT)
		{
			if ((fd = creat(lockFile, 0)) == -1)
			{
				if (debug)
					fprintf(stderr,
						"RoLockMB: Can't create rolock file [%s]\n",
						lockFile);
				return(1);
			}
			else
			{
				close(fd);
				if (debug)
					fprintf(stderr,"Good lock\n");
				return(0);
			}
		}
		else
		{
			if (debug)
			{
				perror("stat");
				fprintf(stderr, "LockMB: Can't create lock file [%s]\n",
						lockFile);
				fflush(stderr);
			}
			return(1);
		}
	}

	return(1);

}

int UnLockMB(mbFileName)
char    *mbFileName;
{
char    lockFile[MAXPATHLEN+1];

strcpy(lockFile, mbFileName);
strcat(lockFile, ".lock");
setegid(mailgroup);
my_lockf(lockFile,0);
my_lockf(mbFileName,0);
unlink(lockFile);
setegid(mygroup);
return(0);

}


notplain(s)
char *s;
{
char *t;
	if (!s) return(1);
	while (*s && isspace(*s)) ++s;
	for(t=s; *t; ++t) if (isupper(*t)) *t = tolower(*t);
	while (t > s && isspace(*--t)) {;}
	if (((t-s) == 3) && !strncmp(s, "text", 4)) return(0);
	if (strncmp(s, "text/plain", 10)) return(1);
	t = (char *) strchr(s, ';');
	while (t) {
		++t;
		while (*t && isspace(*t)) ++t;
		if (!strncmp(t, "charset", 7)) {
			s = (char *) strchr(t, '=');
			if (s) {
				++s;
				while (*s && isspace(*s)) ++s;
				if (!strncmp(s, "us-ascii", 8)) return(0);
			}
			return(1);
		}
		t = (char *) strchr(t, ';');
	}
	return(0); /* no charset, was text/plain */
}
	
