/*
 *  ZMailer smtpserver child-registry
 *
 *  Registers/keeps track of IP addresses that are currently
 *  talking with us in order to figure out of there are too
 *  many parallel connections from same IP address out there..
 *
 */

#include "smtpserver.h"

static int child_space = 0;
static int child_top   = 0;

static struct {
  int pid;
  Usockaddr addr;
} *childs = NULL;

int childsameip(addr)
Usockaddr *addr;
{
    int i, cnt = 1; /* Ourself */

    if (childs == NULL) return 0;

    for (i = 0; i < child_top; ++i) {
      if (childs[i].pid != 0 &&
	  /* PID non zero */
	  addr->v4.sin_family == childs[i].addr.v4.sin_family)
	    /* Same AddressFamily */
	if ((addr->v4.sin_family == AF_INET &&
	     /* Address is IPv4 one */
	     memcmp(& addr->v4.sin_addr, & childs[i].addr.v4.sin_addr, 4) == 0)
#if defined(AF_INET6) && defined(INET6)
	    ||
	    ((addr->v6.sin6_family == AF_INET6 &&
	      /* ... or Address is IPv6 one */
	      memcmp(& addr->v6.sin6_addr, & childs[i].addr.v6.sin6_addr, 16) == 0))
#endif
	     )
	  ++cnt;
    }
  
    return cnt;
}

void childregister(cpid, addr)
int cpid;
Usockaddr *addr;
{
	int i;

	if (child_top == child_space) {
	  if (child_space == 0) {
	    child_space = 8;
	  } else {
	    child_space <<= 1;
	  }
	  if (childs == NULL) {
	    childs = emalloc(child_space * sizeof(*childs));
	  } else {
	    childs = erealloc(childs, child_space * sizeof(*childs));
	  }
	  for (i = child_top; i < child_space; ++i)
	    memset(&childs[i], 0, sizeof(childs[i]));
	}
	for (i = 0; i < child_space; ++i) {
	  if (childs[i].pid == 0) { /* Free slot! */
	    childs[i].pid = cpid;
	    if (addr->v4.sin_family == AF_INET) {
	      childs[i].addr.v4.sin_family = AF_INET;
	      memcpy(&childs[i].addr.v4.sin_addr, &addr->v4.sin_addr, 4);
	    }
#if defined(AF_INET6) && defined(INET6)
	    else if (addr->v6.sin6_family == AF_INET6) {
	      childs[i].addr.v6.sin6_family = AF_INET6;
	      memcpy(&childs[i].addr.v6.sin6_addr, &addr->v6.sin6_addr, 16);
	    }
#endif
	    if (i >= child_top)
	      child_top = i+1;

	    return;
	  }
	}
}

void childreap(cpid)
int cpid;
{
	int i;

	if (childs == NULL) return;

	for (i = 0; i < child_top; ++i)
	  if (childs[i].pid == cpid) {
	    memset(&childs[i], 0, sizeof(childs[i]));
	    break;
	  }
}
