/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

#ifndef PM_h
#define PM_h

/*
 * pm.h
 */

/* Include stdio.h since it defines NULL */
#include <stdio.h>

struct pm_list
  {
    struct pm_list *next_in_hash;       /* next address in linked-list     */
    struct pm_list *prev_in_hash;       /* last address in linked-list     */
    char *label;                        /* entry label                     */
    struct pm_list *next_elem;          /* next element in data structure  */
    struct pm_list *prev_elem;          /* prev element in data structure  */
    int  category;                      /* category (PM_OBJECT or PM_ELEMENT)    */
    int  type;                          /* element type                    */
    int  list_size;                     /* if a list, max length           */
    int  string_max_len;                /* if a string, max number of char */
    int  savable;                       /* SAVE_NONE, SAVE_CONFIG, SAVE_SETTINGS */
    union
       {
        void      *addr_data;
        int       int_data;
        int       *int_list_data;
        double    double_data;
        double    *double_list_data;
        char      *string_data;
        char      **string_list_data;
        void       (*fnct_ptr)(void);
       }data;
  };


#define PM_OBJECT   100
#define PM_ELEMENT  101

#define MAX_LABEL_LEN 40

#define PM_SETUP_ERROR 1001 
#define PM_QUERY_ERROR 1002

#define INT             1050
#define INT_LIST        1052
#define DBL             1054
#define DBL_LIST        1056
#define STRNG           1058
#define STRNG_LIST      1060
#define ADDRS           1062
#define MEMRY           1064
/*#define FNCT            1130 */
#define FNCT            1066 

#define LIST_SIZE       1070
#define STRNG_LENGTH    1071

#define PUT             1120
#define GET             1121
#define INIT            1122
#define CLEAR           1123
#define PUT_LIST        1124
#define GET_LIST        1125
#define CREATE_OBJ      1126
#define RM_OBJ          1127
#define CREATE_ELEM     1128
#define RM_ELEM         1129
#define EXEC            1130
#define GET_SAVABLE	1131
#define PUT_SAVABLE	1132
#define QUERY           1133

/* values for savable field of a postamaster object or element */
#define SAVE_NONE 0		/* never save */
#define SAVE_CONFIG 1		/* save when config selected */
#define SAVE_SETTINGS 2		/* save when settings selected */

/* Postmaster Error Flags */
#define NULL_ADDRESS_ERROR 2
#define VARB_INITIALIZED_ERROR 1
#define MEMORY_ALLOC_ERROR -1
#define MULTIPLE_GET_ERROR -2
#define INAPT_OP_ERROR -4
#define LIST_NOT_ALLOC_ERROR -5
#define INDEX_BOUNDS_ERROR -6
#define RESET_POINTER_ERROR -7

void *pm(int operation, ...);
void pm_init(void);
int pm_exec_all(char *);
void pm_set_error(int error_code, char *called_by);
int pm_type(char *element, int *n, int *len);
int pm_typekeyword(char *word);
int pm_keyword(char *word);

#endif /* PM_h */




