#
# load.tcl
#

proc load(go) {} {
    global Load

    # check file for reading
    set filename $Load(Directory)/$Load(Filename)
    if { ![isreadable $filename] } { return 0 }

    tcl_to_pm Load
 # Switch on value of Load(Format_Flag): 
 # 0 = unformatted
 # 1 = DsTool 1.x
 # 2 = DsTool 2.0
 # 3 = DsTool Tk
    switch $Load(Format_Flag) {
        0 - 
        1 {
           pm EXEC Load.Go 
           }
	2 {
           pm EXEC Load.Go
           pm PUT Load.Format_Flag 2
           }   
        3 {source $filename}	
        default {
		 puts "filesl: Load(Format_Flag) incorrectly set."
		 message_show "Error: Load(Format_Flag) incorrectly set."
		 return 0}
        }

   # in case this was set to something else, set it back... 
    pm PUT Defaults.Precision 17 
   # in case the points weren't saved, get an accurate count of what's in memory
    pm EXEC Memory.Count

    pm_to_tcl 
    return 1
}


proc load(infile) {} {
    global Control Load


    set directory ""
    set filename $Control(Infile)
    if {![isreadable $filename] } {
	set directory $Load(Directory)
	set filename = $directory$Control(Infile)
	if {![isreadable $filename] } { return 0 }
    }

    set Load(Directory) $directory
    set Load(Filename) $Control(Infile)
    tcl_to_pm Control

    source $filename

    return 1
}

proc isreadable fname {

    # if fname is not a file then then return error
    if {![file isfile $fname]} { return 0 }

    # if file is not readable then return error
    if {![file readable $fname]} { return 0 }

    return 1
}
