#
# utils.tcl
#

proc array_to_list {obj elem} {
    upvar #0 $obj ar
    set i $ar($elem)
    set out {}
    for {set j 0} {$j < $i} {incr j} {
	lappend out "$obj\($elem,$j)"
    }
    return $out
}

#
# returns subset of list - no index checking!
#
# usage: array_to_listvalues Prop Choices
#        array_to_listvalues Prop Choices first last
#
proc array_to_listvalues {obj elem args} {
    upvar #0 $obj ar
    set i $ar($elem)
    set out {}
    if { [llength $args] > 1} {
	set j [lindex $args 0]
	set i [lindex $args 1]
	incr i
    } {
	set j 0
	set i $ar($elem)
    }
    while {$j < $i} {
	lappend out $ar($elem,$j) 
	incr j
    }
    return $out
}

proc drop_last_element {ll} {
    set len [expr [llength $ll] - 2]
    if {$len < 0} {
	return {}
    } else {
	return [lrange $ll 0 $len]
    }
}
