/*
  try - try out the DoubleTalk device driver

  */

#include <stdlib.h>
#include <ctype.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <sys/time.h>
#include "dtlk.h"

#define GREET "hello, world"
#define FIRSTLINE "now is the time for all good men\0012I\r"
#define SECONDLINE "to come to the aid of their country\0015I\r"

void print_string(void *v, int n)
{
  char *s = (char *)v;
  printf("\"");
  while (n-- > 0)
    {
      if (isprint(*s))
	printf("%c", *s);
      else
	printf("\\%03o", *s);
      s++;
    }
  printf("\"");
}

int main()
{
  int fd, retval;
  struct dtlk_settings stat;
  char buf[32];
  struct timeval before, after;
  double interval;
  struct timeval tv={0,0};
  fd_set rfds, wfds, xfds;

  setbuf(stdout, NULL);

  printf("\n              DoubleTalk PC Linux device driver demo\n");

  fd = open("/dev/dtlk", O_RDWR);
  if (fd == -1)
    {
      perror("try");
      exit(1);
    }

  printf("\nStart speech, interrupt after 1 sec by interrogating...\n");
  printf("write(fd, ");
  print_string(GREET, strlen(GREET) + 1);
  printf(", %d)", strlen(GREET) + 1);
  gettimeofday(&before, NULL);
  retval = write(fd, GREET, strlen(GREET) + 1);
  gettimeofday(&after, NULL);
  interval = after.tv_sec - before.tv_sec + 
    (after.tv_usec - before.tv_usec)*.000001;
  printf(" returns %d after %7.6f sec\n", retval, interval);
  sleep(1);

  printf("ioctl(fd, DTLK_INTERROGATE)");
  gettimeofday(&before, NULL);
  retval = ioctl(fd, DTLK_INTERROGATE, (long)&stat);
  gettimeofday(&after, NULL);
  interval = after.tv_sec - before.tv_sec + 
    (after.tv_usec - before.tv_usec)*.000001;
  printf(" returns %d after %7.6f sec\n", retval, interval);
  if (retval < 0) perror("try");
  
  printf("results: ");
  print_string(&stat, sizeof(stat));
  printf("\n");

  printf("interpretation: ");
#define SHOW(v) printf("%s=%d, ",#v, (int)stat.##v)
  SHOW(serial_number);
  printf("rom_version=%s, ", stat.rom_version);
  SHOW(mode);
  SHOW(punc_level);
  SHOW(formant_freq);
  SHOW(pitch);
  SHOW(speed);
  SHOW(volume);
  SHOW(tone);
  SHOW(expression);
  SHOW(ext_dict_loaded);
  SHOW(ext_dict_status);
  SHOW(free_ram);
  SHOW(articulation);
  SHOW(reverb);
  printf("eob=%d\n", stat.eob);

  printf("\nWait up to 1 sec for DoubleTalk to become readable"
	 " (should time out)...\n");
  FD_ZERO(&rfds);
  FD_ZERO(&wfds);
  FD_ZERO(&xfds);
  FD_SET(fd, &rfds);
  tv.tv_usec = 0;
  tv.tv_sec = 1;
  printf("select(%d)", tv.tv_sec);
  gettimeofday(&before, NULL);
  retval = select(fd+1, &rfds, &wfds, &xfds, &tv);
  gettimeofday(&after, NULL);
  interval = after.tv_sec - before.tv_sec + 
    (after.tv_usec - before.tv_usec)*.000001;
  printf(" returns %d after %7.6f sec\n", retval, interval);

  printf("\nStart speech, set index `2', wait 3 sec or until readable,"
	 " then read index...\n");
  printf("write(fd, ");
  print_string(FIRSTLINE, strlen(FIRSTLINE));
  printf(", %d)", strlen(FIRSTLINE));
  retval = write(fd, FIRSTLINE, strlen(FIRSTLINE));
  printf(" returns %d\n", retval);

  FD_ZERO(&rfds);
  FD_ZERO(&wfds);
  FD_ZERO(&xfds);
  FD_SET(fd, &rfds);
  tv.tv_usec = 0;
  tv.tv_sec = 3;
  printf("select(%d)", tv.tv_sec);
  gettimeofday(&before, NULL);
  retval = select(fd+1, &rfds, &wfds, &xfds, &tv);
  gettimeofday(&after, NULL);
  interval = after.tv_sec - before.tv_sec + 
    (after.tv_usec - before.tv_usec)*.000001;
  printf(" returns %d after %7.6f sec\n", retval, interval);

  printf("read(fd, buf, 1)");
  gettimeofday(&before, NULL);
  retval = read (fd, buf, 1);
  gettimeofday(&after, NULL);
  interval = after.tv_sec - before.tv_sec + 
    (after.tv_usec - before.tv_usec)*.000001;
  printf(" returns %d after %7.6f sec\n", retval, interval);
  printf("data read: "); print_string(buf, retval); printf("\n");

  printf("\nStart speech, set index `5', "
	 "then immediately read index...\n");
  printf("write(fd, ");
  print_string(SECONDLINE, strlen(SECONDLINE) + 1);
  printf(", %d)", strlen(SECONDLINE) + 1);
  retval = write(fd, SECONDLINE, strlen(SECONDLINE) + 1);
  printf(" returns %d\n", retval);

  printf("read(fd, buf, 1)");
  gettimeofday(&before, NULL);
  retval = read (fd, buf, 1);
  gettimeofday(&after, NULL);
  interval = after.tv_sec - before.tv_sec + 
    (after.tv_usec - before.tv_usec)*.000001;
  printf(" returns %d after %7.6f sec\n", retval, interval);
  printf("data read: "); print_string(buf, retval); printf("\n");

  return 0;
}
