/* 
 *  gstalker stock charter
 * 
 *  Copyright (c) 1998 Stefan S. Stratigakos
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */

/* the pass values for global_int here are 1 = end, 2 = back, 3 = next, 4 = start */


#include "myheader.h"
#include "myerrors.h"
#include <string.h>
#include <unistd.h>
#include <ctype.h>



/***********************************************************************************/
void data_selected()
{
	GList *list = NULL;
	char *text;
	int tint;
	extern int edit_chart_save_flag;
    	extern GtkWidget *edit_chart_open_value_entry, *edit_chart_high_value_entry;
    	extern GtkWidget *edit_chart_low_value_entry, *edit_chart_close_value_entry;
    	extern GtkWidget *edit_chart_volume_value_entry, *edit_chart_openi_value_entry;
    	extern GtkWidget *edit_chart_date, *edit_chart_record;
    	extern GtkWidget *edit_chart_clist;
    	
	
	if (edit_chart_save_flag)
	{
		save_changes();
		return;
	}	
      	list = GTK_CLIST (edit_chart_clist)->selection;
	tint = (int) list->data;
	gtk_clist_get_text (GTK_CLIST (edit_chart_clist), tint, 0, &text);
      	gtk_entry_set_text (GTK_ENTRY(edit_chart_record), text);
      	gtk_clist_get_text (GTK_CLIST (edit_chart_clist), tint, 1, &text);
      	gtk_entry_set_text (GTK_ENTRY(edit_chart_date), text);
	gtk_clist_get_text (GTK_CLIST (edit_chart_clist), tint, 2, &text);
	gtk_entry_set_text (GTK_ENTRY(edit_chart_open_value_entry), text);
	gtk_clist_get_text (GTK_CLIST (edit_chart_clist), tint, 3, &text);
	gtk_entry_set_text (GTK_ENTRY(edit_chart_high_value_entry), text);
	gtk_clist_get_text (GTK_CLIST (edit_chart_clist), tint, 4, &text);
	gtk_entry_set_text (GTK_ENTRY(edit_chart_low_value_entry), text);
	gtk_clist_get_text (GTK_CLIST (edit_chart_clist), tint, 5, &text);
	gtk_entry_set_text (GTK_ENTRY(edit_chart_close_value_entry), text);
	gtk_clist_get_text (GTK_CLIST (edit_chart_clist), tint, 6, &text);
	gtk_entry_set_text (GTK_ENTRY(edit_chart_volume_value_entry), text);
	gtk_clist_get_text (GTK_CLIST (edit_chart_clist), tint, 7, &text);
	gtk_entry_set_text (GTK_ENTRY(edit_chart_openi_value_entry), text);
	edit_chart_save_flag = 0;
}
/*************************************************************************************/
void edit_chart_no_save()
{
	extern int edit_chart_save_flag;
	extern GtkWidget *yesno_window;
	
	if (yesno_window)
		gtk_widget_destroy(yesno_window);
	edit_chart_save_flag = 0;
	data_selected();
}
/**************************************************************************************/
void save_changes()
{
	extern GtkWidget *yesno_window, *yesno_yes_button, *yesno_no_button;
    	
    	if (yesno_window)
    		return;
	show_yesno_window("Changes have not been saved. Save changes?");
      	gtk_signal_connect (GTK_OBJECT (yesno_yes_button), "clicked",
			    GTK_SIGNAL_FUNC (edit_data_save), NULL);
      	gtk_signal_connect (GTK_OBJECT (yesno_no_button), "clicked",
			    GTK_SIGNAL_FUNC (edit_chart_no_save), NULL);
}
/**************************************************************************************/
void edit_chart_changed()
{
	extern int edit_chart_save_flag;
	
	edit_chart_save_flag = 1;
}
/**************************************************************************************/
void yes_delete_record()
{
	GList *list;
	char tstring[250], *text;
	unsigned int tuint;
	int tint, edit_record;
	FILE *infile, *outfile;
	extern int edit_chart_save_flag, data_size, header_size;
    	extern char *datapath, *edit_chart_path, *error_message;
    	extern GtkWidget *yesno_window, *edit_chart_clist;
    	extern struct record2 header;
    	struct record2 header2;
    	struct record1 data;
    	
    	
    	infile = fopen(edit_chart_path, "rb");
    	if (! infile)
	  RETURN_ERR(gs_cant_open_chart);

	fread(&header2, header_size, 1, infile);
    	if (header2.records == 1)
    	{
	  fclose(infile);
	  RETURN_ERR(gs_cant_delete_last_record);
	}
	
    	strcpy(tstring, datapath);
    	strcat(tstring, "temp.dat");
   	outfile = fopen(tstring, "wb");
   	if (! outfile)
	  RETURN_ERR(gs_cant_create_tempfile);

	list = GTK_CLIST (edit_chart_clist)->selection;
	tint = (int) list->data;
	gtk_clist_get_text (GTK_CLIST (edit_chart_clist), tint, 0, &text);
	edit_record = atoi(text);
	gtk_clist_remove(GTK_CLIST(edit_chart_clist), edit_record - 1);
		
	fwrite(&header2, header_size, 1, outfile);
	for (tuint = 1; tuint < edit_record; tuint++)
	{
		fread(&data, data_size, 1, infile);
		fwrite(&data, data_size, 1, outfile);
	}
	fread(&data, data_size, 1, infile);
	for (tuint = edit_record + 1; tuint <= header2.records; tuint++)
	{
		fread(&data, data_size, 1, infile);
		fwrite(&data, data_size, 1, outfile);
	}
	fclose(infile);
    	fclose(outfile);
    	if (edit_record != 1)
    		edit_record--;
    	unlink(edit_chart_path);
    	strcpy(tstring, datapath);
    	strcat(tstring, "temp.dat");
    	rename(tstring, edit_chart_path);
    	
    	infile = fopen(edit_chart_path, "r+b");
    	fread(&header2, header_size, 1, infile);
    	fread(&data, data_size, 1, infile);
    	header2.records--;
    	if (header2.first_date != data.date)
    		header2.first_date = data.date;
    	fseek(infile, (long)((header2.records - 2) * data_size) + header_size, SEEK_SET);
    	fread(&data, data_size, 1, infile);
    	fread(&data, data_size, 1, infile);
    	if (header2.last_date != data.date)
    		header2.last_date = data.date;
    	rewind(infile);
    	fwrite(&header2, header_size, 1, infile);
    	fclose(infile);
    	
	if (yesno_window)
		gtk_widget_destroy(yesno_window);

	if (! strcmp(header.symbol, header2.symbol))
		load_file(header.symbol);
	edit_chart_save_flag = 0;
	for (tint = edit_record - 1; tint < header2.records; tint++)
	{
		sprintf(tstring, "%d", tint + 1);
		gtk_clist_set_text(GTK_CLIST(edit_chart_clist), tint, 0, tstring);
	}
	gtk_clist_select_row(GTK_CLIST(edit_chart_clist), edit_record - 1, 0);
	data_selected();
}
/********************************************************************************************/
void edit_data_delete()
{
    	extern GtkWidget *yesno_window, *yesno_yes_button, *yesno_no_button;
    	
	if (yesno_window)
		return;
	show_yesno_window("Are you sure you want to delete this record ?");
      	gtk_signal_connect (GTK_OBJECT (yesno_yes_button), "clicked",
			    GTK_SIGNAL_FUNC (yes_delete_record), NULL);
      	gtk_signal_connect_object (GTK_OBJECT (yesno_no_button), "clicked",
			    GTK_SIGNAL_FUNC (gtk_widget_destroy),
			    GTK_OBJECT(yesno_window));
}
/*************************************************************************************/
void edit_data_save()
{
	char tstring[250], *tstringpointer;
	FILE *outfile;
	unsigned long volume, openi;
	float open, high, low, close;
    	int edit_record;
    	extern int edit_chart_save_flag, data_size, header_size;
   	extern GtkWidget *edit_chart_name_value_entry, *yesno_window, *edit_chart_clist;
    	extern GtkWidget *edit_chart_open_value_entry, *edit_chart_high_value_entry;
    	extern GtkWidget *edit_chart_low_value_entry, *edit_chart_close_value_entry;
    	extern GtkWidget *edit_chart_volume_value_entry, *edit_chart_openi_value_entry;
    	extern GtkWidget *edit_chart_record;
    	extern char *edit_chart_path, *error_message;
    	extern struct record2 header;
    	struct record2 header2;
    	struct record1 data;    	
    	
    	
    	
	outfile = fopen(edit_chart_path, "r+b");
	if (! outfile)
	  RETURN_ERR(gs_cant_open_chart);
	
	tstringpointer = gtk_entry_get_text (GTK_ENTRY(edit_chart_record));
	edit_record = atoi(tstringpointer);
	edit_record--;
	fread(&header2, header_size, 1, outfile);
	fseek(outfile, (long)(edit_record  * data_size) + header_size, SEEK_SET);
	fread(&data, data_size, 1, outfile);
	tstringpointer = gtk_entry_get_text (GTK_ENTRY(edit_chart_name_value_entry));
	strcpy(header2.name, tstringpointer);
	tstringpointer = gtk_entry_get_text (GTK_ENTRY(edit_chart_open_value_entry));
	gtk_clist_set_text(GTK_CLIST(edit_chart_clist), edit_record, 2, tstringpointer);
	strcpy(tstring, tstringpointer);
	open = atof(tstring);
	tstringpointer = gtk_entry_get_text (GTK_ENTRY(edit_chart_high_value_entry));
	gtk_clist_set_text(GTK_CLIST(edit_chart_clist), edit_record, 3, tstringpointer);
	strcpy(tstring, tstringpointer);
	high = atof(tstring);
	tstringpointer = gtk_entry_get_text (GTK_ENTRY(edit_chart_low_value_entry));
	gtk_clist_set_text(GTK_CLIST(edit_chart_clist), edit_record, 4, tstringpointer);
	strcpy(tstring, tstringpointer);
	low = atof(tstring);
	tstringpointer = gtk_entry_get_text (GTK_ENTRY(edit_chart_close_value_entry));
	gtk_clist_set_text(GTK_CLIST(edit_chart_clist), edit_record, 5, tstringpointer);
	strcpy(tstring, tstringpointer);
	close = atof(tstring);
	tstringpointer = gtk_entry_get_text (GTK_ENTRY(edit_chart_volume_value_entry));
	gtk_clist_set_text(GTK_CLIST(edit_chart_clist), edit_record, 6, tstringpointer);
	strcpy(tstring, tstringpointer);
	volume = atol(tstring);
	tstringpointer = gtk_entry_get_text (GTK_ENTRY(edit_chart_openi_value_entry));
	gtk_clist_set_text(GTK_CLIST(edit_chart_clist), edit_record, 7, tstringpointer);
	strcpy(tstring, tstringpointer);
	openi = atol(tstring);
	data.open = open;
	data.high = high;
	data.low = low;
	data.close = close;
	data.volume = volume;
	data.openint = openi;
	fseek(outfile, (long)(edit_record  * data_size) + header_size, SEEK_SET);
	fwrite(&data, data_size, 1, outfile);
	rewind(outfile);
	fwrite(&header2, header_size, 1, outfile);
	fclose(outfile);
	
	if (! strcmp(header.symbol, header2.symbol))
		load_file(header.symbol);
	if (edit_chart_save_flag)
	{
		edit_chart_save_flag = 0;
		if (yesno_window)
			gtk_widget_destroy(yesno_window);
	}
	edit_chart_save_flag = 0;
	data_selected();
}
/**************************************************************************************/
void edit_chart_data()
{
	char *text[] = {"Record", "Date", "Open", "High", "Low", "Close", "Volume", "Openint"};
	char *tstringpointer, *line[8], tstring[250], tstring2[15], tstring3[15], tstring4[15];
	char tstring5[15], tstring6[15], tstring7[15], tstring8[15];
	FILE *infile;
    	int tint;
    	GtkWidget *frame, *frame2;
    	GtkWidget *vbox, *vbox2, *vbox3, *vbox4, *vbox5;
    	GtkWidget *hbox, *hbox2, *hbox3, *hbox4, *hbox5, *hbox6, *hbox7, *hbox8, *hbox9, *hbox10;
    	GtkWidget *hbox11, *hbox12;
    	GtkWidget *label, *label3, *label4, *label5, *label6, *label7, *label8, *label9;
    	GtkWidget *label10, *label2, *close_button, *save_button, *delete_button, *help_button;
    	GList *list = NULL;
    	extern GtkWidget *workwith_charts_clist, *edit_chart_window, *workwith_charts_window;
    	extern GtkWidget *edit_chart_name_value_entry, *edit_chart_symbol;
    	extern GtkWidget *edit_chart_open_value_entry, *edit_chart_high_value_entry;
    	extern GtkWidget *edit_chart_low_value_entry, *edit_chart_close_value_entry;
    	extern GtkWidget *edit_chart_volume_value_entry, *edit_chart_openi_value_entry;
    	extern GtkWidget *edit_chart_date, *edit_chart_record;
    	extern GtkWidget *edit_chart_clist;
    	extern int edit_chart_save_flag, header_size, data_size;
    	extern char *edit_chart_path, *datapath, *error_message;
    	struct record2 header;
    	struct record1 data;
    	
    	
    	
    	if (edit_chart_window)
    		return;
    	list = GTK_CLIST (workwith_charts_clist)->selection;
    	if (! list)
	  RETURN_ERR(gs_nothing_selected);

	tint = (int) list->data;
      	gtk_clist_get_text(GTK_CLIST(workwith_charts_clist), tint, 0, &tstringpointer);
      	strcpy(tstring, datapath);
 	strcat(tstring, tstringpointer);
 	if (edit_chart_path)
 		free(edit_chart_path);
 	edit_chart_path = (char *)malloc(sizeof(tstring) + 1);
 	strcpy(edit_chart_path, tstring);
 	
 	if (workwith_charts_window)
 		gtk_widget_destroy(workwith_charts_window);
	 		
	
	edit_chart_save_flag = 0;
	edit_chart_window = gtk_window_new (GTK_WINDOW_DIALOG);
      	gtk_signal_connect (GTK_OBJECT (edit_chart_window), "destroy",
			    GTK_SIGNAL_FUNC(gtk_widget_destroyed), &edit_chart_window);
      	gtk_window_set_title (GTK_WINDOW (edit_chart_window), "Edit Chart Data");
      	gtk_window_position(GTK_WINDOW (edit_chart_window), GTK_WIN_POS_CENTER);
      	gtk_container_border_width (GTK_CONTAINER (edit_chart_window), 0);
      	gtk_widget_set_usize(GTK_WIDGET (edit_chart_window), 0, 0);
        
      	vbox = gtk_vbox_new (FALSE, 10);
      	gtk_container_add (GTK_CONTAINER (edit_chart_window), vbox);
      	gtk_container_border_width (GTK_CONTAINER (vbox), 10);
      	gtk_widget_show (vbox);
      	
      	edit_chart_clist = gtk_clist_new_with_titles (8, text);
      	gtk_clist_set_column_width(GTK_CLIST(edit_chart_clist), 0, 40);
      	gtk_clist_set_column_width(GTK_CLIST(edit_chart_clist), 1, 70);
      	gtk_clist_set_column_width(GTK_CLIST(edit_chart_clist), 2, 70);
      	gtk_clist_set_column_width(GTK_CLIST(edit_chart_clist), 3, 70);
      	gtk_clist_set_column_width(GTK_CLIST(edit_chart_clist), 4, 70);
      	gtk_clist_set_column_width(GTK_CLIST(edit_chart_clist), 5, 70);
      	gtk_clist_set_column_width(GTK_CLIST(edit_chart_clist), 6, 70);
      	gtk_clist_set_column_width(GTK_CLIST(edit_chart_clist), 7, 70);
      	gtk_clist_set_selection_mode (GTK_CLIST (edit_chart_clist), GTK_SELECTION_SINGLE);
       	gtk_clist_set_policy(GTK_CLIST(edit_chart_clist),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
       	gtk_box_pack_start(GTK_BOX (vbox), edit_chart_clist, FALSE, TRUE, 0);
      	gtk_container_border_width (GTK_CONTAINER (edit_chart_clist), 0);
      	gtk_widget_set_usize(GTK_WIDGET (edit_chart_clist), 0, 150);
      	gtk_signal_connect(GTK_OBJECT(edit_chart_clist), "select_row",
      			   GTK_SIGNAL_FUNC(data_selected), NULL);
      	gtk_widget_show (edit_chart_clist);
        
      	frame = gtk_frame_new (NULL);
      	gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
      	gtk_widget_show (frame);
      	
      	vbox2 = gtk_vbox_new (FALSE, 5);
      	gtk_container_add (GTK_CONTAINER (frame), vbox2);
      	gtk_container_border_width (GTK_CONTAINER (vbox2), 5);
      	gtk_widget_show (vbox2);
        
      	hbox2 = gtk_hbox_new (FALSE, 10);
      	gtk_container_border_width (GTK_CONTAINER (hbox2), 0);
      	gtk_box_pack_start (GTK_BOX (vbox2), hbox2, FALSE, TRUE, 0);
      	gtk_widget_show (hbox2);
      	
      	label = gtk_label_new ("Name:");
      	gtk_box_pack_start (GTK_BOX (hbox2), label, FALSE, TRUE, 0);
      	gtk_widget_show (label);
      	
      	edit_chart_name_value_entry = gtk_entry_new ();
      	gtk_box_pack_start (GTK_BOX (hbox2), edit_chart_name_value_entry, TRUE, TRUE, 0);
     	gtk_widget_show (edit_chart_name_value_entry);
      	
      	hbox3 = gtk_hbox_new (FALSE, 10);
      	gtk_container_border_width (GTK_CONTAINER (hbox3), 0);
      	gtk_box_pack_start (GTK_BOX (vbox2), hbox3, FALSE, TRUE, 0);
      	gtk_widget_show (hbox3);
      	
      	label2 = gtk_label_new ("Symbol:");
      	gtk_box_pack_start (GTK_BOX (hbox3), label2, FALSE, TRUE, 0);
      	gtk_widget_show (label2);
      	
      	edit_chart_symbol = gtk_entry_new ();
      	gtk_box_pack_start (GTK_BOX (hbox3), edit_chart_symbol, TRUE, TRUE, 0);
      	gtk_entry_set_editable(GTK_ENTRY(edit_chart_symbol), FALSE);
      	gtk_widget_show (edit_chart_symbol);
      	
      	hbox = gtk_hbox_new (FALSE, 10);
      	gtk_container_border_width (GTK_CONTAINER (hbox), 0);
      	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
      	gtk_widget_show (hbox);
      	
      	frame2 = gtk_frame_new (NULL);
      	gtk_box_pack_start (GTK_BOX (hbox), frame2, TRUE, TRUE, 0);
      	gtk_widget_show (frame2);

	hbox5 = gtk_hbox_new (FALSE, 5);
      	gtk_container_add (GTK_CONTAINER (frame2), hbox5);
      	gtk_container_border_width (GTK_CONTAINER (hbox5), 10);
      	gtk_widget_show (hbox5);
	
      	vbox3 = gtk_vbutton_box_new();
      	gtk_container_border_width (GTK_CONTAINER (vbox3), 0);
      	gtk_box_pack_start (GTK_BOX (hbox), vbox3, FALSE, TRUE, 0);
      	gtk_vbutton_box_set_spacing_default(5);
      	gtk_vbutton_box_set_layout_default(GTK_BUTTONBOX_START);
      	gtk_widget_show (vbox3);
      	
      	save_button = gtk_button_new_with_label ("Save");
      	gtk_signal_connect (GTK_OBJECT (save_button), "clicked",
			    	    GTK_SIGNAL_FUNC (edit_data_save), NULL);
      	gtk_box_pack_start (GTK_BOX (vbox3), save_button, FALSE, TRUE, 0);
      	gtk_widget_show (save_button);
      	
      	delete_button = gtk_button_new_with_label ("Delete");
      	gtk_signal_connect (GTK_OBJECT (delete_button), "clicked",
			    	    GTK_SIGNAL_FUNC (edit_data_delete), NULL);
      	gtk_box_pack_start (GTK_BOX (vbox3), delete_button, FALSE, TRUE, 0);
      	gtk_widget_show (delete_button);
      	
      	close_button = gtk_button_new_with_label ("Cancel");
      	gtk_signal_connect_object (GTK_OBJECT (close_button), "clicked",
			    	    GTK_SIGNAL_FUNC (gtk_widget_destroy),
			    	    GTK_OBJECT(edit_chart_window));
      	gtk_box_pack_start (GTK_BOX (vbox3), close_button, FALSE, TRUE, 0);
      	gtk_widget_show (close_button);
      	
      	help_button = gtk_button_new_with_label ("Help");
      	gtk_signal_connect (GTK_OBJECT (help_button), "clicked",
			    	    GTK_SIGNAL_FUNC (help_edit_chart_window), NULL);
      	gtk_box_pack_start (GTK_BOX (vbox3), help_button, FALSE, TRUE, 0);
      	gtk_widget_show (help_button);
      	
      	vbox4 = gtk_vbox_new (FALSE, 5);
      	gtk_box_pack_start (GTK_BOX (hbox5), vbox4, TRUE, TRUE, 0);
      	gtk_widget_show (vbox4);
      	
      	vbox5 = gtk_vbox_new (FALSE, 5);
      	gtk_box_pack_start (GTK_BOX (hbox5), vbox5, TRUE, TRUE, 0);
      	gtk_widget_show (vbox5);
        
      	hbox4 = gtk_hbox_new (FALSE, 10);
      	gtk_box_pack_start (GTK_BOX (vbox4), hbox4, FALSE, TRUE, 0);
      	gtk_widget_show (hbox4);
      	
      	edit_chart_record = gtk_entry_new ();
      	gtk_box_pack_end (GTK_BOX (hbox4), edit_chart_record, FALSE, TRUE, 0);
      	gtk_entry_set_editable(GTK_ENTRY(edit_chart_record), FALSE);
      	gtk_widget_show (edit_chart_record);
      	
      	label3 = gtk_label_new ("Record:");
      	gtk_box_pack_end(GTK_BOX (hbox4), label3, FALSE, TRUE, 0);
      	gtk_widget_show (label3);
      	
      	hbox6 = gtk_hbox_new (FALSE, 10);
      	gtk_box_pack_start (GTK_BOX (vbox5), hbox6, FALSE, TRUE, 0);
      	gtk_widget_show (hbox6);
      	
      	edit_chart_date = gtk_entry_new ();
      	gtk_box_pack_end (GTK_BOX (hbox6), edit_chart_date, FALSE, TRUE, 0);
      	gtk_entry_set_editable(GTK_ENTRY(edit_chart_date), FALSE);
      	gtk_widget_show (edit_chart_date);
      	
      	label4 = gtk_label_new ("Date:");
      	gtk_box_pack_end(GTK_BOX (hbox6), label4, FALSE, TRUE, 0);
      	gtk_widget_show (label4);
      	
      	hbox7 = gtk_hbox_new (FALSE, 10);
      	gtk_box_pack_start (GTK_BOX (vbox4), hbox7, FALSE, TRUE, 0);
      	gtk_widget_show (hbox7);
      	
      	edit_chart_open_value_entry = gtk_entry_new ();
      	gtk_box_pack_end(GTK_BOX (hbox7), edit_chart_open_value_entry, FALSE, TRUE, 0);
     	gtk_widget_show (edit_chart_open_value_entry);
     	
     	label5 = gtk_label_new ("Open:");
      	gtk_box_pack_end(GTK_BOX (hbox7), label5, FALSE, TRUE, 0);
      	gtk_widget_show (label5);
     	
     	hbox8 = gtk_hbox_new (FALSE, 10);
      	gtk_box_pack_start (GTK_BOX (vbox5), hbox8, FALSE, TRUE, 0);
      	gtk_widget_show (hbox8);
      	
	edit_chart_high_value_entry = gtk_entry_new ();
      	gtk_box_pack_end(GTK_BOX (hbox8), edit_chart_high_value_entry, FALSE, TRUE, 0);
      	gtk_widget_show (edit_chart_high_value_entry);
      	
      	label6 = gtk_label_new ("High:");
      	gtk_box_pack_end(GTK_BOX (hbox8), label6, FALSE, TRUE, 0);
      	gtk_widget_show (label6);
      	
      	hbox9 = gtk_hbox_new (FALSE, 10);
      	gtk_box_pack_start (GTK_BOX (vbox4), hbox9, FALSE, TRUE, 0);
      	gtk_widget_show (hbox9);
      	
      	edit_chart_low_value_entry = gtk_entry_new ();
      	gtk_box_pack_end(GTK_BOX (hbox9), edit_chart_low_value_entry, FALSE, TRUE, 0);
      	gtk_widget_show (edit_chart_low_value_entry);
      	
      	label7 = gtk_label_new ("Low:");
      	gtk_box_pack_end(GTK_BOX (hbox9), label7, FALSE, TRUE, 0);
      	gtk_widget_show (label7);
      	
      	hbox10 = gtk_hbox_new (FALSE, 10);
      	gtk_box_pack_start (GTK_BOX (vbox5), hbox10, FALSE, TRUE, 0);
      	gtk_widget_show (hbox10);
      	
      	edit_chart_close_value_entry = gtk_entry_new ();
      	gtk_box_pack_end(GTK_BOX (hbox10), edit_chart_close_value_entry, FALSE, TRUE, 0);
      	gtk_widget_show (edit_chart_close_value_entry);
      	
      	label8 = gtk_label_new ("Close:");
      	gtk_box_pack_end(GTK_BOX (hbox10), label8, FALSE, TRUE, 0);
      	gtk_widget_show (label8);
      	
      	hbox11 = gtk_hbox_new (FALSE, 10);
      	gtk_box_pack_start (GTK_BOX (vbox4), hbox11, FALSE, TRUE, 0);
      	gtk_widget_show (hbox11);
      	
      	edit_chart_volume_value_entry = gtk_entry_new ();
      	gtk_box_pack_end(GTK_BOX (hbox11), edit_chart_volume_value_entry, FALSE, TRUE, 0);
      	gtk_widget_show (edit_chart_volume_value_entry);
      	
      	label9 = gtk_label_new ("Volume:");
      	gtk_box_pack_end(GTK_BOX (hbox11), label9, FALSE, TRUE, 0);
      	gtk_widget_show (label9);
      	
      	hbox12 = gtk_hbox_new (FALSE, 10);
      	gtk_box_pack_start (GTK_BOX (vbox5), hbox12, FALSE, TRUE, 0);
      	gtk_widget_show (hbox12);
	
      	edit_chart_openi_value_entry = gtk_entry_new ();
      	gtk_box_pack_end(GTK_BOX (hbox12), edit_chart_openi_value_entry, FALSE, TRUE, 0);
      	gtk_widget_show (edit_chart_openi_value_entry);
      	
      	label10 = gtk_label_new ("Open Int:");
      	gtk_box_pack_end(GTK_BOX (hbox12), label10, FALSE, TRUE, 0);
      	gtk_widget_show (label10);
      	
	
	gtk_clist_freeze (GTK_CLIST (edit_chart_clist));
	infile = fopen(edit_chart_path, "rb");
	fread(&header, header_size, 1, infile);
	for (tint = 0; tint < header.records; tint++)
	{
		fread(&data, data_size, 1, infile);
		sprintf(tstring, "%d", tint + 1);
		line[0] = tstring;
		sprintf(tstring3, "%ld", data.date);
		tstring2[0] = tstring3[4];
		tstring2[1] = tstring3[5];
		tstring2[2] = '/';
		tstring2[3] = tstring3[6];
		tstring2[4] = tstring3[7];
		tstring2[5] = '/';
		tstring2[6] = tstring3[0];
		tstring2[7] = tstring3[1];
		tstring2[8] = tstring3[2];
		tstring2[9] = tstring3[3];
		tstring2[10] = 0;
		line[1] = tstring2;
		sprintf(tstring3, "%g", data.open);
		line[2] = tstring3;
		sprintf(tstring4, "%g", data.high);
		line[3] = tstring4;
		sprintf(tstring5, "%g", data.low);
		line[4] = tstring5;
		sprintf(tstring6, "%g", data.close);
		line[5] = tstring6;
		sprintf(tstring7, "%ld", data.volume);
		line[6] = tstring7;
		sprintf(tstring8, "%ld", data.openint);
		line[7] = tstring8;
		gtk_clist_append (GTK_CLIST (edit_chart_clist), line);
	}
	fclose(infile);
	gtk_clist_thaw (GTK_CLIST (edit_chart_clist));
	gtk_entry_set_text (GTK_ENTRY(edit_chart_name_value_entry), header.name);
      	gtk_entry_set_text (GTK_ENTRY(edit_chart_symbol), header.symbol);
      	gtk_clist_select_row(GTK_CLIST(edit_chart_clist), 0, 0);
      	
      	gtk_signal_connect (GTK_OBJECT (edit_chart_name_value_entry), "changed",
			    GTK_SIGNAL_FUNC(edit_chart_changed), NULL);
	gtk_signal_connect (GTK_OBJECT (edit_chart_open_value_entry), "changed",
			    GTK_SIGNAL_FUNC(edit_chart_changed), NULL);
	gtk_signal_connect (GTK_OBJECT (edit_chart_high_value_entry), "changed",
			    GTK_SIGNAL_FUNC(edit_chart_changed), NULL);
	gtk_signal_connect (GTK_OBJECT (edit_chart_low_value_entry), "changed",
			    GTK_SIGNAL_FUNC(edit_chart_changed), NULL);
	gtk_signal_connect (GTK_OBJECT (edit_chart_close_value_entry), "changed",
			    GTK_SIGNAL_FUNC(edit_chart_changed), NULL);
	gtk_signal_connect (GTK_OBJECT (edit_chart_volume_value_entry), "changed",
			    GTK_SIGNAL_FUNC(edit_chart_changed), NULL);
	gtk_signal_connect (GTK_OBJECT (edit_chart_openi_value_entry), "changed",
			    GTK_SIGNAL_FUNC(edit_chart_changed), NULL);	

    	gtk_widget_show(edit_chart_window);
}