/*
Copyright (c) 1998 Peter Zelezny.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "xchat.h"
#include <fcntl.h>

extern struct xchatprefs prefs;
extern GdkColor colors[];
extern GdkFont *font_normal;
extern GdkFont *font_bold;
extern GdkFont *dialog_font_normal;
extern GdkFont *dialog_font_bold;
extern GSList *sess_list;

extern void maingui_create_textlist(struct session *sess, GtkWidget *leftpane);
extern void size_request_textgad(GtkWidget *win, GtkRequisition *req);
extern char *get_xdir(void);

void settings_setstyle(struct session *sess)
{
   gtk_widget_destroy(sess->textgad);
   gtk_widget_destroy(sess->vscrollbar);
   maingui_create_textlist(sess, sess->leftpane);
}

gint settings_closegui(GtkWidget *wid, struct session *sess)
{
   if(sess->setup)
   {
      gtk_widget_destroy(sess->setup->settings_window);
      free(sess->setup);
      sess->setup = 0;
   }
   return FALSE;
}

void settings_ok_clicked(GtkWidget *wid, struct session *sess)
{
   int do_colors = FALSE;

   strcpy(sess->setup->prefs.awayreason, gtk_entry_get_text((GtkEntry*)sess->setup->entry_away));
   strcpy(sess->setup->prefs.quitreason, gtk_entry_get_text((GtkEntry*)sess->setup->entry_quit));
   sess->setup->prefs.bufsize = atol(gtk_entry_get_text((GtkEntry*)sess->setup->entry_bufsize));
   
   if(prefs.bg_color != sess->setup->prefs.bg_color ||
      prefs.fg_color != sess->setup->prefs.fg_color)
	do_colors = TRUE;

   if(strcmp(prefs.font_normal, sess->setup->prefs.font_normal) != 0)
	font_normal = gdk_font_load(sess->setup->prefs.font_normal);

   if(strcmp(prefs.font_bold,   sess->setup->prefs.font_bold) != 0)
	font_bold = gdk_font_load(sess->setup->prefs.font_bold);
   
   if(strcmp(prefs.dialog_font_normal, sess->setup->prefs.dialog_font_normal) != 0)
	dialog_font_normal = gdk_font_load(sess->setup->prefs.dialog_font_normal);

   if(strcmp(prefs.dialog_font_bold,   sess->setup->prefs.dialog_font_bold) != 0)
	dialog_font_bold = gdk_font_load(sess->setup->prefs.dialog_font_bold);
   
   memcpy(&prefs, &sess->setup->prefs, sizeof(struct xchatprefs));
   
   if(do_colors)
   {
         GSList *list = sess_list;
	 struct session *s;
	 while(list)
	 {
	    s = (struct session *)list->data;
	    settings_setstyle(s);
	    list = list->next;
   	 }
   }

   settings_closegui(0, sess);
}

void color_clicked(GtkWidget *igad, GtkWidget *colgad, char *colset)
{
   GtkStyle stylefg;
   char buf[16];
   int col = atoi(gtk_entry_get_text(GTK_ENTRY(igad)));
   if(col < 0 || col > 15) col = 0;
   sprintf(buf, "%d", col);
   gtk_entry_set_text(GTK_ENTRY(igad), buf);
   memcpy(&stylefg, gtk_widget_get_style(igad), sizeof(GtkStyle));
   memcpy(&stylefg.bg, &colors[col], sizeof(GdkColor));
   gtk_widget_set_style(colgad, &stylefg);
   *colset = col; 
}

void dialog_fg_color_clicked(GtkWidget *igad, struct session *sess)
{
   color_clicked(igad, sess->setup->dialog_fg_color, &sess->setup->prefs.dialog_fg_color);
}

void dialog_bg_color_clicked(GtkWidget *igad, struct session *sess)
{
   color_clicked(igad, sess->setup->dialog_bg_color, &sess->setup->prefs.dialog_bg_color);
}

void settings_font_change(GtkWidget *igad, char *fontsetting, GtkWidget *fontwid)
{
   GdkFont *font;
   char *newfont = gtk_entry_get_text(GTK_ENTRY(igad));   
   font = gdk_font_load(newfont);
   if(font)
   {
     strcpy(fontsetting, newfont);
     {
	GtkStyle *style = gtk_style_new();
	memcpy(style, gtk_widget_get_style(fontwid), sizeof(GtkStyle));
	style->font = font;
	gtk_widget_set_style(fontwid, style);
     }
   } else
      gtk_entry_set_text(GTK_ENTRY(igad), fontsetting);
}

void settings_dialog_font_bold(GtkWidget *igad, struct session *sess)
{
   settings_font_change(igad, sess->setup->prefs.dialog_font_bold,
			sess->setup->dialog_font_bold);
}

void settings_dialog_font_normal(GtkWidget *igad, struct session *sess)
{
   settings_font_change(igad, sess->setup->prefs.dialog_font_normal,
			sess->setup->dialog_font_normal);
}

void fg_color_clicked(GtkWidget *igad, struct session *sess)
{
   color_clicked(igad, sess->setup->fg_color, &sess->setup->prefs.fg_color);
}

void bg_color_clicked(GtkWidget *igad, struct session *sess)
{
   color_clicked(igad, sess->setup->bg_color, &sess->setup->prefs.bg_color);
}

void settings_font_bold(GtkWidget *igad, struct session *sess)
{
   settings_font_change(igad, sess->setup->prefs.font_bold,
			sess->setup->font_bold);
}

void settings_font_normal(GtkWidget *igad, struct session *sess)
{
   settings_font_change(igad, sess->setup->prefs.font_normal,
			sess->setup->font_normal);
}

void settings_create_font_box(GtkWidget *vvbox,
			      char *label,
			      GtkWidget **font_wid,
			      void *callback,
			      char *font_str,
			      GdkFont *gdkfont,
			      struct session *sess)
{
   GtkStyle *style;
   GtkWidget *wid;

   wid = gtk_label_new(label);
   *font_wid = wid;
   style = gtk_style_new();
   memcpy(style, gtk_widget_get_style(wid), sizeof(GtkStyle));
   style->font = gdkfont;
   gtk_widget_set_style(wid, style);
   gtk_container_add(GTK_CONTAINER(vvbox), wid);
   gtk_widget_show(wid);

   wid = gtk_entry_new();
   gtk_signal_connect(GTK_OBJECT(wid), "activate",
                      GTK_SIGNAL_FUNC(callback), sess);
   gtk_entry_set_text(GTK_ENTRY(wid), font_str);
   gtk_container_add(GTK_CONTAINER(vvbox), wid);
   gtk_widget_show(wid);
}

void settings_create_color_box(GtkWidget *vvbox,
			       char *label,
			       GtkWidget **color_wid,
			       int initcolor,
			       void *callback,
			       struct session *sess)
{
   GtkStyle *style;
   GtkWidget *hbox, *wid;
   char buf[16];

   hbox = gtk_hbox_new(0, 2);
   gtk_container_add(GTK_CONTAINER(vvbox), hbox);
   gtk_widget_show(hbox);

   wid = gtk_label_new(label);
   gtk_box_pack_start(GTK_BOX(hbox), wid, 0, 0, 0);
   gtk_widget_show(wid);

   wid = gtk_button_new();
   *color_wid = wid;
   style = gtk_style_new();
   memcpy(style, gtk_widget_get_style(wid), sizeof(GtkStyle));
   memcpy(style->bg, &colors[initcolor], sizeof(GdkColor));
   gtk_widget_set_style(wid, style);
   gtk_container_add(GTK_CONTAINER(hbox), wid);
   gtk_widget_show(wid);

   wid = gtk_entry_new();
   sprintf(buf, "%d", initcolor);
   gtk_entry_set_text(GTK_ENTRY(wid), buf);
   gtk_widget_set_usize(wid, 40, -1);
   gtk_signal_connect(GTK_OBJECT(wid), "activate",
		      GTK_SIGNAL_FUNC(callback), sess);
   gtk_box_pack_end(GTK_BOX(hbox), wid, 0, 0, 0);
   gtk_widget_show(wid);
}

void settings_create_tab(
			 GtkWidget *book,
			 char *title,
			 GtkWidget **font_normal_wid,
			 GtkWidget **font_bold_wid,
			 char *font_normal_str,
			 char *font_bold_str,
			 void *font_normal_callback,
			 void *font_bold_callback,
			 
			 GtkWidget **bg_color_wid,
			 GtkWidget **fg_color_wid,
			 int bg_color,
			 int fg_color,
			 void *bg_color_callback,
			 void *fg_color_callback,
			 
			 GdkFont *font_nn,
			 GdkFont *font_bb,

			 struct session *sess
			 )
{
   GtkWidget *vvbox, *wid;

   vvbox = gtk_vbox_new(0, 10);

   settings_create_font_box(vvbox,
			    "Normal Font (Don't forget to hit return!)",
			    font_normal_wid,
			    font_normal_callback,
			    font_normal_str,
			    font_nn,
			    sess);
   
   settings_create_font_box(vvbox,
			    "Bold Font",
			    font_bold_wid,
			    font_bold_callback,
			    font_bold_str,
			    font_bb,
			    sess);

   settings_create_color_box(vvbox, "Background:", bg_color_wid,
			       bg_color, bg_color_callback, sess);
   
   settings_create_color_box(vvbox, "Foreground:", fg_color_wid,
			       fg_color, fg_color_callback, sess);
   
   wid = gtk_label_new(title);
   gtk_widget_show(wid);
   gtk_notebook_append_page(GTK_NOTEBOOK(book), vvbox, wid);
   gtk_widget_show(vvbox); 
}

void settings_opengui(struct session *sess)
{
   char buf[16];
   GtkWidget *book, *wid, *vbox, *vvbox, *hbox;

   if(sess->setup)
   {
      settings_closegui(0, sess);
      return;
   }

   sess->setup = malloc(sizeof(struct setup));
   memcpy(&sess->setup->prefs, &prefs, sizeof(struct xchatprefs));

   sess->setup->settings_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_widget_set_usize(sess->setup->settings_window, 500, -1);
   gtk_signal_connect(GTK_OBJECT(sess->setup->settings_window), "destroy",
		      GTK_SIGNAL_FUNC(settings_closegui), sess);
   gtk_window_set_title(GTK_WINDOW(sess->setup->settings_window), "X-Chat: Settings");
   gtk_container_border_width(GTK_CONTAINER(sess->setup->settings_window), 3);

   vbox = gtk_vbox_new(0, 2);
   gtk_container_add(GTK_CONTAINER(sess->setup->settings_window), vbox);
   gtk_widget_show(vbox);

   book = gtk_notebook_new();
   gtk_container_add(GTK_CONTAINER(vbox), book);
   gtk_widget_show(book);

   // main tab
   
   vvbox = gtk_vbox_new(0, 2);
   gtk_container_border_width(GTK_CONTAINER(vvbox), 3);

   hbox = gtk_hbox_new(0, 2);
   gtk_container_add(GTK_CONTAINER(vvbox), hbox);
   gtk_widget_show(hbox);
   
   wid = gtk_label_new("Away Reason:");
   gtk_box_pack_start(GTK_BOX(hbox), wid, 0, 0, 0);
   gtk_widget_show(wid);

   sess->setup->entry_away = gtk_entry_new();
   gtk_entry_set_text(GTK_ENTRY(sess->setup->entry_away), prefs.awayreason);
   gtk_container_add(GTK_CONTAINER(hbox), sess->setup->entry_away);
   gtk_widget_show(sess->setup->entry_away);

   hbox = gtk_hbox_new(0, 2);
   gtk_container_add(GTK_CONTAINER(vvbox), hbox);
   gtk_widget_show(hbox);
   
   wid = gtk_label_new("Quit Message:");
   gtk_box_pack_start(GTK_BOX(hbox), wid, 0, 0, 0);
   gtk_widget_show(wid);

   sess->setup->entry_quit = gtk_entry_new();
   gtk_entry_set_text(GTK_ENTRY( sess->setup->entry_quit), prefs.quitreason);
   gtk_container_add(GTK_CONTAINER(hbox), sess->setup->entry_quit);
   gtk_widget_show(sess->setup->entry_quit);
     
   hbox = gtk_hbox_new(0, 2);
   gtk_container_add(GTK_CONTAINER(vvbox), hbox);
   gtk_widget_show(hbox);
   
   wid = gtk_label_new("Text Buffer Size:");
   gtk_box_pack_start(GTK_BOX(hbox), wid, 0, 0, 0);
   gtk_widget_show(wid);

   sess->setup->entry_bufsize = gtk_entry_new();
   sprintf(buf, "%ld", prefs.bufsize);
   gtk_entry_set_text(GTK_ENTRY(sess->setup->entry_bufsize), buf);
   gtk_container_add(GTK_CONTAINER(hbox), sess->setup->entry_bufsize);
   gtk_widget_show(sess->setup->entry_bufsize);

   wid = gtk_label_new("Misc");
   gtk_widget_show(wid);   
   gtk_notebook_append_page(GTK_NOTEBOOK(book), vvbox, wid);

   gtk_widget_show(vvbox);

   // end of main tab
   
   settings_create_tab(book,
		       "Channel Windows",
		       &sess->setup->font_normal,
		       &sess->setup->font_bold,
		       prefs.font_normal,
		       prefs.font_bold,
		       settings_font_normal,
		       settings_font_bold,
		       &sess->setup->bg_color,
		       &sess->setup->fg_color,
		       prefs.bg_color,
		       prefs.fg_color,
		       bg_color_clicked,
		       fg_color_clicked,
		       font_normal,
		       font_bold,
		       sess);

   settings_create_tab(book,
		       "Dialog Windows",
		       &sess->setup->dialog_font_normal,
		       &sess->setup->dialog_font_bold,
		       prefs.dialog_font_normal,
		       prefs.dialog_font_bold,
		       settings_dialog_font_normal,
		       settings_dialog_font_bold,
		       &sess->setup->dialog_bg_color,
		       &sess->setup->dialog_fg_color,
		       prefs.dialog_bg_color,
		       prefs.dialog_fg_color,
		       dialog_bg_color_clicked,
		       dialog_fg_color_clicked,
		       dialog_font_normal,
		       dialog_font_bold,
		       sess);
   
   hbox = gtk_hbox_new(0, 2);
   gtk_box_pack_end(GTK_BOX(vbox), hbox, 0, 0, 0);
   gtk_widget_show(hbox);
   
   wid = gtk_button_new_with_label("Ok");
   gtk_signal_connect(GTK_OBJECT(wid), "clicked",
		      GTK_SIGNAL_FUNC(settings_ok_clicked), sess);
   gtk_container_add(GTK_CONTAINER(hbox), wid);
   gtk_widget_show(wid);

   wid = gtk_button_new_with_label("Cancel");
   gtk_signal_connect(GTK_OBJECT(wid), "clicked",
		      GTK_SIGNAL_FUNC(settings_closegui), sess);
   gtk_container_add(GTK_CONTAINER(hbox), wid);
   gtk_widget_show(wid);

   gtk_widget_show(sess->setup->settings_window);
}
