.\" -*- nroff -*-
.TH WINE 1 "July 8, 1998" "Version 980628" "Windows Emulator"
.SH NAME
wine \- run Windows programs under Unix
.SH SYNOPSIS
.B wine
[
.I options
]
.I program_name
[
.I program_name...
]
.SH DESCRIPTION
.B wine
invokes the Windows emulator.
.PP
.B wine 
currently runs a growing list of applications written for both Win3.1 and 
Win95.  Older, simpler applications work better than newer, more complex 
ones.  A large percentage of the API has been implemented, although there
are still several major pieces of work left to do.
.SH REQUIREMENTS
At present, 
.B wine
will run under any Linux kernel more recent than 0.99.13, or
under recent releases of NetBSD/i386, FreeBSD and OpenBSD/i386.
.PP
The current support for multithreaded applications relies on the 
.B clone(2)
system call, which is currently available only on Linux systems running
libc6 (glibc2).
.PP
.B X
must be installed.  To use Wine's support for multithreaded applications,
your X libraries must be reetrant.  If you have libc6 (glibc2), or you 
compiled the libraries yourself, they were probably compiled with the 
reetrant option enabled.  
.PP
.B libXpm
must be installed.  If you're using Red Hat, the name of the package is
XFree86-devel.  The sources may be FTP'd from ftp.Xfree86.org or its 
mirrors.
.PP
.B gcc
2.7.x or later is required to build
.B wine.
Versions earlier than 2.7.2.3 may have problems when certain files are
compiled with optimization.
.SH INSTALLATION
To install 
.B Wine,
run "./configure" in the top-level directory of the source, which will 
detect your specific setup and create the Makefiles.  You can run 
"./configure --help" to see the available configuration options.  Then do 
"make depend; make" to build the
.B wine
executable, and then "make install" to install it. By default,
.B wine
is installed in /usr/local/bin; you can specify a different path with
the --prefix option when running
.B configure.
.PP
For more information, see the 
.B README
file contained in the source distribution.
.SH OPTIONS
.TP
.I -backingstore
Turn on backing store
.TP
.I -debug
Enter the debugger before starting application
.TP
.I -debugmsg [xxx]#name[,[xxx1]#name1]
Turn debugging messages on or off.  
.RS +7
.PP
xxx is optional and can be one of the following: 
.I err, 
.I warn, 
.I fixme, 
or 
.I trace. 
If xxx is not specified, all debugging messages for the specified
channel are turned on.  # is required and can be either + or -.  Note that 
there is not a space after the comma between names.
.PP
For instance:
.PP
.I -debugmsg warn+dll,+heap
will turn on DLL warning messages and all heap messages.  
.br
.I -debugmsg fixme-all,warn+cursor,+relay
will turn off all FIXME messages, turn on cursor warning messages, and turn
on all relay messages (API calls).
.PP
The full list of names is: all, accel, advapi, aspi, atom, bitblt, bitmap, 
caret, cd, cdaudio, class, clipboard, clipping, combo, comm, commctrl, 
commdlg, console, crtdll, cursor, dc, dde, ddeml, ddraw, debug, dialog, 
dinput, dll, dosfs, driver, dsound, edit, event, exec, file, fixup, font, 
gdi, global, graphics, header, heap, hook, icon, imagelist, int, int21, 
int31, key, keyboard, ldt, listbox, local, mci, mcianim, mciwave, mdi, menu, 
message, metafile, midi, mmaux, mmio, mmsys, mmtime, module, mpr, msg, 
nonclient, ntdll, ole, palette, print, process, profile, prop, reg, region, 
relay, resource, scroll, security, segment, selector, sem, sendmsg, shell, 
shm, snoop, sound, stress, string, syscolor, task, text, thread, thunk, timer, 
toolhelp, tweak, uitools, updown, ver, virtual, vxd, win, win16drv, win32, 
wing, winsock, wnet, x11, x11drv.
.PP
For more information on debugging messages, see the file 
.I documentation/debug-msgs
in the source distribution.
.RE
.TP
.I -depth n
Change the depth to use for multiple-depth screens
.TP
.I -desktop geom
Use a desktop window of the given geometry
.TP
.I -display name
Use the specified display
.TP
.I -dll name
Enables/disables built-in DLL's - starting wine with
.I -dll -commdlg
is probably a good idea.
The full list of DLLs modifiable by this is:
WIN87EM, SHELL, SOUND, KEYBOARD, WINSOCK, STRESS, MMSYSTEM, SYSTEM, TOOLHELP,
MOUSE, COMMDLG, OLE2, OLE2CONV, OLE2DISP, OLE2NLS, OLE2PROX, OLECLI, OLESVR,
COMPOBJ, STORAGE, WINPROCS, DDEML, ADVAPI32, COMCTL32, COMDLG32, CRTDLL,
GDI32, LZ32, MPR, NTDLL, OLE32, SHELL32, USER32, VER, VERSION, W32SYS, WINMM,
WINSPOOL, WSOCK32
.TP
.I -failreadonly
Read only files may not be opened in write mode (the default is to
allow opening read-only files for writing, because most Windows
programs always request read-write access, even on CD-ROM drives...).
.TP
.I -fixedmap
Use a "standard" color map.
.TP
.I -iconic
Start as an icon
.TP
.I -language xx
Set the language to
.I xx
(one of En, Es, De, No, Fr, Fi, Da, Cz, Eo, It, Ko, Hu, Pl, Po, Sw, Ca)
.TP
.I -managed
Create each top-level window as a properly managed X window
.TP
.I -mode modename
Determines the mode in which
.B wine
is started. Possible mode names are
.I standard
and
.I enhanced.
Enhanced mode is the default (when no -mode option is specified).
.TP
.I -name name
Set the application name
.TP
.I -privatemap
Use a private color map
.TP
.I -synchronous
Turn on synchronous display mode
.TP
.I -winver version
Specify which Windows version WINE should imitate.
Possible arguments are: win31, win95, nt351, and nt40.
.PD 1
.SH PROGRAM/ARGUMENTS
The program name may be specified in DOS format (C:\\WINDOWS\\SOL.EXE) or in 
Unix format (/msdos/windows/sol.exe).  The program being executed may be 
passed arguments by adding them on to the end of the command line invoking
.B wine
(such as: wine "notepad C:\\TEMP\\README.TXT").  Note that
the program name and its arguments 
.I must
be passed as a single parameter, which is usually accomplished by placing
them together in quotation marks.  Multiple applications may be started
by placing all of them on the command line (such as: wine notepad clock).
.SH CONFIGURATION FILE
.B wine
expects a configuration file (/usr/local/etc/wine.conf), which should
conform to the following rules (the format is just like a Windows .ini
file).  The actual file name may be specified during the execution of
the
.B configure
script.  Alternatively, you may have a 
.I .winerc
file of this format in your home directory or have the environment variable
.B WINE_INI
pointing to a configuration file.
.SH CONFIGURATION FILE FORMAT
All entries are grouped in sections; a section begins with the line
.br
.I [section name]
.br
and continues until the next section starts. Individual entries
consist of lines of the form
.br
.I entry=value
.br
The value can be any text string, optionally included in single or
double quotes; it can also contain references to environment variables
surrounded by
.I ${}.
Supported section names and entries are listed below.
.PP
.B [Drive X]
.br
This section is used to specify the root directory and type of each
.B DOS
drive, since most Windows applications require a DOS/MS-Windows based 
disk drive & directory scheme. There is one such section for every
drive you want to configure.
.PP
.I format: Path = <rootdirectory>
.br
default: none
.br
If you mounted your dos partition as 
.I /dos
and installed Microsoft Windows in 
C:\\WINDOWS then you should specify 
.I Path=/dos
in the
.I [Drive C]
section.
.PP
.I format: Type = <type>
.br
default: hd
.br
Used to specify the drive type; supported types are floppy, hd, cdrom
and network.
.PP
.I format: Label = <label>
.br
default: 'Drive X'
.br
Used to specify the drive label; limited to 11 characters.
.PP
.I format: Serial = <serial>
.br
default: 12345678
.br
Used to specify the drive serial number, as an 8-character hexadecimal
number.
.PP
.I format: Filesystem = <fstype>
.br
default: unix
.br
Used to specify the type of the filesystem on which the drive resides;
supported types are msdos (or fat), win95 (or vfat), unix. If the
drive spans several different filesystems, say unix.
.PP
.B [wine]
.br
.I format: windows = <directory>
.br
default: C:\\WINDOWS
.br
Used to specify a different Windows directory
.PP
.I format: system = <directory>
.br
default: C:\\WINDOWS\\SYSTEM
.br
Used to specify a different system directory
.PP
.I format: temp = <directory>
.br
default: C:\\TEMP
.br
Used to specify a directory where Windows applications can store 
temporary files.
.PP
.I format: path = <directories separated by semi-colons>
.br
default: C:\\WINDOWS;C:\\WINDOWS\\SYSTEM
.br
Used to specify the path which will be used to find executables and .DLL's.
.PP
.I format: symboltablefile = <filename>
.br
default: wine.sym
.br
Used to specify the path and file name of the symbol table used by the built-in
debugger.
.PP
.B [serialports]
.br
.I format: com[12345678] = <devicename>
.br
default: none
.br
Used to specify the devices which are used as com1 - com8.
.PP
.B [parallelports]
.br
.I format: lpt[12345678] = <devicename>
.br
default: none
.br
Used to specify the devices which are used as lpt1 - lpt8.
.PP
.B [spy]
.br
.I format: file = <filename or CON when logging to stdout>
.br
default: none
.br
Used to specify the file which will be used as
.B logfile.
.PP
.I format: exclude = <message names separated by semicolons>
.br
default: none
.br
Used to specify which messages will be excluded from the logfile.
.PP
.I format: include = <message names separated by semicolons>
.br
default: none
.br Used to specify which messages will be included in the logfile.
.PP
.B [Tweak.Layout]
.br
.I format: Win95Look=<true|false>
.br
default: false
.br 
Use Win95-like window displays or Win3.1-like window displays.
.SH SAMPLE CONFIGURATION FILE
[Drive A]
.br
Path=/mnt/fd0
.br
Type=floppy
.PP
[Drive C]
.br
Path=/dos
.br
Type=hd
.br
Label=DOS disk
.PP
[Drive D]
.br
Path=${HOME}/Wine
.PP
[wine]
.br
windows=c:\\windows
.br
system=c:\\windows\\system
.br
temp=c:\\temp
.br
path=c:\\windows;c:\\windows\\system;c:\\winapps\\word
.br
symboltablefile=/usr/local/lib/wine.sym
.PP
[serialports]
.br
com1=/dev/cua1
.br
com2=/dev/cua1
.PP
[parallelports]
.br
lpt1=/dev/lp0
.PP
[spy]
.br
;File=CON
.br
;File=spy.log
.br
Exclude=WM_TIMER;WM_SETCURSOR;WM_MOUSEMOVE;WM_NCHITTEST;
.br
Include=WM_COMMAND;
.PP
[Tweak.Layout]
.br 
Win95Look=true
.SH AUTHORS
.B Wine
is available thanks to the work of many developers. For a listing
of the authors, please see the file 
.B AUTHORS
in the top-level directory of the source distribution.
.SH BUGS
There are too many to count, much less list.  Some bugs of note, however,
are that programs requiring VBRUNxxx.DLL are unreliable (with reports of
some working), OLE is not in place, the internal COMMDLG support is not yet
at 100% (although rapidly improving).  Color support for other than 8bpp
(256 colors) is currently flaky.
.PP
A status report on many appplications is available from
.I http://www.winehq.com/apps.cgi.
Users can add, modify, and delete entries on this list.
.PP
Bug reports and successes may be posted to 
.I comp.emulators.ms-windows.wine.
.SH AVAILABILITY
The most recent public version of 
.B wine
can be ftp'ed from sunsite.unc.edu or tsx-11.mit.edu in the /pub/linux/ALPHA/Wine/development 
directory.  The releases are in the format 'Wine-yymmdd.tar.gz', 
or 'Wine-yymmdd.diff.gz' for the diff's from the previous release.
.PP
The
.B wine
homepage is at
.I http://www.winehq.com.
This website contains a great deal of information about
.B wine
as well as a collection of unofficial patches against the current release.
.PP
The
.B wine 
newsgroup is 
.I comp.emulators.ms-windows.wine.
All discussions about the project take place in this forum.
.SH FILES
.PD 0
.TP
.I /usr/local/bin/wine
The invoker program.
.TP
.I /usr/local/etc/wine.conf
Global configuration file for wine.
.TP
.I /usr/local/lib/wine.sym
Global symbol table (used in debugger)
.TP
.I ~/.winerc
User-specific configuration file
.SH "SEE ALSO"
clone(2)
