/*
 *  Digital Audio (PCM) abstract layer / Mixing devices
 *  Copyright (c) by Jaroslav Kysela <perex@jcu.cz>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "driver.h"
#include "info.h"
#include "pmix.h"

/*
 *  File operations
 */
 
static int snd_pmix_open( void *private_data, snd_info_entry_t *entry, unsigned short mode, void **file_private_data )
{
  MOD_INC_USE_COUNT;
  *file_private_data = NULL;
  printk( "open!!!\n" );
  return 0;
}

static int snd_pmix_release( void *private_data, snd_info_entry_t *entry, unsigned short mode, void *file_private_data )
{
  printk( "release!!!\n" );
  MOD_DEC_USE_COUNT;
  return 0;
}

static long snd_pmix_read( void *private_data, void *file_private_data, struct file *file, char *buf, long count )
{
  return 0;
}

static long snd_pmix_write( void *private_data, void *file_private_data, struct file *file, const char *buf, long count )
{
  return 0;
}

#ifdef SND_POLL
unsigned int snd_pmix_poll( void *private_data, void *file_private_data, struct file *file, poll_table *wait )
{
  return 0;
}
#else
int snd_pmix_select( void *private_data, void *file_private_data, struct file *file, int sel_type, select_table *wait )
{
  return 0;
}
#endif

int snd_pmix_ioctl( void *private_data, void *file_private_data, struct file *file, unsigned int cmd, unsigned long arg )
{
  return -EINVAL;
}

/*
 *
 */

struct snd_info_entry_data snd_pmix_fops = {
  snd_pmix_open,
  snd_pmix_release,
  snd_pmix_read,
  snd_pmix_write,
  NULL,
#ifdef SND_POLL
  snd_pmix_poll,
#else
  snd_pmix_select,
#endif
  snd_pmix_ioctl,
  NULL
};
