#ifndef OPTION_H_DEF
#define OPTION_H_DEF

/* options.c */
extern int verbose, debug;
void print_usage(void);
void general_options(char *argstr, int c);
void print_general_options(FILE *fp, char *argstr, awe_option_args *options);
void set_bool(int *val);
int adjust_volscale(char *val);
int do_option_arg(MidiInfo *mp, int type, char *arg, int msg);
int do_option_index(MidiInfo *mp, char *tok, char *val, int before_reading);
void parse_index_line(MidiInfo *mp, char *line, int before_reading);

enum {
	OPT_NONE = -1,

	OPT_INTERFACE = 'i', OPT_MODE = 'm', OPT_TRACE = 't',

	OPT_VERBOSE = 'v', OPT_HELP = 'h',
	OPT_CHORUS = 'c', OPT_REVERB = 'r', OPT_VOLUME = 'V',
	OPT_REALTIME_PAN = 'P', OPT_AUTOSKIP = 's',
	OPT_SAMECSEC = 'C', OPT_GSMACRO = 'G', OPT_XGMACRO = 'X',
	OPT_DRUM = 'D', OPT_ACCEPTALL = 'O', OPT_TRACKS = 'T',
	OPT_MT32 = 'M', OPT_DYNAMIC = 'L', OPT_VOLSCALE = 'S',
	OPT_PARSETITLE = 'Y',
	OPT_EFFECT = 'F', OPT_DISPLAY = 'd', OPT_GEOMETRY = 'g',

	OPT_CHORUSDEPTH = 0x1000, OPT_REVERBDEPTH, OPT_TUNING,
	OPT_SHMID, OPT_PIPEIN, OPT_PIPEOUT,
	OPT_XGMAP, OPT_XGLOAD, OPT_CHN_PRIOR, OPT_DRUMFLAG,
	OPT_SUBSF, OPT_TITLE, OPT_CHN_VOLUME, OPT_OFFSET,
	OPT_MULTIPART, OPT_USEFX,
	OPT_FX_CUTOFF, OPT_FX_RESONANCE, OPT_FX_ATTACK, OPT_FX_RELEASE,
	OPT_FX_VIBRATE, OPT_FX_VIBDEPTH, OPT_FX_VIBDELAY,

	OPT_CONVERT, OPT_SEQBUF, OPT_SEQECHO,

	OPT_LOCAL = 0x2000,
};

#define BOOLSTR(v)	((v) ? "on" : "off")

#endif
