typedef struct {
   Window win, parent;
   int x, y, w, h;
   ImageDat *back;
   Button *button;
   int arrows;
   int state;
   int visible;
   Button *arrow1, *arrow2;
   ImageList *backs;
   ImageList *thumbs;
   float percent;
   int horizontal;
   int slider_size;
   int slider_position;
   int min, max;
   int dragging;
   int progressbar;
   void (*callback) (void);
} Slider;

void HideSlider(Slider * slider);
void UnhideSlider(Slider * slider);
void RaiseSlider(Slider * slider);
void CreateSlider(Slider * slider, Window parent);
Slider *ConfigSlider(Window parent, FILE * file);
void MoveSlider(Slider * slider, int x, int y);
void ScaleSlider(Slider * slider, double scale_w, double scale_h);
void ResizeSlider(Slider * slider, int new_w, int new_h);
void EventSlider(Slider * slider, XEvent ev);
float GetSliderPosition(Slider * slider);
void UpdateSlider(Slider * slider);
void SetSliderPosition(Slider * slider, float percent);
int isEventSlider(Slider * slider, XEvent ev);
void SliderSetCallback(Slider * slider, void (*call) (void));
void FreeSlider(Slider * slider);
void SliderUpdateInfo(Slider * slider);
