/*
 *  @(#) obuffer_linux.h 1.3, last edit: 12 Dec 1994 13:40:19
 *  @(#) Copyright (C) 1993, 1994 Tobias Bading (bading@cs.tu-berlin.de)
 *  @(#) Berlin University of Technology
 *
 *  LinuxObuffer class written by
 *  Louis P. Kruger (lpkruger@phoenix.princeton.edu)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef OBUFFER_LINUX_H
#define OBUFFER_LINUX_H

class LinuxObuffer : public Obuffer
{
  char		buffer[OBUFFERSIZE];
  char		*bufferp[MAXCHANNELS];
  uint32	channels;
  static int	audio_fd;

  static int	open_audio_device (void);

public:
		LinuxObuffer (uint32 number_of_channels, Header *);
	       ~LinuxObuffer (void);
  void		append (uint32 channel, int16 value);
  void		write_buffer (int dummy);

  static boil	class_suitable (uint32 number_of_channels);
};

#endif
