// next_converter.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Converter subclass for NeXT workstation converters.

#ifndef NEXT_CONVERTER_H
#ifdef __GNUG__
#pragma interface
#endif
#define NEXT_CONVERTER_H

#include "converter.h"
#include "next_sound.h"

class NextConverter : public RealConverter {
	typedef RealConverter Super;
public:
	NextConverter();
	virtual ~NextConverter();
	redefined int pause();
	redefined int resume();
	redefined int stop();
	redefined int currentPlayLevel() const;
	redefined int currentRecordLevel() const;
	redefined boolean setPlayLevel(int);
	redefined boolean setRecordLevel(int);
	redefined boolean setSpeakerOutput(boolean);
	redefined boolean ready() const;
	redefined DataType bestPlayableType() { return ShortData; }
protected:
	redefined boolean isPlayableFormat(DataType type);
	redefined int doConfigure();
	redefined int doConversion(StatusAction* askedToStop);
	redefined int doRecording(StatusAction* askedToStop);
	redefined int checkSampleRate(int rate);
	redefined int checkChannels(int chans);
	redefined int checkDataType(DataType type);
	redefined void fail() { Super::fail(); myTag = -1; }
	static int tag();
	class NextConfigRequester : public RealConverter::ConfigRequester {
	public:
		NextConfigRequester(RealConverter* cvtr) : ConfigRequester(cvtr) {}
	protected:
		redefined void configureRequest(Request *);
		redefined boolean confirmValues();
	};
	friend boolean NextConfigRequester::confirmValues();
	redefined Requester* configRequester() {
		return new NextConfigRequester(this);
	}
	friend class Controller;
private:
	int createInternalSound(int samprate, int channels, DataType type);
	static int start_fun(SNDSoundStruct *sp, int tag, int err);
	static int end_fun(SNDSoundStruct *sp, int tag, int err);
	static SNDSoundStruct internalSound;
	static int myTag;
};

#endif

