#include "m_pd.h"
#ifdef NT
#pragma warning( disable : 4244 )
#pragma warning( disable : 4305 )
#endif

/* ------------------------ dspobj~ ----------------------------- */

#define A1 (4 * (3.14159265/2))
#define A3 (64 * (2.5 - 3.14159265))
#define A5 (1024 * ((3.14159265/2) - 1.5))

static t_class *dspobj_class;

typedef struct _dspobj
{
    t_object x_obj;
} t_dspobj;

static t_int *dspobj_perform(t_int *w)
{
    t_float *in = (t_float *)(w[1]);
    t_float *out = (t_float *)(w[2]);
    int n = (int)(w[3]);
    while (n--)
    {
    	float f = *(in++), g, g2, g3;
    	if (f < 0) f -= (int)(f-1);
    	else f -= (int)f;
    	if (f > 0.5)  g = f - 0.75;
    	else g = 0.25 - f;
    	g2 = g * g;
    	g3 = g * g2;
    	*out++ = g * A1 + g3 * A3 + g2 * g3 * A5;
    }
    return (w+4);
}

static void dspobj_dsp(t_dspobj *x, t_signal **sp)
{
    dsp_add(dspobj_perform, 3, sp[0]->s_vec, sp[1]->s_vec, sp[0]->s_n);
}

static void *dspobj_new()
{
    t_dspobj *x = (t_dspobj *)pd_new(dspobj_class);
    outlet_new(&x->x_obj, gensym("signal"));
    return (x);
}

void dspobj_setup(void)
{
    dspobj_class = class_new(gensym("dspobj"), dspobj_new, 0,
    	sizeof(t_dspobj), 0, A_DEFFLOAT, 0);
    class_addmethod(dspobj_class, nullfn, gensym("signal"), 0);
    class_addmethod(dspobj_class, dspobj_dsp, gensym("dsp"), 0);
}
