/*************************************************************/
/* sequncer.c: midi sequencer                                */
/*            V 1.00 (juli 97)             by winfried ritsch */
/*************************************************************/
#define debug 0
#define UNIX

#ifdef UNIX
#include <unistd.h>
#include <sys/time.h>
#ifndef __linux__
#include <bstring.h>
#endif
#endif
#ifdef NT
#include <winsock.h>
#include <sys/types.h>
#include <sys/timeb.h>
#endif
#include <string.h>
#include <stdio.h>

#include "times.h"


/* timebasis for unixs and nts */ 

void sys_gettime(t_systime *st)
{
#ifdef UNIX
    struct timeval now;

    gettimeofday(&now, 0);
    st->st_sec = now.tv_sec;
    st->st_microsec = now.tv_usec;
#endif
#ifdef NT
    struct _timeb now;
    _ftime(&now);
    st->st_sec = now.time;
    st->st_microsec = now.millitm * 1000;
#endif
}
int sys_microsecsince(t_systime *st)
{
    t_systime stnow;
    sys_gettime(&stnow);
    if (stnow.st_sec > st->st_sec + 1000) return (0x7fffffff);
    else return (1000000 * (stnow.st_sec - st->st_sec) +
    	stnow.st_microsec - st->st_microsec);
}

double sys_secsince(t_systime *st)
{
    t_systime stnow;
    sys_gettime(&stnow);
    if (stnow.st_sec > st->st_sec + 1000000) return (0x7fffffff);
    else return (1. * (stnow.st_sec - st->st_sec) +
    	(0.000001 * (stnow.st_microsec - st->st_microsec)));
}



#ifdef MAIN
/* --- Variables ------ */

int main()
{
long i,j;
long count;

t_systime starttime;

double times[11];
int dummy = 1;
printf("Testing timer \n");

 sys_gettime(&starttime);

 for(i=0l ; i<11l ;i++){

	times[i] = sys_secsince(&starttime);

	for(j=0l;j < i*i;j++)
	  dummy = dummy * dummy;
 }

 for(i=1l;i<11l;i++){
	printf("time[%ld]= %f sec (+%f)(wait=%ld)\n",i,times[i],
			 times[i]-times[i-1l],i*i);
 }

 for(i=0l; i<11l; i++)
	times[i]=0.0;

 times[2] = 1.0;
 count = 0l;

 sys_gettime(&starttime);

 for(i=0; i<1000000l; i++){

	times[0] = sys_secsince(&starttime);

	times[4] = times[0]-times[3];

	if((times[4]) > times[1])
	  times[1]=times[4];
	else if((times[4]) < times[2])
	  times[2] = times[4];

	if(times[4] > 0.001)
	  count++;

	times[3]=times[0];

 }

 printf("\nmax delta time= %f sec\n",times[1]); 
 printf("min delta time= %f sec\n",times[2]); 
 printf("%ld times from %ld more than 1 ms that is %f %% \n",
		  count,i,(double) (100l*count)/(double) i);

 return 0;

}

#endif /* MAIN */

