/******************************************************************************
*   WMSound	WindowMaker Sound Server	                              *
*   Copyright (C) 1998  Anthony Quinn <southgat@frontiernet.net               *
*                       William Moore <billy@mud.mind.net>		      *
*									      *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.					      *
*									      *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*******************************************************************************/
#ifndef __wmsd_h__
#define __wmsd_h__

#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xproto.h>
#include <proplist.h>
#include "wsconfig.h"

typedef int bool;

typedef enum {
	WMSound_Startup,
 	WMSound_Shade,
	WMSound_UnShade,
	WMSound_Maximize,
	WMSound_UnMaximize,
	WMSound_Iconify,
	WMSound_DeIconify,
	WMSound_Hide,
	WMSound_UnHide,
	WMSound_AppStart,
	WMSound_AppExit,
	WMSound_UserDefined,
	WMSound_MaxSound,
} SoundEvents;


typedef struct  SPrefrences {
	char 		**SoundPath;
	char		*SoundDevice;
	char		*Sound[WMSound_MaxSound];
} SPrefrences;

extern proplist_t  WMSound;
extern long	   SoundIndex[WMSound_MaxSound];
extern SPrefrences sPrefrences;
extern const char *ProgName;
extern const char *ErrorMsg[];

void		sReadDefaults		(proplist_t *,const char*);

long		getTimeStamp		(const char*);
void		sDispatchStartup	(void);
int		loadConfig		(void);
void		sBugf			(const char *,...);
void		sUpdateOptions		(void);
int		sInitDisplay		(int, char**);
int		sInitSoundIndex		(void);
int		sPlayEvent		(long);
char *		find_file_in_list	(char **,char*);
char *		defaultsPathForDomain	(char *,bool);
#endif
