/* Extended Module Player - scan.c
 * Copyright (C) 1996, 1997 Claudio Matsuoka and Hipolito Carraro Jr
 *
 * This file is part of the Extended Module Player and is distributed
 * under the terms of the GNU General Public License. See docs/COPYING
 * for more information.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "xmpi.h"
#include "xxm.h"
#include "effects.h"

extern struct xmp_ord_info xmpi_oinfo[256];


int xmpi_scan_module (double replay_rate)
{
    int f1, f2, p, o, r, c, rows;
    int bpm, tempo, gvl;
    int order, time_p, time_t;
    int loop[32];

    time_p = time_t = 0;
    order = 0;

    gvl = 64;
    bpm = xxh->bpm;
    tempo = opt.tempo ? opt.tempo : xxh->tpo;

    if (!tempo)
	tempo = 6;

    for (o = 0; o < xxh->len; o++) {
	if (xxo[o] == 0xff) {
	    if (opt.ignoreff)
		continue;
	    else
		break;
	}
	if (xxo[o] >= xxh->pat)
	    continue;

	xmpi_oinfo[o].bpm = bpm;
	xmpi_oinfo[o].tempo = tempo;
	xmpi_oinfo[o].gvl = gvl;
	xmpi_oinfo[o].time = (time_t + time_p) / 10;

	rows = (uint8) (xxp[xxo[o]]->rows - 1) + 1;

	for (r = 0; r < rows; r++) {
	    for (c = 0; c < xxh->chn; c++) {
		loop[c] = -1;

		f1 = EVENT (xxo[o], c, r).fxt;
		f2 = EVENT (xxo[o], c, r).f2t;

		if ((f1 == FX_TEMPO) || (f2 == FX_TEMPO)) {
		    p = (f1 == FX_TEMPO)?
			EVENT (xxo[o], c, r).fxp:
			EVENT (xxo[o], c, r).f2p;
		    if (p > 32)
			bpm = p;
		    else
			tempo = p;
		}

		if ((f1 == FX_JUMP) || (f2 == FX_JUMP)) {
		    order = (f1 == FX_JUMP)?
			EVENT (xxo[o], c, r).fxp:
			EVENT (xxo[o], c, r).f2p;
		    r = rows;
		}

		if ((f1 == FX_BREAK) || (f2 == FX_BREAK)) {
		    r = rows;
		}

		if ((f1 == FX_EXTENDED) || (f2 == FX_EXTENDED)) {
		    p = (f1 == FX_EXTENDED)?
			EVENT (xxo[o], c, r).fxp:
			EVENT (xxo[o], c, r).f2p;
		    if ((p >> 4) == EX_PATTERN_LOOP)
			loop[c] = p & 0x0f;
		}
	    }

	    time_p += tempo * replay_rate * 100 / bpm; 
	    for (f1 = c = 0; c < xxh->chn; c++) {
		if (loop[c] != -1)
		    if (loop[c])
			time_p *= ++loop[c];
		    else 
			if (!f1) {
			    time_t += time_p;
			    time_p = tempo * replay_rate * 100 / bpm; 
			    f1 = 1;
			}
	    }
	}

	if (order > o) {
	    o = order;
	    order = 0;
	}
    }

    return (time_t + time_p) / 10;
}


