;; $Id: dbindex.dsl 1.3 1998/07/19 16:13:12 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ................... INDEX TERMS (EMBEDDED MARKERS) ...................

(element indexterm (empty-sosofo))
(element primary (empty-sosofo))
(element secondary (empty-sosofo))
(element tertiary (empty-sosofo))
(element see (empty-sosofo))
(element seealso (empty-sosofo))

;; =========================== INDEX ELEMENTS ===========================

(element setindex ($component$))
(element (setindex title) (empty-sosofo))

(element index
  (make simple-page-sequence
    page-number-restart?: (or %page-number-restart% 
			      (book-start?) 
			      (first-chapter?))
    page-number-format: ($page-number-format$)
    use: para-style ;; set defaults for text in this simple page sequence
    left-header:   ($left-header$)
    center-header: ($center-header$)
    right-header:  ($right-header$)
    left-footer:   ($left-footer$)
    center-footer: ($center-footer$)
    right-footer:  ($right-footer$)
    start-indent: %body-start-indent%
    input-whitespace-treatment: 'collapse
    quadding: %default-quadding%
    page-n-columns: 2
    (make sequence
      ($component-title$)
      (process-children))
    (make-endnotes)))


(element (index title) (empty-sosofo))

(element indexdiv ($section$))
(element (indexdiv title) (empty-sosofo))

(element indexentry (process-children))

(element primaryie
  (make paragraph
    (process-children)))

(element secondaryie
  (make paragraph
    start-indent: (+ (inherited-start-indent) 1em)
    (process-children)))

(element tertiaryie
  (make paragraph
    start-indent: (+ (inherited-start-indent) 2em)
    (process-children)))

(element seeie
  (let ((indent (cond ((node-list-empty? 
			(select-elements
			 (children (parent (current-node)))
			 (normalize "secondaryie")))
		       1em)
		      ((node-list-empty? 
			(select-elements
			 (children (parent (current-node)))
			 (normalize "tertiaryie")))
		       2em)
		      (else 3em))))
    (make paragraph
      start-indent: (+ (inherited-start-indent) indent)
      (literal "(" (gentext-index-see) " ")
      (process-children)
      (literal ")"))))

(element seealsoie
  (let ((indent (cond ((node-list-empty? 
			(select-elements
			 (children (parent (current-node)))
			 (normalize "secondaryie")))
		       1em)
		      ((node-list-empty? 
			(select-elements
			 (children (parent (current-node)))
			 (normalize "tertiaryie")))
		       2em)
		      (else 3em))))
    (make paragraph
      start-indent: (+ (inherited-start-indent) indent)
      (literal "(" (gentext-index-seealso) " ")
      (process-children)
      (literal ")"))))
