#ifndef VSEARCH_H
#define VSEARCH_H

#include <sys/stat.h>
#include <limits.h>


/* define the NEED_* macros as more-or-less random constants.
   Some happen to coinside with what IS_* macros (or stat mode) give,
   others don't, but that doesn't matter */

/* However, the NEED_WRITE/NEED_READ do need to be 1/2 */
#define NEED_READ   01
#define NEED_WRITE  02   
#define NEED_EXEC   04  /* for an exec*() call */

#define NEED_DIR    010  /* chdir */
#define NEED_EXCL   020  /* O_EXCL mode used in open() call */
#define NEED_STAT   040  /* stat(), lstat() */
#define NEED_CHFL  0100 /* change-file, like chmod, chown, 
			       first arg to rename */
#define NEED_UNLI  0200 /* unlink, rm, second arg to rename */


#define VPATH "VPATH"
#define VPATHLIBDELIM "VPATHLIBDELIM"
#define VPATHLIBEXTDELIM "VPATHLIBEXTDELIM"
#define VPATHLIBEXTSEPERATOR "VPATHLIBEXTSEPERATOR"

#define VPATHSYMLINK "VPATHSYMLINK"

struct errno_str_type {
  char *str;
  int no;
};


extern struct errno_str_type errno_str[];

extern int vpath_findpath(char *vname, const char *name, mode_t mode, struct stat *st, int *vpath_errno);
extern DIR *vpath_opendir(const char *dir, int *vpath_errno);
extern int vpath_closedir(DIR *dir);
extern struct dirent *vpath_readdir(DIR *dir);
extern char *vpath_getcwd (char *buf, size_t size);
extern void vpath_debug(int argc, char **argv);

#endif  /* VSEARCH_H */



