/* LOCKVC Version 3.0 (c) 1994, 1995, 1997 by Matthias Straub */
/* shadow-password option added by Ed Beaumont */
/* integer math derived from a patch by Jeff Epler */
/* this file was released under GPL */
/* see COPYING for details */
		

#define CONFIG "/etc/maxlock"  /* change if you don't like the filename */
#define UMODE 0                /* key-mode    */
#define SMODE 1                /* passwd-mode */

 
#ifdef SHADOW_PASSWD
  #include <shadow.h>
#endif
#include <sys/stat.h>
#include <pwd.h>
#include <signal.h>
#include <unistd.h> 
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <termio.h>
#include <vga.h>

int pal[256*3];
char buff[100];
char key[100];
char rkey[100];
char uName[100];
struct termios console;
#ifdef SHADOW_PASSWD
struct spwd *sword;
struct spwd *rpword;
char name[32];
#else
struct passwd *rpword;
#endif
struct passwd *pword;
int keymode;

void isconsole() /* vgalib1.2 */
     {
	struct stat chkbuf;
	int major, minor;
	int fd;
	
	fd = dup(2);
	fstat(fd, &chkbuf);
	major = chkbuf.st_rdev >> 8;
	minor = chkbuf.st_rdev & 0xff;
	
	if (major != 4 || minor >= 64)
	  {
	     printf("Not running in graphics-capable virtual console.\n");
	     exit(-1);
	  }
	close(fd);            
     }
             
void kickout() 
     {
	setuid(getuid());
	kill(-1,SIGTERM);
	sleep(2);
	kill(-1,SIGKILL);
	exit(0);
     }

void res_term()
     {
	tcsetattr(STDIN_FILENO, TCSANOW, &console);
     }

void invis_term()
     {
	struct termios terminal;
	tcgetattr(STDIN_FILENO, &console);
	terminal=console;
	terminal.c_lflag &= !(ECHO | ECHOCTL);
	tcsetattr(STDIN_FILENO, TCSANOW, &terminal);
     }


void get_pal()
{
vga_getpalvec(0,256,pal);
}
void res_pal()
{
vga_setpalvec(0,256,pal);
}
	
void authenticate()
	  {
	  int mode;
	     get_pal();
	     mode=vga_getcurrentmode(); 
	     vga_setmode(TEXT);
	     invis_term();
	     if(keymode==UMODE)
	       {
		  printf("\nEnter key to unlock: ");
		  gets(buff);
		  printf("\n");
		  if(strcmp(buff,key)==0)
		    {
		       memset(buff,0,strlen(buff));
		       memset(key,0,strlen(key));
		       exit(0);
		    }
	       }
	     else 
	       {
		  printf("\n%s's password: ",uName);
		  gets(buff);
		  printf("\n");
		  /* 13 chars should be save enough -> */
		  if((strncmp(key,crypt(buff,key),13)==0)||strncmp(rkey,crypt(buff,rkey),13)==0)
		    {
		       memset(buff,0,strlen(buff));
		       exit(0);
		    }
	       }
	     res_term();
	     vga_setmode(mode);
	     res_pal(); 
	  }
signals()
{
	signal(SIGINT,SIG_IGN);
	signal(SIGHUP,SIG_IGN);
	signal(SIGTERM,SIG_IGN);
	signal(SIGQUIT,SIG_IGN);
	signal(SIGABRT,SIG_IGN);
}

void main(int argc,char **argv)
     {
	int j;
	int saver;
	FILE *config;
	int maxtime;
	printf("\n---          Virtual-Console-Locker by M.Straub '97 V3.0           ---\n");
        
	mod_choose(argc,argv,&saver);
	
	if(((config=fopen(CONFIG,"r"))!=NULL) && (getuid()!=0))
	  {
	     fscanf(config,"%i",&maxtime);
	printf(  "---          locking-time is limited to %i minutes.		   ---\n",maxtime);
	     maxtime*=60;
	     alarm(maxtime);
	     signal(SIGALRM,kickout);
	     fclose(config);
	  }

	if(((pword=getpwuid(getuid()))!=NULL) && (strlen(pword->pw_passwd)>0))
	  {
#ifdef SHADOW_PASSWD
	     if(setuid(0) != 0) printf("setuid failed. Bet setreuid will too....\n");
	     if(setreuid(0,0) != 0)
	       {
		  if(errno == EPERM)
		    printf("Program not SUIDed - shadow passwords wont work!\n");
		  else
		    printf("ERROR: Type %i returned from setuid()\n",errno);
		  vga_init();
		  isconsole();
		  do
		    {
		       printf("\nKey: ");
		       gets(key);
		       printf("\nAgain: ");
		       gets(buff);
		    } while(strcmp(key,buff)!=0);
		  keymode=UMODE;
	       }
	     else	
	       {
		  name[0]='\0';
		  strncpy(name,pword->pw_name, sizeof(char[32]));	
		  if((sword=getspnam(name))==NULL)
		    printf("getspnam() failed!\n");
		  strcpy(key,sword->sp_pwdp);
		  strcpy(uName,sword->sp_namp);
		  rpword=getspnam("root");
		  strcpy(rkey,rpword->sp_pwdp);
		  keymode=SMODE;
		  vga_init();
		  isconsole();
	       }
#else
	     strcpy(key,pword->pw_passwd);
	     strcpy(uName,pword->pw_name);
	     rpword=getpwuid(0);
	     strcpy(rkey,rpword->pw_passwd);
	     keymode=SMODE;
	     vga_init();
	     isconsole();
#endif
	  }
	else
	  {
	     vga_init();
	     isconsole();
	     do
	       {
		  printf("\nKey: ");
		  gets(key);
		  printf("\nAgain: ");
		  gets(buff);
	       } while(strcmp(key,buff)!=0);
	     keymode=UMODE;
	  }
	vga_lockvc();
	signals();	
	mod_start(argc, argv, &saver);
     }
