/*
 * dnode2.c - PTX node functions for lsof
 *
 * This module must be separate to keep separate the multiple kernel inode
 * structure definitions.
 */


/*
 * Copyright 1996 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1996 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dnode2.c,v 1.4 98/03/06 08:27:38 abe Exp $";
#endif


#include "lsof.h"

#if	defined(HASVXFS)
#define	_KERNEL
#include <sys/vx_inode.h>


/*
 * read_vxinode() - read Veritas file system inode information
 */

int
read_vxinode(v, vfs, dev)
	struct vnode *v;		/* containing vnode */
	struct l_vfs *vfs;		/* local vfs structure */
	dev_t *dev;			/* device number receiver */
{
	struct vx_inode i;

	if (!v->v_data || kread((KA_T)v->v_data, (char *)&i, sizeof(i)))
	    return(1);
/*
 * Return device number.
 */
	if (v->v_type == VCHR || v->v_type == VBLK)
	    *dev = v->v_rdev;
	else if (vfs && vfs->fsname)
	    *dev = vfs->dev;
	else
	    *dev = i.i_dev;
	Lf->dev_def = 1;
/*
 * Record inode number.
 */
	Lf->inode = (unsigned long)i.i_number;
	Lf->inp_ty = 1;
/*
 * Record size.
 */
	if (!Foffset) {
	    Lf->sz = (SZOFFTYPE)i.i_size;
	    Lf->sz_def = 1;
	}
	return(0);
}


# if	defined(HASNCACHE) && defined(HASVXFSDNLC)
/*
 * read_vxvnode() - given vx_inode address, read vnode for it
 */

int
read_vxvnode(va, v)
	KA_T va;			/* vx_inode address */
	struct vnode *v;		/* destination vnode address */
{
	struct vx_inode vi;

	if (!va || kread(va, (char *)&vi, sizeof(vi)))
	    return(0);
	*v = vi.i_vnode;
	return(0);
}
# endif	/* defined(HASNCACHE) && defined(HASVXFSDNLC) */
#endif	/* defined(HASVXFS) */
