/* anlgform.c 3.0 -- a cgi front end for analog */

/* You must uncomment the next line, and put where the analog executable is */
/* #define ANALOG "/usr/local/etc/httpd/analog/analog" */

#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#define MAXARGLENGTH (2048)   /* should be plenty */
#define STRLENGTH (64)
#define TRUE (1)
#define FALSE (0)
#define UNSET ((unsigned int)(-1))
#define WAS(a, b) (c0 == (a) && c1 == (b))
#define PRINTSTR(n, v) if ((v) != NULL) fprintf(thepipe, "%s %s\n", n, v);
#define PRINTSTR2(m, n, v) if ((v) != NULL) {fprintf(thepipe, m, n); \
                                             fprintf(thepipe, " %s\n", v);}
#define PRINTLOG(n, v) if ((v) != UNSET) fprintf(thepipe, "%s %s\n", n, v?"ON":"OFF");
#define PRINTCHAR(n, v) if ((v) != (char)UNSET) fprintf(thepipe, "%s %c\n", n, v);
#define PRINTCHAR2(m, n, v) if ((v) != (char)UNSET) {fprintf(thepipe, m, n); \
                                                 fprintf(thepipe, " %c\n", v);}
#define PRINTINT(n, v) if ((v) != (int)UNSET) fprintf(thepipe, "%s %d\n", n, v);
#define PRINTUINT(n, v) if ((v) != UNSET) fprintf(thepipe, "%s %u\n", n, v);
#define PRINTUINT2(m, n, v) if ((v) != UNSET) {fprintf(thepipe, m, n); \
                                               fprintf(thepipe, " %u\n", v);}
/* From lists in analhea2.h */
enum {REP_MONTH, REP_WEEK, REP_DAYREP, REP_DAYSUM, REP_HOURREP,	REP_HOURSUM,
      REP_QUARTER, REP_FIVE, TIMEREP_NUMBER};
char *trname[TIMEREP_NUMBER] = {"MONTHLY", "WEEKLY", "FULLDAILY", "DAILY",
				"FULLHOURLY", "HOURLY", "QUARTER", "FIVE"};
char *trpref[TIMEREP_NUMBER] = {"MONTH", "WEEK", "FULLDAY", "DAY", "FULLHOUR",
				"HOUR", "QUARTER", "FIVE"};
enum {REP_REQ, REP_REDIR, REP_FAIL, REP_TYPE, REP_DIR, REP_HOST, REP_DOM,
      REP_REF, REP_REFSITE, REP_REDIRREF, REP_FAILREF, REP_BROWREP,
      REP_BROWSUM, REP_VHOST, REP_USER, REP_FAILUSER, REP_CODE, GENREP_NUMBER};
char *grname[GENREP_NUMBER] = {"REQUEST", "REDIR", "FAILURE", "FILETYPE",
			       "DIRECTORY", "HOST", "DOMAIN", "REFERRER",
			       "REFSITE", "REDIRREF", "FAILREF", "FULLBROWSER",
			       "BROWSER", "VHOST", "USER", "FAILUSER",
			       "STATUS"};
char *grpref[GENREP_NUMBER] = {"REQ", "REDIR", "FAIL", "TYPE", "DIR", "HOST",
			       "DOM", "REF", "REFSITE", "REDIRREF", "FAILREF",
			       "FULLBROW", "BROW", "VHOST", "USER", "FAILUSER",
			       "STATUS"};
char *grinex[GENREP_NUMBER] = {"REQ", "REDIR", "FAIL", "TYPE", "DIR",
			       "HOSTREP", "DOM", "REFREP", "REFSITE",
			       "REDIRREF", "FAILREF", "FULLBROW", "BROWSUM",
			       "VHOSTREP", "USERREP", "FAILUSER", "STATUS"};
char *subitstr[GENREP_NUMBER] = {"REQARGS", "REDIRARGS", "FAILARGS", "SUBTYPE",
				 "SUBDIR", "", "SUBDOM", "REFARGS", "REFDIR",
				 "REDIRREFARGS", "FAILREFARGS", "SUBBROW", "",
				 "", "", "", ""};
enum {ITEM_VHOST, ITEM_FILE, ITEM_USER, ITEM_REFERRER, ITEM_BROWSER, ITEM_HOST,
      ITEM_NUMBER};
char *itemstr[ITEM_NUMBER] = {"VHOST", "FILE", "USER", "REF", "BROW", "HOST"};
enum {UNSAFE_CHARS, NO_QS, NO_ARGS, LONG_QS, POPEN_FAILED, PCLOSE_FAILED,
      FAILURE_NUMBER};

typedef unsigned int logical;
typedef struct {
  char graph;
  unsigned int rows;
  char *cols;
  logical on;
} Timerep;
Timerep *tr[TIMEREP_NUMBER];

typedef struct {
  char *floor, *subfloor;
  char floorby, subfloorby;
  unsigned int sortby, subsortby;
  char *subitems, *include, *exclude, *cols;
  logical on;
} Genrep;
Genrep *gr[GENREP_NUMBER];

typedef struct {
  char *include, *exclude;
  unsigned int lowmem;
} Item;
Item *it[ITEM_NUMBER];

void my_exit(int rc) {

  if (rc == UNSAFE_CHARS) {
    fprintf(stderr, "Analog form interface: SECURITY WARNING on request from %s (%s): QUERY_STRING contains unusual characters\n",
     (getenv("REMOTE_HOST") == NULL)?"unknown host":getenv("REMOTE_HOST"),
     (getenv("REMOTE_ADDR") == NULL)?"unknown address":getenv("REMOTE_ADDR"));
    printf("Content-type: text/plain\n\nError in QUERY_STRING\n");
  }
  else if (rc == LONG_QS) {
    fprintf(stderr, "Analog form interface: SECURITY WARNING on request from %s (%s): QUERY_STRING too long\n",
     (getenv("REMOTE_HOST") == NULL)?"unknown host":getenv("REMOTE_HOST"),
     (getenv("REMOTE_ADDR") == NULL)?"unknown address":getenv("REMOTE_ADDR"));
    printf("Content-type: text/plain\n\nError in QUERY_STRING\n");
  }
  else if (rc == NO_QS)
    printf("Content-type: text/plain\n\nQUERY_STRING not found\n");
  else if (rc == NO_ARGS)
    printf("Content-type: text/plain\n\nno arguments supplied\n");
  else if (rc == POPEN_FAILED)
    printf("Content-type: text/plain\n\ncannot start analog program at %s\n",
	   ANALOG);
  else if (rc == PCLOSE_FAILED) {
    printf("Analog failed to run or returned an error code.\n");
    printf("Maybe your server's error log will give a clue why.\n");
  }
  exit(EXIT_FAILURE);
}

void decode(char *s) {
  char *t;
  int i;

  for (t = s; *t != '\0'; t++) {  /* + becomes space */
    if (*s == '+')
      *s = ' ';
  }
  for (t = s; (t = strchr(t, '%')) != NULL; t++) {  /* %ab interpreted */
    sscanf(t + 1, "%2x", &i);
    if (i >= 0x20 && i < 0x7F) {
      *t = i;
      memmove(t + 1, t + 3, strlen(t + 2));
    }
  }
  for (t = s; *t != '\0'; t++) { /* check no unsafe characters */
    if (*t == ';' || *t == '\n' || *t == '\r' || *t == '`' || *t == '|' ||
	*t == '<' || *t == '>')
      my_exit(UNSAFE_CHARS);
  }
}

void timerep(char c0, char c1, logical lc, char *val) {
  Timerep *tp;

  if (c0 == 'd' && lc)
    tp = tr[REP_DAYSUM];
  else if (c0 == 'd')
    tp = tr[REP_DAYREP];
  else if (c0 == 'h' && lc)
    tp = tr[REP_HOURSUM];
  else if (c0 == 'h')
    tp = tr[REP_HOURREP];
  else if (c0 == 'm')
    tp = tr[REP_MONTH];
  else if (c0 == 'p')
    tp = tr[REP_FIVE];
  else if (c0 == 'q')
    tp = tr[REP_QUARTER];
  else
    tp = tr[REP_WEEK];

  if (c1 == 'c' || c1 == 'd')
    tp -> cols = val;
  else if (c1 == 'g' || c1 == 'h')
    tp -> graph = val[0];
  else if (c1 == 'r' || c1 == 's')
    tp -> rows = (unsigned int)atoi(val);
  else if (c1 == 'p' || c1 == 'q')
    tp -> on = (val[0] != '0');
}

void genrep(char c0, char c1, logical lc, char *val) {
  Genrep *gp;

  if (c0 == 'b' && lc)
    gp = gr[REP_BROWSUM];
  else if (c0 == 'b')
    gp = gr[REP_BROWREP];
  else if (c0 == 'c')
    gp = gr[REP_CODE];
  else if (c0 == 'e')
    gp = gr[REP_REDIR];
  else if (c0 == 'f')
    gp = gr[REP_REF];
  else if (c0 == 'i' && lc)
    gp = gr[REP_DIR];
  else if (c0 == 'i')
    gp = gr[REP_FAIL];
  else if (c0 == 'j')
    gp = gr[REP_FAILUSER];
  else if (c0 == 'k' && lc)
    gp = gr[REP_REDIRREF];
  else if (c0 == 'k')
    gp = gr[REP_FAILREF];
  else if (c0 == 'o')
    gp = gr[REP_DOM];
  else if (c0 == 'r')
    gp = gr[REP_REQ];
  else if (c0 == 's' && lc)
    gp = gr[REP_REFSITE];
  else if (c0 == 's')
    gp = gr[REP_HOST];
  else if (c0 == 't')
    gp = gr[REP_TYPE];
  else if (c0 == 'u')
    gp = gr[REP_USER];
  else
    gp = gr[REP_VHOST];

  if (c1 == 'c' || c1 == 'd')
    gp -> cols = val;
  else if (c1 == 'f' || c1 == 'g')
    gp -> floor = val;
  else if (c1 == 'h' || c1 == 'i')
    gp -> floorby = val[0];
  else if (c1 == 'j' || c1 == 'k')
    gp -> subitems = val;
  else if (c1 == 'l' || c1 == 'm')
    gp -> include = val;
  else if (c1 == 'n' || c1 == 'o')
    gp -> exclude = val;
  else if (c1 == 'p' || c1 == 'q')
    gp -> on = (val[0] != '0');
  else if (c1 == 's' || c1 == 't')
    gp -> sortby = (unsigned int)atoi(val);
  else if (c1 == 'u' || c1 == 'v')
    gp -> subsortby = (unsigned int)atoi(val);
  else if (c1 == 'w' || c1 == 'x')
    gp -> subfloor = val;
  else if (c1 == 'y' || c1 == 'z')
    gp -> subfloorby = val[0];
}

void item(char c0, char c1, char *val) {
  Item *ip;

  if (c0 == 'b')
    ip = it[ITEM_BROWSER];
  else if (c0 == 'f')
    ip = it[ITEM_REFERRER];
  else if (c0 == 'r')
    ip = it[ITEM_FILE];
  else if (c0 == 's')
    ip = it[ITEM_HOST];
  else if (c0 == 'u')
    ip = it[ITEM_USER];
  else
    ip = it[ITEM_VHOST];

  if (c1 == 'k')
    ip -> lowmem = (unsigned int)atoi(val);
  else if (c1 == 'x')
    ip -> include = val;
  else if (c1 == 'z')
    ip -> exclude = val;
}

int main(void) {
  char *args, *nextarg, *val;
  FILE *thepipe;
  char *baseurl = NULL, *cg1 = NULL, *cg2 = NULL, *compsep = NULL;
  char *domfile = NULL, *dirsuff = NULL, *dnsfile = NULL, *from = NULL;
  char *hostname = NULL, *hosturl = NULL, *imagedir = NULL, *lang = NULL;
  char *cachefile = NULL, *langfile = NULL, *logo = NULL, *logfile = NULL;
  char *logfmt = NULL, *reportorder = NULL, *to = NULL, *tz = NULL;
  char *sizecols = NULL, *pageinc = NULL, *pageexc = NULL, *linkinc = NULL;
  char *linkexc = NULL, *reflinkinc = NULL, *reflinkexc = NULL;
  char *argsinc = NULL, *argsexc = NULL, *refargsinc = NULL;
  char *refargsexc = NULL;
  logical allback = UNSET, cas = UNSET, settings = FALSE, gotos = UNSET;
  logical gensum = UNSET, warn = FALSE, sizerep = UNSET, last7 = UNSET;
  logical rawbytes = UNSET;
  unsigned int dnsgood = UNSET, dnsbad = UNSET, mgw = UNSET, output = 0;
  unsigned int pagewidth = UNSET, weekbeg = UNSET;
  int timeoffset = (int)UNSET, logtimeoffset = (int)UNSET;
  char markchar = (char)UNSET, decpt = (char)UNSET;
  char sepchar = (char)UNSET, repsepchar = (char)UNSET;
  char TZenv[STRLENGTH];
  char c0, c1;
  int i;

  /* initialise */
  if ((args = getenv("QUERY_STRING")) == NULL)
    my_exit(NO_QS);
  if (args[0] == '\0')
    my_exit(NO_ARGS);
  if (strlen(args) >= MAXARGLENGTH - 1)
    my_exit(LONG_QS);

  for (i = 0; i < TIMEREP_NUMBER; i++) {
    tr[i] = (Timerep *)malloc(sizeof(Timerep));
    tr[i] -> graph = (char)UNSET;
    tr[i] -> rows = UNSET;
    tr[i] -> cols = NULL;
    tr[i] -> on = UNSET;
  }
  for (i = 0; i < GENREP_NUMBER; i++) {
    gr[i] = (Genrep *)malloc(sizeof(Genrep));
    gr[i] -> floor = NULL;
    gr[i] -> floorby = (char)UNSET;
    gr[i] -> sortby = UNSET;
    gr[i] -> subfloor = NULL;
    gr[i] -> subfloorby = (char)UNSET;
    gr[i] -> subsortby = UNSET;
    gr[i] -> subitems = NULL;
    gr[i] -> include = NULL;
    gr[i] -> exclude = NULL;
    gr[i] -> cols = NULL;
    gr[i] -> on = UNSET;
  }
  for (i = 0; i < ITEM_NUMBER; i++) {
    it[i] = (Item *)malloc(sizeof(Item));
    it[i] -> include = NULL;
    it[i] -> exclude = NULL;
    it[i] -> lowmem = UNSET;
  }

  /* interpret arguments */
  for (nextarg = strtok(args, "&"); nextarg != NULL;
       nextarg = strtok(NULL, "&")) {
    if (isalpha(*nextarg) && isalpha(*(nextarg + 1)) &&
	*(nextarg + 2) == '=' && *(nextarg + 3) != '\0') {
      val = nextarg + 3;
      decode(val);
      c0 = tolower(nextarg[0]);
      c1 = tolower(nextarg[1]);
      if ((c0 == 'd' || c0 == 'h' || c0 == 'm' || c0 == 'p' || c0 == 'q') &&
	  (c1 == 'c' || c1 == 'g' || c1 == 'q' || c1 == 'r'))
	timerep(c0, c1, TRUE, val);    /* l.c. timereps */
      else if ((c0 == 'd' || c0 == 'h' || c0 == 'w') &&
	  (c1 == 'd' || c1 == 'h' || c1 == 'p' || c1 == 's'))
	timerep(c0, c1, FALSE, val);   /* u.c. timereps */
      else if ((c0 == 'b' || c0 == 'c' || c0 == 'f' || c0 == 'i' || c0 == 'k'
		|| c0 == 'o' || c0 == 'r' || c0 == 's' || c0 == 't' ||
		c0 == 'u' || c0 == 'v') &&
	       (c1 == 'c' || c1 == 'f' || c1 == 'h' || c1 == 'l' || c1 == 'n'
		|| c1 == 'q' || c1 == 's'))
	genrep(c0, c1, TRUE, val);  /* l.c. genreps */
      else if ((c0 == 'b' || c0 == 'e' || c0 == 'i' || c0 == 'j' || c0 == 'k'
		|| c0 == 's') &&
	       (c1 == 'd' || c1 == 'g' || c1 == 'i' || c1 == 'm' || c1 == 'o'
		|| c1 == 'p' || c1 == 't'))
	genrep(c0, c1, FALSE, val);  /* u.c. genreps */
      else if ((c0 == 'b' || c0 == 'f' || c0 == 'i' || c0 == 'k' || c0 == 'o'
		|| c0 == 'r' || c0 == 's' || c0 == 't') &&
	       (c1 == 'u' || c1 == 'w' || c1 == 'y'))
	genrep(c0, c1, TRUE, val);  /* l.c. hierreps */
      else if ((c0 == 'e' || c0 == 'i' || c0 == 'k') &&
	       (c1 == 'v' || c1 == 'x' || c1 == 'z'))
	genrep(c0, c1, FALSE, val);  /* u.c. hierreps */
      else if ((c0 == 'b' || c0 == 'f' || c0 == 'i' || c0 == 'o' || c0 == 't')
	       && (c1 == 'j')) /* true hierreps, all l.c. */
	genrep(c0, c1, TRUE, val);
      else if ((c0 == 'b' || c0 == 'f' || c0 == 'r' || c0 == 's' || c0 == 'u'
		|| c0 == 'v') && (c1 == 'k' || c1 == 'x' || c1 == 'z'))
	item(c0, c1, val);  /* items */
      else if (WAS('a', 'b'))
	allback = (val[0] != '0');
      else if (WAS('b', 'a'))
	baseurl = val;
      else if (WAS('c', 'a'))
	cas = (val[0] != '0');
      else if (WAS('c', 'g'))
	cg1 = val;
      else if (WAS('c', 'm'))
	cg2 = val;
      else if (WAS('c', 'p'))
	compsep = val;
      else if (WAS('d', 'a'))
	dnsgood = (unsigned int)atoi(val);
      else if (WAS('d', 'b'))
	dnsbad = (unsigned int)atoi(val);
      else if (WAS('d', 'e'))
	decpt = val[0];
      else if (WAS('d', 'f'))
	domfile = val;
      else if (WAS('d', 'i'))
	dirsuff = val;
      else if (WAS('d', 'n'))
	dnsfile = val;
      else if (WAS('f', 'r'))
	from = val;
      else if (WAS('g', 'w'))
	mgw = (unsigned int)atoi(val);
      else if (WAS('h', 'n'))
	hostname = val;
      else if (WAS('h', 'u'))
	hosturl = val;
      else if (WAS('i', 'e'))
	imagedir = val;
      else if (WAS('l', 'a'))
	lang = val;
      else if (WAS('l', 'c'))
	cachefile = val;
      else if (WAS('l', 'f'))
	langfile = val;
      else if (WAS('l', 'g'))
	logo = val;
      else if (WAS('l', 'm'))
	logfmt = val;
      else if (WAS('l', 'o'))
	logfile = val;
      else if (WAS('l', 's'))
	last7 = (val[0] != '0');
      else if (WAS('l', 't'))
	logtimeoffset = atoi(val);
      else if (WAS('l', 'w'))
	reflinkinc = val;
      else if (WAS('l', 'x'))
	linkinc = val;
      else if (WAS('l', 'y'))
	reflinkexc = val;
      else if (WAS('l', 'z'))
	linkexc = val;
      else if (WAS('m', 'a'))
	markchar = val[0];
      else if (WAS('o', 't'))
	output = (unsigned int)atoi(val);
      else if (WAS('p', 'w'))
	pagewidth = (unsigned int)atoi(val);
      else if (WAS('p', 'x'))
	pageinc = val;
      else if (WAS('p', 'z'))
	pageexc = val;
      else if (WAS('q', 'v'))
	settings = TRUE;
      else if (WAS('r', 'b'))
	rawbytes = (val[0] != '0');
      else if (WAS('r', 'e'))
	reportorder = val;
      else if (WAS('s', 'a'))
	sepchar = val[0];
      else if (WAS('s', 'b'))
	repsepchar = val[0];
      else if (WAS('t', 'm'))
	timeoffset = atoi(val);
      else if (WAS('t', 'o'))
	to = val;
      else if (WAS('t', 'z'))
	tz = val;
      else if (WAS('w', 'a'))
	warn = (val[0] != '0');
      else if (WAS('w', 'b'))
	weekbeg = (unsigned int)atoi(val);
      else if (WAS('x', 'p'))
	gotos = (val[0] != '0');
      else if (WAS('x', 'q'))
	gensum = (val[0] != '0');
      else if (WAS('y', 'w'))
	refargsinc = val;
      else if (WAS('y', 'x'))
	argsinc = val;
      else if (WAS('y', 'y'))
	refargsexc = val;
      else if (WAS('y', 'z'))
	argsexc = val;
      else if (WAS('z', 'c'))
	sizecols = val;
      else if (WAS('z', 'q'))
	sizerep = (val[0] != '0');
    }
  }

  if (tz != NULL) {
    strcpy(TZenv, "TZ=");
    strncat(TZenv, tz, STRLENGTH - 4);
    putenv(TZenv);
  }

  /* start program */
  if (settings)
    thepipe = stdout;
  else if ((thepipe = popen(ANALOG " +g-", "w")) == NULL)
    my_exit(POPEN_FAILED);

  printf("Content-type: text/%s\n\n", (settings || output)?"plain":"html");
  fflush(stdout);
  fprintf(thepipe, "OUTFILE stdout\n");

  /* pass arguments to program */
  PRINTSTR("CONFIGFILE", cg1);

  for (i = 0; i < TIMEREP_NUMBER; i++) {
    PRINTLOG(trname[i], tr[i] -> on);
    PRINTCHAR2("%sGRAPH", trpref[i], tr[i] -> graph);
    PRINTUINT2("%sROWS", trpref[i], tr[i] -> rows);
    PRINTSTR2("%sCOLS", trpref[i], tr[i] -> cols);
  }

  for (i = 0; i < GENREP_NUMBER; i++) {
    PRINTLOG(grname[i], (gr[i] -> on));
    if (gr[i] -> floor != NULL && gr[i] -> floorby != (char)UNSET)
      fprintf(thepipe, "%sFLOOR %s%c\n", grpref[i], gr[i] -> floor,
	      gr[i] -> floorby);
    if (gr[i] -> sortby != UNSET) {
      if (gr[i] -> sortby == 0)
	fprintf(thepipe, "%sSORTBY REQUESTS\n", grpref[i]);
      else if (gr[i] -> sortby == 1)
	fprintf(thepipe, "%sSORTBY PAGES\n", grpref[i]);
      else if (gr[i] -> sortby == 2)
	fprintf(thepipe, "%sSORTBY BYTES\n", grpref[i]);
      else if (gr[i] -> sortby == 3)
	fprintf(thepipe, "%sSORTBY DATE\n", grpref[i]);
      else if (gr[i] -> sortby == 4)
	fprintf(thepipe, "%sSORTBY ALPHABETICAL\n", grpref[i]);
      else
	fprintf(thepipe, "%sSORTBY RANDOM\n", grpref[i]);
    }
    PRINTSTR(subitstr[i], gr[i] -> subitems);
    if (gr[i] -> subfloor != NULL && gr[i] -> subfloorby != (char)UNSET)
      fprintf(thepipe, "%sFLOOR %s%c\n", subitstr[i], gr[i] -> subfloor,
	      gr[i] -> subfloorby);
    if (gr[i] -> subsortby != UNSET) {
      if (gr[i] -> subsortby == 0)
	fprintf(thepipe, "%sSORTBY REQUESTS\n", subitstr[i]);
      else if (gr[i] -> subsortby == 1)
	fprintf(thepipe, "%sSORTBY PAGES\n", subitstr[i]);
      else if (gr[i] -> subsortby == 2)
	fprintf(thepipe, "%sSORTBY BYTES\n", subitstr[i]);
      else if (gr[i] -> subsortby == 3)
	fprintf(thepipe, "%sSORTBY DATE\n", subitstr[i]);
      else if (gr[i] -> subsortby == 4)
	fprintf(thepipe, "%sSORTBY ALPHABETICAL\n", subitstr[i]);
      else
	fprintf(thepipe, "%sSORTBY RANDOM\n", subitstr[i]);
    }
    PRINTSTR2("%sCOLS", grpref[i], gr[i] -> cols);
    PRINTSTR2("%sINCLUDE", grinex[i], gr[i] -> include);
    PRINTSTR2("%sEXCLUDE", grinex[i], gr[i] -> exclude);
  }

  for (i = 0; i < ITEM_NUMBER; i++) {
    PRINTUINT2("%sLOWMEM", itemstr[i], it[i] -> lowmem);
    PRINTSTR2("%sINCLUDE", itemstr[i], it[i] -> include);
    PRINTSTR2("%sEXCLUDE", itemstr[i], it[i] -> exclude);
  }

  PRINTINT("TIMEOFFSET", timeoffset);
  PRINTINT("LOGTIMEOFFSET", logtimeoffset);
  PRINTSTR("LOGFORMAT", logfmt);
  PRINTSTR("BASEURL", baseurl);
  PRINTSTR("COMPSEP", compsep);
  PRINTSTR("DOMFILE", domfile);
  PRINTSTR("DIRSUFFIX", dirsuff);
  PRINTSTR("FROM", from);
  PRINTSTR("HOSTNAME", hostname);
  PRINTSTR("HOSTURL", hosturl);
  PRINTSTR("IMAGEDIR", imagedir);
  PRINTSTR("CACHEFILE", cachefile);
  PRINTSTR("LOGO", logo);
  PRINTSTR("LOGFILE", logfile);
  PRINTSTR("REFLINKINCLUDE", reflinkinc);
  PRINTSTR("REFLINKEXCLUDE", reflinkexc);
  PRINTSTR("LINKINCLUDE", linkinc);
  PRINTSTR("LINKEXCLUDE", linkexc);
  PRINTSTR("PAGEINCLUDE", pageinc);
  PRINTSTR("PAGEEXCLUDE", pageexc);
  PRINTSTR("REPORTORDER", reportorder);
  PRINTSTR("TO", to);
  PRINTSTR("REFARGSINCLUDE", refargsinc);
  PRINTSTR("REFARGSEXCLUDE", refargsexc);
  PRINTSTR("ARGSINCLUDE", argsinc);
  PRINTSTR("ARGSEXCLUDE", argsexc);
  PRINTSTR("SIZECOLS", sizecols);
  PRINTLOG("ALLBACK", allback);
  PRINTLOG("GOTOS", gotos);
  PRINTLOG("GENERAL", gensum);
  PRINTLOG("RAWBYTES", rawbytes);
  PRINTLOG("WARNINGS", warn);
  PRINTLOG("SIZE", sizerep);
  PRINTLOG("LASTSEVEN", last7);
  PRINTUINT("DNSGOODHOURS", dnsgood);
  PRINTUINT("DNSBADHOURS", dnsbad);
  PRINTUINT("MINGRAPHWIDTH", mgw);
  PRINTUINT("PAGEWIDTH", pagewidth);
  PRINTCHAR("MARKCHAR", markchar);
  PRINTCHAR("DECPOINT", decpt);
  PRINTCHAR("SEPCHAR", sepchar);
  PRINTCHAR("REPSEPCHAR", repsepchar);
  if (cas != UNSET)
    fprintf(thepipe, "CASE %s", cas?"SENSITIVE":"INSENSITIVE");
  fprintf(thepipe, "OUTPUT ");
  if (output == 0)
    fprintf(thepipe, "HTML\n");
  else if (output == 2)
    fprintf(thepipe, "COMPUTER\n");
  else
    fprintf(thepipe, "ASCII\n");
  if (weekbeg != UNSET) {
    fprintf(thepipe, "WEEKBEGINSON ");
    if (weekbeg == 1)
      fprintf(thepipe, "MONDAY\n");
    else if (weekbeg == 2)
      fprintf(thepipe, "TUESDAY\n");
    else if (weekbeg == 3)
      fprintf(thepipe, "WEDNESDAY\n");
    else if (weekbeg == 4)
      fprintf(thepipe, "THURSDAY\n");
    else if (weekbeg == 5)
      fprintf(thepipe, "FRIDAY\n");
    else if (weekbeg == 6)
      fprintf(thepipe, "SATURDAY\n");
    else
      fprintf(thepipe, "SUNDAY\n");
  }
  fprintf(thepipe, "DNS NONE\n");
  PRINTSTR("DNS READ\nDNSFILE", dnsfile);
  if (langfile != NULL)
    fprintf(thepipe, "LANGFILE %s\n", langfile);
  else if (lang != NULL)
    fprintf(thepipe, "LANGUAGE %s\n", lang);

  PRINTSTR("CONFIGFILE", cg2);

  /* wind up */
  if (!settings) {
    fflush(thepipe);
    if (pclose(thepipe) != 0)
      my_exit(PCLOSE_FAILED);
  }
  fflush(stdout);
  return(EXIT_SUCCESS);
}
