#ifndef ___ARENA_HISTORY_H___
#  define ___ARENA_HISTORY_H___
/*
 * QingLong.12-12-96
 */

#  include "WWWCore.h"
#  include "display_types.h"


typedef enum
{
  HISTORY_NOTREGISTERED = 0,
  HISTORY_REGISTERED    = 1,
  HISTORY_VERIFIED      = 2,
  HISTORY_DELETED       = 3
} HistoryState;

typedef struct s_history
{
 HistoryState state; 
 HTAnchor* anchor;
 char *tag;
 long y;
 char *title;
 /* time etc */
} History;


extern Bool    GotoDoc(GC gc, ViewWindow view_window, int pos);
extern Bool ForwardDoc(GC gc, ViewWindow view_window);
extern Bool    BackDoc(GC gc, ViewWindow view_window);
extern Bool    HomeDoc(GC gc, ViewWindow view_window);

extern int      HistoryMode(int new_mode);
extern void     HistoryAllowMarkForDeath(Bool flag);
extern Bool     HistoryCanMarkForDeath(void);

extern History* NewHistory(void);
extern void     FreeHistory(History* h);

extern History* HistoryRecord(HTAnchor* a);
extern Bool     HistoryVerify(HTAnchor* a);
extern Bool     HistoryDelete(HTAnchor* a);
extern void     HistoryCleanUp(void);

#endif /* ___ARENA_HISTORY_H___ */
