#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>
#include <X11/cursorfont.h>

#include "defs.h"
#include "colour.h"
#ifdef ARENA_DEBUG	/* QingLong.26-12-96 */
#  include "debug.h"
# else
#  include "error.h"
#endif
#include "main.h"
#include "parsehtml.h"
#include "style.h"
#include "util.h"
#include "x11.h"


static Bool busy = False; /* blocks hypertext links etc while receiving data */


Bool ParseColour(const char *s, long *value_p)
{
 char *sp;
 long colour;


 switch (TOLOWER(*s))
   {
    case 'a':
      if (!strcasecmp("aliceblue", s))
	{ 
	  *value_p = (240 << 16) | (248 << 8) | 255; return True;
        } else
        if (!strcasecmp("antiquewhite", s)) { 
	  *value_p = (250 << 16) | (235 << 8) | 215; return True;
        } else
        if (!strcasecmp("aqua", s)) { 
	  *value_p = (0 << 16) | (255 << 8) | 255; return True;
        } else
        if (!strcasecmp("aquamarine", s)) { 
	  *value_p = (127 << 16) | (255 << 8) | 212; return True;
        } else
        if (!strcasecmp("azure", s)) { 
	  *value_p = (240 << 16) | (255 << 8) | 255; return True;
        }
        break;

    case 'b':
        if (!strcasecmp("beige", s)) { 
	  *value_p = (245 << 16) | (245 << 8) | 220; return True;
        } else
        if (!strcasecmp("bisque", s)) { 
	  *value_p = (255 << 16) | (228 << 8) | 196; return True;
        } else
        if (!strcasecmp("black", s)) { 
	  *value_p = (0 << 16) | (0 << 8) | 0; return True;
        } else
        if (!strcasecmp("blanchedalmond", s)) { 
	  *value_p = (255 << 16) | (235 << 8) | 205; return True;
        } else
        if (!strcasecmp("blue", s)) { 
	  *value_p = (0 << 16) | (0 << 8) | 255; return True;
        } else
        if (!strcasecmp("blueviolet", s)) { 
	  *value_p = (138 << 16) | (43 << 8) | 226; return True;
        } else
        if (!strcasecmp("brown", s)) { 
	  *value_p = (165 << 16) | (42 << 8) | 42; return True;
        } else
        if (!strcasecmp("burlywood", s)) { 
	  *value_p = (222 << 16) | (184 << 8) | 135; return True;
        }
        break;

    case 'c':
        if (!strcasecmp("cadetblue", s)) { 
	  *value_p = (95 << 16) | (158 << 8) | 160; return True;
        } else
        if (!strcasecmp("chartreuse", s)) { 
	  *value_p = (127 << 16) | (255 << 8) | 0; return True;
        } else
        if (!strcasecmp("chocolate", s)) { 
	  *value_p = (210 << 16) | (105 << 8) | 30; return True;
        } else
        if (!strcasecmp("coral", s)) { 
	  *value_p = (255 << 16) | (127 << 8) | 80; return True;
        } else
        if (!strcasecmp("cornflowerblue", s)) { 
	  *value_p = (100 << 16) | (149 << 8) | 237; return True;
        } else
        if (!strcasecmp("cornsilk", s)) { 
	  *value_p = (255 << 16) | (248 << 8) | 220; return True;
        } else
        if (!strcasecmp("crimson", s)) { 
	  *value_p = (220 << 16) | (20 << 8) | 60; return True;
        } else
        if (!strcasecmp("cyan", s)) { 
	  *value_p = (0 << 16) | (255 << 8) | 255; return True;
        }
        break;

    case 'd':
        if (!strcasecmp("darkblue", s)) { 
	  *value_p = (0 << 16) | (0 << 8) | 139; return True;
        } else
        if (!strcasecmp("darkcyan", s)) { 
	  *value_p = (0 << 16) | (139 << 8) | 139; return True;
        } else
        if (!strcasecmp("darkgoldenrod", s)) { 
	  *value_p = (184 << 16) | (134 << 8) | 11; return True;
        } else
        if (!strcasecmp("darkgray", s)) { 
	  *value_p = (169 << 16) | (169 << 8) | 169; return True;
        } else
        if (!strcasecmp("darkgreen", s)) { 
	  *value_p = (0 << 16) | (100 << 8) | 0; return True;
        } else
        if (!strcasecmp("darkkhaki", s)) { 
	  *value_p = (189 << 16) | (183 << 8) | 107; return True;
        } else
        if (!strcasecmp("darkmagenta", s)) { 
	  *value_p = (139 << 16) | (0 << 8) | 139; return True;
        } else
        if (!strcasecmp("darkolivegreen", s)) { 
	  *value_p = (85 << 16) | (107 << 8) | 47; return True;
        } else
        if (!strcasecmp("darkorange", s)) { 
	  *value_p = (255 << 16) | (140 << 8) | 0; return True;
        } else
        if (!strcasecmp("darkorchid", s)) { 
	  *value_p = (153 << 16) | (50 << 8) | 204; return True;
        } else
        if (!strcasecmp("darkred", s)) { 
	  *value_p = (139 << 16) | (0 << 8) | 0; return True;
        } else
        if (!strcasecmp("darksalmon", s)) { 
	  *value_p = (233 << 16) | (150 << 8) | 122; return True;
        } else
        if (!strcasecmp("darkseagreen", s)) { 
	  *value_p = (143 << 16) | (188 << 8) | 143; return True;
        } else
        if (!strcasecmp("darkslateblue", s)) { 
	  *value_p = (72 << 16) | (61 << 8) | 139; return True;
        } else
        if (!strcasecmp("darkslategray", s)) { 
	  *value_p = (47 << 16) | (79 << 8) | 79; return True;
        } else
        if (!strcasecmp("darkturquoise", s)) { 
	  *value_p = (0 << 16) | (206 << 8) | 209; return True;
        } else
        if (!strcasecmp("darkviolet", s)) { 
	  *value_p = (148 << 16) | (0 << 8) | 211; return True;
        } else
        if (!strcasecmp("deeppink", s)) { 
	  *value_p = (255 << 16) | (20 << 8) | 147; return True;
        } else
        if (!strcasecmp("deepskyblue", s)) { 
	  *value_p = (0 << 16) | (191 << 8) | 255; return True;
        } else
        if (!strcasecmp("dimgray", s)) { 
	  *value_p = (105 << 16) | (105 << 8) | 105; return True;
        } else
        if (!strcasecmp("dodgerblue", s)) { 
	  *value_p = (30 << 16) | (144 << 8) | 255; return True;
        }
        break;

    case 'f':
        if (!strcasecmp("firebrick", s)) { 
	  *value_p = (178 << 16) | (34 << 8) | 34; return True;
        } else
        if (!strcasecmp("floralwhite", s)) { 
	  *value_p = (255 << 16) | (250 << 8) | 240; return True;
        } else
        if (!strcasecmp("forestgreen", s)) { 
	  *value_p = (34 << 16) | (139 << 8) | 34; return True;
        } else
        if (!strcasecmp("fuchsia", s)) { 
	  *value_p = (255 << 16) | (0 << 8) | 255; return True;
        }
        break;

    case 'g':
        if (!strcasecmp("gainsboro", s)) { 
	  *value_p = (220 << 16) | (220 << 8) | 220; return True;
        } else
        if (!strcasecmp("ghostwhite", s)) { 
	  *value_p = (248 << 16) | (248 << 8) | 255; return True;
        } else
        if (!strcasecmp("gold", s)) { 
	  *value_p = (255 << 16) | (215 << 8) | 0; return True;
        } else
        if (!strcasecmp("goldenrod", s)) { 
	  *value_p = (218 << 16) | (165 << 8) | 32; return True;
        } else
        if (!strcasecmp("gray", s)) { 
	  *value_p = (128 << 16) | (128 << 8) | 128; return True;
        } else
        if (!strcasecmp("green", s)) { 
	  *value_p = (0 << 16) | (128 << 8) | 0; return True;
        } else
        if (!strcasecmp("greenyellow", s)) { 
	  *value_p = (173 << 16) | (255 << 8) | 47; return True;
        }
        break;

    case 'h':
        if (!strcasecmp("honeydew", s)) { 
	  *value_p = (240 << 16) | (255 << 8) | 240; return True;
        } else
        if (!strcasecmp("hotpink", s)) { 
	  *value_p = (255 << 16) | (105 << 8) | 180; return True;
        }
        break;

    case 'i':
        if (!strcasecmp("indianred", s)) { 
	  *value_p = (205 << 16) | (92 << 8) | 92; return True;
        } else
	if (!strcasecmp("indigo", s)) { 
	  *value_p = (75 << 16) | (0 << 8) | 130; return True;
        } else
        if (!strcasecmp("ivory", s)) { 
	  *value_p = (255 << 16) | (255 << 8) | 240; return True;
        }
        break;

    case 'k':
        if (!strcasecmp("khaki", s)) { 
	  *value_p = (240 << 16) | (230 << 8) | 140; return True;
        }
        break;

    case 'l':
        if (!strcasecmp("lavender", s)) { 
	  *value_p = (230 << 16) | (230 << 8) | 250; return True;
        } else
        if (!strcasecmp("lavenderblush", s)) { 
	  *value_p = (255 << 16) | (240 << 8) | 245; return True;
        } else
        if (!strcasecmp("lawngreen", s)) { 
	  *value_p = (124 << 16) | (252 << 8) | 0; return True;
        } else
        if (!strcasecmp("lemonchiffon", s)) { 
	  *value_p = (255 << 16) | (250 << 8) | 205; return True;
        } else
        if (!strcasecmp("lightblue", s)) { 
	  *value_p = (173 << 16) | (216 << 8) | 230; return True;
        } else
        if (!strcasecmp("lightcoral", s)) { 
	  *value_p = (240 << 16) | (128 << 8) | 128; return True;
        } else
        if (!strcasecmp("lightcyan", s)) { 
	  *value_p = (224 << 16) | (255 << 8) | 255; return True;
        } else
        if (!strcasecmp("lightgoldenrodyellow", s)) { 
	  *value_p = (250 << 16) | (250 << 8) | 210; return True;
        } else
        if (!strcasecmp("lightgreen", s)) { 
	  *value_p = (144 << 16) | (238 << 8) | 144; return True;
        } else
        if (!strcasecmp("lightgrey", s)) { 
	  *value_p = (211 << 16) | (211 << 8) | 211; return True;
        } else
        if (!strcasecmp("lightpink", s)) { 
	  *value_p = (255 << 16) | (182 << 8) | 193; return True;
        } else
        if (!strcasecmp("lightsalmon", s)) { 
	  *value_p = (255 << 16) | (160 << 8) | 122; return True;
        } else
        if (!strcasecmp("lightseagreen", s)) { 
	  *value_p = (32 << 16) | (178 << 8) | 170; return True;
        } else
        if (!strcasecmp("lightskyblue", s)) { 
	  *value_p = (135 << 16) | (206 << 8) | 250; return True;
        } else
        if (!strcasecmp("lightslategray", s)) { 
	  *value_p = (119 << 16) | (136 << 8) | 153; return True;
        } else
        if (!strcasecmp("lightsteelblue", s)) { 
	  *value_p = (176 << 16) | (196 << 8) | 222; return True;
        } else
        if (!strcasecmp("lightyellow", s)) { 
	  *value_p = (255 << 16) | (255 << 8) | 224; return True;
        } else
        if (!strcasecmp("lime", s)) { 
	  *value_p = (0 << 16) | (255 << 8) | 0; return True;
        } else
        if (!strcasecmp("limegreen", s)) { 
	  *value_p = (50 << 16) | (205 << 8) | 50; return True;
        } else
        if (!strcasecmp("linen", s)) { 
	  *value_p = (250 << 16) | (240 << 8) | 230; return True;
        }
        break;

    case 'm':
        if (!strcasecmp("magenta", s)) { 
	  *value_p = (255 << 16) | (0 << 8) | 255; return True;
        } else
        if (!strcasecmp("maroon", s)) { 
	  *value_p = (128 << 16) | (0 << 8) | 0; return True;
        } else
        if (!strcasecmp("mediumaquamarine", s)) { 
	  *value_p = (102 << 16) | (205 << 8) | 170; return True;
        } else
        if (!strcasecmp("mediumblue", s)) { 
	  *value_p = (0 << 16) | (0 << 8) | 205; return True;
        } else
        if (!strcasecmp("mediumorchid", s)) { 
	  *value_p = (186 << 16) | (85 << 8) | 211; return True;
        } else
        if (!strcasecmp("mediumpurple", s)) { 
	  *value_p = (147 << 16) | (112 << 8) | 219; return True;
        } else
        if (!strcasecmp("mediumseagreen", s)) { 
	  *value_p = (60 << 16) | (179 << 8) | 113; return True;
        } else
        if (!strcasecmp("mediumslateblue", s)) { 
	  *value_p = (123 << 16) | (104 << 8) | 238; return True;
        } else
        if (!strcasecmp("mediumspringgreen", s)) { 
	  *value_p = (0 << 16) | (250 << 8) | 154; return True;
        } else
        if (!strcasecmp("mediumturquoise", s)) { 
	  *value_p = (72 << 16) | (209 << 8) | 204; return True;
        } else
        if (!strcasecmp("mediumvioletred", s)) { 
	  *value_p = (199 << 16) | (21 << 8) | 133; return True;
        } else
        if (!strcasecmp("midnightblue", s)) { 
	  *value_p = (25 << 16) | (25 << 8) | 112; return True;
        } else
        if (!strcasecmp("mintcream", s)) { 
	  *value_p = (245 << 16) | (255 << 8) | 250; return True;
        } else
        if (!strcasecmp("mistyrose", s)) { 
	  *value_p = (255 << 16) | (228 << 8) | 225; return True;
        } else
        if (!strcasecmp("moccasin", s)) { 
	  *value_p = (255 << 16) | (228 << 8) | 181; return True;
        }
        break;

    case 'n':
        if (!strcasecmp("navajowhite", s)) { 
	  *value_p = (255 << 16) | (222 << 8) | 173; return True;
        } else
        if (!strcasecmp("navy", s)) { 
	  *value_p = (0 << 16) | (0 << 8) | 128; return True;
        }
        break;

    case 'o':
        if (!strcasecmp("oldlace", s)) { 
	  *value_p = (253 << 16) | (245 << 8) | 230; return True;
        } else
        if (!strcasecmp("olive", s)) { 
	  *value_p = (128 << 16) | (128 << 8) | 0; return True;
        } else
        if (!strcasecmp("olivedrab", s)) { 
	  *value_p = (107 << 16) | (142 << 8) | 35; return True;
        } else
        if (!strcasecmp("orange", s)) { 
	  *value_p = (255 << 16) | (165 << 8) | 0; return True;
        } else
        if (!strcasecmp("orangered", s)) { 
	  *value_p = (255 << 16) | (69 << 8) | 0; return True;
        } else
        if (!strcasecmp("orchid", s)) { 
	  *value_p = (218 << 16) | (112 << 8) | 214; return True;
        }
        break;

    case 'p':
        if (!strcasecmp("palegoldenrod", s)) { 
	  *value_p = (238 << 16) | (232 << 8) | 170; return True;
        } else
        if (!strcasecmp("palegreen", s)) { 
	  *value_p = (152 << 16) | (251 << 8) | 152; return True;
        } else
        if (!strcasecmp("paleturquoise", s)) { 
	  *value_p = (175 << 16) | (238 << 8) | 238; return True;
        } else
        if (!strcasecmp("palevioletred", s)) { 
	  *value_p = (219 << 16) | (112 << 8) | 147; return True;
        } else
        if (!strcasecmp("papayawhip", s)) { 
	  *value_p = (255 << 16) | (239 << 8) | 213; return True;
        } else
        if (!strcasecmp("peachpuff", s)) { 
	  *value_p = (255 << 16) | (218 << 8) | 185; return True;
        } else
        if (!strcasecmp("peru", s)) { 
	  *value_p = (205 << 16) | (133 << 8) | 63; return True;
        } else
        if (!strcasecmp("pink", s)) { 
	  *value_p = (255 << 16) | (192 << 8) | 203; return True;
        } else
        if (!strcasecmp("plum", s)) { 
	  *value_p = (221 << 16) | (160 << 8) | 221; return True;
        } else
        if (!strcasecmp("powderblue", s)) { 
	  *value_p = (176 << 16) | (224 << 8) | 230; return True;
        } else
        if (!strcasecmp("purple", s)) { 
	  *value_p = (128 << 16) | (0 << 8) | 128; return True;
        }
        break;

    case 'r':
        if (!strcasecmp("red", s)) { 
	  *value_p = (255 << 16) | (0 << 8) | 0; return True;
        } else
        if (!strcasecmp("rosybrown", s)) { 
	  *value_p = (188 << 16) | (143 << 8) | 143; return True;
        } else
        if (!strcasecmp("royalblue", s)) { 
	  *value_p = (65 << 16) | (105 << 8) | 225; return True;
        } else
        if (!strncasecmp("rgb(", s, 4))
	  {
           sp = (char*)(s + Arena_StrLen(s));
	   *sp = ' ';
	   sp = ARENA_Index(s, '(') + 1;
	   while (*sp == ' ') sp++;
	   *value_p = (long)atoi(sp) & 255;
	   while (*sp != ' ') sp++;
	   while (*sp == ' ') sp++;
	   *value_p = *value_p << 8 | ((long)atoi(sp) & 255);
	   while (*sp != ' ') sp++;
	   while (*sp == ' ') sp++;
	   *value_p = *value_p << 8 | ((long)atoi(sp) & 255);
	   return True;
	  }
        break;

    case 's':
        if (!strcasecmp("saddlebrown", s)) { 
	  *value_p = (139 << 16) | (69 << 8) | 19; return True;
        } else
        if (!strcasecmp("salmon", s)) { 
	  *value_p = (250 << 16) | (128 << 8) | 114; return True;
        } else
        if (!strcasecmp("sandybrown", s)) { 
	  *value_p = (244 << 16) | (164 << 8) | 96; return True;
        } else
        if (!strcasecmp("seagreen", s)) { 
	  *value_p = (46 << 16) | (139 << 8) | 87; return True;
        } else
        if (!strcasecmp("seashell", s)) { 
	  *value_p = (255 << 16) | (245 << 8) | 238; return True;
        } else
        if (!strcasecmp("sienna", s)) { 
	  *value_p = (160 << 16) | (82 << 8) | 45; return True;
        } else
        if (!strcasecmp("silver", s)) { 
	  *value_p = (192 << 16) | (192 << 8) | 192; return True;
        } else
        if (!strcasecmp("skyblue", s)) { 
	  *value_p = (135 << 16) | (206 << 8) | 235; return True;
        } else
        if (!strcasecmp("slateblue", s)) { 
	  *value_p = (106 << 16) | (90 << 8) | 205; return True;
        } else
        if (!strcasecmp("slategray", s)) { 
	  *value_p = (112 << 16) | (128 << 8) | 144; return True;
        } else
        if (!strcasecmp("snow", s)) { 
	  *value_p = (255 << 16) | (250 << 8) | 250; return True;
        } else
        if (!strcasecmp("springgreen", s)) { 
	  *value_p = (0 << 16) | (255 << 8) | 127; return True;
        } else
        if (!strcasecmp("steelblue", s)) { 
	  *value_p = (70 << 16) | (130 << 8) | 180; return True;
        }
        break;

    case 't':
        if (!strcasecmp("tan", s)) { 
	  *value_p = (210 << 16) | (180 << 8) | 140; return True;
        } else
        if (!strcasecmp("teal", s)) { 
	  *value_p = (0 << 16) | (128 << 8) | 128; return True;
        } else
        if (!strcasecmp("thistle", s)) { 
	  *value_p = (216 << 16) | (191 << 8) | 216; return True;
        } else
        if (!strcasecmp("tomato", s)) { 
	  *value_p = (255 << 16) | (99 << 8) | 71; return True;
        } else
        if (!strcasecmp("turquoise", s)) { 
	  *value_p = (64 << 16) | (224 << 8) | 208; return True;
        }
        break;

    case 'v':
        if (!strcasecmp("violet", s)) { 
	  *value_p = (238 << 16) | (130 << 8) | 238; return True;
        }
        break;

    case 'w':
        if (!strcasecmp("wheat", s)) { 
	  *value_p = (245 << 16) | (222 << 8) | 179; return True;
        } else
        if (!strcasecmp("white", s)) { 
	  *value_p = (255 << 16) | (255 << 8) | 255; return True;
        } else
        if (!strcasecmp("whitesmoke", s)) { 
	  *value_p = (245 << 16) | (245 << 8) | 245; return True;
        }
        break;

    case 'y':
      if (!strcasecmp("yellow", s)) { 
	*value_p = (255 << 16) | (255 << 8) | 0; return True;
      } else
      if (!strcasecmp("yellowgreen", s)) { 
	*value_p = (154 << 16) | (205 << 8) | 50; return True;
      }
      break;

    default:
      break;
   }
 /* End ``switch (TOLOWER(*s))'' */

 /* perhaps it is really a hex value - rhw 2-April-1997 */
 if (isrgb(s, &colour))
   {
    *value_p = colour;
    return True;
   }
  else
   {
    XColor xc;

    if (XParseColor(display, colourmap, s, &xc))
      {
       *value_p = (((xc.red   >> 8) << 16) |
		   ((xc.green >> 8) <<  8) |
		   ((xc.blue  >> 8)      ));
       return True;
      }
   }

 return False;
}


Window CreateSubWindow(Display* theDisplay, Window theWindow,
		       int theX, int theY,
		       unsigned int theXd, unsigned int theYd,
		       long theXeventsMask, long theColour)
{
#ifdef ARENA_DEBUG
 char Iam[] = "CreateSubWindow";
#endif

 if (theWindow != None)
   {
    long e_mask = (ExposureMask |
		   KeyPressMask | KeyReleaseMask |
		   Button1MotionMask | ButtonPressMask | ButtonReleaseMask);
    unsigned long attributes_mask = (CWColormap |
				     CWBackPixel | CWBorderPixel |
				     CWEventMask | CWDontPropagate |
				     CWBackingStore | CWBackingPlanes);
    XSetWindowAttributes attributes;


    attributes.colormap = colourmap;
    attributes.border_pixel = attributes.background_pixel = theColour;
    attributes.event_mask            = e_mask;
    attributes.do_not_propagate_mask = theXeventsMask;
    attributes.backing_store  = NotUseful;
    attributes.backing_planes = 0;

#ifdef ARENA_DEBUG
    if (X_TRACE)
      Arena_TracePrint(Iam,
		       " %dx%d%+d%+d of parent %ld,\n"
		       "\tcolour 0x%lx, do_not_propagate events mask 0x%lx.\n",
		       theXd, theYd, theX, theY, theWindow,
		       theColour, theXeventsMask);
#endif

    return XCreateWindow(theDisplay, theWindow,
			 theX, theY, theXd, theYd,
			 0,
			 CopyFromParent, CopyFromParent, CopyFromParent,
			 attributes_mask, &attributes);
   }
  else
   return None;
}


int myLoadFont(char *name)
{
 int direction_hint, font_ascent, font_descent;
 XCharStruct overall;
 XFontStruct *font = NULL;
 static int fix = 0;
 /* janet 24/07/95: not used:    int use_fix = -1; */
 int i;
 char *test = "Testing";
#ifdef ARENA_DEBUG
 char Iam[] = "myLoadFont";
#endif


 for (i = 0; i < fix; i++)
   {
    if (strcmp(name, FontsName[i]) == 0)
      {
#ifdef ARENA_DEBUG	/* QingLong.26-12-96 */
       if (FONT_TRACE)
	 Arena_TracePrint(Iam,
			  " font: %s found in cache, fix = %d\n",
			  name, i);
#endif
       return i;
      } 
   }

 /* a font with the same name has not been loaded, so try it.. */

 font = XLoadQueryFont(display, name);

 if (font)
   {
    FontsName[fix] = strdup(name);
    Fonts[fix] = font;

    XTextExtents(font, test, Arena_StrLen(test),
		 &direction_hint,
		 &font_ascent,
		 &font_descent,
		 &overall);

    LineSpacing[fix] = SPACING(font);
    BaseLine[fix] = BASELINE(font);
    StrikeLine[fix] = STRIKELINE(font);
    LineThickness[fix] = LINETHICKNESS(font);
    fix++;
#ifdef ARENA_DEBUG	/* QingLong.26-12-96 */
    if (FONT_TRACE)
      {
       if (VERBOSE_TRACE) Arena_TracePrint(Iam, " FIX %d\n", fix);
       Arena_TracePrint(Iam,
			" (%s) xloadqueryfonts successful\n", name);
      }
#endif
    return (fix - 1);
   }

#ifdef ARENA_DEBUG	/* QingLong.26-12-96 */
 if (FONT_TRACE) Arena_TracePrint(Iam, " failed %s\n", name);
#endif
 return (0); /* default font returned on error */
}


int GetFont(char *family_l, long px, long weight, long style, Bool small_caps)
{	
 int fix = -1;
 char name[200];
 char *weight_str, *slant_str, *condensed_str, *serif_str, *rgstry;
 char *family;
#ifdef ARENA_DEBUG
 char Iam[] = "GetFont";
#endif


 px = (int)((double) px * lens_factor);

 /* if a point size is requested,
  * let's compute the pixel size to avoid using the dpi in the request
  */

 switch (weight)
   {
    case SV_FONT_WEIGHT_LIGHT:
      weight_str = "light";
      break;
    case SV_FONT_WEIGHT_MEDIUM:
      weight_str = "medium";
      break;
    case SV_FONT_WEIGHT_DEMI_BOLD:
      weight_str = "demibold";
      break;
    case SV_FONT_WEIGHT_BOLD:
      weight_str = "bold";
      break;
    case SV_FONT_WEIGHT_EXTRA_BOLD:
      weight_str = "black";
      break;
    default:
      weight_str = "medium";
      break;	
   }

 switch (style)
   {
    case SV_FONT_STYLE_ROMAN:
      slant_str = "r";
      break;
    case SV_FONT_STYLE_ITALIC:
    case SV_FONT_STYLE_OBLIQUE:
      slant_str = "i";
      break;
    default:
      slant_str = "r";
      break;	
   }

 serif_str = "*";
 condensed_str = "normal";

#if 1
 while((fix < 0) && (family = (char *)family_l/*HTList_nextObject(l)*/))
   {
    if (strcasecmp(family, "symbol") == 0)
      rgstry = "*-*";
     else
      rgstry = "iso8859-1";

    sprintf(name,
	    "-*-%s-%s-%s-%s-%s-%ld-*-*-*-*-*-%s",
	    family, weight_str, slant_str, condensed_str, serif_str, px,
	    rgstry);
    fix = myLoadFont(name);

    if ((fix <= 0) &&
	((style == SV_FONT_STYLE_ITALIC) ||
	 (style == SV_FONT_STYLE_OBLIQUE)))
      {
       slant_str = "o";
       sprintf(name, "-*-%s-%s-%s-%s-%s-%ld-*-*-*-*-*-%s", 
	       family, weight_str, slant_str, condensed_str, serif_str, px,
	       rgstry);
       fix = myLoadFont(name);
      }
   }

#  ifdef ARENA_DEBUG	/* QingLong.26-12-96 */
 if (FONT_TRACE)
   Arena_TracePrint(Iam,
		    " %s %s\n",
		    name,
		    ((fix >= 0) ? "succeded" : "failed, trying again"));
#  endif

# else
 if ((fix < 0) && (style == SV_FONT_STYLE_ITALIC))
   {
    slant_str = "o";

    {
     HTList *l;

     l = family_l;
     while((fix <= 0) && (family = (char *)HTList_nextObject(l)))
       {
	if (strcasecmp(family,"symbol") == 0)
	  rgstry = "*-*";
	 else
	  rgstry = "iso8859-1";
       }

     sprintf(name,
	     "-*-%s-%s-%s-%s-%s-%ld-*-*-*-*-*-%s",
	     family, weight_str, slant_str, condensed_str, serif_str, px,
	     rgstry);
     fix = myLoadFont(name);
    }

#  ifdef ARENA_DEBUG	/* QingLong.26-12-96 */
    if (FONT_TRACE)
      Arena_TracePrint(Iam,
		       " %s %s\n",
		       name,
		       ((fix > 0) ? "succeded" : "failed, trying again"));
#  endif
   }
#endif

 rgstry = "iso8859-1";

 if (fix < 0)
   {
#ifdef ARENA_DEBUG	/* QingLong.26-12-96 */
    if (FONT_TRACE) Arena_TracePrint(Iam, " resorting to 9x15\n");
#endif
    strcpy(name, "9x15");
    fix = myLoadFont(name);
#ifdef ARENA_DEBUG	/* QingLong.26-12-96 */
    if (FONT_TRACE && VERBOSE_TRACE)
      Arena_TracePrint(Iam,
		       " %s %s\n",
		       name,
		       ((fix > 0) ? "succeded" : "failed, trying again"));
#endif
   }

 if (fix < 0)
   {
#ifdef ARENA_DEBUG
    if (FONT_TRACE) Arena_TracePrint(Iam, " resorting to 9x15\n");
#endif
    strcpy(name,"fixed");
    fix = myLoadFont(name);
#ifdef ARENA_DEBUG	/* QingLong.26-12-96 */
    if (FONT_TRACE && VERBOSE_TRACE)
      Arena_TracePrint(Iam,
		       " %s %s\n",
		       name,
		       ((fix > 0) ? "succeded" : "failed, trying again"));
#endif
   }

 if (fix > 255)
   {
#ifdef ARENA_DEBUG	/* QingLong.26-12-96 */
    Arena_TracePrint(Iam, " WARNING! more that 255 fonts loaded!\n");
# else
    Arena_PrintError(_("WARNING! more that 255 fonts loaded!\n"));
#endif
    Exit(0);
   }

 return fix;
}


/*
 * Check visibility. Find the visible subarea of the frame.
 * Actually just two rectangles intersection.
 * If visible, return visible subarea rectangle.
 */
Bool FrameVisibleSubArea(XRectangle  theArea,
			 XRectangle  theFrameArea,
			 XRectangle* theFrameVisibleSubArea)
{
 if (theArea.width > 0 && theArea.height > 0 &&
     theFrameArea.width > 0 && theFrameArea.height > 0)
   {
    int   left1 = theArea.x;
    int    top1 = theArea.y;
    int  right1 = left1 + theArea.width;
    int bottom1 =  top1 + theArea.height;
    int   left2 = theFrameArea.x;
    int    top2 = theFrameArea.y;
    int  right2 = left2 + theFrameArea.width;
    int bottom2 =  top2 + theFrameArea.height;


    if (left1 <  right2 && left2 <  right1 &&
	 top1 < bottom2 &&  top2 < bottom1)
      {
       if (theFrameVisibleSubArea)
	 {
	  if (  left2 >   left1)   left1 =   left2;
	  if ( right2 <  right1)  right1 =  right2;
	  if (   top2 >    top1)    top1 =    top2;
	  if (bottom2 < bottom1) bottom1 = bottom2;

	  theFrameVisibleSubArea->x = left1;
	  theFrameVisibleSubArea->y =  top1;
	  theFrameVisibleSubArea->width  =  right1 - left1;
	  theFrameVisibleSubArea->height = bottom1 -  top1;
	 }

       return True;
      }
   }

 return False;
}


float dpi(void)
{
 float wmm, w;

 wmm = DisplayWidthMM(display, screen);
 w   = DisplayWidth(display, screen);

 return((float)(w/wmm));
}

/*
   how to get from mm to px:

    1 inch = 25.4 mm = 72pt

    pix / mm ~~ 4 (100dpi)
                3 (75 dpi)

    14 pt / 2.83 (pt/mm)

    14 pt * mm/pt * pix/mm = pix
*/


Bool Busy(void)
{
 extern Bool busy;

 return busy;
}


void ShowBusy(void)
{
 extern Bool busy;

 XDefineCursor(display, win, hourglass);
 XFlush(display);
 busy = True;
}


void HideBusy(void)
{
 extern Bool busy;

 XUndefineCursor(display, win);
 XFlush(display);
 busy = False;
}


void Beep(void)
{
 XBell(display, 0);
 XFlush(display);
}


/* functions DrawOutSet amd DrawInSet changed by Janet for more general use
 * (added Window argument)
 */
void DrawOutSet(Window theWin,GC gc,
		int x, int y, unsigned int w, unsigned int h)
{
 XSetForeground(display, gc, windowTopShadow);

 XFillRectangle(display, theWin, gc, x,   y,   w,   1);
 XFillRectangle(display, theWin, gc, x,   y+1, w-1, 1);
 XFillRectangle(display, theWin, gc, x,   y,   1,   h);
 XFillRectangle(display, theWin, gc, x+1, y+1, 1,   h-1);

 XSetForeground(display, gc, windowBottomShadow);

 XFillRectangle(display, theWin, gc, x,     y+h-1, w,   1);
 XFillRectangle(display, theWin, gc, x+1,   y+h-2, w-1, 1);
 XFillRectangle(display, theWin, gc, x+w-1, y,     1,   h);
 XFillRectangle(display, theWin, gc, x+w-2, y+1,   1,   h-1);
}


void DrawInSet(Window theWin, GC gc,
	       int x, int y, unsigned int w, unsigned int h)
{
 XSetForeground(display, gc, windowBottomShadow);

 XFillRectangle(display, theWin, gc, x,      y,     w,     1);
 XFillRectangle(display, theWin, gc, x,      y + 1, w - 1, 1);
 XFillRectangle(display, theWin, gc, x,      y,     1,     h);
 XFillRectangle(display, theWin, gc, x + 1 , y + 1, 1,     h - 1);

 XSetForeground(display, gc, windowTopShadow);

 XFillRectangle(display, theWin, gc, x,         y + h - 1, w,     1);
 XFillRectangle(display, theWin, gc, x + 1,     y + h - 2, w - 1, 1);
 XFillRectangle(display, theWin, gc, x + w - 1, y,         1,     h);
 XFillRectangle(display, theWin, gc, x + w - 2, y + 1,     1,     h - 1);
}


void DrawOutSetCircle(Window theWin, GC gc,
		      int x, int y, unsigned int w, unsigned int h)
{
 XSetForeground(display, gc, windowTopShadow);
 XDrawArc(display, theWin, gc, x,     y,     w,     h,      45<<6, 180<<6);
 XDrawArc(display, theWin, gc, x + 1, y + 1, w - 2, h - 2,  45<<6, 180<<6);

 XSetForeground(display, gc, windowBottomShadow);
 XDrawArc(display, theWin, gc, x,     y,     w,     h,     225<<6, 180<<6);
 XDrawArc(display, theWin, gc, x + 1, y + 1, w - 2, h - 2, 225<<6, 180<<6);
}


void DrawInSetCircle(Window theWin, GC gc,
		     int x, int y, unsigned int w, unsigned int h)
{
 XSetForeground(display, gc, windowBottomShadow);
 XDrawArc(display, theWin, gc, x,     y,     w,     h,      45<<6, 180<<6);
 XDrawArc(display, theWin, gc, x + 1, y + 1, w - 2, h - 2,  45<<6, 180<<6);

 XSetForeground(display, gc, windowTopShadow);
 XDrawArc(display, theWin, gc, x,     y,     w,     h,     225<<6, 180<<6);
 XDrawArc(display, theWin, gc, x + 1, y + 1, w - 2, h - 2, 225<<6, 180<<6);
}


/*
 * The function draws the transparent image to the Drawable.
 */
Status Arena_PutTransparentImage(Display* theDisplay, GC theGC,
				 Pixmap theImage, Pixmap theMask,
				 Drawable theDestination,
				 int theX, int theY,
				 unsigned int theXd, unsigned int theYd)
     /*
      * BE AWARE! (theXd, theYd) derived from <img> tag attributes
      *           can differ from the actual theImage pixmap geometry
      *           derived from the real image (PNG, JPEG,...) size!
      */
     /*
      * QUESTION: How can we get a pixmap geometry (width, height)?
      */
{
 Status theStatus = Success;


 if (theImage != None)
   {
    XGCValues* tmpGCvalues = NULL;
    Bool WellDoIt, theGCgraphics_exposures;


    WellDoIt = (theMask != None);   /* First approximation for "WellDoIt". */

    if ((tmpGCvalues = (XGCValues*)Arena_CAlloc(1, sizeof(XGCValues), False)))
      {
      /*
       * Why, the hell, clip-mask cannot be requested with "GCClipMask"?
       * Stupid X11 designers! (see man XGetGCValues)
       *
       * Moreover,
       *   if the "valuemask" has "GCClipMask" request bit set,
       *   then graphics_exposures value request will be screwed up!
       *   The value returned will be "False", while it actually is "True"!
       */
       theStatus = XGetGCValues(theDisplay, theGC,
				(GCGraphicsExposures |
				 GCClipXOrigin | GCClipYOrigin),
				tmpGCvalues);

       if (theMask != None)
	 {
	 /*
	  * Better approximation for "WellDoIt".
	  */
	  WellDoIt = ((tmpGCvalues->clip_x_origin < theX + (int)theXd) &&
		      (tmpGCvalues->clip_y_origin < theY + (int)theYd));
	 }

       theGCgraphics_exposures = tmpGCvalues->graphics_exposures;

       Free(tmpGCvalues);
      }
     else
      {
       theGCgraphics_exposures = True;
      }
    /* End ``if "we managed to allocate tmpGCvalues"'' */


    if (WellDoIt)
      {
       GC tmpGC;
       Pixmap tmpImage;

      /* We DO NEED to carry out all these clipmasks calculations
       * and play all these games to combine 2 clipmasks:
       * the one   --- of the Arena content area GC and
       * the other --- of the image to be put itself.
       * This could be done much easier if it were possible to request
       * GC clipmask and pixmap geometry from X server:
       * we would just `AND' two clipmasks and voila!
       *
       * Stephen McCamant <alias@mcs.com> has suggested a simplified
       * manual clipping algorithm. It has used global Arena contents
       * window geometry parameters and the fact that the content area
       * has always been a rectangle of a known geometry.
       * Of course that scheme worked much faster than this generalized one,
       * but it had a very limited domain.
       */

      /*
       * Stephen McCamant <alias@mcs.com>:
       * X can't keep track of more than one clip region at a time.
       * The Right Thing To Do (R) would be to have the content region of
       * the browser be a separate window.
       */

       tmpGC = XCreateGC(theDisplay, theDestination, 0, NULL);

       /*
	* BE AWARE,
	* if theImage does not totally cover (theXd, theYd) rectangle,
        * GraphicsExpose events for all corresponding destination
        * (the (theXd, theYd) rectangle) regions will be generated.
        * That probably will cause redrawing deadloops.
	*/
       XSetGraphicsExposures(theDisplay, tmpGC, False);
       XSetFunction(theDisplay, tmpGC, GXcopy);
       XSetClipOrigin(theDisplay, tmpGC, 0, 0);
       XSetClipMask(theDisplay, tmpGC, None);

       tmpImage = XCreatePixmap(theDisplay, theDestination,
				theXd, theYd, depth);

       XCopyArea(theDisplay, theDestination, tmpImage, tmpGC,
		 theX, theY, theXd, theYd, 0, 0);

       XSetClipMask(theDisplay, tmpGC, theMask);

       XCopyArea(theDisplay, theImage, tmpImage, tmpGC,
		 0, 0, theXd, theYd, 0, 0);

       XFreeGC(theDisplay, tmpGC);

       XCopyArea(theDisplay, tmpImage, theDestination, theGC,
		 0, 0, theXd, theYd, theX, theY);

       XFreePixmap(theDisplay, tmpImage);
      }
     else
      {
      /* If theImage does not cover all the (theXd, theYd) rectangle,
       * then GraphicsExpose events would be generated...
       */
       if (theGCgraphics_exposures)
	 XSetGraphicsExposures(theDisplay, theGC, False);

       XCopyArea(theDisplay, theImage, theDestination, theGC,
		 0, 0, theXd, theYd, theX, theY);

       if (theGCgraphics_exposures)
	 XSetGraphicsExposures(theDisplay, theGC, theGCgraphics_exposures);
      }
    }

 return theStatus;
}
