/*                                                  W3C Sample Code Library libwww FTP CLIENT
                                   FTP ACCESS FUNCTIONS
                                             
 */
/*
**      (c) COPYRIGHT MIT 1995.
**      Please first read the full copyright statement in the file COPYRIGH.
*/
/*

   This module is implemented by HTFTP.c, and it is a part of the W3C Sample Code Library.
   
 */
#ifndef HTFTP_H
#define HTFTP_H
#include "HTProt.h"

extern HTProtCallback HTLoadFTP;

typedef enum _FTPServerType {
    FTP_GENERIC         = 0x1,
    FTP_MACHTEN         = 0x2,
    FTP_UNIX            = 0x4,
    FTP_VMS             = 0x8,
    FTP_CMS             = 0x10,
    FTP_DCTS            = 0x20,
    FTP_TCPC            = 0x40,
    FTP_PETER_LEWIS     = 0x80,
    FTP_NCSA            = 0x200,
    FTP_WINNT           = 0x400,
    FTP_UNSURE          = 0x8000
} FTPServerType;

#define MAX_FTP_LINE    128                      /* Don't use more than this */
/*

   Added by Neil Griffin, GAIN Software
   
 */
typedef enum _FTPTransferMode {
    FTP_DEFAULT_TRANSFER_MODE   = 0,
    FTP_ASCII_TRANSFER_MODE     = 1,
    FTP_BINARY_TRANSFER_MODE    = 2,
    FTP_DIR_TRANSFER_MODE       = 3
} FTPTransferMode;

extern FTPTransferMode HTFTP_transferMode (void);
extern void HTFTP_setTransferMode (FTPTransferMode mode);
/*

 */
#endif
/*

   
   ___________________________________
   
                             @(#) $Id: HTFTP.html,v 2.38 1998/03/20 17:52:53 frystyk Exp $
                                                                                          
   */
