{ #read fvwm2rc context 


# These routines parse .fvwm2rc commands from a file and 
# create and set fvwmconf Var's accordingly

sub pset {
    my ($ref,$name,$val) = @_;
#    debug 0, "'$ref':'$name':'$val'";
#    debug 0, $ref->{$name}->get_value();
    set($ref->{$name},$val, 1);
#    debug 0, $ref->{$name}->get_value();
}


    my $gref = $CONFIG{Global};
    my @globalopts = (
		      ['ClickFocusRaise','ClickToFocusRaises','ClickToFocusDoesntRaise'],
		      ['ClickPasses','ClickToFocusPassesClick','ClickToFocusDoesntPassClick'],
		      ['SmartPlacementSmart','SmartPlacementIsReallySmart','SmartPlacementIsNormal'],
		      ['MouseFocusRaise','MouseFocusClickDoesntRaise','MouseFocusClickRaises']
		      );
    my @gvarlist = (
		   ['ClickTime'],
		   ['EdgeScroll','EdgeScrollx','EdgeScrolly'],
		   ['EdgeResistance','EdgeTime','EdgePixels'],
		   ['MenuStyle','MenuFore','MenuBack',
		    'MenuShade','MenuFont','MenuStyle'],
		   ['DeskTopSize','m#x#','DeskTopSizex','DeskTopSizey'],
		    ['IconFont'],
		    ['OpaqueMoveSize'],
		    ['ColorMapFocus'],
		    );
#  decor
    my @dvararg = (
		    ['HilightColor','HilightColorFore','HilightColorBack'],
		    ['WindowFont']
		   );
# These are vars that take arguments
# The first element matches the rc file, the others are fvwmconf vars.
    my @svararg = ( ['BorderWidth'],
		   ['HandleWidth'],
		   ['Color','m#/#','ForeColor','BackColor'],
		   ['BackColor'],
		   ['ForeColor'],
		   ['UseDecor'],
		   ['UseStyle'],
		   ['Icon','IconPixmap'],
#		   ['','',''],

		   );
    my @svarunary = (
		     ['ShowTitle','Title','NoTitle'],
		     ['ShowIcon','Icon','NoIcon'],
		     ['IconTitle','IconTitle','NoIconTitle'],
		     ['Handles','Handles','NoHandles'],
		     ['WindowList','WindowListSkip','WindowListHit'],
		     ['StaysOnTop','StaysOnTop','StaysPut'],
		     ['Sticky','Sticky','Slippery'],
		     ['StartIconic','StartIconic','StartNormal'],
		     ['Circulate','CirculateSkip','CirculateHit'],
		     ['SmartPlacement','SmartPlacement','DumbPlacement'],
		     ['RandomPlacement','RandomPlacement','ActivePlacement'],
		     ['Focus','ClickToFocus','SloppyFocus','MouseFocus','FocusFollowsMouse'],
		     ['DecorateTransient','DecorateTransient','NakedTransient'],
#		     ['',],

		     );


sub read_fvwm2rc_query {
#    debug 0, "gref $gref";
    $READ_FVWM2RC->destroy if Exists($READ_FVWM2RC); 
    $READ_FVWM2RC = $MW->Toplevel(@topcon); 
    my $w = $READ_FVWM2RC;
    $w->title('Read fvwm2rc');
    make_help_dismiss( $w,'File:readfvwm2rc');
    my $f = $w->Frame(@fracon,);
    $f->pack(@EF);
    my $ent = $f->Entry(@entcon, -width => 50);
#    $ent->insert('0',"$ENV{HOME}/.fvwm2rc");
#    $ent->insert('0',"$ENV{HOME}/fvwmconf/system.fvwm2rc");
    $STATE{FrcDir} = "$ENV{HOME}/fvwmconf/test.rc" unless exists $STATE{FrcDir};
    $ent->insert('0',$STATE{FrcDir});
    $ent->pack(@EF);
    $getsub = sub {
	   my $file = $ent->get();
	   set_unsaved();
	   $STATE{FrcDir}=$file;
	   read_fvwm2rc($file);
	   $w->destroy; };
    $ent->bind('<Return>' => $getsub);
    my $ok = $f->Button(@butcon,
			-text => 'OK',
			-command => $getsub
			);
    $ok->pack();
}

sub read_fvwm2rc {
    my $file = shift;
    my ($in,$var,$arg,$x,$y,
	$one,$wref,$cvar,$pat,@sargs,@opts,
	$opt,@olist,$j);

    open FVWMRCIN, "<$file";
    while ($in = read_a_line(FVWMRCIN) ) {
	last if eof(FVWMRCIN) or not defined $in;
	if ($in =~ s/^\s*Style// ) {
	    parse_style($in);
	}
	else	{
	    $in =~ /^(\S+)\s*(.+)/;
	    $var = $1;
	    $arg = $2;
#	    debug 0, "$var:  $arg";
	    $wref = $gref;
	    if ($var eq 'GlobalOpts') {
		@olist = split /\s*\,\s*/, $arg;
		foreach $opt (@olist) {
		    foreach (@globalopts) {
			@opts = @$_;
			if ($opt eq $opts[1] or $arg eq $opts[2]) {
			    pset($gref,$opts[0],$opt);
			    last;
			}			
		    }
		}
	    }
	    else {
		parse_arg_vars(\@gvarlist,$var,$arg,$gref);
		parse_arg_vars(\@dvararg,$var,$arg,$CONFIG{Decors}->{default});
	    }
	}
	last if eof(FVWMRCIN);
    }
    close FVWMRCIN;
    execute_all(0);recapture();
}

sub parse_style {
    my $in = shift;
    my($style,$var,$arg,$ivar,$vals,$j);
    $in =~ s/\s*\"?([\w\*]+)\"?\s*//;
    $style = $1;
    create_style_variables($style) unless exists  $CONFIG{Styles}{$style};
    my $sref = $CONFIG{Styles}->{$style};
    @opts = split /\s*\,\s*/ , $in;
#	    debug 0, "$style:".join(":", @opts) ."\n";
OUT1:    foreach (@opts) {
	/^(\w+)\s*(\S*)\s*/;
	$var = $1;
	$arg = $2;
#	debug 0, "They are '$var:$arg'";
	if (not defined $arg or $arg eq '') {
#	    debug 0, "None '$var'";
	    foreach $vals (@svarunary) {
		for($j=1;$j<@$vals;$j++) {
		    if($var eq $$vals[$j]) {
			pset($sref,$$vals[0],$var);
			next OUT1;
		    }
		}
	    }
	}
	parse_arg_vars(\@svararg,$var,$arg,$sref);     
    }

}

# parse a line for variables which take arguments.
sub parse_arg_vars {
    my($varlist,$var,$arg,$wref) = @_;
    my(@one,$cvar,$pat,@sargs,$j);
    foreach  (@$varlist) {
	@one = @$_;

	$cvar = shift(@one);	# fvwmconf var name

#	if ( defined $one[0] and ref($one[0]) ) {
#	    $wref = shift @one;
#	}
	if (defined $one[0] and  $one[0] =~ s/^m#(.+)#$/$1/) { #separator for args
#		    $one[0] =~ /^m#.+#$/ #separator for args
	    $pat = shift @one;
	    $pat =~ s/^m#(.+)#$/$1/; 
	}
	else {
	    $pat = '\s+';
	}
	if($var eq $cvar) {
	    if (@one == 0) {
		pset($wref,$cvar,$arg);
		set($wref->{$cvar},$arg,1);
	    }
	    else {		# multiple vars on a  line
		@sargs = split /$pat/,$arg;
		for($j=0;$j<@one;$j++) {
		    pset($wref,$one[$j],$sargs[$j])
			if defined $sargs[$j];
		}
	    }
	    last;
	}
    }
}

} # end read fvwm2rc context
1;
