/*
 * IceWM
 *
 * Copyright (C) 1997,1998 Marko Macek
 */

#include "icewm.h"

void YFrameWindow::drawOutline(int x, int y, int w, int h) {
    int bw = (wsBorderX + wsBorderY) / 2;
    
    x += bw / 2;
    y += bw / 2;
    w -= bw;
    h -= bw;
    XDrawRectangle(app->display(), manager->handle(), outlineGC,
                   x, y, w, h);
}

int YFrameWindow::handleMoveKeys(const XKeyEvent &key, int &newX, int &newY) {
    KeySym k = XKeycodeToKeysym(app->display(), key.keycode, 0);
    int m = KEY_MODMASK(key.state);
    int factor = 1;

    if (m == ControlMask)
        factor = 16;
    else if (m == ShiftMask)
        factor = 4;
    
    if (k == XK_Left)
        newX -= factor;
    else if (k == XK_Right)
        newX += factor;
    else if (k == XK_Up)
        newY -= factor;
    else if (k == XK_Down)
        newY += factor;
    else if (k == XK_Home)
        newX = manager->minX(getLayer()) - borderX();
    else if (k == XK_End)
        newX = manager->maxX(getLayer()) - width() + borderX();
    else if (k == XK_Prior)
        newY = manager->minY(getLayer()) - borderY();
    else if (k == XK_Next)
        newY = manager->maxY(getLayer()) - height() + borderY();
    else if (k == XK_Return)
        return -1;
    else if (k ==  XK_Escape) {
        newX = origX;
        newY = origY;
        return -2;
    } else
        return 0;
    return 1;
}
            
int YFrameWindow::handleResizeKeys(const XKeyEvent &key,
                                   int &newX, int &newY, int &newWidth, int &newHeight,
                                   int incX, int incY)
{
    KeySym k = XKeycodeToKeysym(app->display(), key.keycode, 0);
    int m = KEY_MODMASK(key.state);
    int factor = 1;

    if (m == ControlMask)
        factor = 16;
    else if (m == ShiftMask)
        factor = 4;
    
    if (k == XK_Left) {
        if (grabX == 0) {
            grabX = -1;
        } else if (grabX == 1) {
            newWidth -= incX * factor;
        } else if (grabX == -1) {
            newWidth += incX * factor;
            newX -= incX * factor;
        }
    } else if (k == XK_Right) {
        if (grabX == 0) {
            grabX = 1;
        } else if (grabX == 1) {
            newWidth += incX * factor;
        } else if (grabX == -1) {
            newWidth -= incX * factor;
            newX += incX * factor;
        }
    } else if (k == XK_Up) {
        if (grabY == 0) {
            grabY = -1;
        } else if (grabY == 1) {
            newHeight -= incY * factor;
        } else if (grabY == -1) {
            newHeight += incY * factor;
            newY -= incY * factor;
        }
    } else if (k == XK_Down) {
        if (grabY == 0) {
            grabY = 1;
        } else if (grabY == 1) {
            newHeight += incY * factor;
        } else if (grabY == -1) {
            newHeight -= incY * factor;
            newY += incY * factor;
        }
    } else if (k == XK_Return)
        return -1;
    else if (k ==  XK_Escape) {
        newX = origX;
        newY = origY;
        newWidth = origW;
        newHeight = origH;
        return -2;
    } else
        return 0;
    return 1;
}

void YFrameWindow::handleMoveMouse(const XMotionEvent &motion, int &newX, int &newY) {
    int mouseX = motion.x_root;
    int mouseY = motion.y_root;
    
    constrainMouseToWorkspace(mouseX, mouseY);
    
    newX = mouseX - buttonDownX;
    newY = mouseY - buttonDownY;
    
    constrainPositionByModifier(newX, newY, motion);

    newX += borderX();
    newY += borderY();
    int n = -2;
    if (newX + int(width() + n * borderX()) > manager->maxX(getLayer()))
        if (newX + int(width() + n * borderX()) < int(manager->maxX(getLayer()) + EdgeResistance))
            newX = manager->maxX(getLayer()) - width() - n * borderX();
        else if (motion.state & ControlMask)
            newX -= EdgeResistance;
    if (newY + int(height() + n * borderY()) > manager->maxY(getLayer()))
        if (newY + int(height() + n * borderY()) < int(manager->maxY(getLayer()) + EdgeResistance))
            newY = manager->maxY(getLayer()) - height() - n * borderY();
        else if (motion.state & ControlMask)
            newY -= EdgeResistance;
    if (newX < manager->minX(getLayer()))
        if (newX > int(- EdgeResistance + manager->minX(getLayer())))
            newX = manager->minX(getLayer());
        else if (motion.state & ControlMask)
            newX += EdgeResistance;
    if (newY < manager->minY(getLayer()))
        if (newY > int(- EdgeResistance + manager->minY(getLayer())))
            newY = manager->minY(getLayer());
        else if (motion.state & ControlMask)
            newY += EdgeResistance;
    newX -= borderX();
    newY -= borderY();
}

void YFrameWindow::handleResizeMouse(const XMotionEvent &motion,
                                     int &newX, int &newY, int &newWidth, int &newHeight)
{
    int mouseX = motion.x_root;
    int mouseY = motion.y_root;
    
    constrainMouseToWorkspace(mouseX, mouseY);
    
    if (grabX == -1) {
        newX = mouseX - buttonDownX;
        newWidth = width() + x() - newX;
    } else if (grabX == 1) {
        newWidth = mouseX + buttonDownX - x();
    }
    
    if (grabY == -1) {
        newY = mouseY - buttonDownY;
        newHeight = height() + y() - newY;
    } else if (grabY == 1) {
        newHeight = mouseY + buttonDownY - y();
    }
    
    newWidth -= 2 * borderX();
    newHeight -= 2 * borderY() + titleY();
    client()->constrainSize(newWidth, newHeight,
                            YFrameClient::csRound |
                            (grabX ? YFrameClient::csKeepX : 0) |
                            (grabY ? YFrameClient::csKeepY : 0));
    newWidth += 2 * borderX();
    newHeight += 2 * borderY() + titleY();
    
    if (grabX == -1)
        newX = x() + width() - newWidth;
    if (grabY == -1)
        newY = y() + height() - newHeight;

}

void YFrameWindow::outlineMove() {
    int xx = x(), yy = y();

    XGrabServer(app->display());
    XSync(app->display(), 0);
    drawOutline(xx, yy, width(), height());
    while (1) {
        XEvent xev;
        
        XWindowEvent(app->display(),
                     handle(),
                     KeyPressMask | ExposureMask |
                     ButtonPressMask | ButtonReleaseMask | PointerMotionMask, &xev);
        switch (xev.type) {
        case KeyPress:
            {
                int ox = xx;
                int oy = yy;
                int r;
                
                switch (r = handleMoveKeys(xev.xkey, xx, yy)) {
                case 0:
                    break;
                case 1:
                case -2:
                    if (xx != ox || yy != oy) {
                        drawOutline(ox, oy, width(), height());
                        statusMoveSize->setStatus(this, xx, yy, width(), height());
                        drawOutline(xx, yy, width(), height());
                    }
                    if (r == -2)
                        goto end;
                    break;
                case -1:
                    goto end;
                }
            }
            break;
        case ButtonPress:
        case ButtonRelease:
            goto end;
        case MotionNotify:
            {
                int ox = xx;
                int oy = yy;

                handleMoveMouse(xev.xmotion, xx, yy);
                if (xx != ox || yy != oy) {
                    statusMoveSize->setStatus(this, xx, yy, width(), height());
                    drawOutline(ox, oy, width(), height());
                    drawOutline(xx, yy, width(), height());
                }
            }
            break;
        }
    }
end:
    drawOutline(xx, yy, width(), height());
    XSync(app->display(), 0);
    moveWindow(xx, yy);
    XUngrabServer(app->display());
}

void YFrameWindow::outlineResize() {
    int xx = x(), yy = y(), ww = width(), hh = height();
    int incX = 1;
    int incY = 1;
    
    if (client()->sizeHints()) {
        incX = client()->sizeHints()->width_inc;
        incY = client()->sizeHints()->height_inc;
    }

    XGrabServer(app->display());
    XSync(app->display(), 0);
    drawOutline(xx, yy, ww, hh);
    while (1) {
        XEvent xev;
        
        XWindowEvent(app->display(),
                     handle(),
                     KeyPressMask | ExposureMask |
                     ButtonPressMask | ButtonReleaseMask | PointerMotionMask, &xev);
        switch (xev.type) {
        case KeyPress:
            {
                int ox = xx;
                int oy = yy;
                int ow = ww;
                int oh = hh;
                int r;
                
                switch (r = handleResizeKeys(xev.xkey, xx, yy, ww, hh, incX, incY)) {
                case 0:
                    break;
                case -2:
                case 1:
                    if (ox != xx || oy != yy || ow != ww || oh != hh) {
                        drawOutline(ox, oy, ow, oh);
                        statusMoveSize->setStatus(this, xx, yy, ww, hh);
                        drawOutline(xx, yy, ww, hh);
                    }
                    if (r == -2)
                        goto end;
                    break;
                case -1:
                    goto end;
                }
            }
            break;
        case ButtonPress:
        case ButtonRelease:
            goto end;
        case MotionNotify:
            {
                int ox = xx;
                int oy = yy;
                int ow = ww;
                int oh = hh;
                
                handleResizeMouse(xev.xmotion, xx, yy, ww,hh);
                if (ox != xx || oy != yy || ow != ww || oh != hh) {
                    drawOutline(ox, oy, ow, oh);
                    statusMoveSize->setStatus(this, xx, yy, ww, hh);
                    drawOutline(xx, yy, ww, hh);
                }
            }
            break;
        }
    }
end:
    drawOutline(xx, yy, ww, hh);
    XSync(app->display(), 0);
    setGeometry(xx, yy, ww, hh);
    XUngrabServer(app->display());
}

void YFrameWindow::manualPlace() {
    int xx = x(), yy = y();
    Cursor grabPointer = movePointer;

    grabX = borderX();
    grabY = borderY();
    origX = x();
    origY = y();
    origW = width();
    origH = height();
    buttonDownX = 0;
    buttonDownY = 0;

    if (!app->grabEvents(desktop, grabPointer,
                         ButtonPressMask |
                         ButtonReleaseMask |
                         PointerMotionMask))
        return ;
    XGrabServer(app->display());
    statusMoveSize->begin(this);
    drawOutline(xx, yy, width(), height());
    while (1) {
        XEvent xev;

        XMaskEvent(app->display(),
                   KeyPressMask |
                   ButtonPressMask | ButtonReleaseMask | PointerMotionMask,
                   &xev);
        switch (xev.type) {
        case KeyPress:
            {
                int ox = xx;
                int oy = yy;
                int r;
                
                switch (r = handleMoveKeys(xev.xkey, xx, yy)) {
                case 0:
                    break;
                case 1:
                case -2:
                    if (xx != ox || yy != oy) {
                        drawOutline(ox, oy, width(), height());
                        statusMoveSize->setStatus(this, xx, yy, width(), height());
                        drawOutline(xx, yy, width(), height());
                    }
                    if (r == -2)
                        goto end;
                    break;
                case -1:
                    goto end;
                }
            }
            break;
        case ButtonPress:
        case ButtonRelease:
            goto end;
        case MotionNotify:
            {
                int ox = xx;
                int oy = yy;

                handleMoveMouse(xev.xmotion, xx, yy);
                if (xx != ox || yy != oy) {
                    statusMoveSize->setStatus(this, xx, yy, width(), height());
                    drawOutline(ox, oy, width(), height());
                    drawOutline(xx, yy, width(), height());
                }
            }
            break;
        }
    }
end:
    drawOutline(xx, yy, width(), height());
    statusMoveSize->end();
    moveWindow(xx, yy);
    app->releaseEvents();
    XUngrabServer(app->display());
}

bool YFrameWindow::handleKey(const XKeyEvent &key) {
    if (key.type == KeyPress) {
        if (movingWindow) {
            int newX = x();
            int newY = y();

            switch (handleMoveKeys(key, newX, newY)) {
            case -2:
                moveWindow(newX, newY);
                /* nobreak */
            case -1:
                endMoveSize();
                break;
            case 0:
                return true;
            case 1:
                moveWindow(newX, newY);
                break;
            }
        } else if (sizingWindow) {
            int newX = x();
            int newY = y();
            int newWidth = width();
            int newHeight = height();
            int incX = 1;
            int incY = 1;

            if (client()->sizeHints()) {
                incX = client()->sizeHints()->width_inc;
                incY = client()->sizeHints()->height_inc;
            }

            switch (handleResizeKeys(key, newX, newY, newWidth, newHeight, incX, incY)) {
            case 0:
                break;
            case 1:
                newWidth -= 2 * borderX();
                newHeight -= 2 * borderY() + titleY();
                client()->constrainSize(newWidth, newHeight,
                                        YFrameClient::csRound |
                                        (grabX ? YFrameClient::csKeepX : 0) |
                                        (grabY ? YFrameClient::csKeepY : 0));
                newWidth += 2 * borderX();
                newHeight += 2 * borderY() + titleY();
                
                if (grabX == -1)
                    newX = x() + width() - newWidth;
                if (grabY == -1)
                    newY = y() + height() - newHeight;

                setGeometry(newX,
                            newY,
                            newWidth,
                            newHeight);
                
                statusMoveSize->setStatus(this);
                break;
            case -2:
                setGeometry(newX, newY, newWidth, newHeight);
                /* nobreak */
            case -1:
                endMoveSize();
                break;
            }
        } else if (app->AltMask != 0) {
            KeySym k = XKeycodeToKeysym(app->display(), key.keycode, 0);
            unsigned int m = KEY_MODMASK(key.state);
            
            if (m == app->AltMask + ShiftMask) {
                if (k == XK_F6)
                    wmPrevWindow();
                else if (k == XK_F10)
                    wmMaximizeVert();
            } else if (m == app->AltMask) {
                if (k == ' ')
                    popupSystemMenu();
                else if (k == XK_F1)
                    wmRaise();
                else if (k == XK_F2)
                    wmOccupyAllOrCurrent();
                else if (k == XK_F3)
                    wmLower();
                else if (k == XK_F4)
                    wmClose();
                else if (k == XK_F5)
                    wmRestore();
                else if (k == XK_F6)
                    wmNextWindow();
                else if (k == XK_F7)
                    wmMove();
                else if (k == XK_F8)
                    wmSize();
                else if (k == XK_F9)
                    wmMinimize();
                else if (k == XK_F10)
                    wmMaximize();
                else if (k == XK_F11)
                    wmHide();
                else if (k == XK_F12)
                    wmRollup();
            } else if (isIconic()) {
                if (k == XK_Return || k == XK_KP_Enter)
                    wmRestore();
                else if ((k == XK_Menu) || (k == XK_F10 && m == ShiftMask))
                    popupSystemMenu();
            }
        }
    }
    return true;
}

void YFrameWindow::constrainPositionByModifier(int &x, int &y, const XMotionEvent &motion) {
    unsigned int mask = motion.state & (ShiftMask | app->AltMask);

    x += borderX();
    y += borderY();
    if (mask == ShiftMask) {
        x = x / 4 * 4;
        y = y / 4 * 4;
    } else if (mask == app->AltMask) {
        x = x / 8 * 8;
        y = y / 8 * 8;
    }
    x -= borderX();
    y -= borderY();
}

void YFrameWindow::constrainMouseToWorkspace(int &x, int &y) {
    if (x < manager->minX(getLayer()))
        x = manager->minX(getLayer());
    else if (x >= manager->maxX(getLayer()))
        x = manager->maxX(getLayer()) - 1;
    if (y < manager->minY(getLayer()))
        y = manager->minY(getLayer());
    else if (y >= manager->maxY(getLayer()))
        y = manager->maxY(getLayer()) - 1;
}

bool YFrameWindow::canSize(bool horiz, bool vert) {
    if (isRollup())
        return false;
#ifndef NO_MWM_HINTS
    if (!(client()->mwmFunctions() & MWM_FUNC_RESIZE))
        return false;
#endif
    if (!sizeMaximized) {
        if ((!vert || isMaximizedVert()) &&
            (!horiz || isMaximizedHoriz()))
            return false;
    }
    return true;
}

bool YFrameWindow::canMove() {
    //if (maximized() && !moveSizeMaximized)
    //    return 0;
#ifndef NO_MWM_HINTS
    if (!(client()->mwmFunctions() & MWM_FUNC_MOVE))
        return false;
#endif
    return true;
}

void YFrameWindow::startMoveSize(int doMove, int byMouse,
                                 int sideX, int sideY,
                                 int mouseXroot, int mouseYroot)
{
    Cursor grabPointer = None;

    sizeByMouse = byMouse;
    grabX = sideX;
    grabY = sideY;
    origX = x();
    origY = y();
    origW = width();
    origH = height();

    if (doMove && grabX == 0 && grabY == 0) {
        buttonDownX = mouseXroot;
        buttonDownY = mouseYroot;

        grabPointer = movePointer;
    } else if (!doMove) {
        Cursor ptr = leftPointer;
        
        if (grabY == -1) {
            if (grabX == -1)
                ptr = sizeTopLeftPointer;
            else if (grabX == 1)
                ptr = sizeTopRightPointer;
            else
                ptr = sizeTopPointer;
        } else if (grabY == 1) {
            if (grabX == -1)
                ptr = sizeBottomLeftPointer;
            else if (grabX == 1)
                ptr = sizeBottomRightPointer;
            else
                ptr = sizeBottomPointer;
        } else {
            if (grabX == -1)
                ptr = sizeLeftPointer;
            else if (grabX == 1)
                ptr = sizeRightPointer;
        }
        
        if (grabX == 1)
            buttonDownX = x() + width() - mouseXroot;
        else if (grabX == -1)
            buttonDownX = mouseXroot - x();
        
        if (grabY == 1)
            buttonDownY = y() + height() - mouseYroot;
        else if (grabY == -1)
            buttonDownY = mouseYroot - y();
        
        grabPointer = ptr;
    }

    XSync(app->display(), 0);
    if (!app->grabEvents(this, grabPointer,
                         ButtonPressMask |
                         ButtonReleaseMask |
                         PointerMotionMask))
    {
        return ;
    }

    if (doMove)
        movingWindow = 1;
    else
        sizingWindow = 1;

    statusMoveSize->begin(this);
    if (doMove && !opaqueMove) {
        outlineMove();
        endMoveSize();
    } else if (!doMove && !opaqueResize) {
        outlineResize();
        endMoveSize();
    }
}

void YFrameWindow::endMoveSize() {
    app->releaseEvents();
    statusMoveSize->end();
    movingWindow = 0;
    sizingWindow = 0;
    if (getLayer() == WinLayerDock)
        manager->updateWorkArea();
}
        
void YFrameWindow::handleBeginDrag(const XButtonEvent &down, const XMotionEvent &motion) {
    if ((down.button == 3) && canMove()) {
        startMoveSize(1, 1,
                      0, 0,
                      down.x, down.y);
        handleDrag(down, motion);
    } else if ((down.button == 1) && canSize()) {
        grabX = 0;
        grabY = 0;
        
        if (down.x < int(borderX())) grabX = -1;
        else if (width() - down.x <= borderX()) grabX = 1;
        
        if (down.y < int(borderY())) grabY = -1;
        else if (height() - down.y <= borderY()) grabY = 1;
        
        if (grabY != 0 && grabX == 0) {
            if (down.x < int(wsCornerX)) grabX = -1;
            else if (width() - down.x <= wsCornerX) grabX = 1;
        }
        
        if (grabX != 0 && grabY == 0) {
            if (down.y < int(wsCornerY)) grabY = -1;
            else if (height() - down.y <= wsCornerY) grabY = 1;
        }
        
        if (grabX != 0 || grabY != 0) {
            startMoveSize(0, 1,
                          grabX, grabY,
                          down.x_root, down.y_root);
            
        }
    }
}

void YFrameWindow::moveWindow(int newX, int newY) {
    if (newX >= int(manager->maxX(getLayer()) - borderX()))
        newX = manager->maxX(getLayer()) - borderX();

    if (newY >= int(manager->maxY(getLayer()) - borderY() - titleY()))
        newY = manager->maxY(getLayer()) - borderY() - titleY();
    
    if (newX < int(manager->minX(getLayer()) - (width() - borderX())))
        newX = manager->minX(getLayer()) - (width() - borderX());

    if (newY < int(manager->minY(getLayer()) - (height() - borderY())))
        newY = manager->minY(getLayer()) - (height() - borderY());

    setPosition(newX, newY);
    
    statusMoveSize->setStatus(this);
}

void YFrameWindow::handleDrag(const XButtonEvent &/*down*/, const XMotionEvent &/*motion*/) {
}

void YFrameWindow::handleEndDrag(const XButtonEvent &/*down*/, const XButtonEvent &/*up*/) {
}

void YFrameWindow::handleButton(const XButtonEvent &button) {
    if (button.type == ButtonPress) {
        if (!(button.state & ControlMask)) {
            activate();
            if (raiseOnClickFrame)
                wmRaise();
        }
    } else if (button.type == ButtonRelease) {
        if (movingWindow || sizingWindow) {
            endMoveSize();
            return ;
        }
    }
    YWindow::handleButton(button);
}

void YFrameWindow::handleMotion(const XMotionEvent &motion) {
    if (sizingWindow) {
        int newX = x(), newY = y();
        int newWidth = width(), newHeight = height();

        handleResizeMouse(motion, newX, newY, newWidth, newHeight);

        setGeometry(newX,
                    newY,
                    newWidth,
                    newHeight);
        statusMoveSize->setStatus(this);
        return ;
    } else if (movingWindow) {
        int newX = x();
        int newY = y();

        handleMoveMouse(motion, newX, newY);
        moveWindow(newX, newY);
        return ;
    }
    YWindow::handleMotion(motion);
}

