/*****************************************************************************/
/*                                                                           */
/*  wmmail - WindowMaker Mail                                                */
/*                                                                           */
/*  Copyright (c) 1996, 1997, 1998  Per Liden                                */
/*  Copyright (c) 1997, 1998  Bryan Chan                                     */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either version 2 of the License, or        */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                */
/*                                                                           */
/*    wmmail.h: global declarations for wmmail                               */
/*                                                                           */
/*****************************************************************************/

#ifndef WMMAIL_H
#define WMMAIL_H


/* default includes */
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <stdarg.h>
#include <math.h>
#include <unistd.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/extensions/shape.h>
#include <X11/xpm.h>
#include "config.h"


/* constants */
#define WMMAIL_CLASS  "WMMail"         /* X application class name */

#ifndef True                           /* Boolean values */
#define True                 1
#endif

#ifndef False
#define False                0
#endif

#define OK                   0         /* return codes */
#define ERR_IO              -1
#define ERR_AUTH            -2
#define ERR_SYNTAX          -3
#define ERR_CALL            -4
#define ERR_MEM             -5
#define ERR_XPM             -6
#define ERR_UNKNOWN       -255

#define NO_MAIL   	     0         /* wmmail status; array subscripts */
#define OLD_MAIL             1
#define NEW_MAIL             2

#define SHOW_NONE            0         /* NumOfMsgMode mode numbers */
#define SHOW_NEW_OVER_TOTAL  1
#define SHOW_NEW_ONLY        2
#define SHOW_TOTAL_ONLY      3

#define LEFT_BUTTON          1         /* left mousebutton id */
#define MIDDLE_BUTTON        2         /* middle mousebutton id */
#define RIGHT_BUTTON         3         /* right mousebutton id */

#define NORMAL               0         /* parsing modes */
#define EXPECT_ANIM_NO_MAIL  1
#define EXPECT_ANIM_OLD_MAIL 2
#define EXPECT_ANIM_NEW_MAIL 3
#define EXPECT_MAIL_FILE     4

#define TYPE_UNIX            (1<<0)    /* mailbox types */
#define TYPE_MH              (1<<1)
#define TYPE_MAILDIR         (1<<2)
#define TYPE_POP3            (1<<3)
#define TYPE_IMAP            (1<<4)

#define IS_UNIX(mbox)        ((mbox)->mbox_type & TYPE_UNIX)
#define IS_MH(mbox)          ((mbox)->mbox_type & TYPE_MH)
#define IS_MAILDIR(mbox)     ((mbox)->mbox_type & TYPE_MAILDIR)
#define IS_POP3(mbox)        ((mbox)->mbox_type & TYPE_POP3)
#define IS_IMAP(mbox)        ((mbox)->mbox_type & TYPE_IMAP)


/* Mailbox */
typedef struct _Mailbox Mailbox;
struct _Mailbox {
  char     *path;
  off_t    size;
  time_t   last_check;
  int      mail_count;
  int      new_mail_count;
  int      status;
  int      mbox_type;
  Mailbox  *next;
};


/* XPM Icon */
typedef struct _XpmIcon XpmIcon;
struct _XpmIcon {
  Pixmap        pixmap;
  Pixmap        mask;
  XpmAttributes attributes;
  XpmIcon       *next;
};


/* global variables */
extern int rc_errno;
extern int rc_lineno;
extern int rc_mode;

extern int wmmail_status;
extern int overridden;

extern int always_new_mail_exec;
extern int anim_speed[3];
extern int num_of_msg_mode;
extern int num_of_msg_x;
extern int num_of_msg_y;
extern int update_interval;
extern int use_appicon_only;
extern int use_beep;
extern int use_time_stamp;

extern char *app_name;
extern char *config_file_path;
extern char *exec_on_click_path;
extern char *exec_on_update_path;
extern char *exec_on_new_path;
extern char *wmmail_color;

extern Mailbox *mbox_list;

extern XpmIcon *animations[3];

extern Display      *disp;
extern Pixmap       shape_mask;
extern GC           shape_mask_gc;
extern GC           wmmail_gc;
extern Font         wmmail_font;
extern XtAppContext wmmail_context;
extern Widget       wmmail_widget;
extern Widget       wmmail_appicon;
extern Window       root;


/* utility functions */
void croak(char *, ...);
void *safe_malloc (unsigned);
void *safe_realloc (void *, unsigned);
void *safe_free (void *);
void unescape (char *);

#ifdef NEED_STRDUP
char *strdup(char *);
#endif

#endif
