.TH wmmail 1 "13 May 1998" wmmail
.UC

.SH NAME
\fBwmmail\fP \- WindowMaker Mail

.SH SYNOPSIS
.B wmmail \fP[file] [options ...]\fP

.SH DESCRIPTION
\fBwmmail\fP is a "mail-checker" like \fBxbiff\fP. It indicates the status 
of the user's mailbox by showing animated XPM icons when incoming mails are 
detected. Additionally, it can be configured to execute a program on incoming
mail and/or on mouse double-clicks, and can provide a count of emails in the 
user's mailbox. 

\fBwmmail\fP is based on \fBasmail\fP, a similar applet designed for the
AfterStep window manager. However, \fBwmmail\fP has been re-written to be
compatible with the WindowMaker Dock, i.e. \fBwmmail\fP can be dragged and 
dropped on to (and off from) the Dock dynamically.

.SH FILE
By default \fBwmmail\fP uses ~/.wmmailrc as its configuration file, but it 
is possible to use an alternate file by specifying the filename on the 
command line. The syntax of the configuration file is the same as that for
\fBasmail\fP version 0.50. 
.RE

.SH OPTIONS
.IP "\fB-help\fP"
.RS	
Prints a help message
.RE

.SH CONFIGURATION FILE
Here is a list of the keywords that can be used in the configuration file.
.RE
.IP "\fBNoBeep\fP"
.RS	
Do not make an audible signal when new mail is found.
.RE
.IP "\fBMailFiles\fP"

.RE	
        \fImailfile\fP
        ...
.RE
.IP "\fBEnd\fP"
.RS
Specifies which mailbox file(s) or folder(s) to use. If a specified mailbox
is a directory, it is assumed to be a MH mail folder, otherwise the mailbox
is assumed to be in UNIX-style mailbox format. If this option is left 
out, the value in the environment variable $MAIL will be used.
.RE
.IP "\fBUpdate\fP \fIsec\fP"
.RS
Specifies the update frequency. Default is 5 seconds.
.RE
.IP "\fBExecute\fP \fIprogram\fP"
.RS
Specifies the program to execute when the \fBwmmail\fP window receives a
double-left-click.
.RE
.IP "\fBNewMailExecute\fP \fIprogram\fP"
.RS
Specifies the program to execute when new mails arrive.
.RE
.IP "\fBAlwaysNewMailExecute\fP"
.RS
Always execute the program when new mails arrive.

If this option is removed, \fBwmmail\fP will only execute when new mail is 
found when the status of the mailbox(es) is changed from "no/old mail" 
to "new mail".
.RE
.IP "\fBExecuteOnUpdate\fP \fIprogram\fP"
.RS
This option is useful if you need to fetch your mails from a POP3 server. 
\fBwmmail\fP will execute a specified program (e.g. popclient, fetchmail, etc.) 
just before every update of the mailbox status.
.RE
.IP "\fBNumOfMsgMode\fP \fImode\fP"
.RS
With this option you can get \fBwmmail\fP to display the number of messages 
and/or new messages in the mailbox. This option cannot be used if you monitor
more then one mailfile. 

.RE
       \fImode\fP can be set to:

.RE
       0 = disable this feature (default)
.RE
       1 = show number of new mails/total number of mails
.RE
       2 = show number of new mails only
.RE
       3 = show total number of mails only
.RE
.IP "\fBNumOfMsgPosition\fP \fIx\fP \fIy\fP"
.RS
Position of the NumOfMsg text; the position must be within the area of the
icon, e.g. if the XPM icon used is 48x48 pixels large, then \fIx\fP and
\fIy\fP should be in the range 0 to 47, otherwise the text will be 
invisible. The (\fIx\fP, \fIy\fP) coordinates specify the lower left corner 
of the first digit in the test. Default coordinates are (10, 10).
.RE
.IP "\fBNumOfMsgFont\fP"
.RS
The font to use for displaying the NumOfMsg text. Default is "helvetica".
.RE
.IP "\fBNumOfMsgColor\fP"
.RS
The color to use for displaying the NumOfMsg text. Default is black.
.RE
.IP "\fBTimeStampMode\fP"
.RS
This option is useful if you are using utilities like \fBprocmail\fP. 
\fBwmmail\fP will change status to "new mail" when the modification time 
stamp of the mailbox file is changed.
.RE
.IP "\fBAnimationSpeed\fP \fIno_mail\fP \fIold_mail\fP \fInew_mail\fP"
.RS
Sets the delay between two frames in an animation. Each animation corresponds
to one of the three states of the mailbox, and each can have a different frame
delay.
.RE

.IP "\fBNoMail\fP / \fBOldMail\fP / \fBNewMail\fP"

.RE
       \fIXPM_icon\fP
       ...
.RE
.IP "\fBEnd\fP"
.RS
Assign icons and/or animations. List the XPM icons in the order you want them 
to be shown. If you do not want an animation, list just one icon. If these
options are left out, the default, monochrome, non-animated icons will be used.
.RE
.IP "\fB#\fP"
.RS
Comment.
.RE

.SH USING WMMAIL
To use \fBwmmail\fP with the WindowMaker Dock, simply drag the \fBwmmail\fP
icon to the WindowMaker Dock. Double-clicking on the docked icon with the
right mouse button marks \fBwmmail\fP as "auto-starting". Double-clicking on
the icon with the middle mouse button tells \fBwmmail\fP to ignore newly
arrived mails, i.e. resets \fBwmmail\fP to the "no mail" status.

.SH EXAMPLES
.ig
Here is an example of how to start \fBwmmail\fP from the command line. It will 
use myconfig.wmmailrc for configuration instead of ~/.wmmailrc.
.nf

wmmail myconfig.wmmailrc &
	
.fi
Here is an example of how to start \fBwmmail\fP from AfterStep and put 
it in the Wharf. Place the following line in your \fI.steprc\fP file in your 
home directory.
.nf

*Wharf - - Swallow "wmmail" wmmail &

.fi
..

Here is an example of a configuration file.
.nf

#########################################################
# .wmmailrc - wmmail configuration file                 #
#########################################################

NoBeep
MailFile 
	/var/spool/mail/bryan
	/home/bryan/mail/mbox
End
Update 1
Execute "xterm -T PINE -name pine -e pine -i &"
NewMailExecute "cat /home/bryan/sounds/message.au > /dev/audio &"
AlwaysNewMailExecute
AnimationSpeed  10	10	5

NoMail  
	/usr/include/X11/pixmaps/nomail1.xpm	
	/usr/include/X11/pixmaps/nomail2.xpm	
	/usr/include/X11/pixmaps/nomail3.xpm	
End

OldMail  	
	/usr/include/X11/pixmaps/oldmail1.xpm	
	/usr/include/X11/pixmaps/oldmail2.xpm	
	/usr/include/X11/pixmaps/oldmail3.xpm	
End

NewMail  
	/usr/include/X11/pixmaps/newmail1.xpm	
	/usr/include/X11/pixmaps/newmail2.xpm	
	/usr/include/X11/pixmaps/newmail3.xpm	
End

.fi

.SH BUGS
The program goes to sleep between mailbox updates and/or frames of animation,
whichever is more frequent; hence, any X events that occur during its 
sleep are not detected until the next mailbox update or frame.

.SH VERSION
This man page is up-to-date for version 0.59 of \fBwmmail\fP.

.SH COPYRIGHTS
\fBwmmail\fP is based on \fBasmail\fP for the AfterStep window manager,
copyright (c) 1996, 1997, 1998 by Per Liden.

All modifications made to \fBasmail\fP to make it work with WindowMaker
are copyright (c) 1997, 1998 by Bryan Chan. \fBwmmail\fP is licensed
through the GNU General Public License. Read COPYING for the complete
license.

The NeXT-lookalike XPM icons are acquired from an \fBasmail\fP hack by 
Jon Leffert <jbleffer@midway.uchicago.edu>.

The notification sounds are acquired from xbiff++, an enhanced xbiff by
Mike Wagner <wagner@cadillac.siemens.com> and Jamie Zawinski
<jwz@netscape.com>.

.SH AUTHORS
.IP \fBasmail\fP:
  Per Liden
  per@rsn.hk-r.se
  http://www.rby.hk-r.se/~pt96pli/
.RE
.IP \fBwmmail\fP:
  Bryan Chan
  scorpio@technojunkie.com
  http://shells.technojunkie.com/~scorpio/
.RE
