%{

/*****************************************************************************/
/*                                                                           */
/*  wmmail - WindowMaker Mail                                                */
/*                                                                           */
/*  Copyright (c) 1996, 1997, 1998  Per Liden                                */
/*  Copyright (c) 1997, 1998  Bryan Chan                                     */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either version 2 of the License, or        */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                */
/*                                                                           */
/*    wmmailrc_l.l: lexical analyzer of the wmmail configuration file        */
/*                                                                           */
/*****************************************************************************/

#include "wmmail.h"
#include "wmmailrc_y.h"

extern int rc_mode;

%}

%%

AlwaysNewMailExecute	{ return ALWAYS_NEW_MAIL_EXECUTE; }
AnimationSpeed		{ return ANIM_SPEED; }
End			{ return END; }
Execute			{ return EXECUTE; }
ExecuteOnUpdate		{ return EXECUTE_ON_UPDATE; }
MailFiles 		{ rc_mode = EXPECT_MAIL_FILE; return MAIL_FILE; }
LockShape		{ /* ignore */  }
NewMail			{ rc_mode = EXPECT_ANIM_NEW_MAIL; return NEW_MAIL_T; }
NewMailExecute		{ return NEW_MAIL_EXECUTE; }
NoBeep	 		{ return NO_BEEP; }
NoMail			{ rc_mode = EXPECT_ANIM_NO_MAIL; return NO_MAIL_T; }
NoShape			{ /* ignore */  }
NumOfMsgColor           { return NUM_OF_MSG_COLOR; }
NumOfMsgFont		{ return NUM_OF_MSG_FONT; }
NumOfMsgMode		{ return NUM_OF_MSG_MODE; }
NumOfMsgPosition	{ return NUM_OF_MSG_POSITION; }
OldMail			{ rc_mode = EXPECT_ANIM_OLD_MAIL; return OLD_MAIL_T; }
TimeStampMode		{ return TIME_STAMP_MODE; }
Update			{ return UPDATE; }

\\\n		{ rc_lineno++; }   /* escaped newline is ignored */

#.*\n		{ rc_lineno++; }   /* comments are ignored */

\n		{ rc_lineno++; return EOL; }

\"[^\"\r\n]*\"	{
		  if (yytext[yyleng - 2] == '\\')
		  {
		    yyless(yyleng - 1);
		    /* yytext[strlen(yytext) - 2] = '\0'; */
                    yymore();
                  }
                  else
                  {
		    yytext[yyleng - 1] = '\0';
		    yylval.string = (char *) strdup(yytext + 1);
		    unescape(yylval.string);
		    return STRING;
                  }
		}

[0-9]+		{ yylval.number = atoi(yytext); return NUMBER; }

[^ \t\r\n\"]+	{ yylval.string = (char *) strdup(yytext); return STRING; }

[ \t\r]+	/* ignore whitespace */;

%%


