/* ------------------------------------------------------------------------- */
/* alg-pcf.c  i2c-bus with the PCF 8584 				     */
/* ------------------------------------------------------------------------- */
/*   Copyright (C) 1996-97 Simon G. Vogl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		     */
/* ------------------------------------------------------------------------- */
static char alg_rcsid[] = "$Id: alg-pcf.c,v 1.7 1998/01/20 10:01:29 i2c Exp i2c $";
/*
 * TODO:
 *	o implement slave algorithms -> bus monitoring
 *	o parport interface to access ports? Only for those that access the
 *		parallel port, of course
 *	o interrupt support
 */

#include <asm/io.h>
#include <linux/version.h>
#if LINUX_VERSION_CODE >= 0x020100
#include <asm/uaccess.h>
#else
#include <asm/segment.h>
#endif
#include <linux/kernel.h>
#include <linux/delay.h>
#include <linux/ioport.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/lp.h>

#include "i2c.h"
/*#include "i2c-priv.h"*/
#include "pcf8584.h"


/*
 *  This array contains the hw-specific functions for
 *  each port (hardware) type.
 */
static struct bit_adapter *bit_adaps[BIT_ADAP_MAX];
static int adap_count;
static struct i2c_adapter *i2c_adaps[BIT_ADAP_MAX];


/* ----- global defines ---------------------------------------------------- */
#define DEB(x)		/* should be reasonable open, close &c. 	*/
#define DEB2(x) 	/* low level debugging - very slow 		*/
#define DEBE(x)	x	/* error messages 				*/
#define DEBI(x) x	/* ioctl and its arguments 			*/
#define DEBACK(x)	/* ack failed message - may be annoying		*/

/* ----- global variables -------------------------------------------------- */
/* ----- local functions --------------------------------------------------- */

static void i2c_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{
	struct i2c_struct *dev = (struct i2c_struct *)dev_id;
		
	if (dev->wait_q)
		wake_up(&dev->wait_q);
}

static inline int i2c_write_interrupt(unsigned int minor, const char *buf, int count)
{
	return 0;
}

static int i2c_open(struct inode * inode, struct file * file) 
{
/*	unsigned int minor = MINOR(inode->i_rdev);
	unsigned int irq;
	
	irq = i2c_table[minor].irq;
	if (irq) {
		int ret = request_irq(irq, i2c_interrupt,
			SA_INTERRUPT, "i2c PCF 8584, EPP Port", &i2c_table[minor]);
		if (ret) {
			printk("i2c%d unable to use interrupt %d, error %d\n", minor, irq, ret);
			return ret;
		}
	}
*/	return 0;
}


static void i2c_release (struct inode * inode, struct file * file) 
{
/*	unsigned int minor = MINOR(inode->i_rdev);
	unsigned int irq;

	if ( (irq = i2c_table[minor].irq) ) {
		free_irq(irq, &i2c_table[minor]);
	}
*/
}

#define DBG_TIME

inline int pcfBusFree(int minor) 
{
#ifdef DBG_TIME
	int dodo=0;
#endif
	int i;
	do {
		i = stat();
#ifdef DBG_TIME
		if (++dodo>10000) {
			printk("Bus free error!\n");
			cmd(0xc3);
			return PCF_BER;
		}
#endif
	} while ( !(i & PCF_BB) );
	return i;
}

inline int pcfTransmitting(int minor) 
{
#ifdef DBG_TIME
	int dodo=0;
#endif
	int i;

	if ( i2c_table[minor].irq > 0) {
		printk("i2c%d Entering int sleep!\n",minor);
		interruptible_sleep_on(&i2c_table[minor].wait_q);
		printk("i2c%d Woke up!\n",minor);
		i = stat();
		return 0;
	}
	do {
		i = stat();
#ifdef DBG_TIME
		if (++dodo>50000) {
			printk("Transmit timeout!\n");
			return PCF_BER;
		}
		udelay(5);
#endif
	} while ( ( i & PCF_PIN ) );
	return i;
}

static int i2c_write(struct inode * inode, struct file * file,
	const char * buf, int count)
{
	unsigned int minor = MINOR(inode->i_rdev);
	const char *temp = buf;
	int  i,status;
	char c;
	struct i2c_data *data;

	data=(struct i2c_data *)file->private_data;
	if (!data || (data->magic!=I2C_MAGIC))
		return -EINVAL;

	status = pcfBusFree(minor);
	if (!(status & PCF_BB)) {
		return -EIO;
	}
	
	dta(data->address&0xfe);
	cmd(0xc5);	       /* start, transmit address */
#if 0
	for (i=0;i<count;i++) {
		status = pcfTransmitting(minor);
		if ( status & PCF_LRB )
			break;
#if LINUX_VERSION_CODE >= 0x020100
		get_user(c,temp);
#else
		c = get_user((char*)temp);
#endif
		temp++;
		dta(c);
	}
#else					/* How Philips does it...	*/
	i=0;
	while (1) {
		status = pcfTransmitting(minor);
		if (status & PCF_LRB ) /* slave acked? */
			break;
		if (i >= count)
			break;
#if LINUX_VERSION_CODE >= 0x020100
		get_user(c,temp);
#else
		c = get_user((char*)temp);
#endif		get_user(c,temp);
		dta(c);
		i++;temp++;
	}
#endif
	status = pcfTransmitting(minor);
	cmd(0xc3);
	return i;
}

static int i2c_read(struct inode * inode, struct file * file,
	char * buf, int count) 
{
	unsigned int minor = MINOR(inode->i_rdev);
	char *temp = buf;
	int i,status;
	struct i2c_data *data;

	data=(struct i2c_data *)file->private_data;
	if (!data || (data->magic!=I2C_MAGIC))
		return -EINVAL;

	status = pcfBusFree(minor);
	if (!(status & PCF_BB)) {
		return -EIO;
	}

	dta(data->address|0x01);
	cmd(0xc5);			/* start, transmit address	*/
	status = pcfTransmitting(minor);
	if (status < 0) {
		cmd(0xc3);	     	/* no, didn't			*/
		return -EIO;
	}
 	if (status & PCF_LRB ) { 	/* slave acked? 		*/
		cmd(0xc3);	     	/* no, didn't			*/
		return -EIO;
	}
	recv();				/* discard slave address 	*/
	i=0;
	while (1) {
		status = pcfTransmitting(minor);
		if (status < 0) {
			cmd(0xc3);	     	/* no, didn't			*/
			return -EIO;
		}
		i++;
		put_user(recv(),temp);
		if (i >= count)
			break;
		temp++;
	}
	cmd(0x40); /* neg. acknowledge on next byte */
	put_user(recv(),temp);
	temp++;
	status = pcfTransmitting(minor);
	cmd(0xc3);
	put_user(recv(),temp);
	temp++;
	return temp-buf;
}

static int i2c_old_read(struct inode * inode, struct file * file,
	char * buf, int count) 
{
	unsigned int minor = MINOR(inode->i_rdev);
	char *temp = buf, status;
int i;
	struct i2c_data *data;

	data=(struct i2c_data *)file->private_data;
	if (!data || (data->magic!=I2C_MAGIC))
		return -EINVAL;

	status = pcfBusFree(minor);
	if (!(status & PCF_BB)) {
		return -EIO;
	}

	dta(data->address|0x01);
	cmd(0xc5);			/* start, transmit address	*/

	status = pcfTransmitting(minor);

 	if (status & PCF_LRB ) { 	/* slave acked? 		*/
		cmd(0xc3);	     	/* no, didn't			*/
		return -EIO;
	}
	recv();				/* discard slave address 	*/
#if 1					/* my style of code		*/
	for (i=0;i<count-1;i++) {
		status = pcfTransmitting(minor);
		if (i >= count -2) {	/* neg. Ack on last byte	*/
			cmd(0x40);
		}
		if (status & PCF_BER) {	/* Bus error			*/
			printk(" Bus error while reading! (byte %d)\n",i);
			/* now do what? A break seems appropriate	*/
			break;
		}
		put_user(recv(),temp);
		temp++;
	}
	status = pcfTransmitting(minor);
 	cmd(0xc3);
	if (count) put_user(recv(),temp);
	return i;
#else					/* Philips style code 		*/
	i=0;
	while (1) {
		status = pcfTransmitting(minor);
		i++;
		put_user(recv(),temp);
		if (i >= count)
			break;
		temp++;
	}
	cmd(0x40); /* neg. acknowledge on next byte */
	put_user(recv(),temp);
	temp++;
	status = pcfTransmitting(minor);
	cmd(0xc3);
	put_user(recv(),temp);
	temp++;
#endif
	return temp-buf;
}

static int i2c_ioctl(struct inode *inode, struct file *file,/********CHANGE!*/
	unsigned int cmd, unsigned long arg)
{
/*	unsigned int minor = MINOR(inode->i_rdev);
*/
	return 0;
}


#define CHK_REGS
static int i2c_init(int minor)
{
	int ret,irq;
#ifdef CHK_REGS
	int tst;
#endif
	ret = pcf_init(minor);
	
	if (!ret) { 				/* init chip		*/
		cmd(PCF_PIN); 			/* reset chip 		*/
		cmd(PCF_PIN);
		udelay(20);
		dta(0x55); 	/* own address This will change!	*/

		cmd(0xa0); 			/* load clock  		*/
		dta(PCF_CLK8 | PCF_TRNS45);	/* 8MHz clk, 1.5kHz bus	*/
#ifdef CHK_REGS
#define TSTPAT	(PCF_ENI|PCF_STO|PCF_STA|PCF_ACK)
		tst = stat();
		tst &= ~PCF_ESO;		/* when interface off,	*/
		cmd(tst | TSTPAT);		/* 4 lower bits readable*/
		tst = stat();
		if ( ( tst & TSTPAT) != TSTPAT ) {
			printk("read error(1), got %#2x, should be %#2x\n",
				tst,TSTPAT);
		} else {
			printk("passed test 0 (%d)\n",TSTPAT);
		}
		cmd(tst & ~(TSTPAT));
		udelay(10);
		tst = stat();
		if ( ( tst & TSTPAT) != 0x00 ) {
			printk("read error(0), got %#2x\n",tst);
		}
#endif
		cmd(0xc1); 			/* enable interface 	*/
	}
	irq = i2c_table[minor].irq;
	if (irq) {
		int ret = request_irq(irq, i2c_interrupt,
			SA_INTERRUPT, "i2c PCF 8584, EPP Port", &i2c_table[minor]);
		if (ret) {
			printk("i2c%d unable to use interrupt %d, error %d\n", minor, irq, ret);
			return ret;
		}
	}
	return ret;
}


static void i2c_exit(int minor)
{
	int irq;
	if ( (irq = i2c_table[minor].irq) ) {
		free_irq(irq, &i2c_table[minor]);
	}
	pcf_exit(minor);
}


/* -----exported file operations: -------------------------------------	*/
struct i2c_algorithm alg_pcf_opns = {
	"PCF 8584 Access",
	ALGO_PCF,
	i2c_read,
	i2c_write,
	i2c_ioctl,
	i2c_open,
	i2c_release,
	i2c_init,
	i2c_exit
};


/*
 *  Global init function - sets up internal data structures
 */
int algo_pcf_init (void)
{
#if (PCFADAPS > 1)
	int i;
	for (i=0;i<I2C_HW_ADAPS;i++){	/* set dummy values first... */
		pcf_adaps[i]=&dummy_pcfops;
	}
#ifdef PCF_LP
	pcf_adaps[HW_P_LP]=&pcf_lp_ops;
#endif
#ifdef PCF_ISA
	pcf_adaps[HW_P_ISA]=&pcf_isa_ops;
#endif
#else	
	/* only one adapter type defined -- nothing to do. */
#endif
	return 0;
}



#ifdef MODULE
MODULE_PARM(test, "i");
MODULE_PARM(scan, "i");
/*
EXPORT_SYMBOL(i2c_bit_register_bus);
EXPORT_SYMBOL(i2c_bit_unregister_bus);
*/
int init_module(void) 
{
	return algo_pcf_init();
}

void cleanup_module(void) 
{
	i2c_unregister_algorithm(&pcf_algo);
}
#endif





