// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: controlcache.h,v 1.1 1998/01/21 22:02:58 jgg Exp $
/* ######################################################################

   ControlCache - Package control info cache.
   
   This class allows access to the full package record stored in the 
   packages file. When given a version it will pull out the control 
   record and return it. Most applications do not use all of the versions
   of all of the packages so this class demand loads the control data.
   
   When this class is instantiated it will open all of the package files
   that were used to generate the cache and verify their sizes against
   what is recorded in the cache. Initialization will fail and _error
   will have the report if any inconsistancy is detected.
   
   By default 50 versions will be kept in memory.
   
   ##################################################################### */
									/*}}}*/
#ifndef PKGLIB_CONTROLCACHE_H
#define PKGLIB_CONTROLCACHE_H

#include <pkglib/pkgcache.h>
#include <pkglib/pkgctrlinfo.h>
#include <time.h>

class ifstream;

class pkgControlCache
{
   // Simplify by aliasing the iterators..
   typedef pkgCache::PkgFileIterator PkgFileIterator;
   typedef pkgCache::PkgIterator PkgIterator;
   typedef pkgCache::VerIterator VerIterator;
   
   // Cache item for each version
   struct CData
   {
      pkgSPkgCtrlInfo Info;
      clock_t LastHit;
      CData() {LastHit = 0;};
   };
   
   pkgCache &Cache;
   
   // These are indexed directly from the ID values.
   CData *CtrlList;
   ifstream *Files;
   
   int MaxCache;
   int Cached;

   void Dump();
   
   public:

   pkgSPkgCtrlInfo operator [](const VerIterator &Pkg);
   
   pkgControlCache(pkgCache &Cache);
   ~pkgControlCache();
};

#endif
