// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: package.h,v 1.6 1997/09/16 00:54:28 jgg Exp $
/* ######################################################################

   Package File - Encapsulates an on disk package.

   Methods
     ReadControl - Reads the control portion of the archive. 
     ReadFileList - Reads the full filelist
     Unpack - Unpacks the archive in a specific location
     Verifiy - Checks the MD5Sum against the one stored in the header, as
               well as other checks
   
   ##################################################################### */
									/*}}}*/
// Header section: pkglib
#ifndef PKGLIB_PACKAGE_H
#define PKGLIB_PACKAGE_H

#include <string>
#include <vector>

class pkgPkgCtrlInfo;

class pkgPackageFile
{
   public:

   // Handing of the Control portion of the archive
   virtual bool ReadControl(pkgPkgCtrlInfo &Info) = 0;
   virtual bool ReadFileList(vector<string> &List) = 0;

   // Manipulations on the file
   virtual bool Unpack(string Where) = 0;
   virtual bool Verify(const pkgPkgCtrlInfo &Info) = 0; 
   
   virtual ~pkgPackageFile();
};

#endif
